# Dokumentasi Sinkronisasi Metode Pembayaran

## Overview
Fitur ini menyinkronkan metode pembayaran dari konfigurasi Tripay dan OttoPay ke modul wisata dan UMKM, sehingga admin hanya perlu mengatur payment gateway sekali di pengaturan dan metode pembayaran akan otomatis tersedia di seluruh sistem.

## Komponen Utama

### 1. PaymentMethodSyncService
**Lokasi:** `app/Services/PaymentMethodSyncService.php`

Service ini bertugas untuk:
- Mengambil metode pembayaran dari konfigurasi Tripay dan OttoPay
- Menyediakan metode pembayaran untuk modul wisata dan UMKM
- Menghitung biaya administrasi untuk setiap metode pembayaran
- Generate HTML untuk form pembayaran

**Method Utama:**
- `getAvailablePaymentMethods()` - Mengambil semua metode pembayaran yang tersedia
- `getTourismPaymentMethods()` - Metode pembayaran untuk modul wisata
- `getUmkmPaymentMethods()` - Metode pembayaran untuk modul UMKM
- `calculatePaymentFee($amount, $paymentCode)` - Menghitung biaya admin
- `generatePaymentOptionsHtml($type)` - Generate HTML form pembayaran

### 2. Metode Pembayaran yang Didukung

#### Tripay
- **Virtual Account:** BRI, BCA, BNI, Mandiri (Biaya: Rp 4.000)
- **E-Wallet:** OVO, DANA, ShopeePay, GoPay, LinkAja (Biaya: Rp 2.500)
- **QRIS:** Scan QR Code (Biaya: Rp 1.500)

#### OttoPay
- **Virtual Account:** BCA, BRI, BNI, Mandiri, Permata, CIMB (Biaya: Rp 4.000)
- **QRIS:** Scan QR Code (Biaya: 0.7% dari nominal)
- **E-Wallet:** OVO, DANA, GoPay, ShopeePay, LinkAja (Biaya: 2% dari nominal)
- **Kartu Kredit:** Visa, Mastercard, JCB (Biaya: 2.9% dari nominal)

#### Manual/Offline
- **Bayar di Tempat:** Tanpa biaya admin
- **Transfer Bank:** Transfer manual ke rekening

### 3. Integrasi ke Modul

#### Modul Wisata
**File yang diupdate:**
- `app/Http/Controllers/PublicController.php`
- `resources/views/frontend/detail-wisata.php`
- `resources/views/admin/tiket-wisata/create.blade.php`

**Fitur:**
- Form pemesanan tiket wisata menggunakan metode pembayaran yang tersinkronisasi
- Validasi metode pembayaran yang fleksibel
- Perhitungan biaya admin otomatis

#### Modul UMKM
**File yang diupdate:**
- `app/Http/Controllers/CheckoutController.php`
- `resources/views/frontend/checkout.blade.php`

**Fitur:**
- Checkout produk UMKM dengan metode pembayaran yang tersinkronisasi
- Form checkout yang responsive dan user-friendly
- Perhitungan total termasuk biaya admin secara real-time

### 4. API Endpoint
**Endpoint:** `GET /api/payment-methods/{type}`

**Parameter:**
- `type`: `tourism`, `umkm`, atau `all`

**Response:**
```json
{
    "success": true,
    "data": [
        {
            "code": "BRIVA",
            "name": "BRI Virtual Account",
            "type": "virtual_account",
            "icon": "https://tripay.co.id/upload/payment-icon/YgCdBxY21649654936.png",
            "description": "Pembayaran via BRI Virtual Account",
            "fee": 4000,
            "gateway": "tripay",
            "group": "Virtual Account"
        }
    ]
}
```

## Cara Penggunaan

### 1. Konfigurasi Payment Gateway
1. Login sebagai admin
2. Masuk ke menu **Pengaturan**
3. Konfigurasi Tripay dan/atau OttoPay:
   - API Key
   - Secret/Private Key
   - Merchant Code
   - Mode (sandbox/production)
   - Pilih metode pembayaran yang ingin diaktifkan

### 2. Otomatis Tersinkronisasi
Setelah konfigurasi, metode pembayaran akan otomatis muncul di:
- Form pemesanan tiket wisata
- Checkout produk UMKM
- Form admin untuk input manual

### 3. Perhitungan Biaya
Sistem akan otomatis menghitung biaya admin berdasarkan:
- **Fixed fee:** Untuk Virtual Account dan beberapa e-wallet
- **Percentage fee:** Untuk QRIS OttoPay, E-Wallet OttoPay, dan Kartu Kredit
- **No fee:** Untuk metode manual

## Keuntungan

### 1. Centralized Configuration
- Admin hanya perlu konfigurasi sekali di pengaturan
- Perubahan konfigurasi langsung berlaku di semua modul

### 2. Flexible Payment Options
- Mendukung multiple payment gateway
- Bisa kombinasi Tripay + OttoPay + Manual
- Easy to add new payment methods

### 3. Automatic Fee Calculation
- Biaya admin dihitung otomatis
- Mendukung fixed fee dan percentage fee
- Transparent untuk user

### 4. User-Friendly Interface
- Payment options grouped by type
- Clear fee information
- Responsive design

### 5. Developer-Friendly
- Clean API structure
- Easy to extend
- Well-documented code

## Struktur Data

### Payment Method Object
```php
[
    'code' => 'BRIVA',                    // Unique identifier
    'name' => 'BRI Virtual Account',      // Display name
    'type' => 'virtual_account',          // Payment type
    'icon' => 'https://...',              // Icon URL
    'description' => 'Pembayaran via...', // Description
    'fee' => 4000,                        // Fixed fee (optional)
    'fee_percentage' => 2.5,              // Percentage fee (optional)
    'gateway' => 'tripay',                // Gateway provider
    'group' => 'Virtual Account'          // UI grouping
]
```

## Troubleshooting

### 1. Metode Pembayaran Tidak Muncul
- Pastikan payment gateway sudah dikonfigurasi dengan benar
- Cek apakah channels sudah dipilih di pengaturan
- Verify API credentials

### 2. Biaya Admin Tidak Terhitung
- Pastikan payment method memiliki data fee yang valid
- Cek JavaScript di frontend untuk perhitungan real-time

### 3. Error saat Checkout
- Validasi form input
- Cek log error di Laravel
- Pastikan payment gateway service berjalan normal

## Future Enhancements

### 1. Additional Payment Gateways
- Midtrans
- Xendit
- Doku
- PayPal

### 2. Advanced Features
- Payment method availability based on amount
- Dynamic fee calculation from API
- Payment method scheduling
- A/B testing for payment methods

### 3. Analytics
- Payment method usage statistics
- Conversion rate by payment method
- Fee optimization recommendations

## Changelog

### v1.0.0 (Current)
- Initial implementation
- Tripay and OttoPay integration
- Tourism and UMKM module integration
- Basic fee calculation
- Admin configuration interface 