<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;

class SetupEnhancedVillageSystem extends Command
{
    protected $signature = 'village:setup-enhanced';
    protected $description = 'Setup enhanced village management system with all migrations, models, and seeders';

    public function handle()
    {
        $this->info('🚀 Setting up Enhanced Village Management System...');
        
        // Run migrations
        $this->info('📊 Running database migrations...');
        Artisan::call('migrate', ['--force' => true]);
        $this->line(Artisan::output());
        
        // Run seeders
        $this->info('🌱 Running enhanced system seeders...');
        try {
            Artisan::call('db:seed', [
                '--class' => 'Database\\Seeders\\EnhancedSystemSeeder',
                '--force' => true
            ]);
            $this->line(Artisan::output());
        } catch (\Exception $e) {
            $this->warn('⚠️  Some seeders may not run if models are not fully setup: ' . $e->getMessage());
        }
        
        // Clear cache
        $this->info('🧹 Clearing application cache...');
        Artisan::call('cache:clear');
        Artisan::call('config:clear');
        Artisan::call('route:clear');
        Artisan::call('view:clear');
        
        $this->info('✅ Enhanced Village Management System setup completed!');
        $this->line('');
        $this->info('📋 System now includes:');
        $this->line('   • Enhanced Population Data with Mutations');
        $this->line('   • Letter Template System');
        $this->line('   • PBB (Property Tax) Management');
        $this->line('   • Digital Polling/Voting System');
        $this->line('   • Village Officials Structure');
        $this->line('   • Village Agenda Calendar');
        $this->line('   • Asset Inventory Management');
        $this->line('   • Outgoing Mail Archive');
        $this->line('   • Comprehensive Audit Trail');
        $this->line('   • Enhanced Dashboard Statistics');
        $this->line('   • API endpoints for mobile integration');
        $this->line('');
        $this->info('🌐 Access admin panel: /admin');
        $this->info('🔑 Default admin: admin@desa.id / admin123');
        
        return Command::SUCCESS;
    }
} 