<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Umkm;
use Illuminate\Http\Request;

class UmkmController extends Controller
{
    public function index(Request $request)
    {
        $query = Umkm::with(['produk', 'user'])
                     ->aktif()
                     ->verified();
        
        // Search
        if ($request->filled('search')) {
            $search = $request->search;
            $query->where(function($q) use ($search) {
                $q->where('nama_umkm', 'like', "%{$search}%")
                  ->orWhere('deskripsi', 'like', "%{$search}%")
                  ->orWhere('alamat_lengkap', 'like', "%{$search}%");
            });
        }
        
        // Filter by category
        if ($request->filled('kategori')) {
            $query->where('kategori_umkm', $request->kategori);
        }
        
        // Filter by featured
        if ($request->filled('featured') && $request->featured == '1') {
            $query->featured();
        }
        
        // Filter by location
        if ($request->filled('desa_kelurahan')) {
            $query->where('desa_kelurahan', $request->desa_kelurahan);
        }
        
        $umkm = $query->paginate(20);
        
        return response()->json([
            'success' => true,
            'data' => $umkm,
            'message' => 'Data UMKM berhasil diambil'
        ]);
    }
    
    public function show($id)
    {
        $umkm = Umkm::with(['produk', 'user'])
                    ->aktif()
                    ->verified()
                    ->findOrFail($id);
        
        return response()->json([
            'success' => true,
            'data' => $umkm,
            'message' => 'Detail UMKM berhasil diambil'
        ]);
    }
    
    public function featured()
    {
        $umkm = Umkm::with(['produk'])
                    ->aktif()
                    ->verified()
                    ->featured()
                    ->orderBy('rating_rata_rata', 'desc')
                    ->limit(10)
                    ->get();
        
        return response()->json([
            'success' => true,
            'data' => $umkm,
            'message' => 'UMKM unggulan berhasil diambil'
        ]);
    }
    
    public function categories()
    {
        $categories = [
            'makanan_minuman' => 'Makanan & Minuman',
            'kerajinan' => 'Kerajinan',
            'tekstil' => 'Tekstil & Fashion',
            'pertanian' => 'Pertanian',
            'perikanan' => 'Perikanan',
            'peternakan' => 'Peternakan',
            'jasa' => 'Jasa',
            'teknologi' => 'Teknologi',
            'perdagangan' => 'Perdagangan',
            'lainnya' => 'Lainnya'
        ];
        
        return response()->json([
            'success' => true,
            'data' => $categories,
            'message' => 'Kategori UMKM berhasil diambil'
        ]);
    }
} 