<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bantuan extends Model
{
    use HasFactory;

    protected $table = 'bantuan';

    protected $fillable = [
        'nik',
        'jenis_bantuan',
        'deskripsi',
        'periode',
        'nominal',
        'status',
        'tanggal_distribusi',
        'keterangan'
    ];

    protected $casts = [
        'nominal' => 'decimal:2',
        'tanggal_distribusi' => 'date'
    ];

    // Relationships
    public function penduduk()
    {
        return $this->belongsTo(Penduduk::class, 'nik', 'nik');
    }

    // Scopes
    public function scopeDiajukan($query)
    {
        return $query->where('status', 'Diajukan');
    }

    public function scopeDiterima($query)
    {
        return $query->where('status', 'Diterima');
    }

    public function scopeByJenis($query, $jenis)
    {
        return $query->where('jenis_bantuan', $jenis);
    }

    public function scopeByPeriode($query, $periode)
    {
        return $query->where('periode', $periode);
    }

    // Accessors
    public function getStatusColorAttribute()
    {
        return match($this->status) {
            'Diajukan' => 'warning',
            'Diverifikasi' => 'info',
            'Diterima' => 'success',
            'Ditolak' => 'danger',
            default => 'secondary'
        };
    }
    
    public function getJenisColorAttribute()
    {
        return match($this->jenis_bantuan) {
            'PKH' => 'primary',
            'Bansos Pangan' => 'success',
            'BLT Dana Desa' => 'info',
            'Kartu Prakerja' => 'warning',
            'Bantuan Pendidikan' => 'purple',
            'Bantuan Kesehatan' => 'danger',
            'Bantuan Perumahan' => 'dark',
            'BPNT' => 'secondary',
            default => 'info'
        };
    }

    public function getNominalFormatAttribute()
    {
        return $this->nominal ? 'Rp ' . number_format($this->nominal, 0, ',', '.') : '-';
    }
    
    public function getNilaiBantuanAttribute()
    {
        return $this->nominal;
    }
} 
