<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Keluarga extends Model
{
    use HasFactory;

    protected $table = 'keluarga';

    protected $fillable = [
        'no_kk',
        'kepala_keluarga_nik',
        'alamat',
        'dusun',
        'rt',
        'rw'
    ];

    // Relationships
    public function kepalaKeluarga()
    {
        return $this->belongsTo(Penduduk::class, 'kepala_keluarga_nik', 'nik');
    }

    public function anggotaKeluarga()
    {
        return $this->hasMany(AnggotaKeluarga::class, 'no_kk', 'no_kk');
    }

    // Alias untuk anggotaKeluarga untuk kompatibilitas view
    public function anggota()
    {
        return $this->anggotaKeluarga();
    }

    public function penduduk()
    {
        return $this->hasMany(Penduduk::class, 'no_kk', 'no_kk');
    }

    // Accessors
    public function getAlamatLengkapAttribute()
    {
        $alamat = $this->alamat;
        if ($this->rt) $alamat .= " RT {$this->rt}";
        if ($this->rw) $alamat .= " RW {$this->rw}";
        if ($this->dusun) $alamat .= " Dusun {$this->dusun}";
        return $alamat;
    }

    public function getJumlahAnggotaAttribute()
    {
        return $this->anggotaKeluarga()->count();
    }
    
    // Remove accessor that causes issues
    // Use relationship directly in views instead
} 
