<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Pengaduan extends Model
{
    use HasFactory;

    protected $table = 'pengaduan';

    protected $fillable = [
        'nik',
        'judul',
        'isi_pengaduan',
        'kategori',
        'gambar',
        'latitude',
        'longitude',
        'status',
        'tanggapan',
        'tanggal_tanggapan'
    ];

    protected $casts = [
        'tanggal_tanggapan' => 'datetime',
        'latitude' => 'decimal:8',
        'longitude' => 'decimal:8'
    ];

    // Relationships
    public function penduduk()
    {
        return $this->belongsTo(Penduduk::class, 'nik', 'nik');
    }

    // Scopes
    public function scopeBaru($query)
    {
        return $query->where('status', 'Baru');
    }

    public function scopeDiproses($query)
    {
        return $query->where('status', 'Diproses');
    }

    public function scopeDitanggapi($query)
    {
        return $query->where('status', 'Ditanggapi');
    }

    public function scopeByKategori($query, $kategori)
    {
        return $query->where('kategori', $kategori);
    }

    // Accessors
    public function getStatusColorAttribute()
    {
        return match($this->status) {
            'Baru' => 'danger',
            'Diproses' => 'warning',
            'Ditanggapi' => 'info',
            'Selesai' => 'success',
            default => 'secondary'
        };
    }

    public function getHasLocationAttribute()
    {
        return !is_null($this->latitude) && !is_null($this->longitude);
    }
} 
