<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('template_surat', function (Blueprint $table) {
            $table->id();
            $table->string('nama_template'); // Nama template
            $table->string('jenis_surat'); // Jenis surat (Domisili, SKTM, dll)
            $table->string('kode_surat', 10); // Kode untuk penomoran (DOM, SKTM, dll)
            $table->string('format_nomor')->default('{counter}/{kode}/{bulan}/{tahun}'); // Format nomor surat
            $table->longText('template_content'); // Template konten dengan variabel
            $table->text('variabel_tersedia')->nullable(); // JSON list variabel yang bisa digunakan
            $table->string('penandatangan_default')->nullable(); // Default penandatangan
            $table->boolean('aktif')->default(true);
            $table->integer('urutan')->default(0); // Urutan tampil
            $table->text('keterangan')->nullable();
            $table->timestamps();
            
            $table->index(['jenis_surat', 'aktif']);
            $table->index('kode_surat');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('template_surat');
    }
}; 