<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('perangkat_desa', function (Blueprint $table) {
            $table->id();
            $table->string('nik', 16)->unique(); // NIK perangkat desa
            $table->string('nama');
            $table->string('nip', 18)->nullable(); // Nomor Induk Pegawai
            $table->enum('jabatan', [
                'Kepala Desa',
                'Sekretaris Desa', 
                'Kaur Tata Usaha dan Umum',
                'Kaur Keuangan',
                'Kaur Perencanaan',
                'Kasi Pemerintahan',
                'Kasi Kesejahteraan',
                'Kasi Pelayanan',
                'Kepala Dusun',
                'RT',
                'RW',
                'Lainnya'
            ]);
            $table->string('bidang_tugas')->nullable(); // Spesifikasi tugas
            $table->text('tugas_tanggung_jawab')->nullable(); // Detail tugas
            $table->date('mulai_tugas');
            $table->date('selesai_tugas')->nullable();
            $table->enum('status', ['Aktif', 'Tidak Aktif', 'Pensiun', 'Mutasi'])->default('Aktif');
            
            // Data kontak
            $table->string('no_hp', 15)->nullable();
            $table->string('email')->nullable();
            $table->text('alamat')->nullable();
            
            // File pendukung
            $table->string('foto')->nullable();
            $table->string('file_sk')->nullable(); // SK pengangkatan
            $table->string('tanda_tangan')->nullable(); // File tanda tangan digital
            
            // Wilayah kerja (untuk Kadus, RT, RW)
            $table->string('wilayah_kerja')->nullable(); // Dusun/RT/RW yang dibawahi
            
            // Urutan hierarki
            $table->integer('urutan')->default(0);
            $table->integer('level_hierarki')->default(0); // 0=Kades, 1=Staff, 2=Kadus, 3=RT/RW
            
            $table->timestamps();
            
            $table->foreign('nik')->references('nik')->on('penduduk')->onDelete('cascade');
            $table->index(['jabatan', 'status']);
            $table->index('level_hierarki');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('perangkat_desa');
    }
}; 