<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('objek_wisata', function (Blueprint $table) {
            $table->id();
            $table->string('nama_wisata');
            $table->string('slug')->unique();
            $table->text('deskripsi');
            $table->text('deskripsi_singkat')->nullable();
            
            // Kategori & Klasifikasi
            $table->enum('kategori_wisata', [
                'wisata_alam',
                'wisata_budaya',
                'wisata_sejarah',
                'wisata_religi',
                'wisata_kuliner',
                'wisata_edukasi',
                'wisata_adventure',
                'wisata_air',
                'wisata_pegunungan',
                'agrowisata',
                'ekowisata',
                'wisata_buatan',
                'lainnya'
            ]);
            $table->json('tags')->nullable(); // ["air_terjun", "hiking", "fotografi", "keluarga"]
            
            // Lokasi & Akses
            $table->text('alamat');
            $table->decimal('latitude', 10, 8);
            $table->decimal('longitude', 11, 8);
            $table->text('cara_akses')->nullable(); // Petunjuk jalan
            $table->integer('jarak_dari_pusat_desa')->nullable(); // dalam meter
            $table->enum('kondisi_jalan', ['baik', 'sedang', 'buruk'])->default('baik');
            $table->text('transportasi_umum')->nullable();
            $table->boolean('akses_kendaraan_roda_4')->default(true);
            $table->boolean('akses_motor')->default(true);
            
            // Fasilitas & Amenitas
            $table->json('fasilitas')->nullable(); // ["toilet", "parkir", "mushola", "warung", "guide"]
            $table->boolean('ada_toilet')->default(false);
            $table->boolean('ada_parkir')->default(false);
            $table->boolean('ada_mushola')->default(false);
            $table->boolean('ada_warung')->default(false);
            $table->boolean('ada_penginapan')->default(false);
            $table->boolean('ada_guide')->default(false);
            $table->boolean('ada_wifi')->default(false);
            $table->text('fasilitas_lainnya')->nullable();
            
            // Operasional & Jam Buka
            $table->json('jam_operasional')->nullable(); // {"senin": "06:00-18:00", ...}
            $table->json('hari_tutup')->nullable(); // ["jumat"] atau []
            $table->text('catatan_operasional')->nullable();
            $table->enum('musim_terbaik', ['sepanjang_tahun', 'kemarau', 'hujan', 'tertentu'])->default('sepanjang_tahun');
            $table->text('info_musim')->nullable();
            
            // Harga Tiket
            $table->decimal('harga_tiket_dewasa', 10, 2)->default(0);
            $table->decimal('harga_tiket_anak', 10, 2)->default(0);
            $table->decimal('harga_tiket_rombongan', 10, 2)->nullable();
            $table->integer('minimal_rombongan')->nullable();
            $table->decimal('harga_parkir_motor', 8, 2)->default(0);
            $table->decimal('harga_parkir_mobil', 8, 2)->default(0);
            $table->decimal('harga_guide', 10, 2)->nullable();
            $table->text('catatan_harga')->nullable();
            
            // Media & Dokumentasi
            $table->string('foto_utama')->nullable();
            $table->json('galeri_foto')->nullable(); // Array foto wisata
            $table->string('video_profil')->nullable();
            $table->json('virtual_tour')->nullable(); // 360° photos/videos
            
            // Keamanan & Regulasi
            $table->enum('tingkat_kesulitan', ['mudah', 'sedang', 'sulit', 'ekstrem'])->default('mudah');
            $table->text('peringatan_keamanan')->nullable();
            $table->text('aturan_berkunjung')->nullable();
            $table->boolean('perlu_izin_khusus')->default(false);
            $table->text('kontak_izin')->nullable();
            $table->integer('kapasitas_maksimal')->nullable(); // Jumlah pengunjung per hari
            
            // Statistik & Rating
            $table->decimal('rating_rata_rata', 3, 2)->default(0);
            $table->integer('jumlah_review')->default(0);
            $table->integer('total_pengunjung')->default(0);
            $table->integer('pengunjung_bulan_ini')->default(0);
            $table->integer('view_count')->default(0);
            $table->json('statistik_bulanan')->nullable(); // Data pengunjung per bulan
            
            // Status & Visibilitas
            $table->enum('status', ['aktif', 'nonaktif', 'maintenance', 'tutup_sementara'])->default('aktif');
            $table->boolean('is_featured')->default(false);
            $table->boolean('is_recommended')->default(false);
            $table->integer('urutan_tampil')->default(0);
            $table->date('tanggal_buka')->nullable();
            $table->text('alasan_tutup')->nullable();
            
            // Kontak & Pengelola
            $table->string('pengelola')->nullable();
            $table->string('nomor_telepon', 15)->nullable();
            $table->string('email')->nullable();
            $table->string('website')->nullable();
            $table->string('instagram')->nullable();
            $table->string('facebook')->nullable();
            
            // SEO & Marketing
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->json('keyword')->nullable();
            
            // Metadata
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->timestamps();
            
            // Indexes
            $table->index(['kategori_wisata', 'status']);
            $table->index(['is_featured', 'is_recommended']);
            $table->index(['rating_rata_rata', 'status']);
            $table->index('slug');
            $table->index(['latitude', 'longitude']);
            $table->fullText(['nama_wisata', 'deskripsi', 'deskripsi_singkat']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('objek_wisata');
    }
};
