<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('penduduk', function (Blueprint $table) {
            // Menambahkan kolom akta lahir
            $table->string('no_akta_lahir', 50)->nullable()->after('tanggal_lahir');
            $table->date('tanggal_akta_lahir')->nullable()->after('no_akta_lahir');
            $table->string('tempat_akta_lahir')->nullable()->after('tanggal_akta_lahir');
            
            // Menambahkan kolom nama ayah dan ibu untuk referensi (sementara)
            // Ini akan membantu proses mapping ke NIK
            $table->string('nama_ayah')->nullable()->after('ayah_nik');
            $table->string('nama_ibu')->nullable()->after('ibu_nik');
            
            // Menambahkan kolom untuk mempermudah pencarian keluarga
            $table->string('hubungan_keluarga')->nullable()->after('status_keluarga');
            
            // Index untuk performa pencarian
            $table->index(['nama_ayah'], 'idx_nama_ayah');
            $table->index(['nama_ibu'], 'idx_nama_ibu');
            $table->index(['no_akta_lahir'], 'idx_akta_lahir');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('penduduk', function (Blueprint $table) {
            // Drop indexes first
            $table->dropIndex('idx_nama_ayah');
            $table->dropIndex('idx_nama_ibu');
            $table->dropIndex('idx_akta_lahir');
            
            // Drop columns
            $table->dropColumn([
                'no_akta_lahir',
                'tanggal_akta_lahir', 
                'tempat_akta_lahir',
                'nama_ayah',
                'nama_ibu',
                'hubungan_keluarga'
            ]);
        });
    }
};
