<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Berita;

class BeritaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $berita = [
            [
                'judul' => 'Peluncuran Sistem Informasi Desa Digital',
                'slug' => 'peluncuran-sistem-informasi-desa-digital',
                'konten' => 'Desa telah meluncurkan sistem informasi digital yang memudahkan warga dalam mengakses berbagai layanan administrasi dan informasi desa. Platform ini menyediakan fitur pengajuan surat online, pengaduan masyarakat, dan informasi bantuan sosial.',
                'ringkasan' => 'Desa meluncurkan sistem informasi digital untuk memudahkan akses layanan administrasi warga.',
                'kategori' => 'Pengumuman',
                'status' => 'Terbit',
                'views' => 245,
                'user_id' => 1,
                'tanggal_terbit' => now()->subHours(2),
                'created_at' => now()->subHours(2),
                'updated_at' => now()->subHours(2)
            ],
            [
                'judul' => 'Program Vaksinasi COVID-19 Tahap Lanjutan',
                'slug' => 'program-vaksinasi-covid-19-tahap-lanjutan',
                'konten' => 'Program vaksinasi COVID-19 tahap lanjutan akan dilaksanakan di Balai Desa mulai tanggal 20 Januari 2024 untuk seluruh warga. Pelaksanaan dimulai pukul 08.00 hingga 15.00 WIB.',
                'ringkasan' => 'Vaksinasi COVID-19 tahap lanjutan akan dilaksanakan di Balai Desa mulai 20 Januari 2024.',
                'kategori' => 'Kesehatan',
                'status' => 'Terbit',
                'views' => 156,
                'user_id' => 1,
                'tanggal_terbit' => now()->subHours(6),
                'created_at' => now()->subHours(6),
                'updated_at' => now()->subHours(6)
            ],
            [
                'judul' => 'Gotong Royong Bersih Desa Setiap Minggu',
                'slug' => 'gotong-royong-bersih-desa-setiap-minggu',
                'konten' => 'Kegiatan gotong royong bersih desa akan dilaksanakan setiap hari Minggu pagi mulai pukul 07.00 WIB untuk menjaga kebersihan lingkungan. Seluruh warga diharapkan berpartisipasi aktif.',
                'ringkasan' => 'Gotong royong bersih desa setiap Minggu pagi untuk menjaga kebersihan lingkungan.',
                'kategori' => 'Kegiatan',
                'status' => 'Terbit',
                'views' => 89,
                'user_id' => 1,
                'tanggal_terbit' => now()->subDay(),
                'created_at' => now()->subDay(),
                'updated_at' => now()->subDay()
            ],
            [
                'judul' => 'Perubahan Jadwal Pelayanan Administrasi',
                'slug' => 'perubahan-jadwal-pelayanan-administrasi',
                'konten' => 'Mulai tanggal 20 Januari 2024, jadwal pelayanan administrasi desa berubah menjadi Senin-Jumat pukul 08.00-15.00 WIB. Pelayanan pada hari Sabtu dihentikan sementara.',
                'ringkasan' => 'Jadwal pelayanan administrasi berubah menjadi Senin-Jumat pukul 08.00-15.00 WIB.',
                'kategori' => 'Pengumuman',
                'status' => 'Terbit',
                'views' => 198,
                'user_id' => 1,
                'tanggal_terbit' => now()->subDays(3),
                'created_at' => now()->subDays(3),
                'updated_at' => now()->subDays(3)
            ],
            [
                'judul' => 'Launching Platform E-Commerce UMKM Desa',
                'slug' => 'launching-platform-e-commerce-umkm-desa',
                'konten' => 'Portal e-commerce khusus produk UMKM desa resmi diluncurkan untuk meningkatkan penjualan produk lokal. Warga dapat mengakses platform melalui menu UMKM di sistem desa.',
                'ringkasan' => 'Portal e-commerce UMKM desa diluncurkan untuk meningkatkan penjualan produk lokal.',
                'kategori' => 'UMKM',
                'status' => 'Terbit',
                'views' => 134,
                'user_id' => 1,
                'tanggal_terbit' => now()->subDays(5),
                'created_at' => now()->subDays(5),
                'updated_at' => now()->subDays(5)
            ],
            [
                'judul' => 'Pembangunan Jalan Desa Fase 2 Dimulai',
                'slug' => 'pembangunan-jalan-desa-fase-2-dimulai',
                'konten' => 'Proyek pembangunan jalan desa fase 2 resmi dimulai dengan target penyelesaian 3 bulan. Pembangunan meliputi perbaikan jalan utama sepanjang 2 km dengan anggaran dari Dana Desa.',
                'ringkasan' => 'Proyek pembangunan jalan desa fase 2 dimulai dengan target 3 bulan penyelesaian.',
                'kategori' => 'Pembangunan',
                'status' => 'Terbit',
                'views' => 312,
                'user_id' => 1,
                'tanggal_terbit' => now()->subHours(1),
                'created_at' => now()->subHours(1),
                'updated_at' => now()->subHours(1)
            ],
            [
                'judul' => 'Distribusi Bantuan Sembako Bulan Januari',
                'slug' => 'distribusi-bantuan-sembako-bulan-januari',
                'konten' => 'Pendistribusian bantuan sembako untuk keluarga kurang mampu bulan Januari 2024 akan dilaksanakan di Balai Desa. Penerima dapat mengambil bantuan sesuai jadwal yang telah ditentukan.',
                'ringkasan' => 'Distribusi bantuan sembako bulan Januari untuk keluarga kurang mampu.',
                'kategori' => 'Sosial',
                'status' => 'Terbit',
                'views' => 267,
                'user_id' => 1,
                'tanggal_terbit' => now()->subHours(3),
                'created_at' => now()->subHours(3),
                'updated_at' => now()->subHours(3)
            ],
            [
                'judul' => 'Pelatihan Digital Marketing untuk UMKM',
                'slug' => 'pelatihan-digital-marketing-untuk-umkm',
                'konten' => 'Dinas Koperasi dan UMKM mengadakan pelatihan digital marketing gratis untuk pelaku UMKM desa. Pelatihan bertujuan meningkatkan kemampuan pemasaran online produk lokal.',
                'ringkasan' => 'Pelatihan digital marketing gratis untuk pelaku UMKM desa.',
                'kategori' => 'UMKM',
                'status' => 'Terbit',
                'views' => 178,
                'user_id' => 1,
                'tanggal_terbit' => now()->subHours(8),
                'created_at' => now()->subHours(8),
                'updated_at' => now()->subHours(8)
            ],
            [
                'judul' => 'Festival Budaya Desa 2024',
                'slug' => 'festival-budaya-desa-2024',
                'konten' => 'Festival Budaya Desa 2024 akan diselenggarakan pada bulan Februari dengan menampilkan kesenian tradisional, pameran produk UMKM, dan lomba-lomba menarik untuk seluruh keluarga.',
                'ringkasan' => 'Festival Budaya Desa 2024 menampilkan kesenian tradisional dan pameran UMKM.',
                'kategori' => 'Kegiatan',
                'status' => 'Terbit',
                'views' => 423,
                'user_id' => 1,
                'tanggal_terbit' => now()->subDays(2),
                'created_at' => now()->subDays(2),
                'updated_at' => now()->subDays(2)
            ]
        ];

        foreach ($berita as $item) {
            Berita::updateOrCreate(
                ['slug' => $item['slug']], // Cek berdasarkan slug
                $item // Data yang akan diupdate atau dibuat
            );
        }
    }
} 
