<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Penduduk;
use App\Models\PelayananSurat;
use App\Models\Pengaduan;
use App\Models\Bantuan;
use App\Models\Berita;
use Carbon\Carbon;

class DashboardSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create sample Penduduk data
        $pendudukData = [
            [
                'nik' => '3201234567890001',
                'nama' => 'Ahmad Supriyadi',
                'no_kk' => '3201234567890001',
                'status_keluarga' => 'Kepala Keluarga',
                'alamat' => 'Jl. Merdeka No. 1',
                'dusun' => 'Dusun 1',
                'rt' => '01',
                'rw' => '01',
                'tempat_lahir' => 'Bogor',
                'tanggal_lahir' => '1980-01-15',
                'jenis_kelamin' => 'L',
                'agama' => 'Islam',
                'pekerjaan' => 'Petani',
                'pendidikan' => 'SMA',
                'no_wa' => '081234567890',
                'latitude' => -6.5971,
                'longitude' => 106.8060
            ],
            [
                'nik' => '3201234567890002',
                'nama' => 'Siti Nurhaliza',
                'no_kk' => '3201234567890001',
                'status_keluarga' => 'Istri',
                'alamat' => 'Jl. Merdeka No. 1',
                'dusun' => 'Dusun 1',
                'rt' => '01',
                'rw' => '01',
                'tempat_lahir' => 'Bogor',
                'tanggal_lahir' => '1985-03-20',
                'jenis_kelamin' => 'P',
                'agama' => 'Islam',
                'pekerjaan' => 'Ibu Rumah Tangga',
                'pendidikan' => 'SMA',
                'no_wa' => '081234567891',
                'latitude' => -6.5971,
                'longitude' => 106.8060
            ],
            [
                'nik' => '3201234567890003',
                'nama' => 'Budi Santoso',
                'no_kk' => '3201234567890002',
                'status_keluarga' => 'Kepala Keluarga',
                'alamat' => 'Jl. Mawar No. 5',
                'dusun' => 'Dusun 2',
                'rt' => '02',
                'rw' => '01',
                'tempat_lahir' => 'Bogor',
                'tanggal_lahir' => '1975-07-10',
                'jenis_kelamin' => 'L',
                'agama' => 'Islam',
                'pekerjaan' => 'Guru',
                'pendidikan' => 'S1',
                'no_wa' => '081234567892',
                'latitude' => -6.5980,
                'longitude' => 106.8070
            ],
            [
                'nik' => '3201234567890004',
                'nama' => 'Dewi Sartika',
                'no_kk' => '3201234567890002',
                'status_keluarga' => 'Istri',
                'alamat' => 'Jl. Mawar No. 5',
                'dusun' => 'Dusun 2',
                'rt' => '02',
                'rw' => '01',
                'tempat_lahir' => 'Bogor',
                'tanggal_lahir' => '1978-11-25',
                'jenis_kelamin' => 'P',
                'agama' => 'Islam',
                'pekerjaan' => 'Guru',
                'pendidikan' => 'S1',
                'no_wa' => '081234567893',
                'latitude' => -6.5980,
                'longitude' => 106.8070
            ],
            [
                'nik' => '3201234567890005',
                'nama' => 'Joko Widodo',
                'no_kk' => '3201234567890003',
                'status_keluarga' => 'Kepala Keluarga',
                'alamat' => 'Jl. Melati No. 10',
                'dusun' => 'Dusun 3',
                'rt' => '03',
                'rw' => '02',
                'tempat_lahir' => 'Bogor',
                'tanggal_lahir' => '1990-05-30',
                'jenis_kelamin' => 'L',
                'agama' => 'Islam',
                'pekerjaan' => 'Wiraswasta',
                'pendidikan' => 'SMA',
                'no_wa' => '081234567894',
                'latitude' => -6.5960,
                'longitude' => 106.8050
            ]
        ];

        foreach ($pendudukData as $data) {
            Penduduk::create($data);
        }

        // Create sample PelayananSurat data for the last 12 months
        $jenisSurat = [
            'Surat Domisili',
            'SKCK',
            'Surat Kematian',
            'Surat Usaha',
            'Surat Keterangan Tidak Mampu',
            'Surat Keterangan Belum Menikah',
            'Surat Pengantar Nikah',
            'Surat Keterangan Penghasilan'
        ];

        $status = ['Menunggu', 'Diproses', 'Selesai', 'Ditolak'];

        // Generate data for each month in the last 12 months
        for ($i = 11; $i >= 0; $i--) {
            $date = Carbon::now()->subMonths($i);
            $count = rand(1, 8); // Random number of services per month

            for ($j = 0; $j < $count; $j++) {
                PelayananSurat::create([
                    'nik' => $pendudukData[array_rand($pendudukData)]['nik'],
                    'jenis_surat' => $jenisSurat[array_rand($jenisSurat)],
                    'keperluan' => 'Keperluan untuk ' . $jenisSurat[array_rand($jenisSurat)],
                    'tanggal_pengajuan' => $date->copy()->addDays(rand(1, 28)),
                    'status' => $status[array_rand($status)],
                    'catatan' => 'Catatan untuk permohonan',
                    'created_at' => $date->copy()->addDays(rand(1, 28)),
                    'updated_at' => $date->copy()->addDays(rand(1, 28))
                ]);
            }
        }

        // Create sample Pengaduan data
        $pengaduanData = [
            [
                'nik' => '3201234567890001',
                'judul' => 'Jalan Rusak',
                'isi_pengaduan' => 'Jalan di depan rumah rusak dan berlubang',
                'kategori' => 'Infrastruktur',
                'status' => 'Baru',
                'created_at' => Carbon::now()->subDays(5)
            ],
            [
                'nik' => '3201234567890003',
                'judul' => 'Lampu Jalan Mati',
                'isi_pengaduan' => 'Lampu jalan di RT 02 sudah mati sejak seminggu',
                'kategori' => 'Keamanan',
                'status' => 'Diproses',
                'created_at' => Carbon::now()->subDays(10)
            ],
            [
                'nik' => '3201234567890005',
                'judul' => 'Sampah Tidak Diangkut',
                'isi_pengaduan' => 'Sampah di TPS sudah menumpuk tidak diangkut',
                'kategori' => 'Kebersihan',
                'status' => 'Selesai',
                'created_at' => Carbon::now()->subDays(15)
            ]
        ];

        foreach ($pengaduanData as $data) {
            Pengaduan::create($data);
        }

        // Create sample Bantuan data
        $bantuanData = [
            [
                'nik' => '3201234567890001',
                'jenis_bantuan' => 'BLT Dana Desa',
                'deskripsi' => 'Bantuan Langsung Tunai dari Dana Desa',
                'nominal' => 600000,
                'periode' => Carbon::now()->format('Y-m'),
                'status' => 'Diterima',
                'created_at' => Carbon::now()->subDays(20)
            ],
            [
                'nik' => '3201234567890002',
                'jenis_bantuan' => 'PKH',
                'deskripsi' => 'Program Keluarga Harapan untuk keluarga kurang mampu',
                'nominal' => 750000,
                'periode' => Carbon::now()->format('Y-m'),
                'status' => 'Diterima',
                'created_at' => Carbon::now()->subDays(25)
            ],
            [
                'nik' => '3201234567890004',
                'jenis_bantuan' => 'BPNT',
                'deskripsi' => 'Bantuan Pangan Non Tunai',
                'nominal' => 200000,
                'periode' => Carbon::now()->format('Y-m'),
                'status' => 'Diverifikasi',
                'created_at' => Carbon::now()->subDays(10)
            ]
        ];

        foreach ($bantuanData as $data) {
            Bantuan::create($data);
        }

        // Create sample Berita data
        $beritaData = [
            [
                'judul' => 'Pembangunan Jalan Desa Dimulai',
                'slug' => 'pembangunan-jalan-desa-dimulai',
                'konten' => 'Pembangunan jalan desa tahap pertama telah dimulai...',
                'kategori' => 'Pembangunan',
                'status' => 'Terbit',
                'tanggal_terbit' => Carbon::now()->subDays(3),
                'views' => 150,
                'created_at' => Carbon::now()->subDays(3)
            ],
            [
                'judul' => 'Gotong Royong Kebersihan Desa',
                'slug' => 'gotong-royong-kebersihan-desa',
                'konten' => 'Kegiatan gotong royong kebersihan desa akan dilaksanakan...',
                'kategori' => 'Kegiatan',
                'status' => 'Terbit',
                'tanggal_terbit' => Carbon::now()->subDays(7),
                'views' => 200,
                'created_at' => Carbon::now()->subDays(7)
            ]
        ];

        foreach ($beritaData as $data) {
            Berita::create($data);
        }

        $this->command->info('Sample dashboard data created successfully!');
    }
}
