<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Penduduk;
use App\Models\Keluarga;
use App\Models\AnggotaKeluarga;
use App\Models\PelayananSurat;
use App\Models\Pengaduan;
use App\Models\Bantuan;
use App\Models\Berita;
use Illuminate\Support\Facades\DB;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Disable foreign key checks untuk sementara
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        // Truncate tables
        Penduduk::truncate();
        Keluarga::truncate();
        AnggotaKeluarga::truncate();
        PelayananSurat::truncate();
        Pengaduan::truncate();
        Bantuan::truncate();
        Berita::truncate();

        // Enable foreign key checks
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        // Seed data
        $this->call(UserSeeder::class);
        $this->call(ProdukUmkmSeeder::class);
        $this->seedPenduduk();
        $this->seedKeluarga();
        $this->seedPelayananSurat();
        $this->seedPengaduan();
        $this->seedBantuan();
        $this->seedBerita();
    }

    private function seedPenduduk()
    {
        $pendudukData = [
            [
                'nik' => '3201012201850001',
                'nama' => 'Ahmad Suryanto',
                'jenis_kelamin' => 'Laki-laki',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1985-01-22',
                'agama' => 'Islam',
                'pendidikan' => 'S1',
                'pekerjaan' => 'Wiraswasta',
                'status_perkawinan' => 'Kawin',
                'kewarganegaraan' => 'WNI',
                'alamat_jalan' => 'Jl. Merdeka No. 123',
                'alamat_dusun' => 'Dusun Mekar',
                'alamat_rt' => '01',
                'alamat_rw' => '05',
                'alamat_kelurahan' => 'Sukamaju',
                'alamat_kecamatan' => 'Mekarsari',
                'alamat_kabupaten' => 'Bogor',
                'alamat_provinsi' => 'Jawa Barat',
                'kode_pos' => '16710',
                'no_wa' => '081234567890',
                'latitude' => -6.595038,
                'longitude' => 106.816635
            ],
            [
                'nik' => '3201012205880002',
                'nama' => 'Siti Nurhaliza',
                'jenis_kelamin' => 'Perempuan',
                'tempat_lahir' => 'Bogor',
                'tanggal_lahir' => '1988-05-22',
                'agama' => 'Islam',
                'pendidikan' => 'SMA',
                'pekerjaan' => 'Ibu Rumah Tangga',
                'status_perkawinan' => 'Kawin',
                'kewarganegaraan' => 'WNI',
                'alamat_jalan' => 'Jl. Merdeka No. 123',
                'alamat_dusun' => 'Dusun Mekar',
                'alamat_rt' => '01',
                'alamat_rw' => '05',
                'alamat_kelurahan' => 'Sukamaju',
                'alamat_kecamatan' => 'Mekarsari',
                'alamat_kabupaten' => 'Bogor',
                'alamat_provinsi' => 'Jawa Barat',
                'kode_pos' => '16710',
                'no_wa' => '081234567891',
                'latitude' => -6.595038,
                'longitude' => 106.816635
            ],
            [
                'nik' => '3201012210120003',
                'nama' => 'Muhammad Rizki',
                'jenis_kelamin' => 'Laki-laki',
                'tempat_lahir' => 'Bogor',
                'tanggal_lahir' => '2012-10-12',
                'agama' => 'Islam',
                'pendidikan' => 'SD',
                'pekerjaan' => 'Pelajar',
                'status_perkawinan' => 'Belum Kawin',
                'kewarganegaraan' => 'WNI',
                'alamat_jalan' => 'Jl. Merdeka No. 123',
                'alamat_dusun' => 'Dusun Mekar',
                'alamat_rt' => '01',
                'alamat_rw' => '05',
                'alamat_kelurahan' => 'Sukamaju',
                'alamat_kecamatan' => 'Mekarsari',
                'alamat_kabupaten' => 'Bogor',
                'alamat_provinsi' => 'Jawa Barat',
                'kode_pos' => '16710',
                'latitude' => -6.595038,
                'longitude' => 106.816635
            ],
            [
                'nik' => '3201012207800004',
                'nama' => 'Budi Santoso',
                'jenis_kelamin' => 'Laki-laki',
                'tempat_lahir' => 'Bandung',
                'tanggal_lahir' => '1980-07-22',
                'agama' => 'Kristen',
                'pendidikan' => 'S1',
                'pekerjaan' => 'Guru',
                'status_perkawinan' => 'Kawin',
                'kewarganegaraan' => 'WNI',
                'alamat_jalan' => 'Jl. Pancasila No. 45',
                'alamat_dusun' => 'Dusun Sari',
                'alamat_rt' => '02',
                'alamat_rw' => '03',
                'alamat_kelurahan' => 'Sukamaju',
                'alamat_kecamatan' => 'Mekarsari',
                'alamat_kabupaten' => 'Bogor',
                'alamat_provinsi' => 'Jawa Barat',
                'kode_pos' => '16710',
                'no_wa' => '081234567892',
                'latitude' => -6.595100,
                'longitude' => 106.816700
            ],
            [
                'nik' => '3201012209750005',
                'nama' => 'Maria Magdalena',
                'jenis_kelamin' => 'Perempuan',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1975-09-22',
                'agama' => 'Katolik',
                'pendidikan' => 'S2',
                'pekerjaan' => 'Dokter',
                'status_perkawinan' => 'Kawin',
                'kewarganegaraan' => 'WNI',
                'alamat_jalan' => 'Jl. Pancasila No. 45',
                'alamat_dusun' => 'Dusun Sari',
                'alamat_rt' => '02',
                'alamat_rw' => '03',
                'alamat_kelurahan' => 'Sukamaju',
                'alamat_kecamatan' => 'Mekarsari',
                'alamat_kabupaten' => 'Bogor',
                'alamat_provinsi' => 'Jawa Barat',
                'kode_pos' => '16710',
                'no_wa' => '081234567893',
                'latitude' => -6.595100,
                'longitude' => 106.816700
            ]
        ];

        foreach ($pendudukData as $data) {
            Penduduk::create($data);
        }
    }

    private function seedKeluarga()
    {
        $keluargaData = [
            [
                'no_kk' => '3201012201850001',
                'nik_kepala_keluarga' => '3201012201850001',
                'alamat_jalan' => 'Jl. Merdeka No. 123',
                'alamat_dusun' => 'Dusun Mekar',
                'alamat_rt' => '01',
                'alamat_rw' => '05',
                'alamat_kelurahan' => 'Sukamaju',
                'alamat_kecamatan' => 'Mekarsari',
                'alamat_kabupaten' => 'Bogor',
                'alamat_provinsi' => 'Jawa Barat',
                'kode_pos' => '16710',
                'latitude' => -6.595038,
                'longitude' => 106.816635
            ],
            [
                'no_kk' => '3201012207800004',
                'nik_kepala_keluarga' => '3201012207800004',
                'alamat_jalan' => 'Jl. Pancasila No. 45',
                'alamat_dusun' => 'Dusun Sari',
                'alamat_rt' => '02',
                'alamat_rw' => '03',
                'alamat_kelurahan' => 'Sukamaju',
                'alamat_kecamatan' => 'Mekarsari',
                'alamat_kabupaten' => 'Bogor',
                'alamat_provinsi' => 'Jawa Barat',
                'kode_pos' => '16710',
                'latitude' => -6.595100,
                'longitude' => 106.816700
            ]
        ];

        foreach ($keluargaData as $data) {
            Keluarga::create($data);
        }

        // Tambahkan anggota keluarga
        AnggotaKeluarga::create([
            'keluarga_id' => 1,
            'nik' => '3201012201850001',
            'hubungan' => 'Kepala Keluarga'
        ]);

        AnggotaKeluarga::create([
            'keluarga_id' => 1,
            'nik' => '3201012205880002',
            'hubungan' => 'Istri'
        ]);

        AnggotaKeluarga::create([
            'keluarga_id' => 1,
            'nik' => '3201012210120003',
            'hubungan' => 'Anak'
        ]);

        AnggotaKeluarga::create([
            'keluarga_id' => 2,
            'nik' => '3201012207800004',
            'hubungan' => 'Kepala Keluarga'
        ]);

        AnggotaKeluarga::create([
            'keluarga_id' => 2,
            'nik' => '3201012209750005',
            'hubungan' => 'Istri'
        ]);
    }

    private function seedPelayananSurat()
    {
        $pelayananData = [
            [
                'nik' => '3201012201850001',
                'jenis_surat' => 'Surat Domisili',
                'keperluan' => 'Pendaftaran BPJS',
                'keterangan' => 'Untuk keperluan pendaftaran BPJS Kesehatan',
                'status' => 'Disetujui',
                'nomor_surat' => 'SKD/001/2024',
                'tanggal_permohonan' => now()->subDays(5),
                'tanggal_selesai' => now()->subDays(2)
            ],
            [
                'nik' => '3201012207800004',
                'jenis_surat' => 'Surat Keterangan Usaha',
                'keperluan' => 'Pengajuan Modal Bank',
                'keterangan' => 'Untuk pengajuan kredit usaha mikro',
                'status' => 'Diproses',
                'tanggal_permohonan' => now()->subDays(3)
            ],
            [
                'nik' => '3201012205880002',
                'jenis_surat' => 'Surat Keterangan Tidak Mampu',
                'keperluan' => 'Beasiswa Anak',
                'keterangan' => 'Untuk pengajuan beasiswa pendidikan anak',
                'status' => 'Pending',
                'tanggal_permohonan' => now()->subDays(1)
            ]
        ];

        foreach ($pelayananData as $data) {
            PelayananSurat::create($data);
        }
    }

    private function seedPengaduan()
    {
        $pengaduanData = [
            [
                'nik' => '3201012201850001',
                'judul' => 'Jalan Rusak di Dusun Mekar',
                'isi_pengaduan' => 'Jalan di Dusun Mekar mengalami kerusakan parah dengan banyak lubang yang membahayakan pengendara. Mohon segera diperbaiki.',
                'kategori' => 'Infrastruktur',
                'status' => 'Ditanggapi',
                'tanggapan' => 'Terima kasih atas laporannya. Tim akan segera melakukan survei dan perbaikan jalan pada minggu depan.',
                'tanggal_tanggapan' => now()->subDays(1),
                'latitude' => -6.595038,
                'longitude' => 106.816635
            ],
            [
                'nik' => '3201012207800004',
                'judul' => 'Lampu Jalan Mati',
                'isi_pengaduan' => 'Lampu jalan di Jl. Pancasila sudah mati sejak 3 hari yang lalu. Mohon segera diperbaiki karena mengganggu keamanan.',
                'kategori' => 'Keamanan',
                'status' => 'Diproses',
                'latitude' => -6.595100,
                'longitude' => 106.816700
            ]
        ];

        foreach ($pengaduanData as $data) {
            Pengaduan::create($data);
        }
    }

    private function seedBantuan()
    {
        $bantuanData = [
            [
                'nik' => '3201012205880002',
                'jenis_bantuan' => 'PKH',
                'deskripsi' => 'Program Keluarga Harapan untuk keluarga kurang mampu',
                'periode' => '2024',
                'nominal' => 600000,
                'status' => 'Diterima',
                'tanggal_distribusi' => now()->subDays(10)
            ],
            [
                'nik' => '3201012201850001',
                'jenis_bantuan' => 'Bansos Pangan',
                'deskripsi' => 'Bantuan sosial berupa sembako untuk keluarga terdampak',
                'periode' => '2024-Q1',
                'status' => 'Diverifikasi'
            ],
            [
                'nik' => '3201012207800004',
                'jenis_bantuan' => 'BLT Dana Desa',
                'deskripsi' => 'Bantuan Langsung Tunai dari Dana Desa',
                'periode' => '2024',
                'nominal' => 300000,
                'status' => 'Menunggu'
            ]
        ];

        foreach ($bantuanData as $data) {
            Bantuan::create($data);
        }
    }

    private function seedBerita()
    {
        $beritaData = [
            [
                'judul' => 'Pembangunan Jalan Dusun Mekar Dimulai',
                'slug' => 'pembangunan-jalan-dusun-mekar-dimulai',
                'konten' => '<p>Pemerintah desa telah memulai pembangunan jalan di Dusun Mekar dengan anggaran dari Dana Desa sebesar Rp 500 juta. Pembangunan ini diharapkan dapat meningkatkan aksesibilitas warga dan mendukung perekonomian desa.</p><p>Pembangunan jalan sepanjang 2 km ini akan menggunakan material berkualitas tinggi dan diharapkan selesai dalam waktu 3 bulan. Selama proses pembangunan, warga dimohon untuk bersabar dengan adanya gangguan lalu lintas sementara.</p>',
                'ringkasan' => 'Pemerintah desa memulai pembangunan jalan di Dusun Mekar dengan anggaran Rp 500 juta dari Dana Desa.',
                'kategori' => 'Pembangunan',
                'status' => 'Terbit',
                'user_id' => 1,
                'tanggal_terbit' => now()->subDays(7),
                'views' => 245
            ],
            [
                'judul' => 'Posyandu Balita Bulan Februari 2024',
                'slug' => 'posyandu-balita-bulan-februari-2024',
                'konten' => '<p>Kegiatan Posyandu Balita akan dilaksanakan pada tanggal 15 Februari 2024 di Balai Desa mulai pukul 08.00 WIB. Seluruh ibu yang memiliki balita diharapkan hadir untuk pemeriksaan kesehatan rutin.</p><p>Kegiatan ini meliputi penimbangan, pengukuran tinggi badan, imunisasi, dan pemberian vitamin. Jangan lupa membawa buku KIA dan kartu imunisasi anak.</p>',
                'ringkasan' => 'Posyandu Balita akan dilaksanakan tanggal 15 Februari 2024 di Balai Desa mulai pukul 08.00 WIB.',
                'kategori' => 'Kesehatan',
                'status' => 'Terbit',
                'user_id' => 1,
                'tanggal_terbit' => now()->subDays(3),
                'views' => 156
            ],
            [
                'judul' => 'Penerimaan Bantuan Sosial Tahap 2',
                'slug' => 'penerimaan-bantuan-sosial-tahap-2',
                'konten' => '<p>Pemerintah desa mengumumkan pembagian bantuan sosial tahap 2 untuk keluarga kurang mampu. Bantuan berupa sembako dan uang tunai akan dibagikan mulai tanggal 20 Februari 2024.</p><p>Keluarga penerima bantuan dapat mengambil di Balai Desa dengan membawa KTP dan Kartu Keluarga. Jadwal pengambilan akan diatur berdasarkan dusun masing-masing.</p>',
                'ringkasan' => 'Pembagian bantuan sosial tahap 2 dimulai tanggal 20 Februari 2024 di Balai Desa.',
                'kategori' => 'Sosial',
                'status' => 'Terbit',
                'user_id' => 1,
                'tanggal_terbit' => now()->subDays(1),
                'views' => 89
            ],
            [
                'judul' => 'Rapat Koordinasi RT/RW Bulanan',
                'slug' => 'rapat-koordinasi-rt-rw-bulanan',
                'konten' => '<p>Akan dilaksanakan rapat koordinasi RT/RW se-desa pada hari Sabtu, 25 Februari 2024 pukul 19.00 WIB di Balai Desa. Agenda rapat meliputi evaluasi program desa dan perencanaan kegiatan bulan depan.</p>',
                'ringkasan' => 'Rapat koordinasi RT/RW akan dilaksanakan Sabtu, 25 Februari 2024 pukul 19.00 WIB.',
                'kategori' => 'Pengumuman',
                'status' => 'Draft',
                'user_id' => 1,
                'views' => 12
            ]
        ];

        foreach ($beritaData as $data) {
            Berita::create($data);
        }
    }
}
