<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Umkm;
use App\Models\ProdukUmkm;
use Illuminate\Support\Str;

class UmkmSeeder extends Seeder
{
    public function run(): void
    {
        // Create UMKM
        $umkmData = [
            [
                'nama_umkm' => 'Warung Makan Bu Sari',
                'kategori' => 'makanan_minuman',
                'pemilik_id' => 1,
                'user_id' => 1,
                'deskripsi' => 'Warung makan tradisional dengan menu khas Sunda. Spesialisasi nasi liwet, pepes ikan, dan sayur asem yang lezat.',
                'alamat' => 'Kampung Sirnajaya RT 01/RW 01, Desa Sirnajaya',
                'nomor_telepon' => '081234567890',
                'email' => 'busari@example.com',
                'status' => 'aktif',
                'is_verified' => true,
                'latitude' => -6.7175,
                'longitude' => 107.1430,
                'jam_operasional' => json_encode([
                    'senin' => ['07:00', '21:00'],
                    'selasa' => ['07:00', '21:00'],
                    'rabu' => ['07:00', '21:00'],
                    'kamis' => ['07:00', '21:00'],
                    'jumat' => ['07:00', '21:00'],
                    'sabtu' => ['07:00', '22:00'],
                    'minggu' => ['07:00', '22:00']
                ]),
                'produk_unggulan' => 'Nasi Liwet Komplit, Pepes Ikan Mas, Sayur Asem',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nama_umkm' => 'Kerajinan Bambu Pak Joko',
                'kategori' => 'kerajinan_tangan',
                'pemilik_id' => 1,
                'user_id' => 1,
                'deskripsi' => 'Kerajinan bambu berkualitas tinggi dengan desain modern dan tradisional. Menerima pesanan custom untuk furniture dan dekorasi rumah.',
                'alamat' => 'Kampung Bojong RT 02/RW 01, Desa Sirnajaya',
                'nomor_telepon' => '081234567891',
                'email' => 'bambukreatif@example.com',
                'status' => 'aktif',
                'is_verified' => true,
                'latitude' => -6.7180,
                'longitude' => 107.1440,
                'jam_operasional' => json_encode([
                    'senin' => ['08:00', '17:00'],
                    'selasa' => ['08:00', '17:00'],
                    'rabu' => ['08:00', '17:00'],
                    'kamis' => ['08:00', '17:00'],
                    'jumat' => ['08:00', '17:00'],
                    'sabtu' => ['08:00', '16:00']
                ]),
                'produk_unggulan' => 'Furniture Bambu, Anyaman Bambu, Kerajinan Dekoratif',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nama_umkm' => 'Tani Madu Sirnajaya',
                'kategori' => 'pertanian_perkebunan',
                'pemilik_id' => 1,
                'user_id' => 1,
                'deskripsi' => 'Produksi madu murni dari peternakan lebah lokal. Madu berkualitas tinggi tanpa campuran bahan kimia, langsung dari peternak.',
                'alamat' => 'Kampung Puncak RT 03/RW 02, Desa Sirnajaya',
                'nomor_telepon' => '081234567892',
                'email' => 'tanimadu@example.com',
                'status' => 'aktif',
                'is_verified' => true,
                'latitude' => -6.7170,
                'longitude' => 107.1420,
                'jam_operasional' => json_encode([
                    'senin' => ['09:00', '16:00'],
                    'selasa' => ['09:00', '16:00'],
                    'rabu' => ['09:00', '16:00'],
                    'kamis' => ['09:00', '16:00'],
                    'jumat' => ['09:00', '16:00'],
                    'sabtu' => ['09:00', '15:00']
                ]),
                'produk_unggulan' => 'Madu Murni 500ml, Madu Murni 1L, Royal Jelly',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nama_umkm' => 'Toko Kelontong Ibu Ani',
                'kategori' => 'perdagangan_retail',
                'pemilik_id' => 1,
                'user_id' => 1,
                'deskripsi' => 'Toko kelontong lengkap menyediakan kebutuhan sehari-hari warga desa. Melayani dengan ramah dan harga terjangkau.',
                'alamat' => 'Kampung Cigentis RT 01/RW 02, Desa Sirnajaya',
                'nomor_telepon' => '081234567893',
                'email' => 'tokoani@example.com',
                'status' => 'aktif',
                'is_verified' => true,
                'latitude' => -6.7185,
                'longitude' => 107.1415,
                'jam_operasional' => json_encode([
                    'senin' => ['06:00', '21:00'],
                    'selasa' => ['06:00', '21:00'],
                    'rabu' => ['06:00', '21:00'],
                    'kamis' => ['06:00', '21:00'],
                    'jumat' => ['06:00', '21:00'],
                    'sabtu' => ['06:00', '22:00'],
                    'minggu' => ['06:00', '22:00']
                ]),
                'produk_unggulan' => 'Sembako, Snack, Minuman, Alat Tulis',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nama_umkm' => 'Konveksi Sirnajaya',
                'kategori' => 'fashion_tekstil',
                'pemilik_id' => 1,
                'user_id' => 1,
                'deskripsi' => 'Konveksi pakaian dengan kualitas jahitan terbaik. Menerima pesanan seragam, kaos, dan pakaian custom dengan harga kompetitif.',
                'alamat' => 'Kampung Situ RT 02/RW 02, Desa Sirnajaya',
                'nomor_telepon' => '081234567894',
                'email' => 'konveksi@example.com',
                'status' => 'aktif',
                'is_verified' => true,
                'latitude' => -6.7165,
                'longitude' => 107.1435,
                'jam_operasional' => json_encode([
                    'senin' => ['08:00', '17:00'],
                    'selasa' => ['08:00', '17:00'],
                    'rabu' => ['08:00', '17:00'],
                    'kamis' => ['08:00', '17:00'],
                    'jumat' => ['08:00', '17:00'],
                    'sabtu' => ['08:00', '16:00']
                ]),
                'produk_unggulan' => 'Seragam Sekolah, Kaos Custom, Pakaian Kerja',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'nama_umkm' => 'Bengkel Motor Sirnajaya',
                'kategori' => 'jasa_layanan',
                'pemilik_id' => 1,
                'user_id' => 1,
                'deskripsi' => 'Bengkel motor terpercaya dengan mekanik berpengalaman. Melayani servis rutin, perbaikan, dan ganti spare part motor.',
                'alamat' => 'Jalan Raya Sirnajaya, Kampung Sirnajaya RT 01/RW 01',
                'nomor_telepon' => '081234567895',
                'email' => 'bengkel@example.com',
                'status' => 'aktif',
                'is_verified' => true,
                'latitude' => -6.7190,
                'longitude' => 107.1425,
                'jam_operasional' => json_encode([
                    'senin' => ['08:00', '17:00'],
                    'selasa' => ['08:00', '17:00'],
                    'rabu' => ['08:00', '17:00'],
                    'kamis' => ['08:00', '17:00'],
                    'jumat' => ['08:00', '17:00'],
                    'sabtu' => ['08:00', '16:00']
                ]),
                'produk_unggulan' => 'Servis Motor, Ganti Oli, Perbaikan Mesin',
                'created_at' => now(),
                'updated_at' => now()
            ]
        ];

        $umkmIds = [];
        foreach ($umkmData as $data) {
            $umkm = Umkm::create($data);
            $umkmIds[] = $umkm->id;
        }

        // Create Products
        $produkData = [
            [
                'umkm_id' => $umkmIds[0],
                'nama_produk' => 'Keripik Singkong Pedas',
                'slug' => 'keripik-singkong-pedas',
                'kategori_produk' => 'Makanan',
                'deskripsi' => 'Keripik singkong renyah dengan bumbu pedas khas desa, cocok untuk camilan',
                'harga_jual' => 25000,
                'harga_diskon' => 20000,
                'stok' => 50,
                'is_available' => true,
                'status' => 'aktif',
                'is_featured' => true,
                'rating_rata_rata' => 4.5,
                'total_terjual' => 120,
                'view_count' => 89,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'umkm_id' => $umkmIds[0],
                'nama_produk' => 'Emping Jagung Original',
                'slug' => 'emping-jagung-original',
                'kategori_produk' => 'Makanan',
                'deskripsi' => 'Emping jagung tradisional dengan rasa gurih alami',
                'harga_jual' => 35000,
                'stok' => 30,
                'is_available' => true,
                'status' => 'aktif',
                'rating_rata_rata' => 4.2,
                'total_terjual' => 85,
                'view_count' => 67,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'umkm_id' => $umkmIds[1],
                'nama_produk' => 'Tas Rotan Premium',
                'slug' => 'tas-rotan-premium',
                'kategori_produk' => 'Kerajinan',
                'deskripsi' => 'Tas rotan berkualitas tinggi, handmade oleh pengrajin lokal',
                'harga_jual' => 150000,
                'stok' => 15,
                'is_available' => true,
                'status' => 'aktif',
                'is_featured' => true,
                'rating_rata_rata' => 4.8,
                'total_terjual' => 45,
                'view_count' => 156,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'umkm_id' => $umkmIds[1],
                'nama_produk' => 'Kain Tenun Motif Tradisional',
                'slug' => 'kain-tenun-motif-tradisional',
                'kategori_produk' => 'Fashion',
                'deskripsi' => 'Kain tenun dengan motif tradisional desa, dibuat dengan teknik turun temurun',
                'harga_jual' => 450000,
                'stok' => 8,
                'is_available' => true,
                'status' => 'aktif',
                'rating_rata_rata' => 4.9,
                'total_terjual' => 23,
                'view_count' => 234,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'umkm_id' => $umkmIds[2],
                'nama_produk' => 'Madu Murni 500gr',
                'slug' => 'madu-murni-500gr',
                'kategori_produk' => 'Pertanian',
                'deskripsi' => 'Madu murni hasil ternak lebah lokal, tanpa campuran bahan kimia',
                'harga_jual' => 75000,
                'stok' => 25,
                'is_available' => true,
                'status' => 'aktif',
                'is_featured' => true,
                'rating_rata_rata' => 4.7,
                'total_terjual' => 78,
                'view_count' => 123,
                'created_at' => now(),
                'updated_at' => now()
            ]
        ];

        foreach ($produkData as $data) {
            ProdukUmkm::create($data);
        }
    }
} 