# Panduan Import Data Penduduk

## Format File
- **Jenis File**: CSV (Comma Separated Values)
- **Delimiter**: Semicolon (`;`) - bukan koma
- **Ukuran Maksimal**: 2MB
- **Encoding**: UTF-8
- **Total Kolom**: 31 kolom

## Kolom Wajib (6 kolom)
1. **nik** - NIK 16 digit (wajib)
2. **nama_lengkap** - Nama lengkap (wajib)
3. **jenis_kelamin** - L/P (wajib)
4. **tempat_lahir** - Tempat lahir (wajib)
5. **tanggal_lahir** - Format: YYYY-MM-DD (wajib)
6. **alamat_lengkap** - Alamat lengkap (wajib)

## Kolom Opsional (21 kolom)
7. **no_kk** - Nomor Kartu Keluarga
8. **status_keluarga** - Status Hubungan Dalam Keluarga
9. **status_kawin** - Status perkawinan
10. **agama** - Agama (Default: Islam)
11. **pendidikan** - Pendidikan terakhir
12. **pekerjaan** - Pekerjaan
13. **nama_ibu** - Nama ibu kandung
14. **nama_ayah** - Nama ayah kandung
15. **tanggal_akta_lahir** - Tanggal akta lahir (YYYY-MM-DD)
16. **no_akta_lahir** - Nomor akta lahir
17. **rt** - RT
18. **rw** - RW
19. **nama_desa** - Nama desa
20. **nama_dusun** - Nama dusun
21. **kewarganegaraan** - Kewarganegaraan (Default: WNI)
22. **golongan_darah** - Golongan darah (A/B/AB/O)
23. **cacat_fisik** - Status cacat fisik (Default: Tidak Ada)
24. **status_hidup** - Status hidup (Default: Hidup)
25. **no_whatsapp** - Nomor WhatsApp
26. **latitude** - Koordinat latitude
27. **longitude** - Koordinat longitude

## Urutan Kolom CSV
```
nik;nama_lengkap;no_kk;tempat_lahir;tanggal_lahir;jenis_kelamin;status_keluarga;status_kawin;agama;pendidikan;pekerjaan;nama_ibu;nama_ayah;tanggal_akta_lahir;no_akta_lahir;alamat_lengkap;rt;rw;nama_desa;nama_dusun;kewarganegaraan;golongan_darah;cacat_fisik;status_hidup;no_whatsapp;latitude;longitude
```

## Contoh Data
```
3201012201990001;John Doe;3201012201990001;Jakarta;1990-01-01;L;Kepala Keluarga;Belum Kawin;Islam;S1;Programmer;Ibu John;Bapak John;1990-01-15;AK-001;Jl. Contoh No. 1;001;001;Desa Contoh;Dusun Contoh;Kecamatan Contoh;Kabupaten Contoh;Jawa Barat;12345;WNI;A;Tidak Ada;Hidup;628123456789;-6.200000;106.816635
```

## Tips Import
1. **Download Template**: Gunakan tombol "Download Template" untuk mendapatkan format yang benar
2. **Delimiter**: Pastikan menggunakan semicolon (`;`) bukan koma (`,`)
3. **NIK Unik**: NIK tidak boleh duplikat
4. **Format Tanggal**: Gunakan format YYYY-MM-DD
5. **Jenis Kelamin**: Gunakan L untuk Laki-laki, P untuk Perempuan
6. **Koordinat**: Gunakan format desimal untuk latitude/longitude

## Nilai Default
Kolom yang tidak diisi akan menggunakan nilai default:
- **agama**: Islam
- **status_kawin**: Belum Kawin
- **kewarganegaraan**: WNI
- **cacat_fisik**: Tidak Ada
- **status_hidup**: Hidup
- **no_kk**: Menggunakan NIK jika kosong

## Troubleshooting
- **Error "Header tidak ditemukan"**: Pastikan baris pertama berisi header yang benar
- **Error "NIK sudah terdaftar"**: NIK sudah ada di database
- **Error "NIK harus 16 digit"**: NIK harus berupa 16 digit angka
- **Error "Format file tidak didukung"**: Pastikan file berformat CSV
- **Error "Nama Lengkap harus diisi"**: Kolom nama_lengkap tidak boleh kosong

## Catatan
- Kolom yang tidak diisi akan menggunakan nilai default
- System akan otomatis mendeteksi delimiter (`,` atau `;`)
- Import akan menampilkan ringkasan berapa data berhasil dan gagal
- Mendukung backward compatibility dengan format lama (kolom 'nama' dan 'alamat')

📞 **Butuh Bantuan?** Hubungi administrator sistem untuk panduan lebih lanjut. 