

<?php $__env->startSection('title', 'Struktur Organisasi Perangkat Desa'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid px-4">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="fas fa-sitemap me-2"></i>Struktur Organisasi
            </h1>
            <p class="text-muted mb-0">Struktur hierarki perangkat desa</p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.perangkat-desa.index')); ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-1"></i>Kembali
            </a>
            <button class="btn btn-primary" onclick="printStructure()">
                <i class="fas fa-print me-1"></i>Cetak
            </button>
        </div>
    </div>

    <!-- Structure Container -->
    <div class="row justify-content-center" id="structure-container">
        <div class="col-12">
            <div class="card shadow-sm border-0">
                <div class="card-body p-4">
                    
                    <!-- Kepala Desa -->
                    <?php if($kepalaDesa): ?>
                    <div class="text-center mb-5">
                        <div class="position-relative d-inline-block">
                            <div class="org-card kepala-desa">
                                <div class="org-photo">
                                    <?php if($kepalaDesa->foto && file_exists(public_path('storage/' . $kepalaDesa->foto))): ?>
                                        <img src="<?php echo e(asset('storage/' . $kepalaDesa->foto)); ?>" 
                                             alt="<?php echo e($kepalaDesa->nama); ?>"
                                             class="rounded-circle">
                                    <?php else: ?>
                                        <div class="org-avatar bg-primary">
                                            <?php echo e(strtoupper(substr($kepalaDesa->nama, 0, 2))); ?>

                                        </div>
                                    <?php endif; ?>
                                    <div class="status-indicator bg-success"></div>
                                </div>
                                <div class="org-info">
                                    <h5 class="org-name"><?php echo e($kepalaDesa->nama); ?></h5>
                                    <p class="org-position"><?php echo e($kepalaDesa->jabatan); ?></p>
                                    <?php if($kepalaDesa->nip): ?>
                                        <small class="text-muted">NIP: <?php echo e($kepalaDesa->nip); ?></small>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Connector Line -->
                        <div class="connector-line vertical"></div>
                    </div>
                    <?php endif; ?>

                    <!-- Sekretaris Desa -->
                    <?php if($sekretaris): ?>
                    <div class="text-center mb-5">
                        <div class="org-card sekretaris">
                            <div class="org-photo">
                                <?php if($sekretaris->foto && file_exists(public_path('storage/' . $sekretaris->foto))): ?>
                                    <img src="<?php echo e(asset('storage/' . $sekretaris->foto)); ?>" 
                                         alt="<?php echo e($sekretaris->nama); ?>"
                                         class="rounded-circle">
                                <?php else: ?>
                                    <div class="org-avatar bg-info">
                                        <?php echo e(strtoupper(substr($sekretaris->nama, 0, 2))); ?>

                                    </div>
                                <?php endif; ?>
                                <div class="status-indicator bg-success"></div>
                            </div>
                            <div class="org-info">
                                <h5 class="org-name"><?php echo e($sekretaris->nama); ?></h5>
                                <p class="org-position"><?php echo e($sekretaris->jabatan); ?></p>
                                <?php if($sekretaris->nip): ?>
                                    <small class="text-muted">NIP: <?php echo e($sekretaris->nip); ?></small>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <!-- Connector Line -->
                        <?php if($staf->count() > 0): ?>
                            <div class="connector-line vertical"></div>
                            <div class="connector-line horizontal"></div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>

                    <!-- Staff Level (Kaur & Kasi) -->
                    <?php if($staf->count() > 0): ?>
                    <div class="mb-5">
                        <h6 class="text-center text-muted mb-4">
                            <i class="fas fa-users me-2"></i>Kepala Urusan & Kepala Seksi
                        </h6>
                        <div class="row justify-content-center">
                            <?php $__currentLoopData = $staf; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $staff): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                                <div class="org-card staff">
                                    <div class="org-photo">
                                        <?php if($staff->foto && file_exists(public_path('storage/' . $staff->foto))): ?>
                                            <img src="<?php echo e(asset('storage/' . $staff->foto)); ?>" 
                                                 alt="<?php echo e($staff->nama); ?>"
                                                 class="rounded-circle">
                                        <?php else: ?>
                                            <div class="org-avatar bg-success">
                                                <?php echo e(strtoupper(substr($staff->nama, 0, 2))); ?>

                                            </div>
                                        <?php endif; ?>
                                        <div class="status-indicator bg-success"></div>
                                    </div>
                                    <div class="org-info">
                                        <h6 class="org-name"><?php echo e($staff->nama); ?></h6>
                                        <p class="org-position"><?php echo e($staff->jabatan); ?></p>
                                        <?php if($staff->bidang_tugas): ?>
                                            <small class="text-muted"><?php echo e($staff->bidang_tugas); ?></small>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Kepala Dusun -->
                    <?php if($kepalaDusun->count() > 0): ?>
                    <div class="mb-5">
                        <h6 class="text-center text-muted mb-4">
                            <i class="fas fa-map-marker-alt me-2"></i>Kepala Dusun
                        </h6>
                        <div class="row justify-content-center">
                            <?php $__currentLoopData = $kepalaDusun; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kadus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                                <div class="org-card kadus">
                                    <div class="org-photo">
                                        <?php if($kadus->foto && file_exists(public_path('storage/' . $kadus->foto))): ?>
                                            <img src="<?php echo e(asset('storage/' . $kadus->foto)); ?>" 
                                                 alt="<?php echo e($kadus->nama); ?>"
                                                 class="rounded-circle">
                                        <?php else: ?>
                                            <div class="org-avatar bg-warning">
                                                <?php echo e(strtoupper(substr($kadus->nama, 0, 2))); ?>

                                            </div>
                                        <?php endif; ?>
                                        <div class="status-indicator bg-success"></div>
                                    </div>
                                    <div class="org-info">
                                        <h6 class="org-name"><?php echo e($kadus->nama); ?></h6>
                                        <p class="org-position"><?php echo e($kadus->jabatan); ?></p>
                                        <?php if($kadus->wilayah_kerja): ?>
                                            <small class="text-muted"><?php echo e($kadus->wilayah_kerja); ?></small>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- RT/RW -->
                    <?php if($rtRw->count() > 0): ?>
                    <div class="mb-4">
                        <h6 class="text-center text-muted mb-4">
                            <i class="fas fa-home me-2"></i>RT & RW
                        </h6>
                        <div class="row justify-content-center">
                            <?php $__currentLoopData = $rtRw; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
                                <div class="org-card rt-rw">
                                    <div class="org-photo">
                                        <?php if($rt->foto && file_exists(public_path('storage/' . $rt->foto))): ?>
                                            <img src="<?php echo e(asset('storage/' . $rt->foto)); ?>" 
                                                 alt="<?php echo e($rt->nama); ?>"
                                                 class="rounded-circle">
                                        <?php else: ?>
                                            <div class="org-avatar bg-secondary">
                                                <?php echo e(strtoupper(substr($rt->nama, 0, 2))); ?>

                                            </div>
                                        <?php endif; ?>
                                        <div class="status-indicator bg-success"></div>
                                    </div>
                                    <div class="org-info">
                                        <h6 class="org-name"><?php echo e($rt->nama); ?></h6>
                                        <p class="org-position"><?php echo e($rt->jabatan); ?></p>
                                        <?php if($rt->wilayah_kerja): ?>
                                            <small class="text-muted"><?php echo e($rt->wilayah_kerja); ?></small>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Empty State -->
                    <?php if(!$kepalaDesa && !$sekretaris && $staf->count() == 0 && $kepalaDusun->count() == 0 && $rtRw->count() == 0): ?>
                    <div class="text-center py-5">
                        <i class="fas fa-users text-muted" style="font-size: 4rem;"></i>
                        <h5 class="text-muted mt-3">Belum Ada Data Perangkat Desa</h5>
                        <p class="text-muted">Silakan tambahkan data perangkat desa terlebih dahulu</p>
                        <a href="<?php echo e(route('admin.perangkat-desa.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>Tambah Perangkat Desa
                        </a>
                    </div>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<style>
.org-card {
    background: white;
    border: 2px solid #e3e6f0;
    border-radius: 12px;
    padding: 20px;
    text-align: center;
    transition: all 0.3s ease;
    position: relative;
    max-width: 280px;
    margin: 0 auto;
}

.org-card:hover {
    border-color: #4e73df;
    transform: translateY(-2px);
    box-shadow: 0 4px 20px rgba(78, 115, 223, 0.15);
}

.org-card.kepala-desa {
    border-color: #e74a3b;
    background: linear-gradient(135deg, #fff 0%, #fff5f5 100%);
}

.org-card.sekretaris {
    border-color: #36b9cc;
    background: linear-gradient(135deg, #fff 0%, #f0fdff 100%);
}

.org-card.staff {
    border-color: #1cc88a;
    background: linear-gradient(135deg, #fff 0%, #f0fff8 100%);
}

.org-card.kadus {
    border-color: #f6c23e;
    background: linear-gradient(135deg, #fff 0%, #fffcf0 100%);
}

.org-card.rt-rw {
    border-color: #6c757d;
    background: linear-gradient(135deg, #fff 0%, #f8f9fa 100%);
}

.org-photo {
    position: relative;
    display: inline-block;
    margin-bottom: 15px;
}

.org-photo img {
    width: 80px;
    height: 80px;
    object-fit: cover;
    border: 3px solid #fff;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.org-avatar {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    font-size: 24px;
    border: 3px solid #fff;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.status-indicator {
    position: absolute;
    bottom: 5px;
    right: 5px;
    width: 20px;
    height: 20px;
    border-radius: 50%;
    border: 3px solid white;
}

.org-info {
    margin-top: 10px;
}

.org-name {
    font-size: 16px;
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 5px;
    line-height: 1.2;
}

.org-position {
    font-size: 14px;
    color: #7f8c8d;
    margin-bottom: 5px;
    font-weight: 500;
}

.connector-line {
    background: #dee2e6;
}

.connector-line.vertical {
    width: 2px;
    height: 30px;
    margin: 0 auto;
}

.connector-line.horizontal {
    height: 2px;
    width: 200px;
    margin: 0 auto 20px;
}

/* Print Styles */
@media print {
    .container-fluid {
        max-width: none !important;
        padding: 0 !important;
    }
    
    .card {
        border: none !important;
        box-shadow: none !important;
    }
    
    .btn {
        display: none !important;
    }
    
    .org-card {
        border: 1px solid #000 !important;
        box-shadow: none !important;
        background: white !important;
        page-break-inside: avoid;
    }
}

/* Responsive Design */
@media (max-width: 768px) {
    .org-card {
        max-width: 100%;
        padding: 15px;
    }
    
    .org-photo img,
    .org-avatar {
        width: 60px;
        height: 60px;
    }
    
    .org-avatar {
        font-size: 18px;
    }
    
    .org-name {
        font-size: 14px;
    }
    
    .org-position {
        font-size: 12px;
    }
}
</style>

<!-- JavaScript -->
<script>
function printStructure() {
    window.print();
}

// Add animation on load
document.addEventListener('DOMContentLoaded', function() {
    const cards = document.querySelectorAll('.org-card');
    cards.forEach((card, index) => {
        setTimeout(() => {
            card.style.opacity = '0';
            card.style.transform = 'translateY(20px)';
            card.style.transition = 'all 0.5s ease';
            
            setTimeout(() => {
                card.style.opacity = '1';
                card.style.transform = 'translateY(0)';
            }, 100);
        }, index * 100);
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/perangkat-desa/struktur.blade.php ENDPATH**/ ?>