

<?php $__env->startSection('title', 'Tambah Pelayanan Surat'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-plus me-2 text-primary"></i>
                Tambah Pelayanan Surat
            </h2>
            <p class="text-muted mb-0">Buat permohonan surat baru</p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.pelayanan-surat.index')); ?>" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>

    <form id="createSuratForm" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-file-alt me-2"></i>Informasi Surat
                        </h5>
                    </div>
                    <div class="card-body">
                        <!-- Jenis Surat -->
                        <div class="mb-4">
                            <label class="form-label required">Jenis Surat</label>
                            <select class="form-select" name="jenis_surat" required id="jenisSuratSelect">
                                <option value="">Pilih Jenis Surat</option>
                                <option value="surat_keterangan_domisili">Surat Keterangan Domisili</option>
                                <option value="surat_keterangan_usaha">Surat Keterangan Usaha</option>
                                <option value="surat_keterangan_tidak_mampu">Surat Keterangan Tidak Mampu</option>
                                <option value="surat_pengantar_ktp">Surat Pengantar KTP</option>
                                <option value="surat_pengantar_kk">Surat Pengantar KK</option>
                                <option value="surat_keterangan_kelahiran">Surat Keterangan Kelahiran</option>
                                <option value="surat_keterangan_kematian">Surat Keterangan Kematian</option>
                                <option value="surat_keterangan_belum_menikah">Surat Keterangan Belum Menikah</option>
                                <option value="surat_lainnya">Lainnya</option>
                            </select>
                        </div>
                        
                        <!-- Jenis Surat Custom -->
                        <div class="mb-4" id="jenisSuratCustomDiv" style="display: none;">
                            <label class="form-label required">Jenis Surat Lainnya</label>
                            <input type="text" class="form-control" name="jenis_surat_custom" 
                                   placeholder="Masukkan jenis surat...">
                        </div>
                        
                        <!-- Pemohon -->
                        <div class="mb-4">
                            <label class="form-label required">Pemohon</label>
                            <select class="form-select" name="nik" required id="pemohonSelect">
                                <option value="">Pilih Pemohon</option>
                                <?php $__currentLoopData = $penduduk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($p->nik); ?>" 
                                            data-nama="<?php echo e($p->nama); ?>" 
                                            data-nik="<?php echo e($p->nik); ?>" 
                                            data-alamat="<?php echo e($p->alamat); ?>" 
                                            data-telepon="<?php echo e($p->no_wa); ?>">
                                        <?php echo e($p->nama); ?> - <?php echo e($p->nik); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="form-text">Pilih warga yang mengajukan permohonan surat</div>
                        </div>
                        
                        <!-- Tanggal Pengajuan -->
                        <div class="mb-4">
                            <label class="form-label required">Tanggal Pengajuan</label>
                            <input type="date" class="form-control" name="tanggal_pengajuan" required
                                   value="<?php echo e(date('Y-m-d')); ?>">
                        </div>
                        
                        <!-- Status -->
                        <div class="mb-4">
                            <label class="form-label required">Status</label>
                            <select class="form-select" name="status" required>
                                <option value="Menunggu" selected>Menunggu</option>
                                <option value="Diproses">Diproses</option>
                                <option value="Selesai">Selesai</option>
                                <option value="Ditolak">Ditolak</option>
                            </select>
                        </div>
                        
                        <!-- Keperluan -->
                        <div class="mb-4">
                            <label class="form-label required">Keperluan</label>
                            <textarea class="form-control" name="keperluan" rows="3" required
                                      placeholder="Jelaskan keperluan/tujuan surat ini..."></textarea>
                        </div>
                        
                        <!-- Catatan -->
                        <div class="mb-4">
                            <label class="form-label">Catatan</label>
                            <textarea class="form-control" name="catatan" rows="3"
                                      placeholder="Catatan tambahan jika ada..."></textarea>
                        </div>
                        
                        <!-- Upload Persyaratan -->
                        <div class="mb-4">
                            <label class="form-label">Upload Persyaratan</label>
                            <div class="border rounded p-3">
                                <input type="file" class="form-control" name="file_persyaratan" 
                                       accept=".pdf,.jpg,.jpeg,.png,.doc,.docx" id="filePersyaratan">
                                <div class="form-text">
                                    <i class="fas fa-info-circle me-1"></i>
                                    File yang diizinkan: PDF, JPG, PNG, DOC, DOCX. Maksimal 5MB
                                </div>
                                <div id="filePreview" class="mt-2"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <!-- Info Pemohon -->
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-user me-2"></i>Info Pemohon
                        </h6>
                    </div>
                    <div class="card-body" id="infoPemohon">
                        <div class="text-center text-muted py-4">
                            <i class="fas fa-user fa-3x mb-3"></i>
                            <p>Pilih pemohon untuk melihat informasi</p>
                        </div>
                    </div>
                </div>
                
                <!-- Template Surat -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-file-download me-2"></i>Template Surat
                        </h6>
                    </div>
                    <div class="card-body">
                        <div id="templateInfo">
                            <div class="text-center text-muted py-3">
                                <i class="fas fa-file-alt fa-2x mb-2"></i>
                                <p class="small">Pilih jenis surat untuk melihat template</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Persyaratan -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-list-check me-2"></i>Persyaratan
                        </h6>
                    </div>
                    <div class="card-body">
                        <div id="persyaratanInfo">
                            <div class="text-center text-muted py-3">
                                <i class="fas fa-clipboard-list fa-2x mb-2"></i>
                                <p class="small">Pilih jenis surat untuk melihat persyaratan</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Actions -->
                <div class="card mt-4">
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-2"></i>Simpan Permohonan
                            </button>
                            <button type="button" class="btn btn-outline-warning" onclick="resetForm()">
                                <i class="fas fa-refresh me-2"></i>Reset Form
                            </button>
                            <a href="<?php echo e(route('admin.pelayanan-surat.index')); ?>" class="btn btn-outline-secondary">
                                <i class="fas fa-times me-2"></i>Batal
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .required::after {
        content: ' *';
        color: #dc3545;
    }
    
    .file-preview {
        border: 1px solid #dee2e6;
        border-radius: 8px;
        padding: 10px;
        background: #f8f9fa;
    }
    
    .file-icon {
        width: 40px;
        height: 40px;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 18px;
    }
    
    .requirement-item {
        padding: 8px 12px;
        border-left: 3px solid #007bff;
        background: #f8f9fa;
        margin-bottom: 8px;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    $('#jenisSuratSelect').on('change', function() {
        updateTemplateInfo();
        updatePersyaratanInfo();
        toggleCustomJenisSurat();
    });
    
    $('#pemohonSelect').on('change', function() {
        updateInfoPemohon();
    });
    
    $('#filePersyaratan').on('change', function() {
        previewFile(this);
    });
});

function toggleCustomJenisSurat() {
    const jenisSurat = document.getElementById('jenisSuratSelect').value;
    const customDiv = document.getElementById('jenisSuratCustomDiv');
    const customInput = document.querySelector('input[name="jenis_surat_custom"]');
    
    if (jenisSurat === 'surat_lainnya') {
        customDiv.style.display = 'block';
        customInput.required = true;
    } else {
        customDiv.style.display = 'none';
        customInput.required = false;
        customInput.value = '';
    }
}

function updateInfoPemohon() {
    const select = document.getElementById('pemohonSelect');
    const selectedOption = select.options[select.selectedIndex];
    
    if (selectedOption.value) {
        const nama = selectedOption.dataset.nama;
        const nik = selectedOption.dataset.nik;
        const alamat = selectedOption.dataset.alamat;
        const telepon = selectedOption.dataset.telepon;
        
        document.getElementById('infoPemohon').innerHTML = `
            <div class="text-center">
                <div class="bg-primary text-white rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                     style="width: 60px; height: 60px;">
                    <i class="fas fa-user fa-lg"></i>
                </div>
                <h6 class="mb-2">${nama}</h6>
                <div class="small text-muted">
                    <div class="mb-1"><strong>NIK:</strong> ${nik}</div>
                    <div class="mb-1"><strong>Alamat:</strong> ${alamat || 'Belum diisi'}</div>
                    <div><strong>Telepon:</strong> ${telepon || 'Belum diisi'}</div>
                </div>
            </div>
        `;
    } else {
        document.getElementById('infoPemohon').innerHTML = `
            <div class="text-center text-muted py-4">
                <i class="fas fa-user fa-3x mb-3"></i>
                <p>Pilih pemohon untuk melihat informasi</p>
            </div>
        `;
    }
}

function updateTemplateInfo() {
    const jenisSurat = document.getElementById('jenisSuratSelect').value;
    const templates = {
        'surat_keterangan_domisili': 'Template Surat Keterangan Domisili',
        'surat_keterangan_usaha': 'Template Surat Keterangan Usaha',
        'surat_keterangan_tidak_mampu': 'Template Surat Keterangan Tidak Mampu',
        'surat_pengantar_ktp': 'Template Surat Pengantar KTP',
        'surat_pengantar_kk': 'Template Surat Pengantar KK',
        'surat_keterangan_kelahiran': 'Template Surat Keterangan Kelahiran',
        'surat_keterangan_kematian': 'Template Surat Keterangan Kematian',
        'surat_keterangan_belum_menikah': 'Template Surat Keterangan Belum Menikah'
    };
    
    if (jenisSurat && templates[jenisSurat]) {
        document.getElementById('templateInfo').innerHTML = `
            <div class="text-center">
                <i class="fas fa-file-pdf fa-2x text-danger mb-2"></i>
                <h6 class="small">${templates[jenisSurat]}</h6>
                <button type="button" class="btn btn-outline-primary btn-sm mt-2" onclick="downloadTemplate('${jenisSurat}')">
                    <i class="fas fa-download me-1"></i>Download
                </button>
            </div>
        `;
    } else {
        document.getElementById('templateInfo').innerHTML = `
            <div class="text-center text-muted py-3">
                <i class="fas fa-file-alt fa-2x mb-2"></i>
                <p class="small">Pilih jenis surat untuk melihat template</p>
            </div>
        `;
    }
}

function updatePersyaratanInfo() {
    const jenisSurat = document.getElementById('jenisSuratSelect').value;
    const persyaratan = {
        'surat_keterangan_domisili': [
            'Fotocopy KTP yang masih berlaku',
            'Fotocopy KK',
            'Surat pengantar dari RT/RW'
        ],
        'surat_keterangan_usaha': [
            'Fotocopy KTP yang masih berlaku',
            'Fotocopy KK',
            'Foto lokasi usaha',
            'Surat keterangan dari RT/RW'
        ],
        'surat_keterangan_tidak_mampu': [
            'Fotocopy KTP yang masih berlaku',
            'Fotocopy KK',
            'Surat keterangan penghasilan dari RT/RW',
            'Fotocopy rekening listrik (3 bulan terakhir)'
        ],
        'surat_pengantar_ktp': [
            'Fotocopy KTP lama (jika perpanjangan)',
            'Fotocopy KK',
            'Fotocopy akta kelahiran',
            'Pas foto 3x4 (2 lembar)'
        ],
        'surat_pengantar_kk': [
            'Fotocopy KTP semua anggota keluarga',
            'Fotocopy KK lama (jika ada)',
            'Fotocopy akta nikah/cerai',
            'Fotocopy akta kelahiran anak'
        ]
    };
    
    if (jenisSurat && persyaratan[jenisSurat]) {
        let html = '';
        persyaratan[jenisSurat].forEach(item => {
            html += `<div class="requirement-item">${item}</div>`;
        });
        
        document.getElementById('persyaratanInfo').innerHTML = html;
    } else {
        document.getElementById('persyaratanInfo').innerHTML = `
            <div class="text-center text-muted py-3">
                <i class="fas fa-clipboard-list fa-2x mb-2"></i>
                <p class="small">Pilih jenis surat untuk melihat persyaratan</p>
            </div>
        `;
    }
}

function previewFile(input) {
    const file = input.files[0];
    const preview = document.getElementById('filePreview');
    
    if (!file) {
        preview.innerHTML = '';
        return;
    }
    
    const fileName = file.name;
    const fileSize = (file.size / 1024 / 1024).toFixed(2);
    const fileType = file.type;
    
    let iconClass = 'fas fa-file';
    let iconColor = 'bg-secondary';
    
    if (fileType.includes('pdf')) {
        iconClass = 'fas fa-file-pdf';
        iconColor = 'bg-danger';
    } else if (fileType.includes('image')) {
        iconClass = 'fas fa-file-image';
        iconColor = 'bg-success';
    } else if (fileType.includes('word') || fileType.includes('document')) {
        iconClass = 'fas fa-file-word';
        iconColor = 'bg-primary';
    }
    
    preview.innerHTML = `
        <div class="file-preview">
            <div class="d-flex align-items-center">
                <div class="file-icon ${iconColor} me-3">
                    <i class="${iconClass}"></i>
                </div>
                <div class="flex-grow-1">
                    <div class="fw-medium">${fileName}</div>
                    <small class="text-muted">${fileSize} MB</small>
                </div>
                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeFile()">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
    `;
}

function removeFile() {
    document.getElementById('filePersyaratan').value = '';
    document.getElementById('filePreview').innerHTML = '';
}

function downloadTemplate(jenisSurat) {
    window.open(`/admin/pelayanan-surat/template/${jenisSurat}`, '_blank');
}

function resetForm() {
    if (confirm('Apakah Anda yakin ingin mereset form?')) {
        document.getElementById('createSuratForm').reset();
        updateInfoPemohon();
        updateTemplateInfo();
        updatePersyaratanInfo();
        removeFile();
        showToast('Form berhasil direset', 'info');
    }
}

document.getElementById('createSuratForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    fetch('<?php echo e(route("admin.pelayanan-surat.store")); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Permohonan surat berhasil disimpan', 'success');
            setTimeout(() => {
                window.location.href = '<?php echo e(route("admin.pelayanan-surat.index")); ?>';
            }, 1500);
        } else {
            showToast(data.message || 'Gagal menyimpan permohonan', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    });
});

function showToast(message, type = 'info') {
    // Simple toast implementation - you can replace with your preferred toast library
    const toast = document.createElement('div');
    toast.className = `alert alert-${type === 'error' ? 'danger' : type} alert-dismissible fade show position-fixed`;
    toast.style.cssText = 'top: 20px; right: 20px; z-index: 1050; min-width: 300px;';
    toast.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(toast);
    
    setTimeout(() => {
        if (toast.parentNode) {
            toast.parentNode.removeChild(toast);
        }
    }, 5000);
}
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/pelayanan-surat/create.blade.php ENDPATH**/ ?>