@extends('layouts.app')

@section('title', 'Bantuan Sosial')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Bantuan Sosial</li>
@endsection

@section('content')
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-hand-holding-heart me-2 text-primary"></i>
            Bantuan Sosial
        </h2>
        <p class="text-muted mb-0">Kelola distribusi bantuan sosial untuk warga</p>
    </div>
    <div>
        <button type="button" class="btn btn-gradient-success me-2" data-bs-toggle="modal" data-bs-target="#addBantuanModal">
            <i class="fas fa-plus me-2"></i>
            Tambah Bantuan
        </button>
        <button type="button" class="btn btn-gradient-info me-2" onclick="exportBantuan()">
            <i class="fas fa-download me-2"></i>
            Export Data
        </button>
        <button type="button" class="btn btn-gradient-warning" data-bs-toggle="modal" data-bs-target="#massDistributionModal">
            <i class="fas fa-users me-2"></i>
            Distribusi Massal
        </button>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-primary me-3">
                    <i class="fas fa-hand-holding-heart"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['total_bantuan'] ?? 0 }}</h4>
                    <small class="text-muted">Total Bantuan</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-success me-3">
                    <i class="fas fa-users"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['total_penerima'] ?? 0 }}</h4>
                    <small class="text-muted">Total Penerima</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-warning me-3">
                    <i class="fas fa-calendar-month"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['bulan_ini'] ?? 0 }}</h4>
                    <small class="text-muted">Bulan Ini</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-info me-3">
                    <i class="fas fa-money-bill-wave"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ number_format($stats['total_nilai'] ?? 0) }}</h4>
                    <small class="text-muted">Total Nilai (Rp)</small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <div class="row align-items-center">
            <div class="col-md-8">
                <div class="row">
                    <div class="col-md-3">
                        <label class="form-label">Jenis Bantuan</label>
                        <select class="form-select" id="filterJenis">
                            <option value="">Semua Jenis</option>
                            <option value="blt">BLT</option>
                            <option value="pkh">PKH</option>
                            <option value="bpnt">BPNT</option>
                            <option value="sembako">Sembako</option>
                            <option value="bsu">BSU</option>
                            <option value="lainnya">Lainnya</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" id="filterStatus">
                            <option value="">Semua Status</option>
                            <option value="aktif">Aktif</option>
                            <option value="selesai">Selesai</option>
                            <option value="ditangguhkan">Ditangguhkan</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Periode</label>
                        <select class="form-select" id="filterPeriode">
                            <option value="">Semua Periode</option>
                            <option value="2024-01">Januari 2024</option>
                            <option value="2024-02">Februari 2024</option>
                            <option value="2024-03">Maret 2024</option>
                            <option value="2024-04">April 2024</option>
                            <option value="2024-05">Mei 2024</option>
                            <option value="2024-06">Juni 2024</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="button" class="btn btn-primary" onclick="applyFilters()">
                                <i class="fas fa-filter me-2"></i>Filter
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 text-end">
                <button type="button" class="btn btn-outline-secondary" onclick="resetFilters()">
                    <i class="fas fa-refresh me-2"></i>Reset
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Main Content -->
<div class="row">
    <!-- Bantuan List -->
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header bg-light">
                <h5 class="card-title mb-0">
                    <i class="fas fa-list me-2"></i>
                    Daftar Bantuan
                </h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" id="bantuanTable">
                        <thead>
                            <tr>
                                <th width="5%">No</th>
                                <th width="20%">Penerima</th>
                                <th width="15%">Jenis Bantuan</th>
                                <th width="15%">Periode</th>
                                <th width="12%">Nilai</th>
                                <th width="10%">Status</th>
                                <th width="23%">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($bantuan as $index => $b)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>
                                    <div>
                                        <strong>{{ $b->penduduk->nama }}</strong>
                                        <br><small class="text-muted">{{ $b->penduduk->nik }}</small>
                                        <br><small class="text-muted">{{ $b->penduduk->alamat }}</small>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $b->jenis_color }}">{{ strtoupper($b->jenis_bantuan) }}</span>
                                </td>
                                <td>
                                    <div>{{ $b->periode }}</div>
                                    <small class="text-muted">
                                        {{ $b->tanggal_distribusi ? $b->tanggal_distribusi->format('d/m/Y') : 'Belum didistribusi' }}
                                    </small>
                                </td>
                                <td>
                                    @if($b->nominal)
                                        <strong>Rp {{ number_format($b->nominal) }}</strong>
                                    @else
                                        <span class="text-muted">{{ $b->keterangan ?? 'Non-tunai' }}</span>
                                    @endif
                                </td>
                                <td>
                                    <span class="badge bg-{{ $b->status_color }}">
                                        {{ ucfirst($b->status) }}
                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        <button type="button" class="btn btn-outline-info" 
                                                onclick="showDetail({{ $b->id }})" title="Detail">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        
                                        <button type="button" class="btn btn-outline-warning" 
                                                onclick="editBantuan({{ $b->id }})" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        
                                        @if($b->status === 'aktif')
                                        <button type="button" class="btn btn-outline-success" 
                                                onclick="markAsReceived({{ $b->id }})" title="Tandai Diterima">
                                            <i class="fas fa-check"></i>
                                        </button>
                                        @endif
                                        
                                        <button type="button" class="btn btn-outline-primary" 
                                                onclick="sendWhatsApp({{ $b->id }})" title="Kirim WA">
                                            <i class="fab fa-whatsapp"></i>
                                        </button>
                                        
                                        <button type="button" class="btn btn-outline-secondary" 
                                                onclick="printKartu({{ $b->id }})" title="Cetak Kartu">
                                            <i class="fas fa-print"></i>
                                        </button>
                                        
                                        <button type="button" class="btn btn-outline-danger" 
                                                onclick="deleteBantuan({{ $b->id }})" title="Hapus">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center py-5">
                                    <div class="text-muted">
                                        <i class="fas fa-hand-holding-heart fa-3x mb-3 d-block"></i>
                                        <h5>Belum ada data bantuan</h5>
                                        <p>Data bantuan sosial akan muncul di sini</p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Sidebar -->
    <div class="col-lg-4">
        <!-- Chart -->
        <div class="card mb-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    Distribusi per Jenis
                </h6>
            </div>
            <div class="card-body">
                <canvas id="bantuanChart" height="200"></canvas>
            </div>
        </div>
        
        <!-- Recent Recipients -->
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-history me-2"></i>
                    Penerima Terbaru
                </h6>
            </div>
            <div class="card-body">
                <div class="recent-recipients">
                    @foreach($recent_recipients ?? [] as $recipient)
                    <div class="d-flex align-items-center mb-3">
                        <div class="avatar bg-success text-white rounded-circle me-3" style="width: 40px; height: 40px;">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="flex-grow-1">
                            <h6 class="mb-0">{{ $recipient['nama'] }}</h6>
                            <small class="text-muted">{{ $recipient['jenis'] }} - {{ $recipient['periode'] }}</small>
                        </div>
                        <div>
                            <span class="badge bg-success">{{ $recipient['status'] }}</span>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Bantuan Modal -->
<div class="modal fade" id="addBantuanModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i>
                    Tambah Bantuan Sosial
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addBantuanForm">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label required">Penerima</label>
                                <select class="form-select" name="nik" required>
                                    <option value="">Pilih Penduduk</option>
                                    @foreach($penduduk ?? [] as $p)
                                    <option value="{{ $p->nik }}">{{ $p->nama }} - {{ $p->nik }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label required">Jenis Bantuan</label>
                                <select class="form-select" name="jenis_bantuan" required onchange="updateBantuanType(this.value)">
                                    <option value="">Pilih Jenis Bantuan</option>
                                    <option value="blt">BLT (Bantuan Langsung Tunai)</option>
                                    <option value="pkh">PKH (Program Keluarga Harapan)</option>
                                    <option value="bpnt">BPNT (Bantuan Pangan Non Tunai)</option>
                                    <option value="sembako">Sembako</option>
                                    <option value="bsu">BSU (Bantuan Subsidi Upah)</option>
                                    <option value="lainnya">Lainnya</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label required">Periode</label>
                                <input type="month" class="form-control" name="periode" required 
                                       value="{{ date('Y-m') }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Tanggal Distribusi</label>
                                <input type="date" class="form-control" name="tanggal_distribusi" 
                                       value="{{ date('Y-m-d') }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row" id="nilaiSection">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nilai Bantuan (Rp)</label>
                                <input type="number" class="form-control" name="nominal" 
                                       placeholder="0" min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Keterangan</label>
                                <input type="text" class="form-control" name="keterangan" 
                                       placeholder="Contoh: 10 kg beras, 2 liter minyak">
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Catatan</label>
                        <textarea class="form-control" name="catatan" rows="3" 
                                  placeholder="Catatan tambahan..."></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select class="form-select" name="status">
                                    <option value="aktif">Aktif</option>
                                    <option value="selesai">Selesai</option>
                                    <option value="ditangguhkan">Ditangguhkan</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check mt-4">
                                <input class="form-check-input" type="checkbox" name="send_wa" value="1" checked>
                                <label class="form-check-label">
                                    Kirim notifikasi WhatsApp
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-save me-2"></i>Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Mass Distribution Modal -->
<div class="modal fade" id="massDistributionModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-users me-2"></i>
                    Distribusi Massal
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="massDistributionForm">
                @csrf
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        Fitur ini memungkinkan distribusi bantuan ke banyak penerima sekaligus
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label required">Jenis Bantuan</label>
                                <select class="form-select" name="jenis_bantuan" required>
                                    <option value="">Pilih Jenis Bantuan</option>
                                    <option value="blt">BLT</option>
                                    <option value="pkh">PKH</option>
                                    <option value="bpnt">BPNT</option>
                                    <option value="sembako">Sembako</option>
                                    <option value="bsu">BSU</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label required">Periode</label>
                                <input type="month" class="form-control" name="periode" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nilai per Penerima (Rp)</label>
                                <input type="number" class="form-control" name="nominal" min="0">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Tanggal Distribusi</label>
                                <input type="date" class="form-control" name="tanggal_distribusi" 
                                       value="{{ date('Y-m-d') }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Kriteria Penerima</label>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="criteria[]" value="keluarga_miskin">
                                    <label class="form-check-label">Keluarga Miskin</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="criteria[]" value="lansia">
                                    <label class="form-check-label">Lansia (>60 tahun)</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="criteria[]" value="disabilitas">
                                    <label class="form-check-label">Penyandang Disabilitas</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Filter Dusun</label>
                        <select class="form-select" name="dusun">
                            <option value="">Semua Dusun</option>
                            <option value="dusun1">Dusun 1</option>
                            <option value="dusun2">Dusun 2</option>
                            <option value="dusun3">Dusun 3</option>
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Keterangan</label>
                        <input type="text" class="form-control" name="keterangan" 
                               placeholder="Deskripsi bantuan non-tunai">
                    </div>
                    
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="send_wa" value="1" checked>
                        <label class="form-check-label">
                            Kirim notifikasi WhatsApp ke semua penerima
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-warning">
                        <i class="fas fa-users me-2"></i>Distribusi Massal
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Detail Modal -->
<div class="modal fade" id="detailModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-hand-holding-heart me-2"></i>
                    Detail Bantuan
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="detailContent">
                <!-- Content will be loaded here -->
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .required::after {
        content: ' *';
        color: #dc3545;
    }
    
    .stats-icon {
        width: 60px;
        height: 60px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
    }
    
    .table th {
        border-top: none;
        font-weight: 600;
        background: #f8f9fa;
    }
    
    .btn-group-sm .btn {
        padding: 0.25rem 0.5rem;
        font-size: 0.875rem;
    }
    
    .badge {
        font-size: 0.75rem;
        font-weight: 500;
    }
    
    .avatar {
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 16px;
    }
</style>
@endpush

@push('scripts')
<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#bantuanTable').DataTable({
        responsive: true,
        pageLength: 25,
        language: {
            url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/id.json'
        },
        columnDefs: [
            { orderable: false, targets: [6] }
        ]
    });
    
    // Initialize chart
    initBantuanChart();
});

// Initialize bantuan chart
function initBantuanChart() {
    const ctx = document.getElementById('bantuanChart').getContext('2d');
    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['BLT', 'PKH', 'BPNT', 'Sembako', 'BSU', 'Lainnya'],
            datasets: [{
                label: 'Jumlah Penerima',
                data: [
                    {{ $chart_data['blt'] ?? 0 }},
                    {{ $chart_data['pkh'] ?? 0 }},
                    {{ $chart_data['bpnt'] ?? 0 }},
                    {{ $chart_data['sembako'] ?? 0 }},
                    {{ $chart_data['bsu'] ?? 0 }},
                    {{ $chart_data['lainnya'] ?? 0 }}
                ],
                backgroundColor: [
                    '#007bff',
                    '#28a745',
                    '#ffc107',
                    '#17a2b8',
                    '#6f42c1',
                    '#fd7e14'
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
}

// Update bantuan type
function updateBantuanType(jenis) {
    const nilaiSection = document.getElementById('nilaiSection');
    if (jenis === 'sembako' || jenis === 'bpnt') {
        // Focus on keterangan for non-cash assistance
        const keteranganField = document.querySelector('input[name="keterangan"]');
        const nominalField = document.querySelector('input[name="nominal"]');
        if (keteranganField) keteranganField.required = true;
        if (nominalField) nominalField.required = false;
    } else {
        // Focus on nilai for cash assistance
        const keteranganField = document.querySelector('input[name="keterangan"]');
        const nominalField = document.querySelector('input[name="nominal"]');
        if (nominalField) nominalField.required = true;
        if (keteranganField) keteranganField.required = false;
    }
}

// Apply filters
function applyFilters() {
    const jenis = document.getElementById('filterJenis').value;
    const status = document.getElementById('filterStatus').value;
    const periode = document.getElementById('filterPeriode').value;
    
    // Implement filtering logic here
    showToast('Filter diterapkan', 'success');
}

// Reset filters
function resetFilters() {
    document.getElementById('filterJenis').value = '';
    document.getElementById('filterStatus').value = '';
    document.getElementById('filterPeriode').value = '';
    
    $('#bantuanTable').DataTable().search('').columns().search('').draw();
    showToast('Filter direset', 'info');
}

// Show detail
function showDetail(id) {
    showLoading();
    
    fetch(`/admin/bantuan/${id}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const bantuan = data.data;
                const detailHtml = `
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Informasi Penerima</h6>
                            <table class="table table-sm">
                                <tr><td>Nama</td><td>: ${bantuan.penduduk.nama}</td></tr>
                                <tr><td>NIK</td><td>: ${bantuan.penduduk.nik}</td></tr>
                                <tr><td>Alamat</td><td>: ${bantuan.penduduk.alamat}</td></tr>
                                <tr><td>No. HP</td><td>: ${bantuan.penduduk.no_wa || '-'}</td></tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h6>Informasi Bantuan</h6>
                            <table class="table table-sm">
                                <tr><td>Jenis</td><td>: ${bantuan.jenis_bantuan.toUpperCase()}</td></tr>
                                <tr><td>Periode</td><td>: ${bantuan.periode}</td></tr>
                                <tr><td>Tanggal</td><td>: ${bantuan.tanggal_distribusi || 'Belum didistribusi'}</td></tr>
                                <tr><td>Status</td><td>: <span class="badge bg-${bantuan.status_color}">${bantuan.status}</span></td></tr>
                            </table>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <h6>Nilai Bantuan</h6>
                            <p>${bantuan.nominal ? 'Rp ' + new Intl.NumberFormat('id-ID').format(bantuan.nominal) : 'Non-tunai'}</p>
                        </div>
                        <div class="col-md-6">
                            <h6>Keterangan</h6>
                            <p>${bantuan.keterangan || '-'}</p>
                        </div>
                    </div>
                    ${bantuan.catatan ? `
                    <div class="row mt-3">
                        <div class="col-12">
                            <h6>Catatan</h6>
                            <p>${bantuan.catatan}</p>
                        </div>
                    </div>
                    ` : ''}
                `;
                
                document.getElementById('detailContent').innerHTML = detailHtml;
                $('#detailModal').modal('show');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Gagal memuat detail', 'error');
        })
        .finally(() => {
            hideLoading();
        });
}

// Edit bantuan
function editBantuan(id) {
    showToast('Fitur edit bantuan akan segera tersedia', 'info');
}

// Mark as received
function markAsReceived(id) {
    if (confirm('Tandai bantuan ini sebagai telah diterima?')) {
        showLoading();
        
        fetch(`/admin/bantuan/${id}/received`, {
            method: 'PUT',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('Bantuan berhasil ditandai diterima', 'success');
                setTimeout(() => location.reload(), 1500);
            } else {
                showToast(data.message || 'Gagal mengubah status', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan', 'error');
        })
        .finally(() => {
            hideLoading();
        });
    }
}

// Send WhatsApp
function sendWhatsApp(id) {
    if (confirm('Kirim notifikasi WhatsApp ke penerima?')) {
        showLoading();
        
        fetch(`/admin/bantuan/${id}/send-wa`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('WhatsApp berhasil dikirim', 'success');
            } else {
                showToast(data.message || 'Gagal mengirim WhatsApp', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan', 'error');
        })
        .finally(() => {
            hideLoading();
        });
    }
}

// Print kartu
function printKartu(id) {
    window.open(`/admin/bantuan/${id}/print`, '_blank');
}

// Delete bantuan
function deleteBantuan(id) {
    if (confirm('Apakah Anda yakin ingin menghapus data bantuan ini?')) {
        showLoading();
        
        fetch(`/admin/bantuan/${id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('Data bantuan berhasil dihapus', 'success');
                setTimeout(() => location.reload(), 1500);
            } else {
                showToast(data.message || 'Gagal menghapus', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan', 'error');
        })
        .finally(() => {
            hideLoading();
        });
    }
}

// Export bantuan
function exportBantuan() {
    showToast('Fitur export akan segera tersedia', 'info');
}

// Handle add bantuan form
document.getElementById('addBantuanForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    showLoading();
    
    fetch('/admin/bantuan', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Bantuan berhasil ditambahkan', 'success');
            $('#addBantuanModal').modal('hide');
            setTimeout(() => location.reload(), 1500);
        } else {
            showToast(data.message || 'Gagal menambahkan bantuan', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    })
    .finally(() => {
        hideLoading();
    });
});

// Handle mass distribution form
document.getElementById('massDistributionForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    showLoading();
    
    fetch('/admin/bantuan/mass-distribution', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast(`Distribusi massal berhasil! ${data.count} penerima ditambahkan.`, 'success');
            $('#massDistributionModal').modal('hide');
            setTimeout(() => location.reload(), 2000);
        } else {
            showToast(data.message || 'Gagal melakukan distribusi massal', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    })
    .finally(() => {
        hideLoading();
    });
});
</script>
@endpush 
