<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Keluarga - {{ date('d F Y') }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
        }
        
        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #333;
        }
        
        .header h2 {
            margin: 5px 0;
            font-size: 14px;
            color: #666;
        }
        
        .info {
            margin-bottom: 20px;
        }
        
        .info table {
            width: 100%;
        }
        
        .info td {
            padding: 3px 0;
        }
        
        .data-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        
        .data-table th,
        .data-table td {
            border: 1px solid #333;
            padding: 6px 4px;
            text-align: left;
            font-size: 10px;
        }
        
        .data-table th {
            background-color: #f5f5f5;
            font-weight: bold;
            text-align: center;
        }
        
        .data-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        .footer {
            margin-top: 30px;
            text-align: right;
            font-size: 11px;
        }
        
        .signature {
            margin-top: 40px;
            text-align: right;
        }
        
        .signature-box {
            display: inline-block;
            text-align: center;
            margin-left: 50px;
        }
        
        .signature-line {
            border-bottom: 1px solid #333;
            width: 200px;
            margin: 50px 0 10px 0;
        }
        
        @media print {
            body {
                margin: 0;
            }
            
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <!-- Print Button -->
    <div class="no-print" style="text-align: center; margin-bottom: 20px;">
        <button onclick="window.print()" style="padding: 10px 20px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer;">
            <span style="margin-right: 5px;">🖨️</span> Cetak / Download PDF
        </button>
        <button onclick="window.close()" style="padding: 10px 20px; background: #6c757d; color: white; border: none; border-radius: 5px; cursor: pointer; margin-left: 10px;">
            <span style="margin-right: 5px;">❌</span> Tutup
        </button>
    </div>

    <!-- Header -->
    <div class="header">
        <h1>LAPORAN DATA KELUARGA</h1>
        <h2>DESA [NAMA DESA]</h2>
        <p style="margin: 5px 0; font-size: 12px;">
            Dicetak pada: {{ \Carbon\Carbon::now()->format('d F Y, H:i') }} WIB
        </p>
    </div>

    <!-- Summary Info -->
    <div class="info">
        <table>
            <tr>
                <td width="150"><strong>Total Keluarga:</strong></td>
                <td>{{ $keluarga->total() }} keluarga</td>
                <td width="150"><strong>Halaman:</strong></td>
                <td>{{ $keluarga->currentPage() }} dari {{ $keluarga->lastPage() }}</td>
            </tr>
            <tr>
                <td><strong>Total Anggota:</strong></td>
                                    <td>{{ $keluarga->sum(function($k) { return $k->anggotaKeluarga ? $k->anggotaKeluarga->count() : 0; }) }} orang</td>
                <td><strong>Data per halaman:</strong></td>
                <td>{{ $keluarga->perPage() }} data</td>
            </tr>
            <tr>
                <td><strong>Rata-rata Anggota:</strong></td>
                                    <td>{{ $keluarga->count() > 0 ? round($keluarga->sum(function($k) { return $k->anggotaKeluarga ? $k->anggotaKeluarga->count() : 0; }) / $keluarga->count(), 1) : 0 }} orang/keluarga</td>
                <td><strong>Filter diterapkan:</strong></td>
                <td>{{ request()->has('dusun') || request()->has('rt') || request()->has('rw') ? 'Ya' : 'Tidak' }}</td>
            </tr>
        </table>
    </div>

    <!-- Data Table -->
    <table class="data-table">
        <thead>
            <tr>
                <th width="3%">No</th>
                <th width="15%">No. KK</th>
                <th width="20%">Kepala Keluarga</th>
                <th width="25%">Alamat</th>
                <th width="8%">Dusun</th>
                <th width="5%">RT</th>
                <th width="5%">RW</th>
                <th width="8%">Jml Anggota</th>
                <th width="6%">L</th>
                <th width="6%">P</th>
            </tr>
        </thead>
        <tbody>
            @forelse($keluarga as $index => $k)
            @php
                $lakiLaki = $k->anggotaKeluarga->filter(function($anggota) {
                    return $anggota->penduduk && $anggota->penduduk->jenis_kelamin === 'L';
                })->count();
                
                $perempuan = $k->anggotaKeluarga->filter(function($anggota) {
                    return $anggota->penduduk && $anggota->penduduk->jenis_kelamin === 'P';
                })->count();
            @endphp
            <tr>
                <td style="text-align: center;">{{ $keluarga->firstItem() + $index }}</td>
                <td>{{ $k->no_kk }}</td>
                                    <td>{{ optional($k->kepalaKeluarga)->nama ?? '-' }}</td>
                <td>{{ Str::limit($k->alamat, 40) }}</td>
                <td>{{ $k->dusun ?? '-' }}</td>
                <td style="text-align: center;">{{ $k->rt ?? '-' }}</td>
                <td style="text-align: center;">{{ $k->rw ?? '-' }}</td>
                                    <td style="text-align: center;">{{ $k->anggotaKeluarga ? $k->anggotaKeluarga->count() : 0 }}</td>
                <td style="text-align: center;">{{ $lakiLaki }}</td>
                <td style="text-align: center;">{{ $perempuan }}</td>
            </tr>
            @empty
            <tr>
                <td colspan="10" style="text-align: center; padding: 20px;">
                    Tidak ada data keluarga
                </td>
            </tr>
            @endforelse
        </tbody>
    </table>

    <!-- Footer -->
    <div class="footer">
        <p><strong>Catatan:</strong></p>
        <ul style="text-align: left; margin: 10px 0; padding-left: 20px;">
            <li>L = Laki-laki, P = Perempuan</li>
            <li>Data yang ditampilkan maksimal 50 data per halaman untuk optimalisasi</li>
            <li>Untuk data lengkap, silakan export ke format Excel</li>
        </ul>
    </div>

    <!-- Signature -->
    <div class="signature">
        <div class="signature-box">
            <p style="margin: 0;">{{ \Carbon\Carbon::now()->format('d F Y') }}</p>
            <p style="margin: 5px 0;">Kepala Desa</p>
            <div class="signature-line"></div>
            <p style="margin: 0; font-weight: bold;">[NAMA KEPALA DESA]</p>
            <p style="margin: 0; font-size: 10px;">NIP. [NIP KEPALA DESA]</p>
        </div>
    </div>
</body>
</html> 
