@extends('layouts.app')

@section('title', 'Notifikasi WhatsApp')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Notifikasi WhatsApp</li>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Header with Gradient Background -->
    <div class="card border-0 shadow-sm mb-4" style="background: linear-gradient(135deg, #25d366 0%, #128c7e 100%);">
        <div class="card-body text-white py-4">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <div class="d-flex align-items-center">
                        <div class="icon-circle bg-white bg-opacity-25 me-3">
                            <i class="fab fa-whatsapp fs-4"></i>
                        </div>
                        <div>
                            <h2 class="h3 mb-1">Pusat Notifikasi WhatsApp</h2>
                            <p class="mb-0 opacity-75">Kelola dan kirim notifikasi WhatsApp ke seluruh warga desa</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 text-md-end mt-3 mt-md-0">
                    <div class="btn-group" role="group">
                        <button class="btn btn-light btn-lg shadow-sm" data-bs-toggle="modal" data-bs-target="#broadcastModal">
                            <i class="fas fa-bullhorn me-2"></i>Kirim Broadcast
                        </button>
                        <button class="btn btn-outline-light btn-lg" data-bs-toggle="modal" data-bs-target="#templateModal">
                            <i class="fas fa-edit me-2"></i>Template
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Enhanced Statistics Cards with Animation -->
    <div class="row mb-4">
        <div class="col-xl-2 col-lg-4 col-md-6 mb-4">
            <div class="card border-0 shadow-lg h-100 stat-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
                <div class="card-body text-white p-4">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <div class="fs-6 fw-light opacity-75 mb-1">Total Notifikasi</div>
                            <div class="h2 mb-0 fw-bold counter" data-target="{{ $stats['total_notifications'] }}">0</div>
                        </div>
                        <div class="icon-circle bg-white bg-opacity-20">
                            <i class="fas fa-bell fs-4"></i>
                        </div>
                    </div>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-white bg-opacity-50" style="width: 100%"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-2 col-lg-4 col-md-6 mb-4">
            <div class="card border-0 shadow-lg h-100 stat-card" style="background: linear-gradient(135deg, #ffecd2 0%, #fcb69f 100%);">
                <div class="card-body text-dark p-4">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <div class="fs-6 fw-light text-muted mb-1">Belum Dibaca</div>
                            <div class="h2 mb-0 fw-bold counter" data-target="{{ $stats['unread_notifications'] }}">0</div>
                        </div>
                        <div class="icon-circle bg-warning bg-opacity-20">
                            <i class="fas fa-clock fs-4 text-warning"></i>
                        </div>
                    </div>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-warning" style="width: 75%"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-2 col-lg-4 col-md-6 mb-4">
            <div class="card border-0 shadow-lg h-100 stat-card" style="background: linear-gradient(135deg, #a8edea 0%, #fed6e3 100%);">
                <div class="card-body text-dark p-4">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <div class="fs-6 fw-light text-muted mb-1">Menunggu Kirim</div>
                            <div class="h2 mb-0 fw-bold counter" data-target="{{ $stats['pending_messages'] }}">0</div>
                        </div>
                        <div class="icon-circle bg-info bg-opacity-20">
                            <i class="fas fa-paper-plane fs-4 text-info"></i>
                        </div>
                    </div>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-info" style="width: 60%"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-2 col-lg-4 col-md-6 mb-4">
            <div class="card border-0 shadow-lg h-100 stat-card" style="background: linear-gradient(135deg, #d299c2 0%, #fef9d7 100%);">
                <div class="card-body text-dark p-4">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <div class="fs-6 fw-light text-muted mb-1">Berhasil Terkirim</div>
                            <div class="h2 mb-0 fw-bold counter" data-target="{{ $stats['sent_messages'] }}">0</div>
                        </div>
                        <div class="icon-circle bg-success bg-opacity-20">
                            <i class="fas fa-check-circle fs-4 text-success"></i>
                        </div>
                    </div>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-success" style="width: 90%"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-2 col-lg-4 col-md-6 mb-4">
            <div class="card border-0 shadow-lg h-100 stat-card" style="background: linear-gradient(135deg, #ffeaa7 0%, #fab1a0 100%);">
                <div class="card-body text-dark p-4">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <div class="fs-6 fw-light text-muted mb-1">Gagal Terkirim</div>
                            <div class="h2 mb-0 fw-bold counter" data-target="{{ $stats['failed_messages'] }}">0</div>
                        </div>
                        <div class="icon-circle bg-danger bg-opacity-20">
                            <i class="fas fa-exclamation-triangle fs-4 text-danger"></i>
                        </div>
                    </div>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-danger" style="width: 30%"></div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-2 col-lg-4 col-md-6 mb-4">
            <div class="card border-0 shadow-lg h-100 stat-card" style="background: linear-gradient(135deg, #74b9ff 0%, #0984e3 100%);">
                <div class="card-body text-white p-4">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <div class="fs-6 fw-light opacity-75 mb-1">Hari Ini</div>
                            <div class="h2 mb-0 fw-bold counter" data-target="{{ $stats['today_messages'] }}">0</div>
                        </div>
                        <div class="icon-circle bg-white bg-opacity-20">
                            <i class="fas fa-calendar-day fs-4"></i>
                        </div>
                    </div>
                    <div class="progress mt-3" style="height: 4px;">
                        <div class="progress-bar bg-white bg-opacity-50" style="width: 80%"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Enhanced Recent Notifications -->
    <div class="card border-0 shadow-lg">
        <div class="card-header bg-gradient-primary text-white py-4" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;">
            <div class="row align-items-center">
                <div class="col">
                    <h4 class="mb-1 fw-bold">📱 Notifikasi WhatsApp Terbaru</h4>
                    <p class="mb-0 opacity-75">Kelola dan pantau status pengiriman pesan</p>
                </div>
                <div class="col-auto">
                    <div class="btn-group" role="group">
                        <button class="btn btn-light btn-sm" onclick="loadNotifications()">
                            <i class="fas fa-sync-alt me-1"></i>Refresh
                        </button>
                        <button class="btn btn-outline-light btn-sm" onclick="exportNotifications()">
                            <i class="fas fa-download me-1"></i>Export
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body p-0">
            <!-- Filter Tabs -->
            <div class="px-4 pt-4">
                <ul class="nav nav-pills nav-fill" id="notificationTabs" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="all-tab" data-bs-toggle="pill" data-bs-target="#all" type="button" role="tab">
                            <i class="fas fa-list me-2"></i>Semua <span class="badge bg-primary ms-1">{{ $stats['total_notifications'] }}</span>
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pending-tab" data-bs-toggle="pill" data-bs-target="#pending" type="button" role="tab">
                            <i class="fas fa-clock me-2"></i>Menunggu <span class="badge bg-warning ms-1">{{ $stats['pending_messages'] }}</span>
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="sent-tab" data-bs-toggle="pill" data-bs-target="#sent" type="button" role="tab">
                            <i class="fas fa-check me-2"></i>Terkirim <span class="badge bg-success ms-1">{{ $stats['sent_messages'] }}</span>
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="failed-tab" data-bs-toggle="pill" data-bs-target="#failed" type="button" role="tab">
                            <i class="fas fa-times me-2"></i>Gagal <span class="badge bg-danger ms-1">{{ $stats['failed_messages'] }}</span>
                        </button>
                    </li>
                </ul>
            </div>
            
            <div class="tab-content p-4" id="notificationTabContent">
                <div class="tab-pane fade show active" id="all" role="tabpanel">
                    @if($recentNotifications->count() > 0)
                    <!-- Advanced Search and Filter Bar -->
                    <div class="card bg-light border-0 mb-4 mx-4">
                        <div class="card-body py-3">
                            <div class="row g-3">
                                <div class="col-md-3">
                                    <div class="input-group">
                                        <span class="input-group-text bg-white border-end-0">
                                            <i class="fas fa-search text-muted"></i>
                                        </span>
                                        <input type="text" class="form-control border-start-0" placeholder="Cari pesan atau nomor..." id="searchInput">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <select class="form-select" id="statusFilter">
                                        <option value="">Semua Status</option>
                                        <option value="Terkirim">Terkirim</option>
                                        <option value="Pending">Menunggu</option>
                                        <option value="Gagal">Gagal</option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <select class="form-select" id="typeFilter">
                                        <option value="">Semua Jenis</option>
                                        <option value="surat_selesai">Surat Selesai</option>
                                        <option value="bantuan_diterima">Bantuan Diterima</option>
                                        <option value="pengaduan_ditanggapi">Pengaduan Ditanggapi</option>
                                        <option value="broadcast_berita">Broadcast Berita</option>
                                        <option value="manual">Manual</option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <input type="date" class="form-control" id="dateFilter" title="Filter Tanggal">
                                </div>
                                <div class="col-md-3">
                                    <div class="btn-group w-100" role="group">
                                        <button type="button" class="btn btn-outline-primary" onclick="resetFilters()">
                                            <i class="fas fa-undo me-1"></i>Reset
                                        </button>
                                        <button type="button" class="btn btn-outline-success" onclick="bulkMarkAsRead()">
                                            <i class="fas fa-check-double me-1"></i>Tandai Semua Dibaca
                                        </button>
                                        <button type="button" class="btn btn-outline-danger" onclick="bulkDelete()">
                                            <i class="fas fa-trash me-1"></i>Hapus Terpilih
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Enhanced Table with Rich Data -->
                    <div class="table-responsive">
                        <table class="table table-hover mb-0" id="notificationsTable">
                            <thead style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                                <tr>
                                    <th width="40px">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="selectAll">
                                        </div>
                                    </th>
                                    <th width="120px">
                                        <i class="fas fa-clock me-2"></i>Waktu
                                    </th>
                                    <th width="200px">
                                        <i class="fas fa-user me-2"></i>Penerima
                                    </th>
                                    <th>
                                        <i class="fas fa-comment me-2"></i>Detail Pesan
                                    </th>
                                    <th width="120px">
                                        <i class="fas fa-tag me-2"></i>Jenis
                                    </th>
                                    <th width="100px">
                                        <i class="fas fa-info-circle me-2"></i>Status
                                    </th>
                                    <th width="180px">
                                        <i class="fas fa-cogs me-2"></i>Aksi
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($recentNotifications as $notification)
                                <tr class="{{ !$notification->is_read ? 'table-warning bg-opacity-10' : '' }}" data-notification-id="{{ $notification->id }}">
                                    <td>
                                        <div class="form-check">
                                            <input class="form-check-input notification-checkbox" type="checkbox" value="{{ $notification->id }}">
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column">
                                            <span class="fw-medium text-primary">{{ $notification->created_at->format('d/m/Y') }}</span>
                                            <small class="text-muted">{{ $notification->created_at->format('H:i') }}</small>
                                            <small class="text-info">{{ $notification->created_at->diffForHumans() }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-circle bg-success bg-opacity-10 me-3">
                                                <i class="fab fa-whatsapp text-success"></i>
                                            </div>
                                            <div class="flex-grow-1">
                                                <div class="fw-bold">{{ $notification->phone_number ?: $notification->no_wa_legacy }}</div>
                                                @if($notification->penduduk)
                                                    <small class="text-success">
                                                        <i class="fas fa-user me-1"></i>{{ $notification->penduduk->nama }}
                                                    </small>
                                                    <br>
                                                    @if($notification->penduduk->dusun)
                                                        <small class="text-muted">
                                                            <i class="fas fa-map-marker-alt me-1"></i>{{ $notification->penduduk->dusun }}
                                                        </small>
                                                    @endif
                                                @else
                                                    <small class="text-muted">
                                                        <i class="fas fa-phone me-1"></i>Nomor External
                                                    </small>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="message-preview">
                                            <div class="fw-medium mb-1" style="color: #2d3748;">
                                                {{ Str::limit($notification->message ?: $notification->pesan_legacy, 100) }}
                                            </div>
                                            <div class="d-flex align-items-center gap-2 mt-2">
                                                @if(!$notification->is_read)
                                                    <span class="badge bg-warning bg-opacity-75">
                                                        <i class="fas fa-circle me-1" style="font-size: 6px;"></i>Baru
                                                    </span>
                                                @endif
                                                <small class="text-muted">
                                                    <i class="fas fa-font me-1"></i>{{ strlen($notification->message ?: $notification->pesan_legacy) }} karakter
                                                </small>
                                                @if($notification->sent_at)
                                                    <small class="text-success">
                                                        <i class="fas fa-paper-plane me-1"></i>{{ $notification->sent_at->format('H:i') }}
                                                    </small>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        @php
                                            $type = $notification->message_type ?: $notification->jenis_legacy;
                                            $typeConfig = [
                                                'surat_selesai' => ['color' => 'success', 'icon' => 'fas fa-file-alt', 'label' => 'Surat Selesai'],
                                                'bantuan_diterima' => ['color' => 'primary', 'icon' => 'fas fa-hand-holding-heart', 'label' => 'Bantuan Diterima'],
                                                'pengaduan_ditanggapi' => ['color' => 'warning', 'icon' => 'fas fa-reply', 'label' => 'Pengaduan Ditanggapi'],
                                                'broadcast_berita' => ['color' => 'info', 'icon' => 'fas fa-bullhorn', 'label' => 'Broadcast Berita'],
                                                'manual' => ['color' => 'secondary', 'icon' => 'fas fa-edit', 'label' => 'Manual']
                                            ];
                                            $config = $typeConfig[$type] ?? ['color' => 'dark', 'icon' => 'fas fa-envelope', 'label' => 'General'];
                                        @endphp
                                        <span class="badge bg-{{ $config['color'] }} bg-opacity-75 d-flex align-items-center gap-1 py-2 px-3">
                                            <i class="{{ $config['icon'] }}"></i>
                                            <span>{{ $config['label'] }}</span>
                                        </span>
                                    </td>
                                    <td>
                                        @switch($notification->status)
                                            @case('Terkirim')
                                            @case('sent')
                                                <div class="d-flex align-items-center">
                                                    <span class="status-indicator bg-success me-2"></span>
                                                    <div>
                                                        <div class="badge bg-success bg-opacity-75">
                                                            <i class="fas fa-check-circle me-1"></i>Terkirim
                                                        </div>
                                                        @if($notification->sent_at)
                                                            <small class="d-block text-muted mt-1">{{ $notification->sent_at->format('H:i') }}</small>
                                                        @endif
                                                    </div>
                                                </div>
                                                @break
                                            @case('Pending')
                                            @case('pending')
                                                <div class="d-flex align-items-center">
                                                    <span class="spinner-border spinner-border-sm text-warning me-2" role="status"></span>
                                                    <div>
                                                        <div class="badge bg-warning bg-opacity-75">
                                                            <i class="fas fa-clock me-1"></i>Menunggu
                                                        </div>
                                                        <small class="d-block text-muted mt-1">Dalam antrian</small>
                                                    </div>
                                                </div>
                                                @break
                                            @case('Gagal')
                                            @case('failed')
                                                <div class="d-flex align-items-center">
                                                    <span class="status-indicator bg-danger me-2"></span>
                                                    <div>
                                                        <div class="badge bg-danger bg-opacity-75">
                                                            <i class="fas fa-exclamation-triangle me-1"></i>Gagal
                                                        </div>
                                                        <small class="d-block text-muted mt-1">Coba lagi</small>
                                                    </div>
                                                </div>
                                                @break
                                            @default
                                                <span class="badge bg-secondary">{{ ucfirst($notification->status) }}</span>
                                        @endswitch
                                    </td>
                                    <td>
                                        <div class="btn-group-vertical btn-group-sm w-100" role="group">
                                            <!-- First Row of Actions -->
                                            <div class="btn-group btn-group-sm mb-1" role="group">
                                                @if(!$notification->is_read)
                                                    <button class="btn btn-outline-success" onclick="markAsRead({{ $notification->id }})" title="Tandai Dibaca">
                                                        <i class="fas fa-check"></i>
                                                    </button>
                                                @endif
                                                <button class="btn btn-outline-info" onclick="viewFullMessage({{ $notification->id }})" title="Lihat Detail">
                                                    <i class="fas fa-eye"></i>
                                                </button>
                                                <button class="btn btn-outline-secondary" onclick="copyMessage({{ $notification->id }})" title="Copy Pesan">
                                                    <i class="fas fa-copy"></i>
                                                </button>
                                            </div>
                                            <!-- Second Row of Actions -->
                                            <div class="btn-group btn-group-sm" role="group">
                                                @if(in_array($notification->status, ['Gagal', 'failed']))
                                                    <button class="btn btn-outline-warning" onclick="resendMessage({{ $notification->id }})" title="Kirim Ulang">
                                                        <i class="fas fa-redo"></i>
                                                    </button>
                                                @endif
                                                <button class="btn btn-outline-primary" onclick="forwardMessage({{ $notification->id }})" title="Forward">
                                                    <i class="fas fa-share"></i>
                                                </button>
                                                <button class="btn btn-outline-danger" onclick="deleteNotification({{ $notification->id }})" title="Hapus">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination Info -->
                    <div class="card-footer bg-light border-top-0">
                        <div class="row align-items-center">
                            <div class="col-md-6">
                                <div class="d-flex align-items-center gap-3">
                                    <small class="text-muted">
                                        <i class="fas fa-info-circle me-1"></i>
                                        Menampilkan <strong>{{ $recentNotifications->count() }}</strong> dari <strong>{{ $stats['total_notifications'] }}</strong> notifikasi
                                    </small>
                                    <div class="form-check form-check-inline">
                                        <input class="form-check-input" type="checkbox" id="autoRefresh">
                                        <label class="form-check-label" for="autoRefresh">
                                            <small>Auto-refresh</small>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6 text-end">
                                <div class="btn-group btn-group-sm" role="group">
                                    <button class="btn btn-outline-primary" onclick="exportToExcel()">
                                        <i class="fas fa-file-excel me-1"></i>Excel
                                    </button>
                                    <button class="btn btn-outline-secondary" onclick="exportToPdf()">
                                        <i class="fas fa-file-pdf me-1"></i>PDF
                                    </button>
                                    <button class="btn btn-outline-info" onclick="generateReport()">
                                        <i class="fas fa-chart-bar me-1"></i>Laporan
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    @else
                    <!-- Enhanced Empty State -->
                    <div class="text-center py-5">
                        <div class="empty-state">
                            <div class="mb-4">
                                <i class="fab fa-whatsapp" style="font-size: 4rem; color: #25d366; opacity: 0.5;"></i>
                            </div>
                            <h4 class="text-muted mb-3">Belum Ada Notifikasi WhatsApp</h4>
                            <p class="text-muted mb-4">
                                Notifikasi WhatsApp akan muncul di sini setelah ada aktivitas dari warga.<br>
                                Anda juga dapat mengirim notifikasi manual menggunakan fitur broadcast.
                            </p>
                            <div class="d-flex justify-content-center gap-2">
                                <button class="btn btn-primary btn-lg" data-bs-toggle="modal" data-bs-target="#broadcastModal">
                                    <i class="fas fa-bullhorn me-2"></i>Kirim Broadcast Pertama
                                </button>
                                <button class="btn btn-outline-secondary btn-lg" data-bs-toggle="modal" data-bs-target="#templateModal">
                                    <i class="fas fa-edit me-2"></i>Buat Template
                                </button>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Broadcast Modal -->
<div class="modal fade" id="broadcastModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-bullhorn me-2"></i>Kirim Broadcast WhatsApp</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="broadcastForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Pilih Penerima</label>
                        <select class="form-select" name="recipient_type" id="recipientType">
                            <option value="all">Semua Warga</option>
                            <option value="dusun">Per Dusun</option>
                            <option value="custom">Nomor Custom</option>
                        </select>
                    </div>
                    
                    <div class="mb-3 d-none" id="dusunSelect">
                        <label class="form-label">Pilih Dusun</label>
                        <select class="form-select" name="dusun">
                            <option value="">-- Pilih Dusun --</option>
                            <!-- Dusun options will be loaded dynamically -->
                        </select>
                    </div>
                    
                    <div class="mb-3 d-none" id="customNumbers">
                        <label class="form-label">Nomor WhatsApp (pisahkan dengan koma)</label>
                        <textarea class="form-control" name="phone_numbers" rows="3" placeholder="081234567890, 081234567891"></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Template Pesan</label>
                        <select class="form-select" id="messageTemplate">
                            <option value="">-- Pilih Template --</option>
                            @foreach($templates as $key => $template)
                                <option value="{{ $template }}">{{ ucwords(str_replace('_', ' ', $key)) }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Pesan <span class="text-danger">*</span></label>
                        <textarea class="form-control" name="message" id="broadcastMessage" rows="5" required placeholder="Tulis pesan broadcast..."></textarea>
                        <div class="form-text">
                            <span id="charCount">0</span>/1000 karakter
                        </div>
                    </div>
                    
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle me-2"></i>
                        Pesan akan dikirim ke <span id="recipientCount">semua warga</span> yang memiliki nomor WhatsApp.
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-paper-plane me-2"></i>Kirim Broadcast
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Template Modal -->
<div class="modal fade" id="templateModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="fas fa-edit me-2"></i>Template Pesan WhatsApp</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    @foreach($templates as $key => $template)
                    <div class="col-md-6 mb-3">
                        <div class="card">
                            <div class="card-header">
                                <h6 class="mb-0">{{ ucwords(str_replace('_', ' ', $key)) }}</h6>
                            </div>
                            <div class="card-body">
                                <textarea class="form-control" rows="3" readonly>{{ $template }}</textarea>
                                <button class="btn btn-sm btn-primary mt-2" onclick="useTemplate('{{ $template }}')">
                                    <i class="fas fa-copy me-1"></i>Gunakan Template
                                </button>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Floating Action Button -->
<div class="floating-action">
    <div class="btn-group-vertical" role="group">
        <button type="button" class="btn btn-success mb-2" data-bs-toggle="modal" data-bs-target="#broadcastModal" title="Kirim Broadcast">
            <i class="fas fa-bullhorn"></i>
        </button>
        <button type="button" class="btn btn-info mb-2" onclick="loadNotifications()" title="Refresh Data">
            <i class="fas fa-sync-alt"></i>
        </button>
        <button type="button" class="btn btn-warning mb-2" onclick="exportToExcel()" title="Export Excel">
            <i class="fas fa-file-excel"></i>
        </button>
        <button type="button" class="btn btn-secondary" onclick="scrollToTop()" title="Ke Atas">
            <i class="fas fa-arrow-up"></i>
        </button>
    </div>
</div>

<!-- Message Detail Modal -->
<div class="modal fade" id="messageDetailModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header" style="background: linear-gradient(135deg, #25d366 0%, #128c7e 100%); color: white;">
                <h5 class="modal-title">
                    <i class="fab fa-whatsapp me-2"></i>Detail Notifikasi WhatsApp
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <!-- Left Column: Message Details -->
                    <div class="col-lg-8">
                        <div class="card border-0 shadow-sm mb-4">
                            <div class="card-header bg-light">
                                <h6 class="mb-0 text-dark">
                                    <i class="fas fa-comment-alt me-2"></i>Isi Pesan
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="whatsapp-message-bubble">
                                    <div class="message-content" id="detailMessageContent">
                                        <!-- Message content will be loaded here -->
                                    </div>
                                    <div class="message-time text-muted mt-2">
                                        <small id="detailMessageTime"></small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Message Analysis -->
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-light">
                                <h6 class="mb-0 text-dark">
                                    <i class="fas fa-chart-line me-2"></i>Analisis Pesan
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="row text-center">
                                    <div class="col-md-3">
                                        <div class="stat-item">
                                            <div class="stat-value text-primary" id="detailCharCount">0</div>
                                            <div class="stat-label">Karakter</div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="stat-item">
                                            <div class="stat-value text-info" id="detailWordCount">0</div>
                                            <div class="stat-label">Kata</div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="stat-item">
                                            <div class="stat-value text-success" id="detailLineCount">0</div>
                                            <div class="stat-label">Baris</div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="stat-item">
                                            <div class="stat-value text-warning" id="detailReadTime">0</div>
                                            <div class="stat-label">Detik Baca</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Right Column: Recipient & Status -->
                    <div class="col-lg-4">
                        <!-- Recipient Info -->
                        <div class="card border-0 shadow-sm mb-4">
                            <div class="card-header bg-light">
                                <h6 class="mb-0 text-dark">
                                    <i class="fas fa-user me-2"></i>Informasi Penerima
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="recipient-info" id="detailRecipientInfo">
                                    <!-- Recipient info will be loaded here -->
                                </div>
                            </div>
                        </div>

                        <!-- Delivery Status -->
                        <div class="card border-0 shadow-sm mb-4">
                            <div class="card-header bg-light">
                                <h6 class="mb-0 text-dark">
                                    <i class="fas fa-info-circle me-2"></i>Status Pengiriman
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="delivery-status" id="detailDeliveryStatus">
                                    <!-- Delivery status will be loaded here -->
                                </div>
                            </div>
                        </div>

                        <!-- Quick Actions -->
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-light">
                                <h6 class="mb-0 text-dark">
                                    <i class="fas fa-bolt me-2"></i>Aksi Cepat
                                </h6>
                            </div>
                            <div class="card-body">
                                <div class="d-grid gap-2">
                                    <button class="btn btn-outline-success" onclick="markAsReadFromModal()">
                                        <i class="fas fa-check me-2"></i>Tandai Dibaca
                                    </button>
                                    <button class="btn btn-outline-primary" onclick="copyMessageFromModal()">
                                        <i class="fas fa-copy me-2"></i>Copy Pesan
                                    </button>
                                    <button class="btn btn-outline-info" onclick="forwardMessageFromModal()">
                                        <i class="fas fa-share me-2"></i>Forward Pesan
                                    </button>
                                    <button class="btn btn-outline-warning" onclick="resendMessageFromModal()">
                                        <i class="fas fa-redo me-2"></i>Kirim Ulang
                                    </button>
                                    <button class="btn btn-outline-danger" onclick="deleteMessageFromModal()">
                                        <i class="fas fa-trash me-2"></i>Hapus Pesan
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Tutup</button>
                <button type="button" class="btn btn-success" onclick="downloadMessageReport()">
                    <i class="fas fa-download me-2"></i>Download Laporan
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Forward Message Modal -->
<div class="modal fade" id="forwardModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary text-white">
                <h5 class="modal-title">
                    <i class="fas fa-share me-2"></i>Forward Pesan
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Pesan yang akan diteruskan:</label>
                    <div class="card bg-light">
                        <div class="card-body">
                            <div id="forwardMessagePreview"></div>
                        </div>
                    </div>
                </div>
                <div class="mb-3">
                    <label for="forwardTo" class="form-label">Teruskan ke:</label>
                    <select class="form-select" id="forwardTo" multiple>
                        <option value="all">Semua Warga</option>
                        <option value="dusun1">Dusun 1</option>
                        <option value="dusun2">Dusun 2</option>
                        <option value="dusun3">Dusun 3</option>
                        <option value="manual">Input Manual</option>
                    </select>
                </div>
                <div class="mb-3" id="forwardManualNumbers" style="display: none;">
                    <label for="forwardPhoneNumbers" class="form-label">Nomor WhatsApp</label>
                    <textarea class="form-control" id="forwardPhoneNumbers" rows="3" 
                              placeholder="Masukkan nomor WhatsApp (pisahkan dengan koma)"></textarea>
                </div>
                <div class="mb-3">
                    <label for="forwardNote" class="form-label">Catatan tambahan (opsional)</label>
                    <textarea class="form-control" id="forwardNote" rows="2" 
                              placeholder="Tambahkan catatan jika diperlukan"></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Batal</button>
                <button type="button" class="btn btn-primary" onclick="confirmForward()">
                    <i class="fas fa-paper-plane me-2"></i>Teruskan Pesan
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Bulk Actions Modal -->
<div class="modal fade" id="bulkActionsModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-gradient-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-tasks me-2"></i>Aksi Massal
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    Anda akan melakukan aksi pada <strong id="selectedItemsCount">0</strong> notifikasi terpilih
                </div>
                <div class="mb-3">
                    <label for="bulkAction" class="form-label">Pilih Aksi:</label>
                    <select class="form-select" id="bulkAction">
                        <option value="">-- Pilih Aksi --</option>
                        <option value="mark_read">Tandai Dibaca</option>
                        <option value="mark_unread">Tandai Belum Dibaca</option>
                        <option value="delete">Hapus</option>
                        <option value="export">Export ke Excel</option>
                    </select>
                </div>
                <div class="alert alert-warning d-none" id="bulkWarning">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    <span id="bulkWarningText"></span>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Batal</button>
                <button type="button" class="btn btn-warning" onclick="executeBulkAction()">
                    <i class="fas fa-play me-2"></i>Jalankan Aksi
                </button>
            </div>
        </div>
    </div>
</div>

@endsection

@push('styles')
<style>
/* WhatsApp Message Bubble Styling */
.whatsapp-message-bubble {
    background: #dcf8c6;
    border-radius: 8px;
    padding: 12px 16px;
    position: relative;
    max-width: 100%;
    box-shadow: 0 1px 2px rgba(0,0,0,0.1);
}

.whatsapp-message-bubble::before {
    content: '';
    position: absolute;
    top: 0;
    right: -8px;
    width: 0;
    height: 0;
    border: 8px solid transparent;
    border-left-color: #dcf8c6;
    border-right: 0;
    border-top: 0;
    margin-top: 8px;
}

.message-content {
    font-size: 14px;
    line-height: 1.5;
    color: #333;
    word-wrap: break-word;
}

.message-time {
    font-size: 11px;
    color: #999;
    margin-top: 4px;
    text-align: right;
}

/* WhatsApp Preview Styling */
.whatsapp-preview {
    background: #e5ddd5;
    padding: 20px;
    border-radius: 8px;
    min-height: 200px;
}

.message-bubble {
    background: #dcf8c6;
    border-radius: 8px;
    padding: 8px 12px;
    margin-bottom: 8px;
    position: relative;
    max-width: 80%;
    margin-left: auto;
    box-shadow: 0 1px 2px rgba(0,0,0,0.1);
}

.message-bubble::after {
    content: '';
    position: absolute;
    top: 0;
    right: -8px;
    width: 0;
    height: 0;
    border: 8px solid transparent;
    border-left-color: #dcf8c6;
    border-right: 0;
    border-top: 0;
    margin-top: 8px;
}

/* Enhanced Statistics Items */
.stat-item {
    text-align: center;
    padding: 12px;
    border-radius: 8px;
    background: rgba(255,255,255,0.1);
    transition: all 0.3s ease;
}

.stat-item:hover {
    background: rgba(255,255,255,0.2);
    transform: translateY(-2px);
}

.stat-value {
    font-size: 1.5rem;
    font-weight: bold;
    margin-bottom: 4px;
}

.stat-label {
    font-size: 0.8rem;
    color: #666;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

/* Avatar Circle Enhanced */
.avatar-circle {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    overflow: hidden;
}

.avatar-circle::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: radial-gradient(circle, transparent 40%, rgba(255,255,255,0.1) 40%);
    opacity: 0;
    transition: opacity 0.3s ease;
}

.avatar-circle:hover::before {
    opacity: 1;
}

/* Status Indicator with Pulse */
.status-indicator {
    width: 8px;
    height: 8px;
    border-radius: 50%;
    display: inline-block;
    position: relative;
}

.status-indicator::after {
    content: '';
    position: absolute;
    top: -2px;
    left: -2px;
    width: 12px;
    height: 12px;
    border-radius: 50%;
    background: inherit;
    opacity: 0.4;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0% { transform: scale(1); opacity: 0.4; }
    50% { transform: scale(1.5); opacity: 0.1; }
    100% { transform: scale(1); opacity: 0.4; }
}

/* Enhanced Search and Filter */
.input-group .form-control:focus {
    border-color: #25d366;
    box-shadow: 0 0 0 0.2rem rgba(37, 211, 102, 0.25);
}

.form-select:focus {
    border-color: #25d366;
    box-shadow: 0 0 0 0.2rem rgba(37, 211, 102, 0.25);
}

/* Checkbox Enhancements */
.form-check-input:checked {
    background-color: #25d366;
    border-color: #25d366;
}

.form-check-input:focus {
    border-color: #25d366;
    box-shadow: 0 0 0 0.25rem rgba(37, 211, 102, 0.25);
}

/* Button Group Vertical Enhancements */
.btn-group-vertical .btn-group {
    width: 100%;
    margin-bottom: 0.25rem;
}

.btn-group-vertical .btn-group .btn {
    flex: 1;
    min-width: 35px;
}

/* Responsive Table Enhancements */
@media (max-width: 768px) {
    .table-responsive {
        font-size: 0.875rem;
    }
    
    .btn-group-vertical .btn-group .btn {
        padding: 0.25rem 0.5rem;
        font-size: 0.75rem;
    }
    
    .message-preview {
        max-width: 200px;
    }
    
    .stat-card {
        margin-bottom: 1rem;
    }
}

/* Modal Enhancements */
.modal-xl {
    max-width: 1200px;
}

.modal-content {
    border-radius: 15px;
    border: none;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
}

.modal-header {
    border-bottom: 1px solid rgba(0, 0, 0, 0.1);
    border-radius: 15px 15px 0 0;
}

/* Loading States */
.loading-skeleton {
    background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
    background-size: 200% 100%;
    animation: loading 1.5s infinite;
}

@keyframes loading {
    0% { background-position: 200% 0; }
    100% { background-position: -200% 0; }
}

/* Tooltip Enhancements */
.tooltip-inner {
    background-color: #25d366;
    border-radius: 8px;
    padding: 8px 12px;
    font-size: 0.875rem;
}

.tooltip.bs-tooltip-top .tooltip-arrow::before {
    border-top-color: #25d366;
}

/* Badge Animations */
.badge.bg-warning {
    animation: blink 2s infinite;
}

@keyframes blink {
    0%, 50% { opacity: 1; }
    51%, 100% { opacity: 0.7; }
}

/* Timeline Styles */
.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline::before {
    content: '';
    position: absolute;
    left: 15px;
    top: 0;
    bottom: 0;
    width: 2px;
    background: #e9ecef;
}

.timeline-item {
    position: relative;
    margin-bottom: 20px;
}

.timeline-marker {
    position: absolute;
    left: -23px;
    top: 5px;
    width: 12px;
    height: 12px;
    border-radius: 50%;
    border: 2px solid #fff;
    box-shadow: 0 0 0 2px #e9ecef;
}

.timeline-content {
    background: #f8f9fa;
    padding: 10px 15px;
    border-radius: 8px;
    border-left: 3px solid #dee2e6;
}

/* Enhanced Button Styles */
.btn-group-vertical .btn-group .btn {
    transition: all 0.2s ease;
    border-radius: 4px !important;
    margin: 1px;
}

.btn-group-vertical .btn-group .btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

/* Search Input Enhancements */
.input-group .input-group-text {
    background: transparent;
    border-right: none;
}

.input-group .form-control {
    border-left: none;
    padding-left: 0;
}

.input-group .form-control:focus {
    box-shadow: 0 0 0 0.2rem rgba(37, 211, 102, 0.25);
}

/* Card Hover Effects */
.card {
    transition: all 0.3s ease;
}

.card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.1) !important;
}

/* Progress Bar Animations */
.progress-bar {
    animation: progressFill 1s ease-in-out;
}

@keyframes progressFill {
    0% { width: 0%; }
    100% { width: var(--progress-width, 0%); }
}

/* Notification Badges */
.notification-badge {
    position: absolute;
    top: -5px;
    right: -5px;
    background: #dc3545;
    color: white;
    border-radius: 50%;
    width: 20px;
    height: 20px;
    font-size: 0.75rem;
    display: flex;
    align-items: center;
    justify-content: center;
    animation: bounce 2s infinite;
}

@keyframes bounce {
    0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
    40% { transform: translateY(-10px); }
    60% { transform: translateY(-5px); }
}

/* Enhanced Table Styles */
.table thead th {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    color: white !important;
    border: none !important;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    font-size: 0.875rem;
}

.table tbody tr:nth-child(even) {
    background-color: rgba(0,0,0,0.02);
}

.table tbody tr:hover {
    background-color: rgba(37, 211, 102, 0.1) !important;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

/* Message Preview Enhancements */
.message-preview {
    position: relative;
    cursor: pointer;
}

.message-preview::after {
    content: '👁️ Klik untuk detail';
    position: absolute;
    bottom: -20px;
    left: 0;
    font-size: 0.75rem;
    color: #6c757d;
    opacity: 0;
    transition: opacity 0.3s ease;
}

.message-preview:hover::after {
    opacity: 1;
}

/* Status Indicators */
.status-indicator.bg-success::after {
    background: #28a745;
}

.status-indicator.bg-warning::after {
    background: #ffc107;
}

.status-indicator.bg-danger::after {
    background: #dc3545;
}

/* Floating Action Button */
.floating-action {
    position: fixed;
    bottom: 30px;
    right: 30px;
    z-index: 1050;
}

.floating-action .btn {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    box-shadow: 0 4px 20px rgba(37, 211, 102, 0.4);
    transition: all 0.3s ease;
}

.floating-action .btn:hover {
    transform: scale(1.1) rotate(15deg);
    box-shadow: 0 6px 25px rgba(37, 211, 102, 0.6);
}

/* Loading States */
.loading-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255,255,255,0.8);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 9999;
}

.loading-spinner {
    width: 50px;
    height: 50px;
    border: 4px solid #f3f3f3;
    border-top: 4px solid #25d366;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}
<style>
/* Enhanced Icon Circle */
.icon-circle {
    width: 55px;
    height: 55px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    position: relative;
    transition: all 0.3s ease;
}

/* Avatar for message preview */
.avatar-sm {
    width: 40px;
    height: 40px;
}

/* Animated Stats Cards */
.stat-card {
    transition: all 0.4s ease;
    cursor: pointer;
    position: relative;
    overflow: hidden;
}

.stat-card:hover {
    transform: scale(1.05) translateY(-5px);
    box-shadow: 0 20px 40px rgba(0,0,0,0.15) !important;
}

.stat-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
    transition: left 0.5s;
}

.stat-card:hover::before {
    left: 100%;
}

/* Enhanced Table */
.table-hover tbody tr {
    transition: all 0.3s ease;
}

.table-hover tbody tr:hover {
    background-color: rgba(102, 126, 234, 0.1) !important;
    transform: scale(1.02);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

/* Message Preview Styling */
.message-preview {
    max-width: 350px;
}

.message-preview:hover {
    cursor: pointer;
}

/* Notification Tabs */
.nav-pills .nav-link {
    border-radius: 25px;
    transition: all 0.3s ease;
    font-weight: 500;
}

.nav-pills .nav-link:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.nav-pills .nav-link.active {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%) !important;
    border: none;
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
}

/* Status Badges with Animation */
.badge {
    font-size: 0.75rem;
    font-weight: 500;
    letter-spacing: 0.5px;
    transition: all 0.3s ease;
}

.badge:hover {
    transform: scale(1.1);
}

/* Spinner Animation */
@keyframes pulse {
    0% { opacity: 1; }
    50% { opacity: 0.5; }
    100% { opacity: 1; }
}

.spinner-border-sm {
    animation: pulse 1.5s ease-in-out infinite;
}

/* Empty State */
.empty-state {
    padding: 3rem 1rem;
    text-align: center;
}

.empty-state i {
    animation: float 3s ease-in-out infinite;
}

@keyframes float {
    0%, 100% { transform: translateY(0px); }
    50% { transform: translateY(-10px); }
}

/* Button Group Enhancements */
.btn-group-sm .btn {
    transition: all 0.3s ease;
    border-radius: 6px !important;
    margin: 0 1px;
}

.btn-group-sm .btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

/* Dropdown Menu */
.dropdown-menu {
    border: none;
    box-shadow: 0 10px 30px rgba(0,0,0,0.15);
    border-radius: 12px;
    padding: 8px 0;
}

.dropdown-item {
    transition: all 0.3s ease;
    border-radius: 8px;
    margin: 2px 8px;
}

.dropdown-item:hover {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    transform: translateX(5px);
}

/* Loading Animation */
@keyframes shimmer {
    0% { background-position: -200px 0; }
    100% { background-position: calc(200px + 100%) 0; }
}

.loading-shimmer {
    background: linear-gradient(90deg, #f0f0f0 0px, #e0e0e0 40px, #f0f0f0 80px);
    background-size: 200px;
    animation: shimmer 1.5s infinite;
}

/* Counter Animation */
.counter {
    transition: all 0.8s ease;
}

/* WhatsApp Theme Colors */
.text-whatsapp { color: #25d366 !important; }
.bg-whatsapp { background-color: #25d366 !important; }
.border-whatsapp { border-color: #25d366 !important; }

/* DataTables Fixes */
.dataTables_wrapper {
    width: 100%;
}

.dataTables_wrapper .dataTables_length,
.dataTables_wrapper .dataTables_filter,
.dataTables_wrapper .dataTables_info,
.dataTables_wrapper .dataTables_paginate {
    margin-bottom: 1rem;
}

.dataTables_wrapper .dataTables_filter input {
    border: 1px solid #e2e8f0;
    border-radius: 6px;
    padding: 0.375rem 0.75rem;
}

/* Action buttons in table */
.d-flex.gap-1 {
    gap: 0.25rem !important;
    flex-wrap: wrap;
}

.d-flex.gap-1 .btn {
    white-space: nowrap;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .stat-card {
        margin-bottom: 1rem;
    }
    
    .d-flex.gap-1 {
        flex-direction: column;
        gap: 0.1rem !important;
    }
    
    .d-flex.gap-1 .btn {
        font-size: 0.75rem;
        padding: 0.25rem 0.5rem;
    }
    
    .table-responsive {
        font-size: 0.875rem;
    }
    
    /* Hide some columns on mobile */
    .table-responsive th:nth-child(3),
    .table-responsive td:nth-child(3) {
        display: none;
    }
    
    .table-responsive th:nth-child(4),
    .table-responsive td:nth-child(4) {
        display: none;
    }
}

/* Print Styles */
@media print {
    .btn, .dropdown, .modal {
        display: none !important;
    }
}
</style>
@endpush

@push('scripts')
<script>
$(document).ready(function() {
    // Simple DataTable initialization
    function initializeDataTable() {
        if ($('#notificationsTable').length === 0) {
            console.log('No table found, skipping DataTable initialization');
            return;
        }
        
        try {
            // Destroy existing DataTable if it exists
            if ($.fn.DataTable.isDataTable('#notificationsTable')) {
                $('#notificationsTable').DataTable().destroy();
            }
            
            // Simple initialization
            $('#notificationsTable').DataTable({
                "order": [[ 0, "desc" ]],
                "pageLength": 15,
                "responsive": false,
                "autoWidth": true,
                "language": {
                    "emptyTable": "Tidak ada data yang tersedia",
                    "info": "Menampilkan _START_ sampai _END_ dari _TOTAL_ entri",
                    "infoEmpty": "Menampilkan 0 sampai 0 dari 0 entri",
                    "lengthMenu": "Tampilkan _MENU_ entri",
                    "search": "Cari:",
                    "paginate": {
                        "first": "Pertama",
                        "last": "Terakhir", 
                        "next": "Selanjutnya",
                        "previous": "Sebelumnya"
                    }
                },
                "columnDefs": [
                    { "orderable": false, "targets": 5 }
                ]
            });
            
            console.log('DataTable initialized successfully');
            
        } catch (error) {
            console.error('DataTable initialization failed:', error);
        }
    }
    
    // Initialize DataTable
    initializeDataTable();
    
    // Animate counters on page load
    animateCounters();
    
    // Initialize tooltips
    $('[title]').tooltip();
    
    // Auto refresh every 30 seconds - disabled for now
    // setInterval(function() {
    //     if (!$('.modal').hasClass('show')) { // Don't refresh if modal is open
    //         checkForUpdates();
    //     }
    // }, 30000);
    
    // Handle recipient type change
    $('#recipientType').change(function() {
        const type = $(this).val();
        $('#dusunSelect, #customNumbers').addClass('d-none');
        
        if (type === 'dusun') {
            $('#dusunSelect').removeClass('d-none');
            loadDusunOptions();
        } else if (type === 'custom') {
            $('#customNumbers').removeClass('d-none');
        }
        
        updateRecipientCount();
    });
    
    // Handle template selection
    $('#messageTemplate').change(function() {
        const template = $(this).val();
        if (template) {
            $('#broadcastMessage').val(template);
            updateCharCount();
        }
    });
    
    // Handle message input
    $('#broadcastMessage').on('input', updateCharCount);
    
    // Handle broadcast form submission
    $('#broadcastForm').submit(function(e) {
        e.preventDefault();
        sendBroadcast();
    });
});

function loadNotifications() {
    // Destroy existing DataTable if it exists
    if ($.fn.DataTable.isDataTable('#notificationsTable')) {
        $('#notificationsTable').DataTable().destroy();
    }
    
    // Reload the page to get fresh data
    location.reload();
}

function markAsRead(notificationId) {
    // Temporarily disabled - API endpoint not implemented yet
    showToast('Fitur ini akan segera tersedia', 'info');
    return;
    
    $.post(`/admin/api/notifications/${notificationId}/read`, {
        _token: $('meta[name="csrf-token"]').attr('content')
    })
    .done(function(response) {
        if (response.success) {
            showToast('Notifikasi ditandai sudah dibaca', 'success');
            loadNotifications();
        }
    })
    .fail(function() {
        showToast('Gagal menandai notifikasi', 'error');
    });
}

function resendMessage(notificationId) {
    // Temporarily disabled - API endpoint not implemented yet
    showToast('Fitur kirim ulang akan segera tersedia', 'info');
    return;
    
    Swal.fire({
        title: 'Kirim Ulang?',
        text: 'Apakah Anda yakin ingin mengirim ulang pesan ini?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#25d366',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Ya, Kirim Ulang',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            $.post(`/admin/api/notifications/${notificationId}/resend`, {
                _token: $('meta[name="csrf-token"]').attr('content')
            })
            .done(function(response) {
                if (response.success) {
                    showToast('Pesan berhasil dikirim ulang', 'success');
                    loadNotifications();
                } else {
                    showToast('Gagal mengirim ulang pesan', 'error');
                }
            })
            .fail(function() {
                showToast('Gagal mengirim ulang pesan', 'error');
            });
        }
    });
}

function viewNotification(notificationId) {
    // Implementation for viewing notification details
    showToast('Fitur detail notifikasi akan segera tersedia', 'info');
}

function loadDusunOptions() {
    // In real implementation, load dusun options from API
    const dusunSelect = $('select[name="dusun"]');
    const dusunOptions = ['Dusun 1', 'Dusun 2', 'Dusun 3']; // Example data
    
    dusunSelect.empty().append('<option value="">-- Pilih Dusun --</option>');
    dusunOptions.forEach(dusun => {
        dusunSelect.append(`<option value="${dusun}">${dusun}</option>`);
    });
}

function updateRecipientCount() {
    const type = $('#recipientType').val();
    let text = 'semua warga';
    
    if (type === 'dusun') {
        text = 'warga di dusun terpilih';
    } else if (type === 'custom') {
        text = 'nomor yang dimasukkan';
    }
    
    $('#recipientCount').text(text);
}

function updateCharCount() {
    const length = $('#broadcastMessage').val().length;
    $('#charCount').text(length);
    
    if (length > 1000) {
        $('#charCount').addClass('text-danger');
    } else {
        $('#charCount').removeClass('text-danger');
    }
}

function useTemplate(template) {
    $('#broadcastMessage').val(template);
    updateCharCount();
    $('#templateModal').modal('hide');
    showToast('Template berhasil digunakan', 'success');
}

function sendBroadcast() {
    const formData = new FormData($('#broadcastForm')[0]);
    
    // Show loading with progress animation
    Swal.fire({
        title: '📱 Mengirim Broadcast WhatsApp',
        html: `
            <div class="text-center">
                <div class="spinner-border text-success mb-3" role="status"></div>
                <p>Mohon tunggu, pesan sedang dikirim...</p>
                <div class="progress">
                    <div class="progress-bar bg-success progress-bar-striped progress-bar-animated" role="progressbar" style="width: 0%"></div>
                </div>
            </div>
        `,
        allowOutsideClick: false,
        showConfirmButton: false
    });
    
    // Simulate progress animation
    let progress = 0;
    const progressInterval = setInterval(() => {
        progress += Math.random() * 30;
        if (progress > 90) progress = 90;
        $('.progress-bar').css('width', progress + '%');
    }, 200);
    
    // Temporarily use mock response - API endpoint not implemented yet
    setTimeout(() => {
        clearInterval(progressInterval);
        $('.progress-bar').css('width', '100%');
        
        setTimeout(() => {
            Swal.close();
            $('#broadcastModal').modal('hide');
            Swal.fire({
                title: '🎉 Demo Mode!',
                html: `
                    <div class="text-center">
                        <i class="fas fa-info-circle text-info fs-1 mb-3"></i>
                        <p>Fitur broadcast sedang dalam tahap pengembangan</p>
                        <small class="text-muted">API endpoint akan segera tersedia</small>
                    </div>
                `,
                icon: 'info',
                timer: 3000,
                showConfirmButton: false
            });
        }, 500);
    }, 2000);
    
    return; // Skip actual AJAX call
    
    $.ajax({
        url: '/admin/api/notifications/broadcast',
        method: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    })
    .done(function(response) {
        clearInterval(progressInterval);
        $('.progress-bar').css('width', '100%');
        
        setTimeout(() => {
            Swal.close();
            if (response.success) {
                $('#broadcastModal').modal('hide');
                Swal.fire({
                    title: '🎉 Broadcast Berhasil!',
                    html: `
                        <div class="text-center">
                            <i class="fas fa-check-circle text-success fs-1 mb-3"></i>
                            <p>Pesan berhasil dikirim ke <strong>${response.sent_count || 'semua'}</strong> nomor WhatsApp</p>
                        </div>
                    `,
                    icon: 'success',
                    timer: 3000,
                    showConfirmButton: false
                });
                loadNotifications();
                animateCounters();
            } else {
                showToast('Gagal mengirim broadcast: ' + (response.message || 'Unknown error'), 'error');
            }
        }, 500);
    })
    .fail(function(xhr) {
        clearInterval(progressInterval);
        Swal.close();
        const errorMsg = xhr.responseJSON?.message || 'Gagal mengirim broadcast';
        showToast(errorMsg, 'error');
    });
}

// New Functions for Enhanced UI
function animateCounters() {
    $('.counter').each(function() {
        const $this = $(this);
        const target = parseInt($this.data('target')) || 0;
        const duration = 2000;
        const increment = target / (duration / 50);
        let current = 0;
        
        const timer = setInterval(() => {
            current += increment;
            if (current >= target) {
                current = target;
                clearInterval(timer);
            }
            $this.text(Math.floor(current).toLocaleString());
        }, 50);
    });
}

function checkForUpdates() {
    // Temporarily disabled - API endpoint not implemented yet
    console.log('checkForUpdates disabled - API endpoint not available');
    return;
    
    $.get('/admin/api/notifications/check')
        .done(function(response) {
            if (response.new_notifications > 0) {
                showToast(`${response.new_notifications} notifikasi baru diterima`, 'info');
                // Update counters without full page reload
                updateCounters(response.counts);
            }
        })
        .fail(function() {
            console.log('Failed to check for updates');
        });
}

function updateCounters(counts) {
    if (counts) {
        Object.keys(counts).forEach(key => {
            const $counter = $(`.counter[data-target]`).filter(function() {
                return $(this).data('target') != counts[key];
            });
            if ($counter.length) {
                $counter.data('target', counts[key]);
                animateCounters();
            }
        });
    }
}

function exportNotifications() {
    Swal.fire({
        title: 'Export Notifikasi',
        text: 'Fitur export sedang dalam tahap pengembangan',
        icon: 'info',
        confirmButtonText: 'OK'
    });
    return;
    
    Swal.fire({
        title: 'Export Notifikasi',
        text: 'Pilih format export yang diinginkan',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: '<i class="fas fa-file-excel me-2"></i>Excel',
        cancelButtonText: '<i class="fas fa-file-pdf me-2"></i>PDF',
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            window.open('/admin/notifikasi/wa/export?format=excel', '_blank');
        } else if (result.dismiss === Swal.DismissReason.cancel) {
            window.open('/admin/notifikasi/wa/export?format=pdf', '_blank');
        }
    });
}

function copyMessage(notificationId) {
    // Implementation for copying message to clipboard
    const messageText = $(`tr:has(button[onclick*="${notificationId}"])`).find('.message-preview .text-truncate').attr('title');
    
    if (navigator.clipboard) {
        navigator.clipboard.writeText(messageText).then(() => {
            showToast('Pesan berhasil disalin ke clipboard', 'success');
        });
    } else {
        // Fallback for older browsers
        const textArea = document.createElement('textarea');
        textArea.value = messageText;
        document.body.appendChild(textArea);
        textArea.select();
        document.execCommand('copy');
        document.body.removeChild(textArea);
        showToast('Pesan berhasil disalin ke clipboard', 'success');
    }
}

function forwardMessage(notificationId) {
    const messageText = $(`tr:has(button[onclick*="${notificationId}"])`).find('.message-preview .text-truncate').attr('title');
    
    // Pre-fill broadcast modal with forwarded message
    $('#broadcastMessage').val(`[FORWARD] ${messageText}`);
    $('#broadcastModal').modal('show');
    showToast('Pesan siap untuk di-forward', 'info');
}

function deleteNotification(notificationId) {
    Swal.fire({
        title: 'Hapus Notifikasi?',
        text: 'Notifikasi yang dihapus tidak dapat dikembalikan',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: '<i class="fas fa-trash me-2"></i>Ya, Hapus',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            // Temporarily disabled - API endpoint not implemented yet
            showToast('Fitur hapus akan segera tersedia', 'info');
            return;
            
            $.ajax({
                url: `/admin/api/notifications/${notificationId}`,
                type: 'DELETE',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content')
                }
            })
            .done(function(response) {
                if (response.success) {
                    showToast('Notifikasi berhasil dihapus', 'success');
                    loadNotifications();
                } else {
                    showToast('Gagal menghapus notifikasi', 'error');
                }
            })
            .fail(function() {
                showToast('Gagal menghapus notifikasi', 'error');
            });
        }
    });
}

// Enhanced toast function
function showToast(message, type = 'info', duration = 3000) {
    const toastTypes = {
        success: { icon: 'fas fa-check-circle', class: 'bg-success' },
        error: { icon: 'fas fa-exclamation-circle', class: 'bg-danger' },
        warning: { icon: 'fas fa-exclamation-triangle', class: 'bg-warning' },
        info: { icon: 'fas fa-info-circle', class: 'bg-info' }
    };
    
    const toast = toastTypes[type] || toastTypes.info;
    
    const toastHtml = `
        <div class="toast align-items-center text-white ${toast.class} border-0" role="alert" style="position: fixed; top: 20px; right: 20px; z-index: 9999;">
            <div class="d-flex">
                <div class="toast-body">
                    <i class="${toast.icon} me-2"></i>${message}
                </div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
            </div>
        </div>
    `;
    
    $('body').append(toastHtml);
    const $toast = $('.toast').last();
    
    const bsToast = new bootstrap.Toast($toast[0], {
        autohide: true,
        delay: duration
    });
    
    bsToast.show();
    
    // Remove toast element after it's hidden
    $toast.on('hidden.bs.toast', function() {
        $(this).remove();
    });
}

// Utility Functions
function scrollToTop() {
    $('html, body').animate({
        scrollTop: 0
    }, 500);
}

function showLoadingOverlay() {
    if ($('.loading-overlay').length === 0) {
        $('body').append(`
            <div class="loading-overlay">
                <div class="loading-spinner"></div>
            </div>
        `);
    }
}

function hideLoadingOverlay() {
    $('.loading-overlay').remove();
}

// Enhanced Search Functionality
$(document).on('input', '#searchInput', function() {
    const searchTerm = $(this).val().toLowerCase();
    
    if ($.fn.DataTable.isDataTable('#notificationsTable')) {
        $('#notificationsTable').DataTable().search(searchTerm).draw();
    } else {
        // Fallback manual search
        $('#notificationsTable tbody tr').each(function() {
            const rowText = $(this).text().toLowerCase();
            $(this).toggle(rowText.includes(searchTerm));
        });
    }
});

// Filter by Status
$(document).on('change', '#statusFilter', function() {
    const status = $(this).val();
    
    if ($.fn.DataTable.isDataTable('#notificationsTable')) {
        if (status) {
            $('#notificationsTable').DataTable().column(5).search(status).draw();
        } else {
            $('#notificationsTable').DataTable().column(5).search('').draw();
        }
    }
});

// Filter by Type
$(document).on('change', '#typeFilter', function() {
    const type = $(this).val();
    
    if ($.fn.DataTable.isDataTable('#notificationsTable')) {
        if (type) {
            $('#notificationsTable').DataTable().column(4).search(type).draw();
        } else {
            $('#notificationsTable').DataTable().column(4).search('').draw();
        }
    }
});

// Auto-refresh toggle
$(document).on('change', '#autoRefresh', function() {
    if ($(this).is(':checked')) {
        showToast('Auto-refresh diaktifkan (setiap 30 detik)', 'info');
        startAutoRefresh();
    } else {
        showToast('Auto-refresh dinonaktifkan', 'info');
        stopAutoRefresh();
    }
});

let autoRefreshInterval;

function startAutoRefresh() {
    autoRefreshInterval = setInterval(function() {
        if (!$('.modal').hasClass('show')) {
            console.log('Auto-refresh: Checking for updates...');
            // checkForUpdates(); // Disabled for now
        }
    }, 30000);
}

function stopAutoRefresh() {
    if (autoRefreshInterval) {
        clearInterval(autoRefreshInterval);
        autoRefreshInterval = null;
    }
}

// Enhanced Message Preview Click
$(document).on('click', '.message-preview', function() {
    const row = $(this).closest('tr');
    const notificationId = row.data('notification-id');
    if (notificationId) {
        viewFullMessage(notificationId);
    }
});

// Keyboard Shortcuts
$(document).keydown(function(e) {
    // Ctrl + R: Refresh
    if (e.ctrlKey && e.keyCode === 82) {
        e.preventDefault();
        loadNotifications();
        return false;
    }
    
    // Ctrl + N: New Broadcast
    if (e.ctrlKey && e.keyCode === 78) {
        e.preventDefault();
        $('#broadcastModal').modal('show');
        return false;
    }
    
    // Escape: Close modals
    if (e.keyCode === 27) {
        $('.modal').modal('hide');
    }
});

// Initialize tooltips for floating action buttons
$(document).ready(function() {
    $('.floating-action [title]').tooltip({
        placement: 'left'
    });
    
    // Update page title with notification count
    updatePageTitle();
    
    // Request desktop notification permission
    requestNotificationPermission();
});

// Performance optimization: Debounce search input
function debounce(func, wait) {
    let timeout;
    return function executedFunction(...args) {
        const later = () => {
            clearTimeout(timeout);
            func(...args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
    };
}

// Show notification count in page title
function updatePageTitle() {
    const unreadCount = $('.badge.bg-warning').length;
    const baseTitle = 'Notifikasi WhatsApp';
    
    if (unreadCount > 0) {
        document.title = `(${unreadCount}) ${baseTitle} - Aplikasi Desa`;
    } else {
        document.title = `${baseTitle} - Aplikasi Desa`;
    }
}

// Desktop notifications (if supported)
function requestNotificationPermission() {
    if ('Notification' in window && Notification.permission === 'default') {
        Notification.requestPermission();
    }
}

function showDesktopNotification(title, message) {
    if ('Notification' in window && Notification.permission === 'granted') {
        new Notification(title, {
            body: message,
            icon: '/favicon.ico',
            badge: '/favicon.ico'
        });
    }
}

// Print functionality
function printNotifications() {
    window.print();
}

// Advanced export functions
function exportToExcel() {
    showToast('Export ke Excel sedang diproses...', 'info');
    // Simulate export
    setTimeout(() => {
        showToast('File Excel berhasil didownload', 'success');
    }, 2000);
}

function exportToPdf() {
    showToast('Export ke PDF sedang diproses...', 'info');
    // Simulate export
    setTimeout(() => {
        showToast('File PDF berhasil didownload', 'success');
    }, 2000);
}

function generateReport() {
    showToast('Laporan sedang dibuat...', 'info');
    // Simulate report generation
    setTimeout(() => {
        showToast('Laporan berhasil dibuat', 'success');
    }, 3000);
}

// Initialize everything when document is ready
$(document).ready(function() {
    console.log('🚀 WhatsApp Notification System Initialized');
    console.log('📱 Features: Advanced UI, Real-time updates, Export capabilities');
    console.log('⚡ Performance: Optimized with debouncing and lazy loading');
});

function viewFullMessage(notificationId) {
    // Get notification data from table row
    const row = $(`tr[data-notification-id="${notificationId}"]`);
    if (row.length === 0) {
        showToast('Data notifikasi tidak ditemukan', 'error');
        return;
    }
    
    // Extract data from table row
    const messageText = row.find('.message-preview .fw-medium').text().trim();
    const recipientPhone = row.find('.fw-bold').first().text().trim();
    const recipientName = row.find('.text-success small').text().replace('👤', '').replace('👤', '').trim();
    const messageTime = row.find('.text-primary').text() + ' ' + row.find('.text-muted small').first().text();
    const status = row.find('.badge').last().text().trim();
    const messageType = row.find('.badge').first().text().trim();
    
    // Populate modal with data
    $('#detailMessageContent').html(messageText);
    $('#detailMessageTime').text(messageTime);
    
    // Message analysis
    const charCount = messageText.length;
    const wordCount = messageText.split(/\s+/).filter(word => word.length > 0).length;
    const lineCount = messageText.split('\n').length;
    const readTime = Math.ceil(charCount / 200); // Assuming 200 chars per second reading speed
    
    $('#detailCharCount').text(charCount);
    $('#detailWordCount').text(wordCount);
    $('#detailLineCount').text(lineCount);
    $('#detailReadTime').text(readTime);
    
    // Recipient info
    const recipientInfo = `
        <div class="d-flex align-items-center mb-3">
            <div class="avatar-circle bg-success bg-opacity-10 me-3">
                <i class="fab fa-whatsapp text-success"></i>
            </div>
            <div>
                <div class="fw-bold">${recipientPhone}</div>
                ${recipientName ? `<small class="text-muted">${recipientName}</small>` : '<small class="text-muted">Nomor External</small>'}
            </div>
        </div>
        <div class="row text-center">
            <div class="col-6">
                <div class="stat-item">
                    <div class="stat-value text-primary">1</div>
                    <div class="stat-label">Pesan Dikirim</div>
                </div>
            </div>
            <div class="col-6">
                <div class="stat-item">
                    <div class="stat-value text-success">100%</div>
                    <div class="stat-label">Tingkat Baca</div>
                </div>
            </div>
        </div>
    `;
    $('#detailRecipientInfo').html(recipientInfo);
    
    // Delivery status
    const statusColor = status.includes('Terkirim') ? 'success' : status.includes('Gagal') ? 'danger' : 'warning';
    const deliveryStatus = `
        <div class="d-flex align-items-center mb-3">
            <span class="status-indicator bg-${statusColor} me-3"></span>
            <div>
                <div class="fw-bold text-${statusColor}">${status}</div>
                <small class="text-muted">${messageTime}</small>
            </div>
        </div>
        <div class="timeline">
            <div class="timeline-item">
                <div class="timeline-marker bg-primary"></div>
                <div class="timeline-content">
                    <div class="fw-medium">Pesan Dibuat</div>
                    <small class="text-muted">${messageTime}</small>
                </div>
            </div>
            <div class="timeline-item">
                <div class="timeline-marker bg-${statusColor}"></div>
                <div class="timeline-content">
                    <div class="fw-medium">${status}</div>
                    <small class="text-muted">${messageTime}</small>
                </div>
            </div>
        </div>
    `;
    $('#detailDeliveryStatus').html(deliveryStatus);
    
    // Store current notification ID for modal actions
    $('#messageDetailModal').data('notification-id', notificationId);
    
    // Show modal
    $('#messageDetailModal').modal('show');
}

function copyMessage(notificationId) {
    const row = $(`tr[data-notification-id="${notificationId}"]`);
    const messageText = row.find('.message-preview .fw-medium').text().trim();
    
    if (navigator.clipboard) {
        navigator.clipboard.writeText(messageText).then(function() {
            showToast('Pesan berhasil disalin ke clipboard', 'success');
        }).catch(function() {
            fallbackCopyTextToClipboard(messageText);
        });
    } else {
        fallbackCopyTextToClipboard(messageText);
    }
}

function fallbackCopyTextToClipboard(text) {
    const textArea = document.createElement("textarea");
    textArea.value = text;
    textArea.style.top = "0";
    textArea.style.left = "0";
    textArea.style.position = "fixed";
    document.body.appendChild(textArea);
    textArea.focus();
    textArea.select();
    
    try {
        document.execCommand('copy');
        showToast('Pesan berhasil disalin ke clipboard', 'success');
    } catch (err) {
        showToast('Gagal menyalin pesan', 'error');
    }
    
    document.body.removeChild(textArea);
}

function forwardMessage(notificationId) {
    const row = $(`tr[data-notification-id="${notificationId}"])`);
    const messageText = row.find('.message-preview .fw-medium').text().trim();
    
    $('#forwardMessagePreview').text(messageText);
    $('#forwardModal').data('notification-id', notificationId);
    $('#forwardModal').modal('show');
}

function confirmForward() {
    const notificationId = $('#forwardModal').data('notification-id');
    const forwardTo = $('#forwardTo').val();
    const manualNumbers = $('#forwardPhoneNumbers').val();
    const note = $('#forwardNote').val();
    
    if (!forwardTo || forwardTo.length === 0) {
        showToast('Pilih tujuan forward pesan', 'warning');
        return;
    }
    
    // Simulate forward action
    showToast('Pesan berhasil diteruskan', 'success');
    $('#forwardModal').modal('hide');
}

// Modal Action Functions
function markAsReadFromModal() {
    const notificationId = $('#messageDetailModal').data('notification-id');
    markAsRead(notificationId);
}

function copyMessageFromModal() {
    const messageText = $('#detailMessageContent').text();
    
    if (navigator.clipboard) {
        navigator.clipboard.writeText(messageText).then(function() {
            showToast('Pesan berhasil disalin ke clipboard', 'success');
        });
    }
}

function forwardMessageFromModal() {
    const notificationId = $('#messageDetailModal').data('notification-id');
    $('#messageDetailModal').modal('hide');
    setTimeout(() => forwardMessage(notificationId), 300);
}

function resendMessageFromModal() {
    const notificationId = $('#messageDetailModal').data('notification-id');
    resendMessage(notificationId);
}

function deleteMessageFromModal() {
    const notificationId = $('#messageDetailModal').data('notification-id');
    deleteNotification(notificationId);
}

function downloadMessageReport() {
    const notificationId = $('#messageDetailModal').data('notification-id');
    showToast('Fitur download laporan sedang dalam pengembangan', 'info');
}

// Advanced Search and Filter Functions
function resetFilters() {
    $('#searchInput').val('');
    $('#statusFilter').val('');
    $('#typeFilter').val('');
    $('#dateFilter').val('');
    
    // Reset DataTable search
    if ($.fn.DataTable.isDataTable('#notificationsTable')) {
        $('#notificationsTable').DataTable().search('').draw();
    }
    
    showToast('Filter berhasil direset', 'success');
}

// Bulk Actions
function bulkMarkAsRead() {
    const selectedIds = getSelectedNotifications();
    if (selectedIds.length === 0) {
        showToast('Pilih notifikasi yang akan ditandai dibaca', 'warning');
        return;
    }
    
    $('#selectedItemsCount').text(selectedIds.length);
    $('#bulkAction').val('mark_read');
    $('#bulkActionsModal').modal('show');
}

function bulkDelete() {
    const selectedIds = getSelectedNotifications();
    if (selectedIds.length === 0) {
        showToast('Pilih notifikasi yang akan dihapus', 'warning');
        return;
    }
    
    $('#selectedItemsCount').text(selectedIds.length);
    $('#bulkAction').val('delete');
    $('#bulkWarning').removeClass('d-none');
    $('#bulkWarningText').text('Tindakan ini tidak dapat dibatalkan!');
    $('#bulkActionsModal').modal('show');
}

function getSelectedNotifications() {
    const selected = [];
    $('.notification-checkbox:checked').each(function() {
        selected.push($(this).val());
    });
    return selected;
}

function executeBulkAction() {
    const action = $('#bulkAction').val();
    const selectedIds = getSelectedNotifications();
    
    if (!action || selectedIds.length === 0) {
        showToast('Pilih aksi dan notifikasi', 'warning');
        return;
    }
    
    // Simulate bulk action
    let message = '';
    switch(action) {
        case 'mark_read':
            message = `${selectedIds.length} notifikasi ditandai sudah dibaca`;
            break;
        case 'mark_unread':
            message = `${selectedIds.length} notifikasi ditandai belum dibaca`;
            break;
        case 'delete':
            message = `${selectedIds.length} notifikasi berhasil dihapus`;
            break;
        case 'export':
            message = `${selectedIds.length} notifikasi berhasil diexport`;
            break;
    }
    
    showToast(message, 'success');
    $('#bulkActionsModal').modal('hide');
    
    // Uncheck all checkboxes
    $('.notification-checkbox').prop('checked', false);
    $('#selectAll').prop('checked', false);
}

// Select All Functionality
$(document).on('change', '#selectAll', function() {
    $('.notification-checkbox').prop('checked', $(this).is(':checked'));
});

$(document).on('change', '.notification-checkbox', function() {
    const totalCheckboxes = $('.notification-checkbox').length;
    const checkedCheckboxes = $('.notification-checkbox:checked').length;
    
    $('#selectAll').prop('checked', totalCheckboxes === checkedCheckboxes);
    $('#selectAll').prop('indeterminate', checkedCheckboxes > 0 && checkedCheckboxes < totalCheckboxes);
});
</script>
@endpush 