@extends('layouts.app')

@section('title', 'Tambah Objek Wisata')

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-plus"></i> Tambah Objek Wisata
        </h1>
        <a href="{{ route('admin.objek-wisata.index') }}" class="btn btn-secondary shadow-sm">
            <i class="fas fa-arrow-left fa-sm text-white-50"></i> Kembali
        </a>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">Form Tambah Objek Wisata</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.objek-wisata.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                        <div class="row">
                            <!-- Informasi Dasar -->
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nama_wisata">Nama Objek Wisata <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('nama_wisata') is-invalid @enderror" 
                                           id="nama_wisata" name="nama_wisata" value="{{ old('nama_wisata') }}" required>
                                    @error('nama_wisata')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="kategori_wisata">Kategori Wisata <span class="text-danger">*</span></label>
                                    <select class="form-control @error('kategori_wisata') is-invalid @enderror" 
                                            id="kategori_wisata" name="kategori_wisata" required>
                                        <option value="">Pilih Kategori</option>
                                        @foreach($kategoriList as $key => $label)
                                            <option value="{{ $key }}" {{ old('kategori_wisata') == $key ? 'selected' : '' }}>
                                                {{ $label }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('kategori_wisata')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="deskripsi">Deskripsi <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                                      id="deskripsi" name="deskripsi" rows="4" required>{{ old('deskripsi') }}</textarea>
                            @error('deskripsi')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Lokasi -->
                        <h5 class="mb-3 mt-4">Informasi Lokasi</h5>
                        
                        <div class="form-group">
                            <label for="alamat_lengkap">Alamat Lengkap <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('alamat_lengkap') is-invalid @enderror" 
                                      id="alamat_lengkap" name="alamat_lengkap" rows="3" required>{{ old('alamat_lengkap') }}</textarea>
                            @error('alamat_lengkap')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="desa_kelurahan">Desa/Kelurahan</label>
                                    <input type="text" class="form-control @error('desa_kelurahan') is-invalid @enderror" 
                                           id="desa_kelurahan" name="desa_kelurahan" value="{{ old('desa_kelurahan') }}">
                                    @error('desa_kelurahan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="kecamatan">Kecamatan</label>
                                    <input type="text" class="form-control @error('kecamatan') is-invalid @enderror" 
                                           id="kecamatan" name="kecamatan" value="{{ old('kecamatan') }}">
                                    @error('kecamatan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="kabupaten_kota">Kabupaten/Kota</label>
                                    <input type="text" class="form-control @error('kabupaten_kota') is-invalid @enderror" 
                                           id="kabupaten_kota" name="kabupaten_kota" value="{{ old('kabupaten_kota') }}">
                                    @error('kabupaten_kota')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="provinsi">Provinsi</label>
                                    <input type="text" class="form-control @error('provinsi') is-invalid @enderror" 
                                           id="provinsi" name="provinsi" value="{{ old('provinsi') }}">
                                    @error('provinsi')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="latitude">Latitude</label>
                                    <input type="number" step="any" class="form-control @error('latitude') is-invalid @enderror" 
                                           id="latitude" name="latitude" value="{{ old('latitude') }}">
                                    @error('latitude')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="longitude">Longitude</label>
                                    <input type="number" step="any" class="form-control @error('longitude') is-invalid @enderror" 
                                           id="longitude" name="longitude" value="{{ old('longitude') }}">
                                    @error('longitude')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Harga Tiket -->
                        <h5 class="mb-3 mt-4">Informasi Tiket</h5>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="harga_tiket_dewasa">Harga Tiket Dewasa <span class="text-danger">*</span></label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">Rp</span>
                                        </div>
                                        <input type="number" class="form-control @error('harga_tiket_dewasa') is-invalid @enderror" 
                                               id="harga_tiket_dewasa" name="harga_tiket_dewasa" value="{{ old('harga_tiket_dewasa') }}" min="0" required>
                                    </div>
                                    @error('harga_tiket_dewasa')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="harga_tiket_anak">Harga Tiket Anak</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">Rp</span>
                                        </div>
                                        <input type="number" class="form-control @error('harga_tiket_anak') is-invalid @enderror" 
                                               id="harga_tiket_anak" name="harga_tiket_anak" value="{{ old('harga_tiket_anak') }}" min="0">
                                    </div>
                                    @error('harga_tiket_anak')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Jam Operasional -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="jam_buka">Jam Buka</label>
                                    <input type="time" class="form-control @error('jam_buka') is-invalid @enderror" 
                                           id="jam_buka" name="jam_buka" value="{{ old('jam_buka') }}">
                                    @error('jam_buka')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="jam_tutup">Jam Tutup</label>
                                    <input type="time" class="form-control @error('jam_tutup') is-invalid @enderror" 
                                           id="jam_tutup" name="jam_tutup" value="{{ old('jam_tutup') }}">
                                    @error('jam_tutup')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Media -->
                        <h5 class="mb-3 mt-4">Media & Kontak</h5>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="foto_utama">Foto Utama</label>
                                    <input type="file" class="form-control-file @error('foto_utama') is-invalid @enderror" 
                                           id="foto_utama" name="foto_utama" accept="image/*">
                                    <small class="form-text text-muted">Format: JPG, PNG. Maksimal 2MB.</small>
                                    @error('foto_utama')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="galeri_foto">Galeri Foto</label>
                                    <input type="file" class="form-control-file @error('galeri_foto.*') is-invalid @enderror" 
                                           id="galeri_foto" name="galeri_foto[]" accept="image/*" multiple>
                                    <small class="form-text text-muted">Bisa pilih beberapa file. Format: JPG, PNG. Maksimal 2MB per file.</small>
                                    @error('galeri_foto.*')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email_kontak">Email Kontak</label>
                                    <input type="email" class="form-control @error('email_kontak') is-invalid @enderror" 
                                           id="email_kontak" name="email_kontak" value="{{ old('email_kontak') }}">
                                    @error('email_kontak')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nomor_telepon">Nomor Telepon</label>
                                    <input type="text" class="form-control @error('nomor_telepon') is-invalid @enderror" 
                                           id="nomor_telepon" name="nomor_telepon" value="{{ old('nomor_telepon') }}">
                                    @error('nomor_telepon')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Status -->
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="is_featured" name="is_featured" value="1" {{ old('is_featured') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_featured">
                                            Jadikan Featured
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="is_recommended" name="is_recommended" value="1" {{ old('is_recommended') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="is_recommended">
                                            Jadikan Recommended
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Simpan
                            </button>
                            <a href="{{ route('admin.objek-wisata.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
