@extends('layouts.app')

@section('title', 'Edit Objek Wisata')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Edit Objek Wisata</h1>
        <a href="{{ route('admin.objek-wisata.show', $objekWisata->id) }}" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    <form action="{{ route('admin.objek-wisata.update', $objekWisata->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        
        <div class="row">
            <!-- Main Form -->
            <div class="col-lg-8">
                <!-- Basic Information -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Informasi Dasar</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nama">Nama Objek Wisata <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('nama') is-invalid @enderror" 
                                           id="nama" name="nama" value="{{ old('nama', $objekWisata->nama) }}" required>
                                    @error('nama')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="kategori">Kategori <span class="text-danger">*</span></label>
                                    <select class="form-control @error('kategori') is-invalid @enderror" 
                                            id="kategori" name="kategori" required>
                                        <option value="">Pilih Kategori</option>
                                        <option value="alam" {{ old('kategori', $objekWisata->kategori) == 'alam' ? 'selected' : '' }}>Wisata Alam</option>
                                        <option value="budaya" {{ old('kategori', $objekWisata->kategori) == 'budaya' ? 'selected' : '' }}>Wisata Budaya</option>
                                        <option value="sejarah" {{ old('kategori', $objekWisata->kategori) == 'sejarah' ? 'selected' : '' }}>Wisata Sejarah</option>
                                        <option value="kuliner" {{ old('kategori', $objekWisata->kategori) == 'kuliner' ? 'selected' : '' }}>Wisata Kuliner</option>
                                        <option value="edukasi" {{ old('kategori', $objekWisata->kategori) == 'edukasi' ? 'selected' : '' }}>Wisata Edukasi</option>
                                        <option value="adventure" {{ old('kategori', $objekWisata->kategori) == 'adventure' ? 'selected' : '' }}>Wisata Adventure</option>
                                        <option value="religi" {{ old('kategori', $objekWisata->kategori) == 'religi' ? 'selected' : '' }}>Wisata Religi</option>
                                        <option value="lainnya" {{ old('kategori', $objekWisata->kategori) == 'lainnya' ? 'selected' : '' }}>Lainnya</option>
                                    </select>
                                    @error('kategori')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="deskripsi">Deskripsi <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                                      id="deskripsi" name="deskripsi" rows="4" required>{{ old('deskripsi', $objekWisata->deskripsi) }}</textarea>
                            @error('deskripsi')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="harga_tiket_dewasa">Harga Tiket Dewasa (Rp)</label>
                                    <input type="number" class="form-control @error('harga_tiket_dewasa') is-invalid @enderror" 
                                           id="harga_tiket_dewasa" name="harga_tiket_dewasa" 
                                           value="{{ old('harga_tiket_dewasa', $objekWisata->harga_tiket_dewasa) }}" min="0">
                                    <small class="text-muted">Kosongkan atau isi 0 jika gratis</small>
                                    @error('harga_tiket_dewasa')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="harga_tiket_anak">Harga Tiket Anak (Rp)</label>
                                    <input type="number" class="form-control @error('harga_tiket_anak') is-invalid @enderror" 
                                           id="harga_tiket_anak" name="harga_tiket_anak" 
                                           value="{{ old('harga_tiket_anak', $objekWisata->harga_tiket_anak) }}" min="0">
                                    <small class="text-muted">Kosongkan atau isi 0 jika gratis</small>
                                    @error('harga_tiket_anak')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="jam_operasional">Jam Operasional</label>
                            <input type="text" class="form-control @error('jam_operasional') is-invalid @enderror" 
                                   id="jam_operasional" name="jam_operasional" 
                                   value="{{ old('jam_operasional', $objekWisata->jam_operasional) }}"
                                   placeholder="Contoh: Senin-Minggu 08:00-17:00">
                            @error('jam_operasional')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Location Information -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Informasi Lokasi</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="alamat">Alamat Lengkap <span class="text-danger">*</span></label>
                            <textarea class="form-control @error('alamat') is-invalid @enderror" 
                                      id="alamat" name="alamat" rows="3" required>{{ old('alamat', $objekWisata->alamat) }}</textarea>
                            @error('alamat')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="desa">Desa <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('desa') is-invalid @enderror" 
                                           id="desa" name="desa" value="{{ old('desa', $objekWisata->desa) }}" required>
                                    @error('desa')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="kecamatan">Kecamatan <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('kecamatan') is-invalid @enderror" 
                                           id="kecamatan" name="kecamatan" value="{{ old('kecamatan', $objekWisata->kecamatan) }}" required>
                                    @error('kecamatan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="latitude">Latitude</label>
                                    <input type="number" step="any" class="form-control @error('latitude') is-invalid @enderror" 
                                           id="latitude" name="latitude" value="{{ old('latitude', $objekWisata->latitude) }}">
                                    @error('latitude')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="longitude">Longitude</label>
                                    <input type="number" step="any" class="form-control @error('longitude') is-invalid @enderror" 
                                           id="longitude" name="longitude" value="{{ old('longitude', $objekWisata->longitude) }}">
                                    @error('longitude')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <button type="button" class="btn btn-info btn-sm" onclick="getCurrentLocation()">
                                <i class="fas fa-map-marker-alt"></i> Dapatkan Lokasi Saat Ini
                            </button>
                        </div>

                        <div class="form-group">
                            <label for="akses_jalan">Akses Jalan</label>
                            <textarea class="form-control @error('akses_jalan') is-invalid @enderror" 
                                      id="akses_jalan" name="akses_jalan" rows="2" 
                                      placeholder="Deskripsi kondisi jalan menuju lokasi">{{ old('akses_jalan', $objekWisata->akses_jalan) }}</textarea>
                            @error('akses_jalan')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Contact Information -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Informasi Kontak</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nama_pengelola">Nama Pengelola</label>
                                    <input type="text" class="form-control @error('nama_pengelola') is-invalid @enderror" 
                                           id="nama_pengelola" name="nama_pengelola" 
                                           value="{{ old('nama_pengelola', $objekWisata->nama_pengelola) }}">
                                    @error('nama_pengelola')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="telepon">Nomor Telepon</label>
                                    <input type="text" class="form-control @error('telepon') is-invalid @enderror" 
                                           id="telepon" name="telepon" value="{{ old('telepon', $objekWisata->telepon) }}">
                                    @error('telepon')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email">Email</label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                           id="email" name="email" value="{{ old('email', $objekWisata->email) }}">
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="website">Website</label>
                                    <input type="url" class="form-control @error('website') is-invalid @enderror" 
                                           id="website" name="website" value="{{ old('website', $objekWisata->website) }}">
                                    @error('website')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Facilities -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Fasilitas</h6>
                    </div>
                    <div class="card-body">
                        <div id="fasilitas-container">
                            @php
                                $fasilitas = old('fasilitas', $objekWisata->fasilitas ? (is_array($objekWisata->fasilitas) ? $objekWisata->fasilitas : json_decode($objekWisata->fasilitas, true)) : []);
                            @endphp
                            @if($fasilitas && count($fasilitas) > 0)
                                @foreach($fasilitas as $index => $item)
                                    <div class="input-group mb-2 fasilitas-item">
                                        <input type="text" class="form-control" name="fasilitas[]" 
                                               value="{{ $item }}" placeholder="Masukkan fasilitas">
                                        <div class="input-group-append">
                                            <button type="button" class="btn btn-danger btn-remove-fasilitas">
                                                <i class="fas fa-times"></i>
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            @else
                                <div class="input-group mb-2 fasilitas-item">
                                    <input type="text" class="form-control" name="fasilitas[]" 
                                           placeholder="Masukkan fasilitas">
                                    <div class="input-group-append">
                                        <button type="button" class="btn btn-danger btn-remove-fasilitas">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>
                            @endif
                        </div>
                        <button type="button" class="btn btn-success btn-sm mt-2" id="btn-add-fasilitas">
                            <i class="fas fa-plus"></i> Tambah Fasilitas
                        </button>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Photos -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Foto</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="foto_utama">Foto Utama</label>
                            <input type="file" class="form-control-file @error('foto_utama') is-invalid @enderror" 
                                   id="foto_utama" name="foto_utama" accept="image/*">
                            <small class="text-muted">Format: JPG, PNG, WebP. Maksimal 2MB</small>
                            @error('foto_utama')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            
                            @if($objekWisata->foto_utama)
                                <div class="mt-2">
                                    <label class="small text-muted">Foto saat ini:</label><br>
                                    <img src="{{ Storage::url($objekWisata->foto_utama) }}" 
                                         alt="Current Photo" 
                                         class="img-thumbnail"
                                         style="max-width: 150px;">
                                </div>
                            @endif
                        </div>

                        <div class="form-group">
                            <label for="galeri_foto">Galeri Foto</label>
                            <input type="file" class="form-control-file @error('galeri_foto') is-invalid @enderror" 
                                   id="galeri_foto" name="galeri_foto[]" accept="image/*" multiple>
                            <small class="text-muted">Pilih beberapa foto sekaligus. Maksimal 5 foto</small>
                            @error('galeri_foto')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror

                            @if($objekWisata->galeri_foto)
                                @php
                                    $galeri = is_array($objekWisata->galeri_foto) ? $objekWisata->galeri_foto : json_decode($objekWisata->galeri_foto, true);
                                @endphp
                                @if($galeri && count($galeri) > 0)
                                    <div class="mt-2">
                                        <label class="small text-muted">Galeri saat ini:</label>
                                        <div class="row">
                                            @foreach($galeri as $foto)
                                                <div class="col-6 mb-2">
                                                    <img src="{{ Storage::url($foto) }}" 
                                                         alt="Gallery" 
                                                         class="img-thumbnail"
                                                         style="width: 100%; height: 80px; object-fit: cover;">
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                @endif
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Status -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Status</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="status">Status Publikasi</label>
                            <select class="form-control @error('status') is-invalid @enderror" 
                                    id="status" name="status">
                                <option value="aktif" {{ old('status', $objekWisata->status) == 'aktif' ? 'selected' : '' }}>Aktif</option>
                                <option value="nonaktif" {{ old('status', $objekWisata->status) == 'nonaktif' ? 'selected' : '' }}>Non-aktif</option>
                                <option value="pending" {{ old('status', $objekWisata->status) == 'pending' ? 'selected' : '' }}>Pending</option>
                            </select>
                            @error('status')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="card shadow">
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Update Objek Wisata
                            </button>
                            <a href="{{ route('admin.objek-wisata.show', $objekWisata->id) }}" 
                               class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
// Fasilitas management
$(document).ready(function() {
    // Add new fasilitas
    $('#btn-add-fasilitas').click(function() {
        var newItem = `
            <div class="input-group mb-2 fasilitas-item">
                <input type="text" class="form-control" name="fasilitas[]" placeholder="Masukkan fasilitas">
                <div class="input-group-append">
                    <button type="button" class="btn btn-danger btn-remove-fasilitas">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
        `;
        $('#fasilitas-container').append(newItem);
    });

    // Remove fasilitas
    $(document).on('click', '.btn-remove-fasilitas', function() {
        if ($('.fasilitas-item').length > 1) {
            $(this).closest('.fasilitas-item').remove();
        }
    });
});

// Get current location
function getCurrentLocation() {
    if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(function(position) {
            $('#latitude').val(position.coords.latitude);
            $('#longitude').val(position.coords.longitude);
            alert('Lokasi berhasil didapatkan!');
        }, function(error) {
            alert('Gagal mendapatkan lokasi: ' + error.message);
        });
    } else {
        alert('Browser tidak mendukung geolocation');
    }
}

// Form validation
$('form').submit(function(e) {
    var nama = $('#nama').val().trim();
    var deskripsi = $('#deskripsi').val().trim();
    var alamat = $('#alamat').val().trim();
    
    if (!nama || !deskripsi || !alamat) {
        e.preventDefault();
        alert('Mohon lengkapi semua field yang wajib diisi!');
        return false;
    }
});
</script>
@endpush 
