@extends('layouts.app')

@section('title', 'Detail Objek Wisata')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Detail Objek Wisata</h1>
                <div>
                    <a href="{{ route('admin.objek-wisata.edit', $objekWisata->id) }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="{{ route('admin.objek-wisata.index') }}" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-left"></i> Kembali
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Dasar</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Nama:</strong> {{ $objekWisata->nama }}</p>
                            <p><strong>Kategori:</strong> <span class="badge badge-info">{{ ucfirst($objekWisata->kategori) }}</span></p>
                            <p><strong>Status:</strong> 
                                @if($objekWisata->status === 'aktif')
                                    <span class="badge badge-success">Aktif</span>
                                @else
                                    <span class="badge badge-secondary">Non-aktif</span>
                                @endif
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Harga Tiket Dewasa:</strong> Rp {{ number_format($objekWisata->harga_tiket_dewasa) }}</p>
                            <p><strong>Harga Tiket Anak:</strong> Rp {{ number_format($objekWisata->harga_tiket_anak) }}</p>
                            <p><strong>Total Pengunjung:</strong> {{ number_format($objekWisata->total_pengunjung) }}</p>
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-12">
                            <p><strong>Deskripsi:</strong></p>
                            <p>{{ $objekWisata->deskripsi }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Lokasi</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Alamat:</strong> {{ $objekWisata->alamat }}</p>
                            <p><strong>Desa:</strong> {{ $objekWisata->desa }}</p>
                            <p><strong>Kecamatan:</strong> {{ $objekWisata->kecamatan }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Latitude:</strong> {{ $objekWisata->latitude ?? '-' }}</p>
                            <p><strong>Longitude:</strong> {{ $objekWisata->longitude ?? '-' }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            @if($objekWisata->foto_utama)
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Foto Utama</h6>
                </div>
                <div class="card-body">
                    <img src="{{ Storage::url($objekWisata->foto_utama) }}" 
                         alt="{{ $objekWisata->nama }}" 
                         class="img-fluid rounded">
                </div>
            </div>
            @endif

            <div class="card shadow">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Aksi</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.objek-wisata.edit', $objekWisata->id) }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('admin.tiket-wisata.index') }}?objek_wisata_id={{ $objekWisata->id }}" 
                           class="btn btn-info btn-sm">
                            <i class="fas fa-ticket-alt"></i> Lihat Booking
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
