@extends('layouts.app')

@section('title', 'Edit Pelayanan Surat')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-edit me-2 text-primary"></i>
                Edit Pelayanan Surat
            </h2>
            <p class="text-muted mb-0">Edit permohonan surat #{{ $surat->id }}</p>
        </div>
        <div>
            <a href="{{ route('admin.pelayanan-surat.index') }}" class="btn btn-outline-secondary me-2">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
            <a href="{{ route('admin.pelayanan-surat.show', $surat->id) }}" class="btn btn-outline-info">
                <i class="fas fa-eye me-2"></i>Lihat Detail
            </a>
        </div>
    </div>

    <form id="editSuratForm" enctype="multipart/form-data">
        @csrf
        @method('PUT')
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-file-alt me-2"></i>Informasi Surat
                        </h5>
                    </div>
                    <div class="card-body">
                        <!-- Jenis Surat -->
                        <div class="mb-4">
                            <label class="form-label required">Jenis Surat</label>
                            <select class="form-select" name="jenis_surat" required id="jenisSuratSelect">
                                <option value="">Pilih Jenis Surat</option>
                                <option value="surat_keterangan_domisili" {{ $surat->jenis_surat === 'surat_keterangan_domisili' ? 'selected' : '' }}>Surat Keterangan Domisili</option>
                                <option value="surat_keterangan_usaha" {{ $surat->jenis_surat === 'surat_keterangan_usaha' ? 'selected' : '' }}>Surat Keterangan Usaha</option>
                                <option value="surat_keterangan_tidak_mampu" {{ $surat->jenis_surat === 'surat_keterangan_tidak_mampu' ? 'selected' : '' }}>Surat Keterangan Tidak Mampu</option>
                                <option value="surat_pengantar_ktp" {{ $surat->jenis_surat === 'surat_pengantar_ktp' ? 'selected' : '' }}>Surat Pengantar KTP</option>
                                <option value="surat_pengantar_kk" {{ $surat->jenis_surat === 'surat_pengantar_kk' ? 'selected' : '' }}>Surat Pengantar KK</option>
                                <option value="surat_keterangan_kelahiran" {{ $surat->jenis_surat === 'surat_keterangan_kelahiran' ? 'selected' : '' }}>Surat Keterangan Kelahiran</option>
                                <option value="surat_keterangan_kematian" {{ $surat->jenis_surat === 'surat_keterangan_kematian' ? 'selected' : '' }}>Surat Keterangan Kematian</option>
                                <option value="surat_keterangan_belum_menikah" {{ $surat->jenis_surat === 'surat_keterangan_belum_menikah' ? 'selected' : '' }}>Surat Keterangan Belum Menikah</option>
                                <option value="surat_lainnya" {{ $surat->jenis_surat === 'surat_lainnya' ? 'selected' : '' }}>Lainnya</option>
                            </select>
                        </div>
                        
                        <!-- Jenis Surat Custom -->
                        <div class="mb-4" id="jenisSuratCustomDiv" style="{{ $surat->jenis_surat_custom ? 'display: block;' : 'display: none;' }}">
                            <label class="form-label required">Jenis Surat Lainnya</label>
                            <input type="text" class="form-control" name="jenis_surat_custom" 
                                   value="{{ $surat->jenis_surat_custom }}"
                                   placeholder="Masukkan jenis surat...">
                        </div>
                        
                        <!-- Pemohon -->
                        <div class="mb-4">
                            <label class="form-label required">Pemohon</label>
                            <select class="form-select" name="pemohon_id" required id="pemohonSelect">
                                <option value="">Pilih Pemohon</option>
                                @foreach($penduduk ?? [] as $p)
                                <option value="{{ $p->id }}" 
                                        {{ $surat->pemohon_id == $p->id ? 'selected' : '' }}
                                        data-nama="{{ $p->nama }}" 
                                        data-nik="{{ $p->nik }}" 
                                        data-alamat="{{ $p->alamat }}" 
                                        data-telepon="{{ $p->telepon }}">
                                    {{ $p->nama }} - {{ $p->nik }}
                                </option>
                                @endforeach
                            </select>
                            <div class="form-text">Pilih warga yang mengajukan permohonan surat</div>
                        </div>
                        
                        <!-- Keperluan -->
                        <div class="mb-4">
                            <label class="form-label required">Keperluan</label>
                            <textarea class="form-control" name="keperluan" rows="3" required
                                      placeholder="Jelaskan keperluan/tujuan surat ini...">{{ $surat->keperluan }}</textarea>
                        </div>
                        
                        <!-- Keterangan Tambahan -->
                        <div class="mb-4">
                            <label class="form-label">Keterangan Tambahan</label>
                            <textarea class="form-control" name="keterangan" rows="3"
                                      placeholder="Keterangan tambahan jika ada...">{{ $surat->keterangan }}</textarea>
                        </div>
                        
                        <!-- Status -->
                        <div class="mb-4">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status" id="statusSelect">
                                <option value="pending" {{ $surat->status === 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="diproses" {{ $surat->status === 'diproses' ? 'selected' : '' }}>Diproses</option>
                                <option value="selesai" {{ $surat->status === 'selesai' ? 'selected' : '' }}>Selesai</option>
                                <option value="ditolak" {{ $surat->status === 'ditolak' ? 'selected' : '' }}>Ditolak</option>
                            </select>
                        </div>
                        
                        <!-- Estimasi Selesai -->
                        <div class="mb-4">
                            <label class="form-label">Estimasi Selesai</label>
                            <input type="date" class="form-control" name="estimasi_selesai" 
                                   value="{{ $surat->estimasi_selesai ? \Carbon\Carbon::parse($surat->estimasi_selesai)->format('Y-m-d') : '' }}">
                        </div>
                        
                        <!-- Catatan -->
                        <div class="mb-4">
                            <label class="form-label">Catatan</label>
                            <textarea class="form-control" name="catatan" rows="3"
                                      placeholder="Catatan untuk pemohon...">{{ $surat->catatan }}</textarea>
                        </div>
                        
                        <!-- Upload File Persyaratan -->
                        <div class="mb-4">
                            <label class="form-label">Upload Persyaratan</label>
                            <div class="border rounded p-3">
                                <input type="file" class="form-control" name="file_persyaratan" 
                                       accept=".pdf,.jpg,.jpeg,.png,.doc,.docx" id="filePersyaratan">
                                <div class="form-text">
                                    <i class="fas fa-info-circle me-1"></i>
                                    File yang diizinkan: PDF, JPG, PNG, DOC, DOCX. Maksimal 5MB
                                </div>
                                
                                @if($surat->file_persyaratan)
                                <div class="mt-2">
                                    <div class="alert alert-info d-flex align-items-center">
                                        <i class="fas fa-file me-2"></i>
                                        <div class="flex-grow-1">
                                            <strong>File saat ini:</strong> {{ basename($surat->file_persyaratan) }}
                                        </div>
                                        <a href="{{ Storage::url($surat->file_persyaratan) }}" 
                                           class="btn btn-sm btn-outline-primary" target="_blank">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </div>
                                </div>
                                @endif
                                
                                <div id="filePreview" class="mt-2"></div>
                            </div>
                        </div>
                        
                        <!-- Upload File Hasil -->
                        <div class="mb-4" id="fileHasilDiv" style="{{ $surat->status === 'selesai' ? 'display: block;' : 'display: none;' }}">
                            <label class="form-label">Upload File Hasil</label>
                            <div class="border rounded p-3">
                                <input type="file" class="form-control" name="file_hasil" 
                                       accept=".pdf" id="fileHasil">
                                <div class="form-text">
                                    <i class="fas fa-info-circle me-1"></i>
                                    Upload file surat yang sudah jadi (PDF)
                                </div>
                                
                                @if($surat->file_hasil)
                                <div class="mt-2">
                                    <div class="alert alert-success d-flex align-items-center">
                                        <i class="fas fa-file-pdf me-2"></i>
                                        <div class="flex-grow-1">
                                            <strong>File hasil saat ini:</strong> {{ basename($surat->file_hasil) }}
                                        </div>
                                        <a href="{{ Storage::url($surat->file_hasil) }}" 
                                           class="btn btn-sm btn-success" target="_blank">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <!-- Info Pemohon -->
                <div class="card">
                    <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-user me-2"></i>Info Pemohon
                        </h6>
                    </div>
                    <div class="card-body" id="infoPemohon">
                        @if($surat->pemohon)
                        <div class="text-center">
                            <div class="bg-primary text-white rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                                 style="width: 60px; height: 60px;">
                                <i class="fas fa-user fa-lg"></i>
                            </div>
                            <h6 class="mb-2">{{ $surat->pemohon->nama }}</h6>
                            <div class="small text-muted">
                                <div class="mb-1"><strong>NIK:</strong> {{ $surat->pemohon->nik }}</div>
                                <div class="mb-1"><strong>Alamat:</strong> {{ $surat->pemohon->alamat }}</div>
                                <div><strong>Telepon:</strong> {{ $surat->pemohon->telepon ?: 'Belum diisi' }}</div>
                            </div>
                        </div>
                        @else
                        <div class="text-center text-muted py-4">
                            <i class="fas fa-user fa-3x mb-3"></i>
                            <p>Pilih pemohon untuk melihat informasi</p>
                        </div>
                        @endif
                    </div>
                </div>
                
                <!-- Informasi Sistem -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-info-circle me-2"></i>Informasi Sistem
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="small">
                            <div class="d-flex justify-content-between mb-2">
                                <span>ID Surat</span>
                                <span class="fw-bold">#{{ $surat->id }}</span>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <span>Dibuat</span>
                                <span class="fw-bold">{{ $surat->created_at->format('d/m/Y H:i') }}</span>
                            </div>
                            <div class="d-flex justify-content-between mb-2">
                                <span>Diperbarui</span>
                                <span class="fw-bold">{{ $surat->updated_at->format('d/m/Y H:i') }}</span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Actions -->
                <div class="card mt-4">
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-2"></i>Update Surat
                            </button>
                            <button type="button" class="btn btn-outline-warning" onclick="resetChanges()">
                                <i class="fas fa-undo me-2"></i>Batalkan Perubahan
                            </button>
                            <a href="{{ route('admin.pelayanan-surat.show', $surat->id) }}" class="btn btn-outline-info">
                                <i class="fas fa-eye me-2"></i>Lihat Detail
                            </a>
                        </div>
                    </div>
                </div>
                
                <!-- Delete Section -->
                <div class="card mt-4 border-danger">
                    <div class="card-body">
                        <h6 class="text-danger">
                            <i class="fas fa-exclamation-triangle me-2"></i>Zona Bahaya
                        </h6>
                        <p class="text-muted mb-3">Hapus permohonan surat secara permanen.</p>
                        <button type="button" class="btn btn-danger btn-sm" onclick="deleteSurat()">
                            <i class="fas fa-trash me-2"></i>Hapus Surat
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('styles')
<style>
    .required::after {
        content: ' *';
        color: #dc3545;
    }
    
    .file-preview {
        border: 1px solid #dee2e6;
        border-radius: 8px;
        padding: 10px;
        background: #f8f9fa;
    }
    
    .file-icon {
        width: 40px;
        height: 40px;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 18px;
    }
</style>
@endpush

@push('scripts')
<script>
const suratId = {{ $surat->id }};

$(document).ready(function() {
    $('#jenisSuratSelect').on('change', function() {
        toggleCustomJenisSurat();
    });
    
    $('#pemohonSelect').on('change', function() {
        updateInfoPemohon();
    });
    
    $('#statusSelect').on('change', function() {
        toggleFileHasil();
    });
    
    $('#filePersyaratan').on('change', function() {
        previewFile(this, 'filePreview');
    });
    
    // Initialize
    toggleCustomJenisSurat();
    toggleFileHasil();
});

function toggleCustomJenisSurat() {
    const jenisSurat = document.getElementById('jenisSuratSelect').value;
    const customDiv = document.getElementById('jenisSuratCustomDiv');
    const customInput = document.querySelector('input[name="jenis_surat_custom"]');
    
    if (jenisSurat === 'surat_lainnya') {
        customDiv.style.display = 'block';
        customInput.required = true;
    } else {
        customDiv.style.display = 'none';
        customInput.required = false;
    }
}

function toggleFileHasil() {
    const status = document.getElementById('statusSelect').value;
    const fileHasilDiv = document.getElementById('fileHasilDiv');
    
    if (status === 'selesai') {
        fileHasilDiv.style.display = 'block';
    } else {
        fileHasilDiv.style.display = 'none';
    }
}

function updateInfoPemohon() {
    const select = document.getElementById('pemohonSelect');
    const selectedOption = select.options[select.selectedIndex];
    
    if (selectedOption.value) {
        const nama = selectedOption.dataset.nama;
        const nik = selectedOption.dataset.nik;
        const alamat = selectedOption.dataset.alamat;
        const telepon = selectedOption.dataset.telepon;
        
        document.getElementById('infoPemohon').innerHTML = `
            <div class="text-center">
                <div class="bg-primary text-white rounded-circle mx-auto mb-3 d-flex align-items-center justify-content-center" 
                     style="width: 60px; height: 60px;">
                    <i class="fas fa-user fa-lg"></i>
                </div>
                <h6 class="mb-2">${nama}</h6>
                <div class="small text-muted">
                    <div class="mb-1"><strong>NIK:</strong> ${nik}</div>
                    <div class="mb-1"><strong>Alamat:</strong> ${alamat || 'Belum diisi'}</div>
                    <div><strong>Telepon:</strong> ${telepon || 'Belum diisi'}</div>
                </div>
            </div>
        `;
    } else {
        document.getElementById('infoPemohon').innerHTML = `
            <div class="text-center text-muted py-4">
                <i class="fas fa-user fa-3x mb-3"></i>
                <p>Pilih pemohon untuk melihat informasi</p>
            </div>
        `;
    }
}

function previewFile(input, previewId) {
    const file = input.files[0];
    const preview = document.getElementById(previewId);
    
    if (!file) {
        preview.innerHTML = '';
        return;
    }
    
    const fileName = file.name;
    const fileSize = (file.size / 1024 / 1024).toFixed(2);
    const fileType = file.type;
    
    let iconClass = 'fas fa-file';
    let iconColor = 'bg-secondary';
    
    if (fileType.includes('pdf')) {
        iconClass = 'fas fa-file-pdf';
        iconColor = 'bg-danger';
    } else if (fileType.includes('image')) {
        iconClass = 'fas fa-file-image';
        iconColor = 'bg-success';
    } else if (fileType.includes('word') || fileType.includes('document')) {
        iconClass = 'fas fa-file-word';
        iconColor = 'bg-primary';
    }
    
    preview.innerHTML = `
        <div class="file-preview">
            <div class="d-flex align-items-center">
                <div class="file-icon ${iconColor} me-3">
                    <i class="${iconClass}"></i>
                </div>
                <div class="flex-grow-1">
                    <div class="fw-medium">${fileName}</div>
                    <small class="text-muted">${fileSize} MB</small>
                </div>
                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeFile('${input.id}', '${previewId}')">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
    `;
}

function removeFile(inputId, previewId) {
    document.getElementById(inputId).value = '';
    document.getElementById(previewId).innerHTML = '';
}

function resetChanges() {
    if (confirm('Apakah Anda yakin ingin membatalkan semua perubahan?')) {
        location.reload();
    }
}

function deleteSurat() {
    if (confirm('Apakah Anda yakin ingin menghapus permohonan surat ini?\n\nTindakan ini tidak dapat dibatalkan.')) {
        showLoading();
        
        fetch(`/admin/pelayanan-surat/${suratId}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showToast('Permohonan surat berhasil dihapus', 'success');
                setTimeout(() => {
                    window.location.href = '{{ route("admin.pelayanan-surat.index") }}';
                }, 1500);
            } else {
                showToast(data.message || 'Gagal menghapus permohonan', 'error');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showToast('Terjadi kesalahan', 'error');
        })
        .finally(() => {
            hideLoading();
        });
    }
}

document.getElementById('editSuratForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    showLoading();
    
    fetch(`{{ route('admin.pelayanan-surat.update', $surat->id) }}`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Permohonan surat berhasil diperbarui', 'success');
            setTimeout(() => {
                window.location.href = '{{ route("admin.pelayanan-surat.index") }}';
            }, 1500);
        } else {
            showToast(data.message || 'Gagal memperbarui permohonan', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    })
    .finally(() => {
        hideLoading();
    });
});
</script>
@endpush 
