@extends('layouts.app')

@section('title', 'Detail Pelayanan Surat')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-file-alt me-2 text-primary"></i>
                Detail Pelayanan Surat
            </h2>
            <p class="text-muted mb-0">Informasi lengkap permohonan surat #{{ $surat->id }}</p>
        </div>
        <div>
            <a href="{{ route('admin.pelayanan-surat.index') }}" class="btn btn-outline-secondary me-2">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
            <a href="{{ route('admin.pelayanan-surat.edit', $surat->id) }}" class="btn btn-warning">
                <i class="fas fa-edit me-2"></i>Edit
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <!-- Informasi Surat -->
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-file-alt me-2"></i>Informasi Surat
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Jenis Surat</label>
                                <div class="fw-bold">
                                    {{ $surat->jenis_surat_custom ?: ucwords(str_replace('_', ' ', $surat->jenis_surat)) }}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Status</label>
                                <div>
                                    @php
                                        $statusColors = [
                                            'pending' => 'warning',
                                            'diproses' => 'info',
                                            'selesai' => 'success',
                                            'ditolak' => 'danger'
                                        ];
                                    @endphp
                                    <span class="badge bg-{{ $statusColors[$surat->status] ?? 'secondary' }} fs-6">
                                        {{ ucfirst($surat->status) }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label text-muted">Keperluan</label>
                        <div class="fw-medium">{{ $surat->keperluan }}</div>
                    </div>
                    
                    @if($surat->keterangan)
                    <div class="mb-3">
                        <label class="form-label text-muted">Keterangan Tambahan</label>
                        <div class="fw-medium">{{ $surat->keterangan }}</div>
                    </div>
                    @endif
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Tanggal Permohonan</label>
                                <div class="fw-medium">{{ $surat->created_at->format('d F Y H:i') }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Estimasi Selesai</label>
                                <div class="fw-medium">
                                    @if($surat->estimasi_selesai)
                                        {{ \Carbon\Carbon::parse($surat->estimasi_selesai)->format('d F Y') }}
                                    @else
                                        <span class="text-muted">Belum ditentukan</span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Informasi Pemohon -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-user me-2"></i>Informasi Pemohon
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Nama Lengkap</label>
                                <div class="fw-bold">{{ $surat->pemohon->nama }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">NIK</label>
                                <div class="fw-medium">{{ $surat->pemohon->nik }}</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Tempat, Tanggal Lahir</label>
                                <div class="fw-medium">
                                    {{ $surat->pemohon->tempat_lahir }}, 
                                    {{ \Carbon\Carbon::parse($surat->pemohon->tanggal_lahir)->format('d F Y') }}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Jenis Kelamin</label>
                                <div class="fw-medium">{{ $surat->pemohon->jk === 'L' ? 'Laki-laki' : 'Perempuan' }}</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label text-muted">Alamat</label>
                        <div class="fw-medium">{{ $surat->pemohon->alamat }}</div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Telepon</label>
                                <div class="fw-medium">{{ $surat->pemohon->telepon ?: 'Belum diisi' }}</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Pekerjaan</label>
                                <div class="fw-medium">{{ $surat->pemohon->pekerjaan ?: 'Belum diisi' }}</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- File Persyaratan -->
            @if($surat->file_persyaratan)
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-paperclip me-2"></i>File Persyaratan
                    </h5>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center p-3 border rounded">
                        <div class="file-icon bg-primary text-white me-3" style="width: 40px; height: 40px; border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                            <i class="fas fa-file"></i>
                        </div>
                        <div class="flex-grow-1">
                            <div class="fw-medium">{{ basename($surat->file_persyaratan) }}</div>
                            <small class="text-muted">Diupload {{ $surat->created_at->format('d F Y H:i') }}</small>
                        </div>
                        <div>
                            <a href="{{ Storage::url($surat->file_persyaratan) }}" 
                               class="btn btn-outline-primary btn-sm" target="_blank">
                                <i class="fas fa-eye me-1"></i>Lihat
                            </a>
                            <a href="{{ Storage::url($surat->file_persyaratan) }}" 
                               class="btn btn-outline-success btn-sm" download>
                                <i class="fas fa-download me-1"></i>Download
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            @endif
            
            <!-- File Hasil -->
            @if($surat->file_hasil)
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-file-pdf me-2"></i>File Hasil Surat
                    </h5>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center p-3 border rounded bg-light">
                        <div class="file-icon bg-success text-white me-3" style="width: 40px; height: 40px; border-radius: 8px; display: flex; align-items: center; justify-content: center;">
                            <i class="fas fa-file-pdf"></i>
                        </div>
                        <div class="flex-grow-1">
                            <div class="fw-medium">{{ basename($surat->file_hasil) }}</div>
                            <small class="text-muted">Dibuat {{ $surat->updated_at->format('d F Y H:i') }}</small>
                        </div>
                        <div>
                            <a href="{{ Storage::url($surat->file_hasil) }}" 
                               class="btn btn-success btn-sm" target="_blank">
                                <i class="fas fa-eye me-1"></i>Lihat Surat
                            </a>
                            <a href="{{ Storage::url($surat->file_hasil) }}" 
                               class="btn btn-outline-success btn-sm" download>
                                <i class="fas fa-download me-1"></i>Download
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </div>
        
        <!-- Sidebar -->
        <div class="col-lg-4">
            <!-- Timeline Status -->
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-history me-2"></i>Timeline Proses
                    </h6>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <div class="timeline-item {{ $surat->created_at ? 'completed' : '' }}">
                            <div class="timeline-marker"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Permohonan Dibuat</h6>
                                <p class="timeline-time">{{ $surat->created_at->format('d M Y H:i') }}</p>
                            </div>
                        </div>
                        
                        <div class="timeline-item {{ in_array($surat->status, ['diproses', 'selesai']) ? 'completed' : '' }}">
                            <div class="timeline-marker"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Sedang Diproses</h6>
                                <p class="timeline-time">
                                    @if(in_array($surat->status, ['diproses', 'selesai']))
                                        {{ $surat->updated_at->format('d M Y H:i') }}
                                    @else
                                        -
                                    @endif
                                </p>
                            </div>
                        </div>
                        
                        <div class="timeline-item {{ $surat->status === 'selesai' ? 'completed' : '' }}">
                            <div class="timeline-marker"></div>
                            <div class="timeline-content">
                                <h6 class="timeline-title">Selesai</h6>
                                <p class="timeline-time">
                                    @if($surat->status === 'selesai')
                                        {{ $surat->updated_at->format('d M Y H:i') }}
                                    @else
                                        -
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Update Status -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-edit me-2"></i>Update Status
                    </h6>
                </div>
                <div class="card-body">
                    <form id="updateStatusForm">
                        @csrf
                        @method('PUT')
                        
                        <div class="mb-3">
                            <label class="form-label">Status</label>
                            <select class="form-select" name="status" id="statusSelect">
                                <option value="pending" {{ $surat->status === 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="diproses" {{ $surat->status === 'diproses' ? 'selected' : '' }}>Diproses</option>
                                <option value="selesai" {{ $surat->status === 'selesai' ? 'selected' : '' }}>Selesai</option>
                                <option value="ditolak" {{ $surat->status === 'ditolak' ? 'selected' : '' }}>Ditolak</option>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Estimasi Selesai</label>
                            <input type="date" class="form-control" name="estimasi_selesai" 
                                   value="{{ $surat->estimasi_selesai ? \Carbon\Carbon::parse($surat->estimasi_selesai)->format('Y-m-d') : '' }}">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Catatan</label>
                            <textarea class="form-control" name="catatan" rows="3" 
                                      placeholder="Catatan untuk pemohon...">{{ $surat->catatan ?? '' }}</textarea>
                        </div>
                        
                        <div class="mb-3" id="fileHasilDiv" style="{{ $surat->status === 'selesai' ? 'display: block;' : 'display: none;' }}">
                            <label class="form-label">Upload File Hasil</label>
                            <input type="file" class="form-control" name="file_hasil" accept=".pdf">
                            <div class="form-text">Upload file surat yang sudah jadi (PDF)</div>
                        </div>
                        
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>Update Status
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            
            <!-- Informasi Sistem -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="card-title mb-0">
                        <i class="fas fa-info-circle me-2"></i>Informasi Sistem
                    </h6>
                </div>
                <div class="card-body">
                    <div class="small">
                        <div class="d-flex justify-content-between mb-2">
                            <span>ID Surat</span>
                            <span class="fw-bold">#{{ $surat->id }}</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Dibuat</span>
                            <span class="fw-bold">{{ $surat->created_at->format('d/m/Y H:i') }}</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Diperbarui</span>
                            <span class="fw-bold">{{ $surat->updated_at->format('d/m/Y H:i') }}</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Actions -->
            <div class="card mt-4">
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.pelayanan-surat.edit', $surat->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit me-2"></i>Edit Surat
                        </a>
                        <button type="button" class="btn btn-outline-primary" onclick="printSurat()">
                            <i class="fas fa-print me-2"></i>Cetak
                        </button>
                        <button type="button" class="btn btn-outline-success" onclick="kirimWhatsapp()">
                            <i class="fab fa-whatsapp me-2"></i>Kirim WhatsApp
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.timeline {
    position: relative;
    padding-left: 30px;
}

.timeline::before {
    content: '';
    position: absolute;
    left: 9px;
    top: 0;
    bottom: 0;
    width: 2px;
    background: #dee2e6;
}

.timeline-item {
    position: relative;
    margin-bottom: 20px;
}

.timeline-marker {
    position: absolute;
    left: -25px;
    top: 5px;
    width: 18px;
    height: 18px;
    border-radius: 50%;
    background: #dee2e6;
    border: 3px solid white;
}

.timeline-item.completed .timeline-marker {
    background: #28a745;
}

.timeline-title {
    font-size: 14px;
    margin-bottom: 5px;
}

.timeline-time {
    font-size: 12px;
    color: #6c757d;
    margin: 0;
}
</style>
@endpush

@push('scripts')
<script>
$(document).ready(function() {
    $('#statusSelect').on('change', function() {
        const status = $(this).val();
        const fileHasilDiv = document.getElementById('fileHasilDiv');
        
        if (status === 'selesai') {
            fileHasilDiv.style.display = 'block';
        } else {
            fileHasilDiv.style.display = 'none';
        }
    });
});

document.getElementById('updateStatusForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    fetch(`{{ route('admin.pelayanan-surat.update', $surat->id) }}`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            showToast('Status berhasil diperbarui', 'success');
            setTimeout(() => {
                location.reload();
            }, 1500);
        } else {
            showToast(data.message || 'Gagal memperbarui status', 'error');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        showToast('Terjadi kesalahan', 'error');
    });
});

function printSurat() {
    window.print();
}

function kirimWhatsapp() {
    const pemohon = '{{ $surat->pemohon->nama }}';
    const jenisSurat = '{{ $surat->jenis_surat_custom ?: ucwords(str_replace("_", " ", $surat->jenis_surat)) }}';
    const status = '{{ $surat->status }}';
    const telepon = '{{ $surat->pemohon->telepon }}';
    
    if (!telepon) {
        showToast('Nomor telepon pemohon belum tersedia', 'warning');
        return;
    }
    
    let message = `Halo ${pemohon},\n\nPermohonan ${jenisSurat} Anda dengan ID #{{ $surat->id }} saat ini berstatus: ${status.toUpperCase()}.\n\n`;
    
    if (status === 'selesai') {
        message += 'Surat Anda sudah selesai dan dapat diambil di kantor desa.\n\n';
    } else if (status === 'diproses') {
        message += 'Surat Anda sedang dalam proses pengerjaan.\n\n';
    }
    
    message += 'Terima kasih.\n\nKantor Desa';
    
    const whatsappUrl = `https://wa.me/${telepon.replace(/[^0-9]/g, '')}?text=${encodeURIComponent(message)}`;
    window.open(whatsappUrl, '_blank');
}
</script>
@endpush 
