@extends('layouts.app')

@section('title', 'Edit Perangkat Desa')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.perangkat-desa.index') }}">Perangkat Desa</a></li>
    <li class="breadcrumb-item active">Edit {{ $perangkatDesa->nama }}</li>
@endsection

@push('styles')
<style>
    .current-file {
        background: #f8f9fa;
        border: 1px solid #dee2e6;
        border-radius: 8px;
        padding: 1rem;
        margin-bottom: 0.5rem;
    }
    
    .file-preview {
        max-width: 100px;
        max-height: 100px;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    
    .form-section {
        background: #ffffff;
        border: 1px solid #e3e6f0;
        border-radius: 10px;
        padding: 1.5rem;
        margin-bottom: 1.5rem;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }
    
    .section-title {
        color: #5a5c69;
        font-weight: 600;
        margin-bottom: 1rem;
        padding-bottom: 0.5rem;
        border-bottom: 2px solid #e3e6f0;
    }
</style>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="card-title">
                            <i class="fas fa-edit me-2"></i>
                            Edit Perangkat Desa
                        </h3>
                        <div>
                            <a href="{{ route('admin.perangkat-desa.show', $perangkatDesa) }}" class="btn btn-info btn-sm">
                                <i class="fas fa-eye me-1"></i>
                                Lihat Detail
                            </a>
                            <a href="{{ route('admin.perangkat-desa.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-1"></i>
                                Kembali
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <form action="{{ route('admin.perangkat-desa.update', $perangkatDesa) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        
                        <!-- Informasi Dasar -->
                        <div class="form-section">
                            <h5 class="section-title">
                                <i class="fas fa-user me-2"></i>Informasi Dasar
                            </h5>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="nik" class="form-label">NIK <span class="text-danger">*</span></label>
                                        <select class="form-control @error('nik') is-invalid @enderror" 
                                                id="nik" name="nik" required>
                                            <option value="">Pilih Penduduk</option>
                                            @foreach($penduduk as $p)
                                                <option value="{{ $p->nik }}" 
                                                        {{ (old('nik', $perangkatDesa->nik) == $p->nik) ? 'selected' : '' }}>
                                                    {{ $p->nik }} - {{ $p->nama }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('nik')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="nama" class="form-label">Nama <span class="text-danger">*</span></label>
                                        <input type="text" 
                                               class="form-control @error('nama') is-invalid @enderror" 
                                               id="nama" 
                                               name="nama" 
                                               value="{{ old('nama', $perangkatDesa->nama) }}" 
                                               required>
                                        @error('nama')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="jabatan" class="form-label">Jabatan <span class="text-danger">*</span></label>
                                        <select class="form-control @error('jabatan') is-invalid @enderror" 
                                                id="jabatan" name="jabatan" required>
                                            <option value="">Pilih Jabatan</option>
                                            @foreach($jabatan as $j)
                                                <option value="{{ $j }}" 
                                                        {{ (old('jabatan', $perangkatDesa->jabatan) == $j) ? 'selected' : '' }}>
                                                    {{ $j }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('jabatan')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="nip" class="form-label">NIP</label>
                                        <input type="text" 
                                               class="form-control @error('nip') is-invalid @enderror" 
                                               id="nip" 
                                               name="nip" 
                                               value="{{ old('nip', $perangkatDesa->nip) }}" 
                                               placeholder="Nomor Induk Pegawai (opsional)">
                                        @error('nip')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Informasi Jabatan -->
                        <div class="form-section">
                            <h5 class="section-title">
                                <i class="fas fa-briefcase me-2"></i>Informasi Jabatan
                            </h5>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="mulai_tugas" class="form-label">Mulai Tugas <span class="text-danger">*</span></label>
                                        <input type="date" 
                                               class="form-control @error('mulai_tugas') is-invalid @enderror" 
                                               id="mulai_tugas" 
                                               name="mulai_tugas" 
                                               value="{{ old('mulai_tugas', $perangkatDesa->mulai_tugas ? $perangkatDesa->mulai_tugas->format('Y-m-d') : '') }}" 
                                               required>
                                        @error('mulai_tugas')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="selesai_tugas" class="form-label">Selesai Tugas</label>
                                        <input type="date" 
                                               class="form-control @error('selesai_tugas') is-invalid @enderror" 
                                               id="selesai_tugas" 
                                               name="selesai_tugas" 
                                               value="{{ old('selesai_tugas', $perangkatDesa->selesai_tugas ? $perangkatDesa->selesai_tugas->format('Y-m-d') : '') }}">
                                        @error('selesai_tugas')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                        <select class="form-control @error('status') is-invalid @enderror" 
                                                id="status" name="status" required>
                                            <option value="">Pilih Status</option>
                                            <option value="Aktif" {{ (old('status', $perangkatDesa->status) == 'Aktif') ? 'selected' : '' }}>Aktif</option>
                                            <option value="Tidak Aktif" {{ (old('status', $perangkatDesa->status) == 'Tidak Aktif') ? 'selected' : '' }}>Tidak Aktif</option>
                                            <option value="Pensiun" {{ (old('status', $perangkatDesa->status) == 'Pensiun') ? 'selected' : '' }}>Pensiun</option>
                                            <option value="Mutasi" {{ (old('status', $perangkatDesa->status) == 'Mutasi') ? 'selected' : '' }}>Mutasi</option>
                                        </select>
                                        @error('status')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="wilayah_kerja" class="form-label">Wilayah Kerja</label>
                                        <input type="text" 
                                               class="form-control @error('wilayah_kerja') is-invalid @enderror" 
                                               id="wilayah_kerja" 
                                               name="wilayah_kerja" 
                                               value="{{ old('wilayah_kerja', $perangkatDesa->wilayah_kerja) }}" 
                                               placeholder="Wilayah kerja/tanggung jawab">
                                        @error('wilayah_kerja')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="bidang_tugas" class="form-label">Bidang Tugas</label>
                                        <input type="text" 
                                               class="form-control @error('bidang_tugas') is-invalid @enderror" 
                                               id="bidang_tugas" 
                                               name="bidang_tugas" 
                                               value="{{ old('bidang_tugas', $perangkatDesa->bidang_tugas) }}" 
                                               placeholder="Bidang tugas dan tanggung jawab">
                                        @error('bidang_tugas')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="tugas_tanggung_jawab" class="form-label">Tugas & Tanggung Jawab</label>
                                        <textarea class="form-control @error('tugas_tanggung_jawab') is-invalid @enderror" 
                                                  id="tugas_tanggung_jawab" 
                                                  name="tugas_tanggung_jawab" 
                                                  rows="4" 
                                                  placeholder="Uraian detail tugas dan tanggung jawab">{{ old('tugas_tanggung_jawab', $perangkatDesa->tugas_tanggung_jawab) }}</textarea>
                                        @error('tugas_tanggung_jawab')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Informasi Kontak -->
                        <div class="form-section">
                            <h5 class="section-title">
                                <i class="fas fa-phone me-2"></i>Informasi Kontak
                            </h5>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="no_hp" class="form-label">No. HP</label>
                                        <input type="text" 
                                               class="form-control @error('no_hp') is-invalid @enderror" 
                                               id="no_hp" 
                                               name="no_hp" 
                                               value="{{ old('no_hp', $perangkatDesa->no_hp) }}" 
                                               placeholder="Nomor HP/WhatsApp">
                                        @error('no_hp')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="email" class="form-label">Email</label>
                                        <input type="email" 
                                               class="form-control @error('email') is-invalid @enderror" 
                                               id="email" 
                                               name="email" 
                                               value="{{ old('email', $perangkatDesa->email) }}" 
                                               placeholder="Email perangkat desa">
                                        @error('email')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label for="alamat" class="form-label">Alamat</label>
                                        <textarea class="form-control @error('alamat') is-invalid @enderror" 
                                                  id="alamat" 
                                                  name="alamat" 
                                                  rows="2" 
                                                  placeholder="Alamat lengkap">{{ old('alamat', $perangkatDesa->alamat) }}</textarea>
                                        @error('alamat')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- File Upload -->
                        <div class="form-section">
                            <h5 class="section-title">
                                <i class="fas fa-file me-2"></i>File & Dokumen
                            </h5>
                            
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="foto" class="form-label">Foto</label>
                                        
                                        @if($perangkatDesa->foto)
                                            <div class="current-file">
                                                <div class="d-flex align-items-center">
                                                    <img src="{{ asset('storage/' . $perangkatDesa->foto) }}" 
                                                         class="file-preview me-3" 
                                                         alt="Foto saat ini">
                                                    <div>
                                                        <small class="text-muted d-block">Foto saat ini</small>
                                                        <small class="text-info">Pilih file baru untuk mengganti</small>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        
                                        <input type="file" 
                                               class="form-control @error('foto') is-invalid @enderror" 
                                               id="foto" 
                                               name="foto" 
                                               accept="image/*">
                                        <small class="form-text text-muted">Format: JPG, PNG (Max: 2MB)</small>
                                        @error('foto')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="file_sk" class="form-label">File SK</label>
                                        
                                        @if($perangkatDesa->file_sk)
                                            <div class="current-file">
                                                <div class="d-flex align-items-center">
                                                    <i class="fas fa-file-pdf fa-2x text-danger me-3"></i>
                                                    <div>
                                                        <small class="text-muted d-block">File SK saat ini</small>
                                                        <a href="{{ route('admin.perangkat-desa.cetak-sk', $perangkatDesa) }}" 
                                                           class="btn btn-sm btn-outline-danger">
                                                            <i class="fas fa-download me-1"></i>Download
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        
                                        <input type="file" 
                                               class="form-control @error('file_sk') is-invalid @enderror" 
                                               id="file_sk" 
                                               name="file_sk" 
                                               accept=".pdf,.doc,.docx">
                                        <small class="form-text text-muted">Format: PDF, DOC, DOCX (Max: 5MB)</small>
                                        @error('file_sk')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-4">
                                    <div class="mb-3">
                                        <label for="tanda_tangan" class="form-label">Tanda Tangan</label>
                                        
                                        @if($perangkatDesa->tanda_tangan)
                                            <div class="current-file">
                                                <div class="d-flex align-items-center">
                                                    <img src="{{ asset('storage/' . $perangkatDesa->tanda_tangan) }}" 
                                                         class="file-preview me-3" 
                                                         alt="TTD saat ini">
                                                    <div>
                                                        <small class="text-muted d-block">TTD saat ini</small>
                                                        <small class="text-info">Pilih file baru untuk mengganti</small>
                                                    </div>
                                                </div>
                                            </div>
                                        @endif
                                        
                                        <input type="file" 
                                               class="form-control @error('tanda_tangan') is-invalid @enderror" 
                                               id="tanda_tangan" 
                                               name="tanda_tangan" 
                                               accept=".png">
                                        <small class="form-text text-muted">Format: PNG dengan background transparan (Max: 1MB)</small>
                                        @error('tanda_tangan')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Pengaturan Struktur -->
                        <div class="form-section">
                            <h5 class="section-title">
                                <i class="fas fa-sitemap me-2"></i>Pengaturan Struktur
                            </h5>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="level_hierarki" class="form-label">Level Hierarki</label>
                                        <select class="form-control @error('level_hierarki') is-invalid @enderror" 
                                                id="level_hierarki" name="level_hierarki">
                                            <option value="">Pilih Level</option>
                                            <option value="0" {{ (old('level_hierarki', $perangkatDesa->level_hierarki) == '0') ? 'selected' : '' }}>Level 0 - Kepala Desa</option>
                                            <option value="1" {{ (old('level_hierarki', $perangkatDesa->level_hierarki) == '1') ? 'selected' : '' }}>Level 1 - Perangkat Inti</option>
                                            <option value="2" {{ (old('level_hierarki', $perangkatDesa->level_hierarki) == '2') ? 'selected' : '' }}>Level 2 - Kepala Dusun</option>
                                            <option value="3" {{ (old('level_hierarki', $perangkatDesa->level_hierarki) == '3') ? 'selected' : '' }}>Level 3 - RT/RW</option>
                                        </select>
                                        @error('level_hierarki')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="urutan" class="form-label">Urutan</label>
                                        <input type="number" 
                                               class="form-control @error('urutan') is-invalid @enderror" 
                                               id="urutan" 
                                               name="urutan" 
                                               value="{{ old('urutan', $perangkatDesa->urutan ?? 1) }}" 
                                               min="1">
                                        <small class="form-text text-muted">Urutan tampil dalam struktur organisasi</small>
                                        @error('urutan')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex justify-content-end gap-2">
                                    <a href="{{ route('admin.perangkat-desa.show', $perangkatDesa) }}" class="btn btn-info">
                                        <i class="fas fa-eye me-1"></i>
                                        Lihat Detail
                                    </a>
                                    <a href="{{ route('admin.perangkat-desa.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-times me-1"></i>
                                        Batal
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i>
                                        Update Data
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Auto-fill nama when NIK is selected
    $('#nik').change(function() {
        const selectedOption = $(this).find('option:selected');
        if (selectedOption.val()) {
            const nama = selectedOption.text().split(' - ')[1];
            $('#nama').val(nama);
        }
    });
    
    // Show/hide selesai_tugas based on status
    $('#status').change(function() {
        const status = $(this).val();
        const selesaiTugasField = $('#selesai_tugas').closest('.mb-3');
        
        if (status === 'Aktif') {
            selesaiTugasField.hide();
            $('#selesai_tugas').val('');
        } else {
            selesaiTugasField.show();
        }
    });
    
    // Trigger on page load
    $('#status').trigger('change');
});
</script>
@endpush
