@extends('layouts.app')

@section('title', 'Struktur Organisasi Perangkat Desa')

@section('content')
<div class="container-fluid px-4">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="fas fa-sitemap me-2"></i>Struktur Organisasi
            </h1>
            <p class="text-muted mb-0">Struktur hierarki perangkat desa</p>
        </div>
        <div>
            <a href="{{ route('admin.perangkat-desa.index') }}" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-1"></i>Kembali
            </a>
            <button class="btn btn-primary" onclick="printStructure()">
                <i class="fas fa-print me-1"></i>Cetak
            </button>
        </div>
    </div>

    <!-- Structure Container -->
    <div class="row justify-content-center" id="structure-container">
        <div class="col-12">
            <div class="card shadow-sm border-0">
                <div class="card-body p-4">
                    
                    <!-- Kepala Desa -->
                    @if($kepalaDesa)
                    <div class="text-center mb-5">
                        <div class="position-relative d-inline-block">
                            <div class="org-card kepala-desa">
                                <div class="org-photo">
                                    @if($kepalaDesa->foto && file_exists(public_path('storage/' . $kepalaDesa->foto)))
                                        <img src="{{ asset('storage/' . $kepalaDesa->foto) }}" 
                                             alt="{{ $kepalaDesa->nama }}"
                                             class="rounded-circle">
                                    @else
                                        <div class="org-avatar bg-primary">
                                            {{ strtoupper(substr($kepalaDesa->nama, 0, 2)) }}
                                        </div>
                                    @endif
                                    <div class="status-indicator bg-success"></div>
                                </div>
                                <div class="org-info">
                                    <h5 class="org-name">{{ $kepalaDesa->nama }}</h5>
                                    <p class="org-position">{{ $kepalaDesa->jabatan }}</p>
                                    @if($kepalaDesa->nip)
                                        <small class="text-muted">NIP: {{ $kepalaDesa->nip }}</small>
                                    @endif
                                </div>
                            </div>
                        </div>
                        
                        <!-- Connector Line -->
                        <div class="connector-line vertical"></div>
                    </div>
                    @endif

                    <!-- Sekretaris Desa -->
                    @if($sekretaris)
                    <div class="text-center mb-5">
                        <div class="org-card sekretaris">
                            <div class="org-photo">
                                @if($sekretaris->foto && file_exists(public_path('storage/' . $sekretaris->foto)))
                                    <img src="{{ asset('storage/' . $sekretaris->foto) }}" 
                                         alt="{{ $sekretaris->nama }}"
                                         class="rounded-circle">
                                @else
                                    <div class="org-avatar bg-info">
                                        {{ strtoupper(substr($sekretaris->nama, 0, 2)) }}
                                    </div>
                                @endif
                                <div class="status-indicator bg-success"></div>
                            </div>
                            <div class="org-info">
                                <h5 class="org-name">{{ $sekretaris->nama }}</h5>
                                <p class="org-position">{{ $sekretaris->jabatan }}</p>
                                @if($sekretaris->nip)
                                    <small class="text-muted">NIP: {{ $sekretaris->nip }}</small>
                                @endif
                            </div>
                        </div>
                        
                        <!-- Connector Line -->
                        @if($staf->count() > 0)
                            <div class="connector-line vertical"></div>
                            <div class="connector-line horizontal"></div>
                        @endif
                    </div>
                    @endif

                    <!-- Staff Level (Kaur & Kasi) -->
                    @if($staf->count() > 0)
                    <div class="mb-5">
                        <h6 class="text-center text-muted mb-4">
                            <i class="fas fa-users me-2"></i>Kepala Urusan & Kepala Seksi
                        </h6>
                        <div class="row justify-content-center">
                            @foreach($staf as $staff)
                            <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                                <div class="org-card staff">
                                    <div class="org-photo">
                                        @if($staff->foto && file_exists(public_path('storage/' . $staff->foto)))
                                            <img src="{{ asset('storage/' . $staff->foto) }}" 
                                                 alt="{{ $staff->nama }}"
                                                 class="rounded-circle">
                                        @else
                                            <div class="org-avatar bg-success">
                                                {{ strtoupper(substr($staff->nama, 0, 2)) }}
                                            </div>
                                        @endif
                                        <div class="status-indicator bg-success"></div>
                                    </div>
                                    <div class="org-info">
                                        <h6 class="org-name">{{ $staff->nama }}</h6>
                                        <p class="org-position">{{ $staff->jabatan }}</p>
                                        @if($staff->bidang_tugas)
                                            <small class="text-muted">{{ $staff->bidang_tugas }}</small>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif

                    <!-- Kepala Dusun -->
                    @if($kepalaDusun->count() > 0)
                    <div class="mb-5">
                        <h6 class="text-center text-muted mb-4">
                            <i class="fas fa-map-marker-alt me-2"></i>Kepala Dusun
                        </h6>
                        <div class="row justify-content-center">
                            @foreach($kepalaDusun as $kadus)
                            <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                                <div class="org-card kadus">
                                    <div class="org-photo">
                                        @if($kadus->foto && file_exists(public_path('storage/' . $kadus->foto)))
                                            <img src="{{ asset('storage/' . $kadus->foto) }}" 
                                                 alt="{{ $kadus->nama }}"
                                                 class="rounded-circle">
                                        @else
                                            <div class="org-avatar bg-warning">
                                                {{ strtoupper(substr($kadus->nama, 0, 2)) }}
                                            </div>
                                        @endif
                                        <div class="status-indicator bg-success"></div>
                                    </div>
                                    <div class="org-info">
                                        <h6 class="org-name">{{ $kadus->nama }}</h6>
                                        <p class="org-position">{{ $kadus->jabatan }}</p>
                                        @if($kadus->wilayah_kerja)
                                            <small class="text-muted">{{ $kadus->wilayah_kerja }}</small>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif

                    <!-- RT/RW -->
                    @if($rtRw->count() > 0)
                    <div class="mb-4">
                        <h6 class="text-center text-muted mb-4">
                            <i class="fas fa-home me-2"></i>RT & RW
                        </h6>
                        <div class="row justify-content-center">
                            @foreach($rtRw as $rt)
                            <div class="col-lg-2 col-md-3 col-sm-4 col-6 mb-3">
                                <div class="org-card rt-rw">
                                    <div class="org-photo">
                                        @if($rt->foto && file_exists(public_path('storage/' . $rt->foto)))
                                            <img src="{{ asset('storage/' . $rt->foto) }}" 
                                                 alt="{{ $rt->nama }}"
                                                 class="rounded-circle">
                                        @else
                                            <div class="org-avatar bg-secondary">
                                                {{ strtoupper(substr($rt->nama, 0, 2)) }}
                                            </div>
                                        @endif
                                        <div class="status-indicator bg-success"></div>
                                    </div>
                                    <div class="org-info">
                                        <h6 class="org-name">{{ $rt->nama }}</h6>
                                        <p class="org-position">{{ $rt->jabatan }}</p>
                                        @if($rt->wilayah_kerja)
                                            <small class="text-muted">{{ $rt->wilayah_kerja }}</small>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif

                    <!-- Empty State -->
                    @if(!$kepalaDesa && !$sekretaris && $staf->count() == 0 && $kepalaDusun->count() == 0 && $rtRw->count() == 0)
                    <div class="text-center py-5">
                        <i class="fas fa-users text-muted" style="font-size: 4rem;"></i>
                        <h5 class="text-muted mt-3">Belum Ada Data Perangkat Desa</h5>
                        <p class="text-muted">Silakan tambahkan data perangkat desa terlebih dahulu</p>
                        <a href="{{ route('admin.perangkat-desa.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>Tambah Perangkat Desa
                        </a>
                    </div>
                    @endif

                </div>
            </div>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<style>
.org-card {
    background: white;
    border: 2px solid #e3e6f0;
    border-radius: 12px;
    padding: 20px;
    text-align: center;
    transition: all 0.3s ease;
    position: relative;
    max-width: 280px;
    margin: 0 auto;
}

.org-card:hover {
    border-color: #4e73df;
    transform: translateY(-2px);
    box-shadow: 0 4px 20px rgba(78, 115, 223, 0.15);
}

.org-card.kepala-desa {
    border-color: #e74a3b;
    background: linear-gradient(135deg, #fff 0%, #fff5f5 100%);
}

.org-card.sekretaris {
    border-color: #36b9cc;
    background: linear-gradient(135deg, #fff 0%, #f0fdff 100%);
}

.org-card.staff {
    border-color: #1cc88a;
    background: linear-gradient(135deg, #fff 0%, #f0fff8 100%);
}

.org-card.kadus {
    border-color: #f6c23e;
    background: linear-gradient(135deg, #fff 0%, #fffcf0 100%);
}

.org-card.rt-rw {
    border-color: #6c757d;
    background: linear-gradient(135deg, #fff 0%, #f8f9fa 100%);
}

.org-photo {
    position: relative;
    display: inline-block;
    margin-bottom: 15px;
}

.org-photo img {
    width: 80px;
    height: 80px;
    object-fit: cover;
    border: 3px solid #fff;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.org-avatar {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: bold;
    font-size: 24px;
    border: 3px solid #fff;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.status-indicator {
    position: absolute;
    bottom: 5px;
    right: 5px;
    width: 20px;
    height: 20px;
    border-radius: 50%;
    border: 3px solid white;
}

.org-info {
    margin-top: 10px;
}

.org-name {
    font-size: 16px;
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 5px;
    line-height: 1.2;
}

.org-position {
    font-size: 14px;
    color: #7f8c8d;
    margin-bottom: 5px;
    font-weight: 500;
}

.connector-line {
    background: #dee2e6;
}

.connector-line.vertical {
    width: 2px;
    height: 30px;
    margin: 0 auto;
}

.connector-line.horizontal {
    height: 2px;
    width: 200px;
    margin: 0 auto 20px;
}

/* Print Styles */
@media print {
    .container-fluid {
        max-width: none !important;
        padding: 0 !important;
    }
    
    .card {
        border: none !important;
        box-shadow: none !important;
    }
    
    .btn {
        display: none !important;
    }
    
    .org-card {
        border: 1px solid #000 !important;
        box-shadow: none !important;
        background: white !important;
        page-break-inside: avoid;
    }
}

/* Responsive Design */
@media (max-width: 768px) {
    .org-card {
        max-width: 100%;
        padding: 15px;
    }
    
    .org-photo img,
    .org-avatar {
        width: 60px;
        height: 60px;
    }
    
    .org-avatar {
        font-size: 18px;
    }
    
    .org-name {
        font-size: 14px;
    }
    
    .org-position {
        font-size: 12px;
    }
}
</style>

<!-- JavaScript -->
<script>
function printStructure() {
    window.print();
}

// Add animation on load
document.addEventListener('DOMContentLoaded', function() {
    const cards = document.querySelectorAll('.org-card');
    cards.forEach((card, index) => {
        setTimeout(() => {
            card.style.opacity = '0';
            card.style.transform = 'translateY(20px)';
            card.style.transition = 'all 0.5s ease';
            
            setTimeout(() => {
                card.style.opacity = '1';
                card.style.transform = 'translateY(0)';
            }, 100);
        }, index * 100);
    });
});
</script>
@endsection