@extends('layouts.app')

@section('title', 'Peta Rumah')

@section('breadcrumb')
    <li class="breadcrumb-item active">Peta Rumah</li>
@endsection

@section('content')
<div class="row">
    <!-- Statistics Cards -->
    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-primary h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-map-marker-alt"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold">{{ $stats['penduduk'] ?? 0 }}</div>
                    <div class="small">Lokasi Penduduk</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-success h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-home"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold">{{ $stats['keluarga'] ?? 0 }}</div>
                    <div class="small">Rumah Keluarga</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-warning h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold">{{ $stats['pengaduan'] ?? 0 }}</div>
                    <div class="small">Lokasi Pengaduan</div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6 mb-4">
        <div class="card card-gradient-info h-100">
            <div class="card-body d-flex align-items-center">
                <div class="stats-icon bg-white bg-opacity-20 me-3">
                    <i class="fas fa-hand-holding-heart"></i>
                </div>
                <div>
                    <div class="fs-2 fw-bold">{{ $stats['bantuan'] ?? 0 }}</div>
                    <div class="small">Lokasi Bantuan</div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Map Container -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-light">
                <h5 class="card-title mb-0">
                    <i class="fas fa-map me-2 text-primary"></i>
                    Peta Rumah Penduduk
                </h5>
            </div>
            <div class="card-body p-0">
                <div id="petaRumah" style="height: 500px; width: 100%;"></div>
            </div>
        </div>
    </div>
</div>

<!-- Info Card -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-body text-center">
                <h5>🗺️ Fitur Peta Rumah</h5>
                <p class="text-muted">
                    Halaman ini menampilkan lokasi rumah penduduk yang telah memiliki koordinat GPS. 
                    Fitur ini dapat dikembangkan lebih lanjut untuk menampilkan peta interaktif dengan berbagai informasi geografis.
                </p>
                <div class="row text-center">
                    <div class="col-md-3">
                        <i class="fas fa-map-marker-alt fa-2x text-primary mb-2"></i>
                        <h6>Lokasi Penduduk</h6>
                        <small class="text-muted">Menampilkan titik rumah penduduk</small>
                    </div>
                    <div class="col-md-3">
                        <i class="fas fa-home fa-2x text-success mb-2"></i>
                        <h6>Data Keluarga</h6>
                        <small class="text-muted">Informasi kepala keluarga</small>
                    </div>
                    <div class="col-md-3">
                        <i class="fas fa-search fa-2x text-info mb-2"></i>
                        <h6>Pencarian Lokasi</h6>
                        <small class="text-muted">Cari berdasarkan nama atau alamat</small>
                    </div>
                    <div class="col-md-3">
                        <i class="fas fa-layer-group fa-2x text-warning mb-2"></i>
                        <h6>Multi Layer</h6>
                        <small class="text-muted">Tampilkan berbagai jenis data</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.stats-icon {
    width: 50px;
    height: 50px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 24px;
}

.card-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.card-gradient-success {
    background: linear-gradient(135deg, #56ab2f 0%, #a8e6cf 100%);
    color: white;
}

.card-gradient-warning {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    color: white;
}

.card-gradient-info {
    background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
    color: white;
}
</style>
@endpush

@push('scripts')
<script>
let map;

// Initialize map when document is ready
document.addEventListener('DOMContentLoaded', function() {
    initMap();
});

function initMap() {
    // Default coordinates (Indonesia center)
    const defaultLat = -2.5489;
    const defaultLng = 118.0149;
    
    // Initialize map
    map = L.map('petaRumah').setView([defaultLat, defaultLng], 5);
    
    // Add tile layer
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors'
    }).addTo(map);
    
    // Add sample markers if we have data
    const pendudukData = @json($pendudukWithCoordinates ?? []);
    
    if (pendudukData.length > 0) {
        pendudukData.forEach(function(penduduk) {
            if (penduduk.latitude && penduduk.longitude) {
                L.marker([penduduk.latitude, penduduk.longitude])
                    .bindPopup(`
                        <div class="p-2">
                            <h6>${penduduk.nama}</h6>
                            <small>NIK: ${penduduk.nik}</small><br>
                            <small>Alamat: ${penduduk.alamat}</small><br>
                            <small>KK: ${penduduk.no_kk}</small>
                        </div>
                    `)
                    .addTo(map);
            }
        });
        
        // Auto-fit to markers
        if (pendudukData.length > 0) {
            const group = new L.featureGroup();
            pendudukData.forEach(function(penduduk) {
                if (penduduk.latitude && penduduk.longitude) {
                    group.addLayer(L.marker([penduduk.latitude, penduduk.longitude]));
                }
            });
            
            if (group.getLayers().length > 0) {
                map.fitBounds(group.getBounds().pad(0.1));
            }
        }
    }
}
</script>
@endpush 
