@extends('layouts.app')

@section('title', 'Direktori UMKM')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
<li class="breadcrumb-item active">Direktori UMKM</li>
@endsection

@section('content')
<div class="container-fluid">
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="fas fa-store text-primary me-2"></i>
                Direktori UMKM Desa
            </h1>
            <p class="text-muted mb-0">Kelola data Usaha Mikro Kecil Menengah (UMKM) desa</p>
        </div>
        <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addUmkmModal">
            <i class="fas fa-plus me-2"></i>Tambah UMKM
        </button>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total UMKM</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $umkm->total() }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-store fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                UMKM Aktif</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $umkm->where('status', 'aktif')->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Marketplace Aktif</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $umkm->where('aktif_marketplace', true)->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-shopping-cart fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Pending Verifikasi</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $umkm->where('status', 'pending_verifikasi')->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter & Pencarian</h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.umkm.index') }}">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="search">Pencarian</label>
                            <input type="text" class="form-control" id="search" name="search" 
                                   value="{{ request('search') }}" placeholder="Nama UMKM, pemilik...">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="kategori">Kategori</label>
                            <select class="form-control" id="kategori" name="kategori">
                                <option value="">Semua Kategori</option>
                                @foreach($kategoris as $key => $label)
                                    <option value="{{ $key }}" {{ request('kategori') == $key ? 'selected' : '' }}>
                                        {{ $label }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" id="status" name="status">
                                <option value="">Semua Status</option>
                                <option value="aktif" {{ request('status') == 'aktif' ? 'selected' : '' }}>Aktif</option>
                                <option value="nonaktif" {{ request('status') == 'nonaktif' ? 'selected' : '' }}>Non-aktif</option>
                                <option value="pending_verifikasi" {{ request('status') == 'pending_verifikasi' ? 'selected' : '' }}>Pending</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="verified">Verifikasi</label>
                            <select class="form-control" id="verified" name="verified">
                                <option value="">Semua</option>
                                <option value="1" {{ request('verified') == '1' ? 'selected' : '' }}>Terverifikasi</option>
                                <option value="0" {{ request('verified') == '0' ? 'selected' : '' }}>Belum Verifikasi</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div class="d-flex">
                                <button type="submit" class="btn btn-primary me-2">
                                    <i class="fas fa-search"></i> Filter
                                </button>
                                <a href="{{ route('admin.umkm.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-redo"></i> Reset
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- UMKM Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Daftar UMKM</h6>
        </div>
        <div class="card-body">
            @if($umkm->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered" id="umkmTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Logo</th>
                                <th>Nama UMKM</th>
                                <th>Kategori</th>
                                <th>Pemilik</th>
                                <th>Kontak</th>
                                <th>Status</th>
                                <th>Marketplace</th>
                                <th>Rating</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($umkm as $item)
                            <tr>
                                <td class="text-center">
                                    <img src="{{ $item->logo_url }}" alt="Logo" class="rounded-circle" 
                                         style="width: 40px; height: 40px; object-fit: cover;">
                                </td>
                                <td>
                                    <div class="d-flex flex-column">
                                        <strong>{{ $item->nama_umkm }}</strong>
                                        <small class="text-muted">{{ Str::limit($item->deskripsi, 50) }}</small>
                                        @if($item->is_verified)
                                            <span class="badge bg-success badge-sm mt-1">
                                                <i class="fas fa-check-circle"></i> Terverifikasi
                                            </span>
                                        @endif
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-info">{{ $item->kategori_label }}</span>
                                </td>
                                <td>
                                    <div class="d-flex flex-column">
                                        <strong>{{ $item->pemilik->nama ?? 'N/A' }}</strong>
                                        <small class="text-muted">{{ $item->pemilik->nik ?? 'N/A' }}</small>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex flex-column">
                                        @if($item->nomor_telepon)
                                            <small><i class="fas fa-phone"></i> {{ $item->nomor_telepon }}</small>
                                        @endif
                                        @if($item->email)
                                            <small><i class="fas fa-envelope"></i> {{ $item->email }}</small>
                                        @endif
                                        @if($item->whatsapp)
                                            <small><i class="fab fa-whatsapp"></i> {{ $item->whatsapp }}</small>
                                        @endif
                                    </div>
                                </td>
                                <td>
                                    {!! $item->status_badge !!}
                                </td>
                                <td class="text-center">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input marketplace-toggle" type="checkbox" 
                                               data-id="{{ $item->id }}" {{ $item->aktif_marketplace ? 'checked' : '' }}>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <div class="d-flex flex-column align-items-center">
                                        <div class="rating-stars">
                                            @for($i = 1; $i <= 5; $i++)
                                                <i class="fas fa-star {{ $i <= $item->rating_rata_rata ? 'text-warning' : 'text-muted' }}"></i>
                                            @endfor
                                        </div>
                                        <small class="text-muted">{{ $item->rating_rata_rata }}/5 ({{ $item->jumlah_ulasan }})</small>
                                    </div>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-sm btn-info" 
                                                onclick="viewUmkm({{ $item->id }})" title="Lihat Detail">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button type="button" class="btn btn-sm btn-warning" 
                                                onclick="editUmkm({{ $item->id }})" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        @if($item->status == 'pending_verifikasi')
                                            <button type="button" class="btn btn-sm btn-success" 
                                                    onclick="verifyUmkm({{ $item->id }})" title="Verifikasi">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        @endif
                                        <button type="button" class="btn btn-sm btn-danger" 
                                                onclick="deleteUmkm({{ $item->id }})" title="Hapus">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div>
                        Menampilkan {{ $umkm->firstItem() }} sampai {{ $umkm->lastItem() }} 
                        dari {{ $umkm->total() }} data
                    </div>
                    {{ $umkm->links() }}
                </div>
            @else
                <div class="text-center py-4">
                    <i class="fas fa-store fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">Belum ada data UMKM</h5>
                    <p class="text-muted">Klik tombol "Tambah UMKM" untuk menambahkan data pertama</p>
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Add UMKM Modal -->
<div class="modal fade" id="addUmkmModal" tabindex="-1" aria-labelledby="addUmkmModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addUmkmModalLabel">
                    <i class="fas fa-plus me-2"></i>Tambah UMKM Baru
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="addUmkmForm" action="{{ route('admin.umkm.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <!-- Basic Information -->
                        <div class="col-md-6">
                            <h6 class="text-primary mb-3">Informasi Dasar</h6>
                            
                            <div class="mb-3">
                                <label for="nama_umkm" class="form-label">Nama UMKM <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="nama_umkm" name="nama_umkm" required>
                            </div>

                            <div class="mb-3">
                                <label for="kategori" class="form-label">Kategori <span class="text-danger">*</span></label>
                                <select class="form-control" id="kategori" name="kategori" required>
                                    <option value="">Pilih Kategori</option>
                                    @foreach($kategoris as $key => $label)
                                        <option value="{{ $key }}">{{ $label }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="mb-3">
                                <label for="pemilik_id" class="form-label">Pemilik <span class="text-danger">*</span></label>
                                <select class="form-control" id="pemilik_id" name="pemilik_id" required>
                                    <option value="">Pilih Pemilik</option>
                                    @foreach($penduduk as $p)
                                        <option value="{{ $p->id }}">{{ $p->nama }} ({{ $p->nik }})</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="mb-3">
                                <label for="skala_usaha" class="form-label">Skala Usaha <span class="text-danger">*</span></label>
                                <select class="form-control" id="skala_usaha" name="skala_usaha" required>
                                    <option value="">Pilih Skala</option>
                                    <option value="mikro">Mikro</option>
                                    <option value="kecil">Kecil</option>
                                    <option value="menengah">Menengah</option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label for="deskripsi" class="form-label">Deskripsi <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="deskripsi" name="deskripsi" rows="4" required></textarea>
                            </div>
                        </div>

                        <!-- Contact & Location -->
                        <div class="col-md-6">
                            <h6 class="text-primary mb-3">Kontak & Lokasi</h6>
                            
                            <div class="mb-3">
                                <label for="alamat" class="form-label">Alamat <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="alamat" name="alamat" rows="3" required></textarea>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="nomor_telepon" class="form-label">Nomor Telepon</label>
                                        <input type="text" class="form-control" id="nomor_telepon" name="nomor_telepon">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="whatsapp" class="form-label">WhatsApp</label>
                                        <input type="text" class="form-control" id="whatsapp" name="whatsapp">
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" id="email" name="email">
                            </div>

                            <div class="mb-3">
                                <label for="website" class="form-label">Website</label>
                                <input type="url" class="form-control" id="website" name="website">
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="latitude" class="form-label">Latitude</label>
                                        <input type="number" step="any" class="form-control" id="latitude" name="latitude">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label for="longitude" class="form-label">Longitude</label>
                                        <input type="number" step="any" class="form-control" id="longitude" name="longitude">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Media Upload -->
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <h6 class="text-primary mb-3">Media</h6>
                            
                            <div class="mb-3">
                                <label for="logo" class="form-label">Logo UMKM</label>
                                <input type="file" class="form-control" id="logo" name="logo" accept="image/*">
                                <small class="text-muted">Format: JPG, PNG. Maksimal 2MB</small>
                            </div>

                            <div class="mb-3">
                                <label for="galeri_foto" class="form-label">Galeri Foto</label>
                                <input type="file" class="form-control" id="galeri_foto" name="galeri_foto[]" 
                                       accept="image/*" multiple>
                                <small class="text-muted">Bisa pilih beberapa foto sekaligus</small>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <h6 class="text-primary mb-3">Pengaturan</h6>
                            
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="aktif_marketplace" 
                                           name="aktif_marketplace" value="1">
                                    <label class="form-check-label" for="aktif_marketplace">
                                        Aktifkan di Marketplace
                                    </label>
                                </div>
                            </div>

                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="bisa_cod" 
                                           name="bisa_cod" value="1" checked>
                                    <label class="form-check-label" for="bisa_cod">
                                        Terima COD (Cash on Delivery)
                                    </label>
                                </div>
                            </div>

                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="bisa_transfer" 
                                           name="bisa_transfer" value="1" checked>
                                    <label class="form-check-label" for="bisa_transfer">
                                        Terima Transfer
                                    </label>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="tags" class="form-label">Tags</label>
                                <input type="text" class="form-control" id="tags" name="tags" 
                                       placeholder="organik, halal, handmade (pisahkan dengan koma)">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-2"></i>Simpan UMKM
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#umkmTable').DataTable({
        "paging": false,
        "searching": false,
        "ordering": true,
        "info": false,
        "responsive": true,
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json"
        }
    });

    // Marketplace toggle
    $('.marketplace-toggle').change(function() {
        const umkmId = $(this).data('id');
        const isChecked = $(this).is(':checked');
        
        $.ajax({
            url: `/admin/umkm/${umkmId}/toggle-marketplace`,
            method: 'PUT',
            data: {
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil!',
                        text: response.message,
                        timer: 2000,
                        showConfirmButton: false
                    });
                }
            },
            error: function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Terjadi kesalahan!'
                });
                // Revert checkbox
                $(this).prop('checked', !isChecked);
            }
        });
    });
});

function viewUmkm(id) {
    window.location.href = `/admin/umkm/${id}`;
}

function editUmkm(id) {
    window.location.href = `/admin/umkm/${id}/edit`;
}

function verifyUmkm(id) {
    Swal.fire({
        title: 'Verifikasi UMKM',
        html: `
            <div class="mb-3">
                <label for="status" class="form-label">Status</label>
                <select class="form-control" id="verify-status">
                    <option value="aktif">Aktif</option>
                    <option value="nonaktif">Non-aktif</option>
                </select>
            </div>
            <div class="mb-3">
                <label for="catatan" class="form-label">Catatan Verifikasi</label>
                <textarea class="form-control" id="verify-catatan" rows="3"></textarea>
            </div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Verifikasi',
        cancelButtonText: 'Batal',
        preConfirm: () => {
            const status = document.getElementById('verify-status').value;
            const catatan = document.getElementById('verify-catatan').value;
            
            return { status, catatan };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `/admin/umkm/${id}/verify`,
                method: 'PUT',
                data: {
                    _token: '{{ csrf_token() }}',
                    status: result.value.status,
                    catatan_verifikasi: result.value.catatan
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message
                        }).then(() => {
                            location.reload();
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Terjadi kesalahan!'
                    });
                }
            });
        }
    });
}

function deleteUmkm(id) {
    Swal.fire({
        title: 'Apakah Anda yakin?',
        text: "Data UMKM akan dihapus permanen!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Ya, hapus!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `/admin/umkm/${id}`;
            form.innerHTML = `
                @csrf
                @method('DELETE')
            `;
            document.body.appendChild(form);
            form.submit();
        }
    });
}
</script>
@endpush 
