@extends('layouts.app')

@section('title', 'Edit Wilayah Administratif')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.wilayah-administratif.index') }}">Wilayah Administratif</a></li>
<li class="breadcrumb-item active">Edit Wilayah</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title mb-0">
                        <i class="fas fa-edit text-warning me-2"></i>
                        Edit Wilayah Administratif
                    </h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.wilayah-administratif.update', $wilayah->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Kode Wilayah <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('kode_wilayah') is-invalid @enderror" 
                                           name="kode_wilayah" value="{{ old('kode_wilayah', $wilayah->kode_wilayah) }}" 
                                           required placeholder="Contoh: D001, RW01, RT001">
                                    @error('kode_wilayah')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Nama Wilayah <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('nama_wilayah') is-invalid @enderror" 
                                           name="nama_wilayah" value="{{ old('nama_wilayah', $wilayah->nama_wilayah) }}" 
                                           required placeholder="Contoh: Dusun Maju, RW 01, RT 001">
                                    @error('nama_wilayah')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Tipe Wilayah <span class="text-danger">*</span></label>
                                    <select class="form-select @error('jenis_wilayah') is-invalid @enderror" 
                                            name="jenis_wilayah" required>
                                        <option value="">Pilih Tipe Wilayah</option>
                                        <option value="dusun" {{ old('jenis_wilayah', $wilayah->jenis_wilayah) == 'dusun' ? 'selected' : '' }}>Dusun</option>
                                        <option value="rw" {{ old('jenis_wilayah', $wilayah->jenis_wilayah) == 'rw' ? 'selected' : '' }}>RW</option>
                                        <option value="rt" {{ old('jenis_wilayah', $wilayah->jenis_wilayah) == 'rt' ? 'selected' : '' }}>RT</option>
                                    </select>
                                    @error('jenis_wilayah')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Induk Wilayah</label>
                                    <select class="form-select @error('parent_id') is-invalid @enderror" name="parent_id">
                                        <option value="">Pilih Induk Wilayah</option>
                                        @foreach($dusunList ?? [] as $dusun)
                                            <option value="{{ $dusun->id }}" {{ old('parent_id', $wilayah->parent_id) == $dusun->id ? 'selected' : '' }}>
                                                {{ $dusun->nama_wilayah }}
                                            </option>
                                        @endforeach
                                        @foreach($rwList ?? [] as $rw)
                                            <option value="{{ $rw->id }}" {{ old('parent_id', $wilayah->parent_id) == $rw->id ? 'selected' : '' }}>
                                                {{ $rw->nama_wilayah }} ({{ $rw->parent->nama_wilayah ?? '' }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('parent_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Nama Kepala Wilayah</label>
                                    <input type="text" class="form-control @error('kepala_wilayah') is-invalid @enderror" 
                                           name="kepala_wilayah" value="{{ old('kepala_wilayah', $wilayah->kepala_wilayah) }}" 
                                           placeholder="Nama Kepala RT/RW/Dusun">
                                    @error('kepala_wilayah')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Nomor HP Kepala</label>
                                    <input type="text" class="form-control @error('nomor_hp_kepala') is-invalid @enderror" 
                                           name="nomor_hp_kepala" value="{{ old('nomor_hp_kepala', $wilayah->nomor_hp_kepala) }}" 
                                           placeholder="08xxxxxxxxxx">
                                    @error('nomor_hp_kepala')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label">Jumlah KK</label>
                                    <input type="number" class="form-control @error('jumlah_kk') is-invalid @enderror" 
                                           name="jumlah_kk" value="{{ old('jumlah_kk', $wilayah->jumlah_kk ?? 0) }}" min="0">
                                    @error('jumlah_kk')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label">Jumlah Penduduk</label>
                                    <input type="number" class="form-control @error('jumlah_penduduk') is-invalid @enderror" 
                                           name="jumlah_penduduk" value="{{ old('jumlah_penduduk', $wilayah->jumlah_penduduk ?? 0) }}" min="0">
                                    @error('jumlah_penduduk')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label class="form-label">Luas Wilayah (Ha)</label>
                                    <input type="number" step="0.01" class="form-control @error('luas_wilayah') is-invalid @enderror" 
                                           name="luas_wilayah" value="{{ old('luas_wilayah', $wilayah->luas_wilayah) }}" 
                                           placeholder="0.00" min="0">
                                    @error('luas_wilayah')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Batas Wilayah</label>
                                    <textarea class="form-control @error('batas_wilayah') is-invalid @enderror" 
                                              name="batas_wilayah" rows="3" 
                                              placeholder="Utara: ..., Selatan: ..., Timur: ..., Barat: ...">{{ old('batas_wilayah', $wilayah->batas_wilayah) }}</textarea>
                                    @error('batas_wilayah')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Status</label>
                                    <select class="form-select @error('status') is-invalid @enderror" name="status" required>
                                        <option value="aktif" {{ old('status', $wilayah->status ?? 'aktif') == 'aktif' ? 'selected' : '' }}>Aktif</option>
                                        <option value="nonaktif" {{ old('status', $wilayah->status) == 'nonaktif' ? 'selected' : '' }}>Non Aktif</option>
                                    </select>
                                    @error('status')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="d-flex justify-content-between">
                            <a href="{{ route('admin.wilayah-administratif.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-1"></i>
                                Kembali
                            </a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i>
                                Update Data
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 