<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Informasi Demografi Warga - Portal Desa</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        .mobile-card {
            background: white;
            border-radius: 16px;
            padding: 16px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border: 1px solid #f1f5f9;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #f97316 0%, #ea580c 100%);
        }
        
        .stat-card {
            background: white;
            border-radius: 12px;
            padding: 12px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
            border: 1px solid #f1f5f9;
        }
        
        .education-progress {
            animation: fillProgress 1.5s ease-out forwards;
            transform-origin: left;
        }
        
        @keyframes fillProgress {
            from {
                transform: scaleX(0);
            }
            to {
                transform: scaleX(1);
            }
        }
        
        .education-item {
            animation: slideInUp 0.6s ease-out forwards;
            opacity: 0;
            transform: translateY(20px);
        }
        
        @keyframes slideInUp {
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .education-item:nth-child(1) { animation-delay: 0.1s; }
        .education-item:nth-child(2) { animation-delay: 0.2s; }
        .education-item:nth-child(3) { animation-delay: 0.3s; }
        .education-item:nth-child(4) { animation-delay: 0.4s; }
        .education-item:nth-child(5) { animation-delay: 0.5s; }
        
        .age-summary-card {
            animation: slideInUp 0.6s ease-out forwards;
            opacity: 0;
            transform: translateY(20px);
        }
        
        .age-detail-item {
            animation: slideInUp 0.6s ease-out forwards;
            opacity: 0;
            transform: translateY(20px);
        }
        
        .age-progress {
            animation: fillProgress 1.8s ease-out forwards;
            transform-origin: left;
        }
        
        @keyframes shimmer {
            0% {
                transform: translateX(-100%);
            }
            100% {
                transform: translateX(100%);
            }
        }
        
        .animate-shimmer {
            animation: shimmer 2s infinite;
        }
        
        /* Fix for age progress bars */
        .age-progress {
            transition: all 0.3s ease;
        }
        
        .age-progress:hover {
            transform: scaleY(1.1);
        }
        
        .job-summary-card {
            animation: slideInUp 0.6s ease-out forwards;
            opacity: 0;
            transform: translateY(20px);
        }
        
        .job-detail-item {
            animation: slideInUp 0.6s ease-out forwards;
            opacity: 0;
            transform: translateY(20px);
        }
        
        .job-progress {
            animation: fillProgress 1.8s ease-out forwards;
            transform-origin: left;
            transition: all 0.3s ease;
        }
        
        .job-progress:hover {
            transform: scaleY(1.1);
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        <!-- Header -->
        <div class="gradient-bg px-6 py-8 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 right-0 w-32 h-32 bg-white rounded-full translate-x-16 -translate-y-16"></div>
                <div class="absolute bottom-0 left-0 w-24 h-24 bg-white rounded-full -translate-x-12 translate-y-12"></div>
            </div>
            
            <div class="relative z-10">
                <!-- Back Button -->
                <div class="flex items-center mb-6">
                    <button onclick="history.back()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center mr-4">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z"/>
                        </svg>
                    </button>
                    <div>
                        <h1 class="text-xl font-bold text-white">Demografi Warga</h1>
                        <p class="text-white/80 text-sm">Informasi Kependudukan</p>
                    </div>
                </div>

                <!-- Summary Stats -->
                <div class="grid grid-cols-2 gap-3">
                    <div class="bg-white/20 rounded-xl p-3 text-center">
                        <div class="text-2xl font-bold text-white"><?= $data['totalPenduduk'] ?? 0 ?></div>
                        <div class="text-white/80 text-xs">Total Penduduk</div>
                    </div>
                    <div class="bg-white/20 rounded-xl p-3 text-center">
                        <div class="text-2xl font-bold text-white"><?= $data['totalKeluarga'] ?? 0 ?></div>
                        <div class="text-white/80 text-xs">Kepala Keluarga</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistik Detail -->
        <div class="px-6 -mt-4 relative z-20 mb-6">
            <div class="mobile-card">
                <h3 class="text-sm font-semibold text-gray-800 mb-4">Statistik Berdasarkan Jenis Kelamin</h3>
                
                <!-- Gender Chart Container -->
                <div class="mb-4" style="height: 200px;">
                    <canvas id="genderChart"></canvas>
                </div>
                
                <!-- Gender Stats -->
                <div class="grid grid-cols-2 gap-3">
                    <div class="stat-card text-center">
                        <div class="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-mars text-blue-600 text-sm"></i>
                        </div>
                        <div class="text-lg font-bold text-gray-800"><?= $data['lakiLaki'] ?? 0 ?></div>
                        <div class="text-xs text-gray-500">Laki-laki</div>
                    </div>
                    <div class="stat-card text-center">
                        <div class="w-8 h-8 bg-pink-100 rounded-full flex items-center justify-center mx-auto mb-2">
                            <i class="fas fa-venus text-pink-600 text-sm"></i>
                        </div>
                        <div class="text-lg font-bold text-gray-800"><?= $data['perempuan'] ?? 0 ?></div>
                        <div class="text-xs text-gray-500">Perempuan</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistik Usia -->
        <div class="px-6 mb-6">
            <div class="mobile-card">
                <div class="flex items-center justify-between mb-4">
                    <div>
                        <h3 class="text-sm font-semibold text-gray-800">Distribusi Usia</h3>
                        <p class="text-xs text-gray-500">Kategori usia penduduk</p>
                    </div>
                    <div class="text-right">
                        <div class="text-lg font-bold text-indigo-600"><?= ($data['anak'] ?? 0) + ($data['dewasa'] ?? 0) + ($data['lansia'] ?? 0) ?></div>
                        <div class="text-xs text-gray-500">Total Warga</div>
                    </div>
                </div>

                <!-- Age Summary Cards -->
                <?php 
                $totalAgeData = ($data['anak'] ?? 0) + ($data['dewasa'] ?? 0) + ($data['lansia'] ?? 0);
                $ageGroups = [
                    ['name' => 'Anak', 'count' => $data['anak'] ?? 0, 'range' => '0-17 tahun', 'color' => 'green', 'icon' => 'fa-child'],
                    ['name' => 'Dewasa', 'count' => $data['dewasa'] ?? 0, 'range' => '18-59 tahun', 'color' => 'blue', 'icon' => 'fa-user'],
                    ['name' => 'Lansia', 'count' => $data['lansia'] ?? 0, 'range' => '60+ tahun', 'color' => 'orange', 'icon' => 'fa-user-friends']
                ];
                
                // Sort by count for ranking
                usort($ageGroups, function($a, $b) {
                    return $b['count'] - $a['count'];
                });
                ?>
                
                <div class="grid grid-cols-3 gap-2 mb-4">
                    <?php foreach ($ageGroups as $index => $group): ?>
                        <?php $percentage = $totalAgeData > 0 ? round(($group['count'] / $totalAgeData) * 100, 1) : 0; ?>
                        <div class="bg-gradient-to-br from-<?= $group['color'] ?>-50 to-<?= $group['color'] ?>-100 p-3 rounded-lg border border-<?= $group['color'] ?>-200 relative age-summary-card" style="animation-delay: <?= $index * 0.1 ?>s;">
                            <?php if ($index == 0 && $group['count'] > 0): ?>
                                <div class="absolute -top-1 -right-1 w-4 h-4 bg-gradient-to-r from-yellow-400 to-yellow-600 rounded-full flex items-center justify-center">
                                    <i class="fas fa-crown text-white" style="font-size: 8px;"></i>
                                </div>
                            <?php endif; ?>
                            <div class="text-center">
                                <div class="w-8 h-8 bg-<?= $group['color'] ?>-200 rounded-full flex items-center justify-center mx-auto mb-2">
                                    <i class="fas <?= $group['icon'] ?> text-<?= $group['color'] ?>-600 text-xs"></i>
                                </div>
                                <div class="text-lg font-bold text-<?= $group['color'] ?>-800"><?= $group['count'] ?></div>
                                <div class="text-xs font-medium text-<?= $group['color'] ?>-700"><?= $group['name'] ?></div>
                                <div class="text-xs text-<?= $group['color'] ?>-600"><?= $percentage ?>%</div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                
                <!-- Age Chart Container -->
                <div class="mb-4" style="height: 200px;">
                    <canvas id="ageChart"></canvas>
                </div>
                
                <!-- Detailed Age Groups with Progress Bars -->
                <div class="space-y-3">
                    <?php 
                    // Reset to original order for detailed view
                    $detailedAgeGroups = [
                        ['name' => 'Anak-anak', 'count' => $data['anak'] ?? 0, 'range' => '0-17 tahun', 'color' => 'green', 'icon' => 'fa-child', 'description' => 'Masa pertumbuhan dan pendidikan'],
                        ['name' => 'Dewasa', 'count' => $data['dewasa'] ?? 0, 'range' => '18-59 tahun', 'color' => 'blue', 'icon' => 'fa-user', 'description' => 'Usia produktif dan bekerja'],
                        ['name' => 'Lansia', 'count' => $data['lansia'] ?? 0, 'range' => '60+ tahun', 'color' => 'orange', 'icon' => 'fa-user-friends', 'description' => 'Masa pensiun dan istirahat']
                    ];
                    ?>
                    
                    <?php foreach ($detailedAgeGroups as $index => $group): ?>
                        <?php $percentage = $totalAgeData > 0 ? round(($group['count'] / $totalAgeData) * 100, 1) : 0; ?>
                        <div class="age-detail-item relative" style="animation-delay: <?= ($index + 1) * 0.2 ?>s;">
                            <div class="flex items-center justify-between mb-3">
                                <div class="flex items-center space-x-3">
                                    <div class="relative">
                                        <div class="w-10 h-10 bg-<?= $group['color'] ?>-100 rounded-full flex items-center justify-center transform hover:scale-110 transition-transform duration-200">
                                            <i class="fas <?= $group['icon'] ?> text-<?= $group['color'] ?>-600 text-sm"></i>
                                        </div>
                                        <div class="absolute -bottom-1 -right-1 w-4 h-4 bg-<?= $group['color'] ?>-500 rounded-full flex items-center justify-center">
                                            <span class="text-white text-xs font-bold" style="font-size: 8px;"><?= $group['count'] ?></span>
                                        </div>
                                    </div>
                                    <div>
                                        <div class="flex items-center space-x-2">
                                            <div class="text-sm font-semibold text-gray-800"><?= $group['name'] ?></div>
                                            <span class="text-xs bg-<?= $group['color'] ?>-100 text-<?= $group['color'] ?>-700 px-2 py-0.5 rounded-full font-medium"><?= $group['range'] ?></span>
                                        </div>
                                        <div class="text-xs text-gray-500"><?= $group['description'] ?></div>
                                        <div class="text-xs text-<?= $group['color'] ?>-600 font-medium"><?= $percentage ?>% dari total populasi</div>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <div class="text-lg font-bold text-gray-800"><?= $group['count'] ?></div>
                                    <div class="text-xs text-gray-500">orang</div>
                                </div>
                            </div>
                            
                            <!-- Enhanced Progress Bar -->
                            <div class="relative">
                                <div class="w-full bg-gray-200 rounded-full h-3 overflow-hidden group cursor-pointer" 
                                     title="<?= $group['name'] ?>: <?= $group['count'] ?> orang (<?= $percentage ?>%)">
                                    <div class="age-progress h-3 rounded-full group-hover:h-4 transition-all duration-300 relative overflow-hidden" 
                                         style="width: <?= $percentage ?>%; background: linear-gradient(90deg, <?= $group['color'] === 'green' ? '#10b981, #059669' : ($group['color'] === 'blue' ? '#3b82f6, #2563eb' : '#f97316, #ea580c') ?>); box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                                        <!-- Shimmer effect -->
                                        <div class="absolute inset-0 bg-gradient-to-r from-transparent via-white to-transparent opacity-30 animate-shimmer"></div>
                                    </div>
                                    
                                    <!-- Tooltip -->
                                    <div class="absolute -top-10 left-1/2 transform -translate-x-1/2 bg-gray-800 text-white text-xs px-3 py-1 rounded opacity-0 group-hover:opacity-100 transition-opacity duration-200 pointer-events-none whitespace-nowrap z-10">
                                        <?= $group['name'] ?>: <?= $percentage ?>% (<?= $group['count'] ?> orang)
                                    </div>
                                </div>
                                
                                <!-- Progress indicators -->
                                <div class="flex justify-between mt-1 text-xs text-gray-400">
                                    <span>0%</span>
                                    <span><?= $percentage ?>%</span>
                                    <span>100%</span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <!-- Age Statistics Summary -->
                <div class="mt-4 p-3 bg-gradient-to-r from-gray-50 to-gray-100 rounded-lg border border-gray-200">
                    <div class="grid grid-cols-2 gap-4 text-center">
                        <div>
                            <div class="text-xs text-gray-500 mb-1">Rasio Ketergantungan</div>
                            <?php 
                            $dependencyRatio = $totalAgeData > 0 && ($data['dewasa'] ?? 0) > 0 ? 
                                round((($data['anak'] ?? 0) + ($data['lansia'] ?? 0)) / ($data['dewasa'] ?? 0) * 100, 1) : 0;
                            ?>
                            <div class="text-sm font-bold text-gray-800"><?= $dependencyRatio ?>%</div>
                        </div>
                        <div>
                            <div class="text-xs text-gray-500 mb-1">Usia Median</div>
                            <?php 
                            // Estimasi usia median berdasarkan distribusi
                            $medianAge = 'N/A';
                            if ($totalAgeData > 0) {
                                if (($data['dewasa'] ?? 0) > ($data['anak'] ?? 0) && ($data['dewasa'] ?? 0) > ($data['lansia'] ?? 0)) {
                                    $medianAge = '35 tahun';
                                } elseif (($data['anak'] ?? 0) > ($data['dewasa'] ?? 0)) {
                                    $medianAge = '15 tahun';
                                } else {
                                    $medianAge = '45 tahun';
                                }
                            }
                            ?>
                            <div class="text-sm font-bold text-gray-800"><?= $medianAge ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Statistik Pendidikan -->
        <div class="px-6 mb-6">
            <div class="mobile-card">
                <div class="flex items-center justify-between mb-4">
                    <div>
                        <h3 class="text-sm font-semibold text-gray-800">Tingkat Pendidikan</h3>
                        <p class="text-xs text-gray-500">Distribusi pendidikan warga</p>
                    </div>
                    <div class="text-right">
                        <div class="text-lg font-bold text-blue-600"><?= isset($data['pendidikan']) ? array_sum($data['pendidikan']) : 0 ?></div>
                        <div class="text-xs text-gray-500">Total Data</div>
                    </div>
                </div>
                
                <!-- Education Summary Cards -->
                <?php if (isset($data['pendidikan']) && count($data['pendidikan']) > 0): ?>
                    <?php 
                    $maxEducation = array_keys($data['pendidikan'], max($data['pendidikan']))[0];
                    $minEducation = array_keys($data['pendidikan'], min($data['pendidikan']))[0];
                    ?>
                    <div class="grid grid-cols-2 gap-3 mb-4">
                        <div class="bg-gradient-to-r from-green-50 to-green-100 p-3 rounded-lg border border-green-200">
                            <div class="text-xs text-green-600 font-medium mb-1">Terbanyak</div>
                            <div class="text-sm font-bold text-green-800"><?= ucfirst($maxEducation) ?></div>
                            <div class="text-xs text-green-600"><?= max($data['pendidikan']) ?> orang</div>
                        </div>
                        <div class="bg-gradient-to-r from-blue-50 to-blue-100 p-3 rounded-lg border border-blue-200">
                            <div class="text-xs text-blue-600 font-medium mb-1">Tersedikit</div>
                            <div class="text-sm font-bold text-blue-800"><?= ucfirst($minEducation) ?></div>
                            <div class="text-xs text-blue-600"><?= min($data['pendidikan']) ?> orang</div>
                        </div>
                    </div>
                <?php endif; ?>
                
                <!-- Education Chart Container -->
                <div class="mb-4" style="height: 200px;">
                    <canvas id="educationChart"></canvas>
                </div>
                
                <div class="space-y-3">
                    <?php if (isset($data['pendidikan']) && count($data['pendidikan']) > 0): ?>
                        <?php 
                        // Enhanced education colors with better mapping
                        $educationColors = [
                            // Exact matches
                            'SD' => ['bg' => 'bg-red-100', 'text' => 'text-red-600', 'icon' => 'fa-pencil-alt', 'gradient' => '#ef4444, #dc2626'],
                            'SMP' => ['bg' => 'bg-orange-100', 'text' => 'text-orange-600', 'icon' => 'fa-book', 'gradient' => '#f97316, #ea580c'],
                            'SMA' => ['bg' => 'bg-emerald-100', 'text' => 'text-emerald-600', 'icon' => 'fa-user-graduate', 'gradient' => '#10b981, #059669'],
                            'SMK' => ['bg' => 'bg-sky-100', 'text' => 'text-sky-600', 'icon' => 'fa-tools', 'gradient' => '#0ea5e9, #0284c7'],
                            'D1' => ['bg' => 'bg-violet-100', 'text' => 'text-violet-600', 'icon' => 'fa-certificate', 'gradient' => '#8b5cf6, #7c3aed'],
                            'D2' => ['bg' => 'bg-purple-100', 'text' => 'text-purple-600', 'icon' => 'fa-medal', 'gradient' => '#a855f7, #9333ea'],
                            'D3' => ['bg' => 'bg-fuchsia-100', 'text' => 'text-fuchsia-600', 'icon' => 'fa-star', 'gradient' => '#d946ef, #c026d3'],
                            'S1' => ['bg' => 'bg-indigo-100', 'text' => 'text-indigo-600', 'icon' => 'fa-university', 'gradient' => '#6366f1, #4f46e5'],
                            'S2' => ['bg' => 'bg-rose-100', 'text' => 'text-rose-600', 'icon' => 'fa-graduation-cap', 'gradient' => '#f43f5e, #e11d48'],
                            'S3' => ['bg' => 'bg-amber-100', 'text' => 'text-amber-600', 'icon' => 'fa-crown', 'gradient' => '#f59e0b, #d97706'],
                            // Variations
                            'SD/SEDERAJAT' => ['bg' => 'bg-red-100', 'text' => 'text-red-600', 'icon' => 'fa-pencil-alt', 'gradient' => '#ef4444, #dc2626'],
                            'SMP/SEDERAJAT' => ['bg' => 'bg-orange-100', 'text' => 'text-orange-600', 'icon' => 'fa-book', 'gradient' => '#f97316, #ea580c'],
                            'SMA/SEDERAJAT' => ['bg' => 'bg-emerald-100', 'text' => 'text-emerald-600', 'icon' => 'fa-user-graduate', 'gradient' => '#10b981, #059669'],
                            'SMK/SEDERAJAT' => ['bg' => 'bg-sky-100', 'text' => 'text-sky-600', 'icon' => 'fa-tools', 'gradient' => '#0ea5e9, #0284c7'],
                            'DIPLOMA' => ['bg' => 'bg-violet-100', 'text' => 'text-violet-600', 'icon' => 'fa-certificate', 'gradient' => '#8b5cf6, #7c3aed'],
                            'SARJANA' => ['bg' => 'bg-indigo-100', 'text' => 'text-indigo-600', 'icon' => 'fa-university', 'gradient' => '#6366f1, #4f46e5'],
                            'MAGISTER' => ['bg' => 'bg-rose-100', 'text' => 'text-rose-600', 'icon' => 'fa-graduation-cap', 'gradient' => '#f43f5e, #e11d48'],
                            'DOKTOR' => ['bg' => 'bg-amber-100', 'text' => 'text-amber-600', 'icon' => 'fa-crown', 'gradient' => '#f59e0b, #d97706']
                        ];
                        $totalPenduduk = array_sum($data['pendidikan']);
                        
                        // Sort education data by count (descending) to show ranking
                        $sortedEducation = $data['pendidikan'];
                        arsort($sortedEducation);
                        $rank = 1;
                        
                        // Debug: Show education data keys for testing
                        // echo "<!-- DEBUG: Education data keys: " . implode(', ', array_keys($data['pendidikan'])) . " -->";
                        ?>
                        <?php 
                        // Create a color array based on rank for consistent coloring
                        $rankColors = [
                            1 => ['bg' => '#fef2f2', 'text' => '#dc2626', 'icon' => 'fa-crown', 'gradient' => '#ef4444, #dc2626'],
                            2 => ['bg' => '#fff7ed', 'text' => '#ea580c', 'icon' => 'fa-medal', 'gradient' => '#f97316, #ea580c'],
                            3 => ['bg' => '#ecfdf5', 'text' => '#059669', 'icon' => 'fa-award', 'gradient' => '#10b981, #059669'],
                            4 => ['bg' => '#f0f9ff', 'text' => '#0284c7', 'icon' => 'fa-star', 'gradient' => '#0ea5e9, #0284c7'],
                            5 => ['bg' => '#f5f3ff', 'text' => '#7c3aed', 'icon' => 'fa-certificate', 'gradient' => '#8b5cf6, #7c3aed'],
                            6 => ['bg' => '#faf5ff', 'text' => '#9333ea', 'icon' => 'fa-graduation-cap', 'gradient' => '#a855f7, #9333ea'],
                            7 => ['bg' => '#fdf4ff', 'text' => '#c026d3', 'icon' => 'fa-university', 'gradient' => '#d946ef, #c026d3'],
                            8 => ['bg' => '#eef2ff', 'text' => '#4f46e5', 'icon' => 'fa-book', 'gradient' => '#6366f1, #4f46e5'],
                            9 => ['bg' => '#fff1f2', 'text' => '#e11d48', 'icon' => 'fa-pencil-alt', 'gradient' => '#f43f5e, #e11d48'],
                            10 => ['bg' => '#fffbeb', 'text' => '#d97706', 'icon' => 'fa-tools', 'gradient' => '#f59e0b, #d97706']
                        ];
                        
                        // Debug: Add comment to show which rank is being used
                        // echo "<!-- Education rank colors applied -->";
                        ?>
                        
                        <?php foreach ($sortedEducation as $tingkat => $jumlah): ?>
                            <?php 
                            // Use rank-based coloring for guaranteed different colors
                            $colors = $rankColors[$rank] ?? ['bg' => '#f9fafb', 'text' => '#6b7280', 'icon' => 'fa-graduation-cap', 'gradient' => '#6b7280, #4b5563'];
                            $percentage = $totalPenduduk > 0 ? round(($jumlah / $totalPenduduk) * 100, 1) : 0;
                            ?>
                            <div class="relative education-item">
                                <div class="flex items-center justify-between mb-2">
                                    <div class="flex items-center space-x-3">
                                        <!-- Ranking Badge -->
                                        <div class="relative">
                                            <div class="w-8 h-8 rounded-full flex items-center justify-center transform hover:scale-110 transition-transform duration-200" 
                                                 style="background-color: <?= $colors['bg'] ?>;">
                                                <i class="fas <?= $colors['icon'] ?> text-xs" 
                                                   style="color: <?= $colors['text'] ?>;"></i>
                                            </div>
                                            <?php if ($rank <= 3): ?>
                                                <div class="absolute -top-1 -right-1 w-4 h-4 bg-gradient-to-r <?= $rank == 1 ? 'from-yellow-400 to-yellow-600' : ($rank == 2 ? 'from-gray-300 to-gray-500' : 'from-amber-600 to-amber-800') ?> rounded-full flex items-center justify-center">
                                                    <span class="text-white text-xs font-bold" style="font-size: 8px;"><?= $rank ?></span>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div>
                                            <div class="flex items-center space-x-2">
                                                <div class="text-xs font-semibold text-gray-800"><?= ucfirst($tingkat) ?></div>
                                                <?php if ($rank == 1): ?>
                                                    <span class="text-xs bg-yellow-100 text-yellow-800 px-1 py-0.5 rounded font-medium">Terbanyak</span>
                                                <?php endif; ?>
                                            </div>
                                            <div class="text-xs text-gray-500"><?= $percentage ?>% dari total</div>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <div class="text-sm font-bold text-gray-800"><?= $jumlah ?></div>
                                        <div class="text-xs text-gray-500">orang</div>
                                    </div>
                                </div>
                                
                                <!-- Enhanced Progress Bar -->
                                <div class="w-full bg-gray-200 rounded-full h-3 overflow-hidden relative group cursor-pointer" 
                                     title="<?= ucfirst($tingkat) ?>: <?= $jumlah ?> orang (<?= $percentage ?>%)">
                                    <div class="education-progress h-3 rounded-full group-hover:h-4 transition-all duration-300 relative overflow-hidden" 
                                         style="width: <?= $percentage ?>%; background: linear-gradient(90deg, <?= $colors['gradient'] ?>); box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                                        <!-- Shimmer effect -->
                                        <div class="absolute inset-0 bg-gradient-to-r from-transparent via-white to-transparent opacity-30 animate-shimmer"></div>
                                    </div>
                                    
                                    <!-- Tooltip -->
                                    <div class="absolute -top-10 left-1/2 transform -translate-x-1/2 bg-gray-800 text-white text-xs px-3 py-1 rounded opacity-0 group-hover:opacity-100 transition-opacity duration-200 pointer-events-none whitespace-nowrap z-10">
                                        <?= ucfirst($tingkat) ?>: <?= $percentage ?>% (<?= $jumlah ?> orang)
                                    </div>
                                    
                                    <!-- Progress indicators -->
                                    <div class="flex justify-between mt-1 text-xs text-gray-400">
                                        <span>0%</span>
                                        <span><?= $percentage ?>%</span>
                                        <span>100%</span>
                                    </div>
                                </div>
                            </div>
                            <?php $rank++; ?>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="text-center py-8">
                            <div class="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i class="fas fa-graduation-cap text-gray-400 text-xl"></i>
                            </div>
                            <div class="text-gray-500 text-sm">Belum ada data pendidikan</div>
                            <div class="text-gray-400 text-xs mt-1">Data akan muncul setelah ada input</div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Statistik Pekerjaan -->
        <div class="px-6 mb-6">
            <div class="mobile-card">
                <div class="flex items-center justify-between mb-4">
                    <div>
                        <h3 class="text-sm font-semibold text-gray-800">Status Pekerjaan</h3>
                        <p class="text-xs text-gray-500">Kategori mata pencaharian</p>
                    </div>
                    <div class="text-right">
                        <div class="text-lg font-bold text-purple-600"><?= ($data['bekerja'] ?? 0) + ($data['mencariKerja'] ?? 0) + ($data['pelajar'] ?? 0) + ($data['lainnya'] ?? 0) ?></div>
                        <div class="text-xs text-gray-500">Total Data</div>
                    </div>
                </div>

                <!-- Job Summary Cards -->
                <?php 
                $totalJobData = ($data['bekerja'] ?? 0) + ($data['mencariKerja'] ?? 0) + ($data['pelajar'] ?? 0) + ($data['lainnya'] ?? 0);
                $jobCategories = [
                    ['name' => 'Bekerja', 'count' => $data['bekerja'] ?? 0, 'color' => 'green', 'icon' => 'fa-briefcase', 'description' => 'Memiliki pekerjaan tetap'],
                    ['name' => 'Mencari Kerja', 'count' => $data['mencariKerja'] ?? 0, 'color' => 'yellow', 'icon' => 'fa-search', 'description' => 'Sedang mencari pekerjaan'],
                    ['name' => 'Pelajar', 'count' => $data['pelajar'] ?? 0, 'color' => 'blue', 'icon' => 'fa-graduation-cap', 'description' => 'Masih bersekolah/kuliah'],
                    ['name' => 'Lainnya', 'count' => $data['lainnya'] ?? 0, 'color' => 'gray', 'icon' => 'fa-home', 'description' => 'Kategori lainnya']
                ];
                
                // Sort by count for ranking
                usort($jobCategories, function($a, $b) {
                    return $b['count'] - $a['count'];
                });
                ?>
                
                <div class="grid grid-cols-2 gap-2 mb-4">
                    <?php foreach ($jobCategories as $index => $category): ?>
                        <?php if ($category['count'] > 0): ?>
                            <?php $percentage = $totalJobData > 0 ? round(($category['count'] / $totalJobData) * 100, 1) : 0; ?>
                            <div class="bg-gradient-to-br from-<?= $category['color'] ?>-50 to-<?= $category['color'] ?>-100 p-3 rounded-lg border border-<?= $category['color'] ?>-200 relative job-summary-card" style="animation-delay: <?= $index * 0.1 ?>s;">
                                <?php if ($index == 0): ?>
                                    <div class="absolute -top-1 -right-1 w-4 h-4 bg-gradient-to-r from-yellow-400 to-yellow-600 rounded-full flex items-center justify-center">
                                        <i class="fas fa-trophy text-white" style="font-size: 8px;"></i>
                                    </div>
                                <?php endif; ?>
                                <div class="text-center">
                                    <div class="w-8 h-8 bg-<?= $category['color'] ?>-200 rounded-full flex items-center justify-center mx-auto mb-2">
                                        <i class="fas <?= $category['icon'] ?> text-<?= $category['color'] ?>-600 text-xs"></i>
                                    </div>
                                    <div class="text-lg font-bold text-<?= $category['color'] ?>-800"><?= $category['count'] ?></div>
                                    <div class="text-xs font-medium text-<?= $category['color'] ?>-700"><?= $category['name'] ?></div>
                                    <div class="text-xs text-<?= $category['color'] ?>-600"><?= $percentage ?>%</div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
                
                <!-- Job Chart Container -->
                <div class="mb-4" style="height: 200px;">
                    <canvas id="jobChart"></canvas>
                </div>
                
                <!-- Detailed Job Categories with Progress Bars -->
                <div class="space-y-3">
                    <h4 class="text-sm font-semibold text-gray-800 mb-3 flex items-center">
                        <i class="fas fa-chart-bar text-purple-500 mr-2"></i>
                        Kategori Pekerjaan Detail
                    </h4>
                    
                    <?php foreach ($jobCategories as $index => $category): ?>
                        <?php if ($category['count'] > 0): ?>
                            <?php $percentage = $totalJobData > 0 ? round(($category['count'] / $totalJobData) * 100, 1) : 0; ?>
                            <div class="job-detail-item relative" style="animation-delay: <?= ($index + 1) * 0.1 ?>s;">
                                <div class="flex items-center justify-between mb-2">
                                    <div class="flex items-center space-x-3">
                                        <div class="relative">
                                            <div class="w-10 h-10 bg-<?= $category['color'] ?>-100 rounded-full flex items-center justify-center transform hover:scale-110 transition-transform duration-200">
                                                <i class="fas <?= $category['icon'] ?> text-<?= $category['color'] ?>-600 text-sm"></i>
                                            </div>
                                            <div class="absolute -bottom-1 -right-1 w-4 h-4 bg-<?= $category['color'] ?>-500 rounded-full flex items-center justify-center">
                                                <span class="text-white text-xs font-bold" style="font-size: 8px;"><?= $category['count'] ?></span>
                                            </div>
                                        </div>
                                        <div>
                                            <div class="text-sm font-semibold text-gray-800"><?= $category['name'] ?></div>
                                            <div class="text-xs text-gray-500"><?= $category['description'] ?></div>
                                            <div class="text-xs text-<?= $category['color'] ?>-600 font-medium"><?= $percentage ?>% dari total</div>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <div class="text-lg font-bold text-gray-800"><?= $category['count'] ?></div>
                                        <div class="text-xs text-gray-500">orang</div>
                                    </div>
                                </div>
                                
                                <!-- Enhanced Progress Bar -->
                                <div class="relative">
                                    <div class="w-full bg-gray-200 rounded-full h-3 overflow-hidden group cursor-pointer" 
                                         title="<?= $category['name'] ?>: <?= $category['count'] ?> orang (<?= $percentage ?>%)">
                                        <div class="job-progress h-3 rounded-full group-hover:h-4 transition-all duration-300 relative overflow-hidden" 
                                             style="width: <?= $percentage ?>%; background: linear-gradient(90deg, <?= $category['color'] === 'green' ? '#10b981, #059669' : ($category['color'] === 'yellow' ? '#f59e0b, #d97706' : ($category['color'] === 'blue' ? '#3b82f6, #2563eb' : '#6b7280, #4b5563')) ?>); box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                                            <!-- Shimmer effect -->
                                            <div class="absolute inset-0 bg-gradient-to-r from-transparent via-white to-transparent opacity-30 animate-shimmer"></div>
                                        </div>
                                        
                                        <!-- Tooltip -->
                                        <div class="absolute -top-10 left-1/2 transform -translate-x-1/2 bg-gray-800 text-white text-xs px-3 py-1 rounded opacity-0 group-hover:opacity-100 transition-opacity duration-200 pointer-events-none whitespace-nowrap z-10">
                                            <?= $category['name'] ?>: <?= $percentage ?>% (<?= $category['count'] ?> orang)
                                        </div>
                                    </div>
                                    
                                    <!-- Progress indicators -->
                                    <div class="flex justify-between mt-1 text-xs text-gray-400">
                                        <span>0%</span>
                                        <span><?= $percentage ?>%</span>
                                        <span>100%</span>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>

                <!-- Job Statistics Summary -->
                <div class="mt-4 p-3 bg-gradient-to-r from-purple-50 to-purple-100 rounded-lg border border-purple-200">
                    <div class="grid grid-cols-2 gap-4 text-center">
                        <div>
                            <div class="text-xs text-gray-500 mb-1">Tingkat Partisipasi</div>
                            <?php 
                            $workingCount = $data['bekerja'] ?? 0;
                            $participationRate = $totalJobData > 0 ? round(($workingCount / $totalJobData) * 100, 1) : 0;
                            ?>
                            <div class="text-sm font-bold text-gray-800"><?= $participationRate ?>%</div>
                        </div>
                        <div>
                            <div class="text-xs text-gray-500 mb-1">Status Tertinggi</div>
                            <?php 
                            $highestCategory = !empty($jobCategories) ? $jobCategories[0]['name'] : 'N/A';
                            ?>
                            <div class="text-sm font-bold text-gray-800"><?= $highestCategory ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bottom Navigation -->
        <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-200 px-6 py-4 z-50 shadow-lg">
            <div class="flex justify-around">
                <button onclick="navigateToService('/')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"/>
                    </svg>
                    <span class="text-xs">Beranda</span>
                </button>
                
                <button onclick="navigateToService('berita')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M2 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 002 2H4a2 2 0 01-2-2V5zm3 1h6v4H5V6zm6 6H5v2h6v-2z"/>
                        <path d="M15 7h1a2 2 0 012 2v5.5a1.5 1.5 0 01-3 0V7z"/>
                    </svg>
                    <span class="text-xs">Berita</span>
                </button>
                
                <button class="flex flex-col items-center space-y-1 text-orange-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z"/>
                    </svg>
                    <span class="text-xs">Demografi</span>
                </button>
                
                <button onclick="navigateToService('wisata')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z"/>
                    </svg>
                    <span class="text-xs">Wisata</span>
                </button>
                
                <button onclick="navigateToService('layanan-mandiri')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M3 3a1 1 0 011 1v12a1 1 0 11-2 0V4a1 1 0 011-1zm7.707 3.293a1 1 0 010 1.414L9.414 9H17a1 1 0 110 2H9.414l1.293 1.293a1 1 0 01-1.414 1.414l-3-3a1 1 0 010-1.414l3-3a1 1 0 011.414 0z"/>
                    </svg>
                    <span class="text-xs">Portal</span>
                </button>
            </div>
        </div>
        
        <!-- Spacer for bottom navigation -->
        <div class="h-24"></div>
    </div>

    <script>
        // Navigation function
        function navigateToService(serviceType) {
            console.log('Navigating to:', serviceType);
            
            switch(serviceType) {
                case '/':
                case 'home':
                case 'beranda':
                    window.location.href = '/';
                    break;
                case 'berita':
                    window.location.href = '/berita';
                    break;
                case 'wisata':
                    window.location.href = '/wisata';
                    break;
                case 'umkm':
                    window.location.href = '/produk-umkm';
                    break;
                case 'layanan-mandiri':
                    window.location.href = '/layanan-mandiri';
                    break;
                case 'demografi':
                    window.location.href = '/demografi';
                    break;
                default:
                    console.log('Unknown service type:', serviceType);
                    window.location.href = '/';
            }
        }

        // Chart initialization
        document.addEventListener('DOMContentLoaded', function() {
            initializeCharts();
        });

        function initializeCharts() {
            // Data dari PHP
            const data = <?= json_encode($data) ?>;
            
            // Gender Chart
            const genderCtx = document.getElementById('genderChart').getContext('2d');
            new Chart(genderCtx, {
                type: 'doughnut',
                data: {
                    labels: ['Laki-laki', 'Perempuan'],
                    datasets: [{
                        data: [data.lakiLaki, data.perempuan],
                        backgroundColor: ['#3B82F6', '#EC4899'],
                        borderWidth: 0
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                font: {
                                    size: 10
                                }
                            }
                        }
                    }
                }
            });

            // Age Chart - Enhanced with gradient and animations
            const ageCtx = document.getElementById('ageChart').getContext('2d');
            
            // Create gradients
            const gradientGreen = ageCtx.createLinearGradient(0, 0, 0, 400);
            gradientGreen.addColorStop(0, '#10B981');
            gradientGreen.addColorStop(1, 'rgba(16, 185, 129, 0.1)');
            
            const gradientBlue = ageCtx.createLinearGradient(0, 0, 0, 400);
            gradientBlue.addColorStop(0, '#3B82F6');
            gradientBlue.addColorStop(1, 'rgba(59, 130, 246, 0.1)');
            
            const gradientOrange = ageCtx.createLinearGradient(0, 0, 0, 400);
            gradientOrange.addColorStop(0, '#F59E0B');
            gradientOrange.addColorStop(1, 'rgba(245, 158, 11, 0.1)');
            
            new Chart(ageCtx, {
                type: 'bar',
                data: {
                    labels: ['Anak (0-17)', 'Dewasa (18-59)', 'Lansia (60+)'],
                    datasets: [{
                        label: 'Jumlah Penduduk',
                        data: [data.anak, data.dewasa, data.lansia],
                        backgroundColor: [gradientGreen, gradientBlue, gradientOrange],
                        borderColor: ['#10B981', '#3B82F6', '#F59E0B'],
                        borderWidth: 2,
                        borderRadius: 8,
                        borderSkipped: false,
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    animation: {
                        duration: 2000,
                        easing: 'easeOutBounce'
                    },
                    plugins: {
                        legend: {
                            display: false
                        },
                        tooltip: {
                            backgroundColor: 'rgba(0, 0, 0, 0.8)',
                            titleColor: 'white',
                            bodyColor: 'white',
                            borderColor: 'rgba(255, 255, 255, 0.1)',
                            borderWidth: 1,
                            cornerRadius: 8,
                            displayColors: true,
                            callbacks: {
                                label: function(context) {
                                    const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                    const percentage = total > 0 ? ((context.parsed.y / total) * 100).toFixed(1) : 0;
                                    return `${context.parsed.y} orang (${percentage}%)`;
                                }
                            }
                        }
                    },
                    scales: {
                        y: {
                            beginAtZero: true,
                            grid: {
                                color: 'rgba(0, 0, 0, 0.05)',
                                drawBorder: false
                            },
                            ticks: {
                                font: {
                                    size: 10
                                },
                                color: '#6B7280'
                            }
                        },
                        x: {
                            grid: {
                                display: false
                            },
                            ticks: {
                                font: {
                                    size: 10,
                                    weight: 'bold'
                                },
                                color: '#374151'
                            }
                        }
                    },
                    onHover: (event, activeElements) => {
                        event.native.target.style.cursor = activeElements.length > 0 ? 'pointer' : 'default';
                    }
                }
            });

            // Job Chart - Enhanced doughnut chart with animations
            const jobCtx = document.getElementById('jobChart').getContext('2d');
            new Chart(jobCtx, {
                type: 'doughnut',
                data: {
                    labels: ['Bekerja', 'Mencari Kerja', 'Pelajar', 'Lainnya'],
                    datasets: [{
                        label: 'Status Pekerjaan',
                        data: [data.bekerja, data.mencariKerja, data.pelajar, data.lainnya],
                        backgroundColor: [
                            'rgba(16, 185, 129, 0.8)',  // Green for working
                            'rgba(245, 158, 11, 0.8)',  // Yellow for job seeking
                            'rgba(59, 130, 246, 0.8)',  // Blue for students
                            'rgba(107, 114, 128, 0.8)'  // Gray for others
                        ],
                        borderColor: [
                            '#10B981',
                            '#F59E0B', 
                            '#3B82F6',
                            '#6B7280'
                        ],
                        borderWidth: 3,
                        hoverOffset: 10,
                        hoverBorderWidth: 4
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    cutout: '60%',
                    animation: {
                        animateRotate: true,
                        animateScale: true,
                        duration: 2000,
                        easing: 'easeOutBounce'
                    },
                    plugins: {
                        legend: {
                            position: 'bottom',
                            labels: {
                                font: {
                                    size: 10,
                                    weight: 'bold'
                                },
                                padding: 15,
                                usePointStyle: true,
                                pointStyle: 'circle'
                            }
                        },
                        tooltip: {
                            backgroundColor: 'rgba(0, 0, 0, 0.8)',
                            titleColor: 'white',
                            bodyColor: 'white',
                            borderColor: 'rgba(255, 255, 255, 0.1)',
                            borderWidth: 1,
                            cornerRadius: 8,
                            displayColors: true,
                            callbacks: {
                                label: function(context) {
                                    const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                    const percentage = total > 0 ? ((context.parsed / total) * 100).toFixed(1) : 0;
                                    return `${context.label}: ${context.parsed} orang (${percentage}%)`;
                                }
                            }
                        }
                    },
                    onHover: (event, activeElements) => {
                        event.native.target.style.cursor = activeElements.length > 0 ? 'pointer' : 'default';
                    },
                    elements: {
                        arc: {
                            borderRadius: 5
                        }
                    }
                }
            });

            // Education Chart
            if (data.pendidikan && Object.keys(data.pendidikan).length > 0) {
                const educationCtx = document.getElementById('educationChart').getContext('2d');
                
                // Prepare education data
                const educationLabels = Object.keys(data.pendidikan);
                const educationValues = Object.values(data.pendidikan);
                
                // Create rank-based colors for chart (same as progress bars)
                const rankBasedColors = [
                    '#ef4444',  // Rank 1 - Red
                    '#f97316',  // Rank 2 - Orange
                    '#10b981',  // Rank 3 - Emerald
                    '#0ea5e9',  // Rank 4 - Sky
                    '#8b5cf6',  // Rank 5 - Violet
                    '#a855f7',  // Rank 6 - Purple
                    '#d946ef',  // Rank 7 - Fuchsia
                    '#6366f1',  // Rank 8 - Indigo
                    '#f43f5e',  // Rank 9 - Rose
                    '#f59e0b'   // Rank 10 - Amber
                ];
                
                // Sort education data by count to match the ranking in progress bars
                const educationData = Object.entries(data.pendidikan).sort((a, b) => b[1] - a[1]);
                const sortedLabels = educationData.map(item => item[0]);
                const sortedValues = educationData.map(item => item[1]);
                
                const chartColors = sortedLabels.map((label, index) => {
                    return rankBasedColors[index] || '#6b7280';
                });
                
                new Chart(educationCtx, {
                    type: 'doughnut',
                    data: {
                        labels: sortedLabels,
                        datasets: [{
                            data: sortedValues,
                            backgroundColor: chartColors,
                            borderWidth: 3,
                            borderColor: '#ffffff',
                            hoverOffset: 8,
                            hoverBorderWidth: 4
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        animation: {
                            animateRotate: true,
                            animateScale: true,
                            duration: 2000,
                            easing: 'easeOutBounce'
                        },
                        plugins: {
                            legend: {
                                position: 'bottom',
                                labels: {
                                    font: {
                                        size: 10,
                                        weight: 'bold'
                                    },
                                    padding: 15,
                                    usePointStyle: true,
                                    pointStyle: 'circle'
                                }
                            },
                            tooltip: {
                                backgroundColor: 'rgba(0, 0, 0, 0.8)',
                                titleColor: 'white',
                                bodyColor: 'white',
                                borderColor: 'rgba(255, 255, 255, 0.1)',
                                borderWidth: 1,
                                cornerRadius: 8,
                                displayColors: true,
                                callbacks: {
                                    label: function(context) {
                                        const total = context.dataset.data.reduce((a, b) => a + b, 0);
                                        const percentage = ((context.parsed * 100) / total).toFixed(1);
                                        return `${context.label}: ${context.parsed} orang (${percentage}%)`;
                                    }
                                }
                            }
                        },
                        cutout: '60%',
                        onHover: (event, activeElements) => {
                            event.native.target.style.cursor = activeElements.length > 0 ? 'pointer' : 'default';
                        },
                        elements: {
                            arc: {
                                borderRadius: 5
                            }
                        }
                    }
                });
            }
        }
    </script>
</body>
</html>
