<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Sistem Informasi Desa</title>
    
    <!-- PWA Meta Tags -->
    <meta name="theme-color" content="#3B82F6">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="Sistem Desa">
    <link rel="manifest" href="/manifest.json">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    
    <!-- CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'inter': ['Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#eff6ff',
                            500: '#3b82f6',
                            600: '#2563eb',
                            700: '#1d4ed8'
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        
        body {
            font-family: 'Inter', system-ui, sans-serif;
        }
        
        .mobile-card {
            background: white;
            border-radius: 16px;
            padding: 16px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border: 1px solid #f1f5f9;
            transition: all 0.3s ease;
        }
        
        .mobile-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        }
        
        .mobile-button {
            padding: 1rem 1.5rem;
            border-radius: 0.75rem;
            font-weight: 600;
            text-align: center;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            transform: translateY(0);
        }
        
        .mobile-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .glass-effect {
            background: rgba(255, 255, 255, 0.25);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.18);
        }
        
        .animate-float {
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-20px); }
        }
        
        .animate-counter {
            animation: countUp 2s ease-out forwards;
        }
        
        @keyframes countUp {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* PERANGKAT DESA SLIDER - BULLETPROOF REBUILD */
        #perangkatSlider {
            position: relative !important;
            width: 100% !important;
            overflow: hidden !important;
            background: transparent !important;
            border-radius: 16px !important;
            min-height: 180px !important;
        }
        
        #perangkatSliderContent {
            display: flex !important;
            transition: transform 0.5s ease-in-out !important;
            width: 100% !important;
            height: 100% !important;
            align-items: stretch !important;
            flex-wrap: nowrap !important;
            justify-content: flex-start !important;
        }
        
        /* SLIDE STRUCTURE - BULLETPROOF 2 COLUMNS */
        .perangkat-slide {
            /* Flexbox child properties */
            min-width: 100% !important;
            width: 100% !important;
            flex-shrink: 0 !important;
            flex-grow: 0 !important;
            flex-basis: 100% !important;
            
            /* Grid container properties */
            display: grid !important;
            grid-template-columns: 1fr 1fr !important;
            grid-template-rows: 1fr !important;
            gap: 12px !important;
            align-items: stretch !important;
            align-content: stretch !important;
            
            /* Box model */
            padding: 8px !important;
            box-sizing: border-box !important;
            min-height: 180px !important;
            max-height: none !important;
            
            /* Position */
            position: relative !important;
            overflow: visible !important;
        }
        
        .perangkat-column {
            /* Grid child properties */
            grid-column: auto !important;
            grid-row: 1 !important;
            
            /* Flexbox container properties */
            display: flex !important;
            flex-direction: column !important;
            justify-content: space-between !important;
            align-items: stretch !important;
            
            /* Appearance */
            background: rgba(255, 255, 255, 0.9) !important;
            border: 1px solid rgba(0, 0, 0, 0.08) !important;
            border-radius: 12px !important;
            padding: 12px !important;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1) !important;
            backdrop-filter: blur(10px) !important;
            
            /* Dimensions */
            min-height: 160px !important;
            width: 100% !important;
            height: 100% !important;
            max-width: none !important;
            
            /* Position */
            position: relative !important;
            overflow: hidden !important;
            
            /* Transition */
            transition: all 0.3s ease !important;
        }
        
        .perangkat-column:hover {
            transform: translateY(-2px) !important;
            box-shadow: 0 4px 16px rgba(0, 0, 0, 0.15) !important;
        }
        
        .perangkat-column.empty {
            opacity: 0.3 !important;
            pointer-events: none !important;
            background: rgba(240, 240, 240, 0.5) !important;
        }
        
        /* CARD CONTENT */
        .perangkat-content {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-align: center;
            height: 100%;
            justify-content: space-between;
        }
        
        .perangkat-avatar {
            width: 60px;
            height: 60px;
            border-radius: 50%;
            overflow: hidden;
            margin-bottom: 12px;
            flex-shrink: 0;
            background: #f3f4f6;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .perangkat-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .perangkat-info {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        
        .perangkat-name {
            font-size: 14px;
            font-weight: 600;
            color: #1f2937;
            margin-bottom: 4px;
            line-height: 1.3;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
        
        .perangkat-position {
            font-size: 12px;
            font-weight: 500;
            color: #3b82f6;
            margin-bottom: 4px;
            line-height: 1.2;
            display: -webkit-box;
            -webkit-line-clamp: 1;
            line-clamp: 1;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
        
        .perangkat-description {
            font-size: 11px;
            color: #6b7280;
            line-height: 1.2;
            display: -webkit-box;
            -webkit-line-clamp: 2;
            line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
        }
        
        /* Navigation button styles */
        .nav-btn {
            backdrop-filter: blur(4px);
            -webkit-backdrop-filter: blur(4px);
        }
        
        /* RESPONSIVE - FORCE GRID CONSISTENCY */
        @media (max-width: 768px) {
            .perangkat-slide {
                grid-template-columns: 1fr 1fr !important;
                gap: 8px !important;
                padding: 6px !important;
                min-height: 160px !important;
                display: grid !important;
            }
            
            .perangkat-column {
                padding: 10px !important;
                min-height: 140px !important;
                width: 100% !important;
                height: 100% !important;
            }
            
            .perangkat-avatar {
                width: 50px !important;
                height: 50px !important;
                margin-bottom: 8px !important;
            }
            
            .perangkat-name {
                font-size: 13px !important;
            }
            
            .perangkat-position {
                font-size: 11px !important;
            }
            
            .perangkat-description {
                font-size: 10px !important;
            }
        }
        
        @media (max-width: 480px) {
            .perangkat-slide {
                grid-template-columns: 1fr 1fr !important;
                gap: 6px !important;
                padding: 4px !important;
                min-height: 140px !important;
                display: grid !important;
            }
            
            .perangkat-column {
                padding: 8px !important;
                min-height: 120px !important;
                width: 100% !important;
                height: 100% !important;
            }
            
            .perangkat-avatar {
                width: 45px !important;
                height: 45px !important;
                margin-bottom: 6px !important;
            }
            
            .perangkat-name {
                font-size: 12px !important;
            }
            
            .perangkat-position {
                font-size: 10px !important;
            }
            
            .perangkat-description {
                font-size: 9px !important;
            }
        }
        
        /* FontAwesome fallback with !important for all icons */
        .fas.fa-home:before, .fa.fa-home:before { content: "🏠" !important; font-family: system-ui !important; }
        .fas.fa-newspaper:before, .fa.fa-newspaper:before { content: "📰" !important; font-family: system-ui !important; }
        .fas.fa-map-marked-alt:before, .fa.fa-map-marked-alt:before { content: "🗺️" !important; font-family: system-ui !important; }
        .fas.fa-store:before, .fa.fa-store:before { content: "🏪" !important; font-family: system-ui !important; }
        .fas.fa-user-shield:before, .fa.fa-user-shield:before { content: "🛡️" !important; font-family: system-ui !important; }
        .fas.fa-sync-alt:before, .fa.fa-sync-alt:before { content: "🔄" !important; font-family: system-ui !important; }
        .fab.fa-youtube:before, .fa.fa-youtube:before { content: "▶️" !important; font-family: system-ui !important; }
        .fas.fa-external-link-alt:before, .fa.fa-external-link-alt:before { content: "↗️" !important; font-family: system-ui !important; }
        .fas.fa-spinner:before, .fa.fa-spinner:before { content: "⏳" !important; font-family: system-ui !important; }
        
        /* Additional common icons */
        .fas.fa-sign-out-alt:before, .fa.fa-sign-out:before { content: "🚪" !important; font-family: system-ui !important; }
        .fas.fa-tachometer-alt:before, .fa.fa-dashboard:before { content: "📊" !important; font-family: system-ui !important; }
        .fas.fa-file-alt:before, .fa.fa-file:before { content: "📄" !important; font-family: system-ui !important; }
        .fas.fa-search:before, .fa.fa-search:before { content: "🔍" !important; font-family: system-ui !important; }
        .fas.fa-exclamation-triangle:before, .fa.fa-warning:before { content: "⚠️" !important; font-family: system-ui !important; }
        .fas.fa-bell:before, .fa.fa-bell:before { content: "🔔" !important; font-family: system-ui !important; }
        .fas.fa-user-circle:before, .fa.fa-user-circle:before { content: "👤" !important; font-family: system-ui !important; }
        .fas.fa-chevron-right:before, .fa.fa-chevron-right:before { content: "▶️" !important; font-family: system-ui !important; }
        .fas.fa-briefcase:before, .fa.fa-briefcase:before { content: "💼" !important; font-family: system-ui !important; }
        .fas.fa-hand-holding-heart:before, .fa.fa-hand-holding-heart:before { content: "🤲" !important; font-family: system-ui !important; }
        .fas.fa-clock:before, .fa.fa-clock:before { content: "🕐" !important; font-family: system-ui !important; }
        .fas.fa-file-text:before, .fa.fa-file-text:before { content: "📝" !important; font-family: system-ui !important; }
        .fas.fa-key:before, .fa.fa-key:before { content: "🔑" !important; font-family: system-ui !important; }
        .fas.fa-check:before, .fa.fa-check:before { content: "✅" !important; font-family: system-ui !important; }
        
        /* Force emoji display for all FontAwesome icons */
        .fas:before, .fab:before, .fa:before {
            font-weight: normal !important;
            font-style: normal !important;
            text-rendering: auto !important;
            -webkit-font-smoothing: antialiased !important;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Mobile App Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        
        <!-- Header/Status Bar -->
        <div class="gradient-bg text-white px-6 py-8 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 bg-cover bg-top bg-no-repeat opacity-60" style="background-image: url('/images/bg-pettren.png');"></div>
            
            <!-- Header Content -->
            <div class="relative z-10">
                <div class="flex items-center justify-between mb-6">
                    <div class="flex items-center space-x-3">
                        <div class="w-12 h-12 bg-white/20 rounded-xl flex items-center justify-center backdrop-blur-md overflow-hidden" id="logoContainer">
                            <!-- Logo desa akan dimuat dari backend -->
                            <span class="text-2xl" id="defaultIcon">🏛️</span
                            <img src="/storage/settings/rVKWaU0L9qgdEacLSU0eGrfq1XNYfCjfIL2ROKwO.png" alt="Logo Desa Sirnajaya" class="w-full h-full object-contain" style="border-radius: 8px;">
                        </div>
                        <div id="headerText">
                            <h1 class="text-xl font-bold">Sistem Desa</h1>
                            <p class="text-white/80 text-sm">Desa Digital</p>
                        </div>
                    </div>
                    
                    <!-- Notification Bell -->
                    <button class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-md">
                        <span class="text-lg">🔔</span>
                    </button>
                </div>
                
                <!-- Welcome Message -->
                <div class="text-center">
                    <h2 class="text-2xl font-bold mb-2">Selamat Datang</h2>
                    <p class="text-white/90">Akses layanan desa dengan mudah</p>
                </div>
            </div>
        </div>



        <!-- YouTube Video Card -->
        <div class="px-6 relative z-10 mb-6">
            <div class="mobile-card p-4">
                <div class="flex items-center justify-between mb-3">
                    <h3 class="text-sm font-semibold text-gray-800">Video Profil Desa</h3>
                    <button onclick="refreshVideo()" class="text-blue-600 text-xs">
                        <i class="fas fa-sync-alt"></i>
                    </button>
                </div>
                
                <!-- Video Container -->
                <div class="relative bg-gray-100 rounded-lg overflow-hidden" style="aspect-ratio: 16/9;">
                    <iframe 
                        id="youtubeVideo"
                        src="https://www.youtube.com/embed/Gd9KS62iT5I?si=dG4RN-thHvhDQ5u3"
                        frameborder="0"
                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"
                        allowfullscreen
                        class="w-full h-full">
                    </iframe>
                    
                    <!-- Loading Overlay -->
                    <div id="videoLoading" class="absolute inset-0 bg-gray-200 flex items-center justify-center hidden">
                        <div class="text-center">
                            <i class="fas fa-spinner fa-spin text-gray-400 text-xl mb-2"></i>
                            <p class="text-xs text-gray-500">Memuat video...</p>
                        </div>
                    </div>
                </div>
                
                <!-- Video Info -->
                <div class="mt-3 flex items-center justify-between">
                    <div class="flex items-center space-x-2">
                        <div class="w-6 h-6 bg-red-100 rounded-full flex items-center justify-center">
                            <svg class="w-3 h-3" viewBox="0 0 24 24" fill="#FF0000">
                                <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                            </svg>
                        </div>
                        <span class="text-xs text-gray-600">YouTube</span>
                    </div>
                    <button onclick="openFullVideo()" class="text-xs text-blue-600 hover:text-blue-800">
                        Buka di YouTube <i class="fas fa-external-link-alt ml-1"></i>
                    </button>
                </div>
            </div>
        </div>





        <!-- Perangkat Desa Section -->
        <div class="px-6 mb-6">
            <div class="flex items-center justify-between mb-3">
                <h3 class="text-base font-semibold text-gray-800">Perangkat Desa</h3>
                <button class="text-blue-600 text-xs font-medium">Lihat Semua</button>
            </div>
            
            <!-- Perangkat Desa Horizontal Slider -->
            <div class="relative overflow-hidden">
                <div id="perangkatSlider">
                    <!-- Data akan diisi dari backend melalui API -->
                    <div id="perangkatSliderContent">
                        <!-- Content will be loaded from backend -->
                    </div>
                </div>
                
                <!-- Navigation Arrows -->
                <button onclick="prevSlide()" class="absolute left-2 top-1/2 transform -translate-y-1/2 bg-white/30 hover:bg-white/50 rounded-full p-2 shadow-md transition-all z-10" id="prevBtn">
                    <svg class="w-4 h-4 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </button>
                <button onclick="nextSlide()" class="absolute right-2 top-1/2 transform -translate-y-1/2 bg-white/30 hover:bg-white/50 rounded-full p-2 shadow-md transition-all z-10" id="nextBtn">
                    <svg class="w-4 h-4 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                </button>
                
                <!-- Slide Indicators -->
                <div class="flex justify-center mt-4 space-x-2" id="indicators">
                    <!-- Indicators will be generated dynamically -->
                </div>
            </div>
        </div>

        <!-- Services Grid -->
        <div class="px-6 mb-6">
            <h3 class="text-base font-semibold text-gray-800 mb-3">Layanan Umum</h3>
            
            <div class="grid grid-cols-3 gap-2">
                
                <!-- PPOB -->
                <button onclick="navigateToService('ppob')" class="mobile-card text-center hover:bg-purple-50 transition-all group p-2">
                    <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center mx-auto mb-1 group-hover:bg-purple-200 transition-colors">
                        <span class="text-purple-600 text-sm">💳</span>
                    </div>
                    <div class="font-semibold text-gray-800 text-xs">PPOB</div>
           
                </button>
                
                <!-- Demografi -->
                <button onclick="navigateToService('demografi')" class="mobile-card text-center hover:bg-orange-50 transition-all group p-2">
                    <div class="w-8 h-8 bg-orange-100 rounded-lg flex items-center justify-center mx-auto mb-1 group-hover:bg-orange-200 transition-colors">
                        <span class="text-orange-600 text-sm">👥</span>
                    </div>
                    <div class="font-semibold text-gray-800 text-xs">Demografi</div>
             
                </button>

                <!-- Berita -->
                <button onclick="navigateToService('berita')" class="mobile-card text-center hover:bg-purple-50 transition-all group p-2">
                    <div class="w-8 h-8 bg-purple-100 rounded-lg flex items-center justify-center mx-auto mb-1 group-hover:bg-purple-200 transition-colors">
                        <span class="text-purple-600 text-sm">📰</span>
                    </div>
                    <div class="font-semibold text-gray-800 text-xs">Berita</div>
              
                </button>

                <!-- UMKM -->
                <button onclick="navigateToService('umkm')" class="mobile-card text-center hover:bg-indigo-50 transition-all group p-2">
                    <div class="w-8 h-8 bg-indigo-100 rounded-lg flex items-center justify-center mx-auto mb-1 group-hover:bg-indigo-200 transition-colors">
                        <span class="text-indigo-600 text-sm">🏪</span>
                    </div>
                    <div class="font-semibold text-gray-800 text-xs">UMKM</div>
              
                </button>

                                <!-- Wisata -->
                <button onclick="navigateToService('wisata')" class="mobile-card text-center hover:bg-teal-50 transition-all group p-2">
                    <div class="w-8 h-8 bg-teal-100 rounded-lg flex items-center justify-center mx-auto mb-1 group-hover:bg-teal-200 transition-colors">
                        <span class="text-teal-600 text-sm">🗺️</span>
                    </div>
                    <div class="font-semibold text-gray-800 text-xs">Wisata</div>
                
                </button>

                <!-- Peta -->
                <button onclick="navigateToService('peta')" class="mobile-card text-center hover:bg-green-50 transition-all group p-2">
                    <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center mx-auto mb-1 group-hover:bg-green-200 transition-colors">
                        <span class="text-green-600 text-sm">🗺️</span>
                    </div>
                    <div class="font-semibold text-gray-800 text-xs">Peta Desa</div>
                 
                </button>

            </div>
        </div>

        <!-- News Section -->
        <div class="px-6 mb-6">
            <div class="flex items-center justify-between mb-3">
                <h3 class="text-base font-semibold text-gray-800">Berita Terbaru</h3>
                <button class="text-blue-600 text-xs font-medium">Lihat Semua</button>
            </div>
            
            <div class="space-y-3">
                <div class="mobile-card py-2 px-3">
                    <div class="flex space-x-3">
                        <div class="w-12 h-12 bg-gray-200 rounded-lg flex-shrink-0"></div>
                        <div class="flex-1">
                            <h4 class="font-semibold text-gray-800 text-xs mb-1">Pembangunan Jalan Desa</h4>
                            <p class="text-gray-600 text-xs mb-1">Proyek pembangunan jalan desa fase 2...</p>
                            <div class="text-xs text-gray-400">2 hari lalu</div>
                        </div>
                    </div>
                </div>
                
                <div class="mobile-card py-2 px-3">
                    <div class="flex space-x-3">
                        <div class="w-12 h-12 bg-gray-200 rounded-lg flex-shrink-0"></div>
                        <div class="flex-1">
                            <h4 class="font-semibold text-gray-800 text-xs mb-1">Program Bantuan Sembako</h4>
                            <p class="text-gray-600 text-xs mb-1">Pendistribusian bantuan sembako...</p>
                            <div class="text-xs text-gray-400">5 hari lalu</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bottom Navigation -->
        <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-100 px-4 py-3 z-50 shadow-lg backdrop-blur-sm bg-white/95">
            <div class="flex justify-around items-center">
                <button onclick="navigateToService('/')" class="flex flex-col items-center space-y-1.5 text-blue-600 transition-all duration-200">
                    <div class="bg-blue-50 p-2 rounded-xl">
                        <i class="fas fa-home text-lg"></i>
                    </div>
                    <span class="text-xs font-semibold">Beranda</span>
                </button>
                
                <button onclick="navigateToService('berita')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-newspaper text-lg"></i>
                    </div>
                    <span class="text-xs">Berita</span>
                </button>
                
                <button onclick="navigateToService('wisata')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-map-marked-alt text-lg"></i>
                    </div>
                    <span class="text-xs">Wisata</span>
                </button>
                
                <button onclick="navigateToService('umkm')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-store text-lg"></i>
                    </div>
                    <span class="text-xs">UMKM</span>
                </button>
                
                <button onclick="navigateToService('layanan-mandiri')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-user-shield text-lg"></i>
                    </div>
                    <span class="text-xs">Portal</span>
                </button>
            </div>
        </div>
        
        <!-- Spacer for bottom navigation -->
        <div class="h-24"></div>
    </div>

    <!-- JavaScript -->
    <script>
        // Perangkat Desa Slider
        let currentSlide = 0;
        let totalSlides = 3;
        let slideInterval;

        function showSlide(index) {
            const sliderContent = document.getElementById('perangkatSliderContent');
            if (!sliderContent) return;
            
            // Calculate slide width (100% per slide)
            const translateX = -index * 100;
            sliderContent.style.transform = `translateX(${translateX}%)`;
            
            // Update indicators
            document.querySelectorAll('[id^="indicator-"]').forEach((indicator, i) => {
                if (i === index) {
                    indicator.classList.remove('bg-gray-300');
                    indicator.classList.add('bg-blue-600');
                } else {
                    indicator.classList.remove('bg-blue-600');
                    indicator.classList.add('bg-gray-300');
                }
            });
            
            // Re-synchronize heights after slide transition
            setTimeout(() => {
                ensureConsistentHeight();
            }, 100);
        }

        function updateSlider() {
            const sliderContent = document.getElementById('perangkatSliderContent');
            if (sliderContent) {
                const translateX = -currentSlide * 100;
                sliderContent.style.transform = `translateX(${translateX}%)`;
            }
        }
        
        function nextSlide() {
            console.log('Next slide triggered');
            if (currentSlide < totalSlides - 1) {
                currentSlide++;
            } else {
                currentSlide = 0; // Loop back to first slide
            }
            console.log(`📍 Moving to slide ${currentSlide + 1}/${totalSlides}`);
            updateSlider();
            updateSlideIndicators();
            
            // BULLETPROOF SYNC - Multiple aggressive calls
            console.log('🔄 Triggering navigation sync...');
            setTimeout(() => {
                console.log('🔄 Nav sync phase 1');
                ensureConsistentHeight();
            }, 50);
            setTimeout(() => {
                console.log('🔄 Nav sync phase 2');
                ensureConsistentHeight();
            }, 200);
            setTimeout(() => {
                console.log('🔄 Nav sync phase 3');
                ensureConsistentHeight();
            }, 600);
        }
        
        function prevSlide() {
            console.log('⬅️ Previous slide triggered');
            if (currentSlide > 0) {
                currentSlide--;
            } else {
                currentSlide = totalSlides - 1; // Loop to last slide
            }
            console.log(`📍 Moving to slide ${currentSlide + 1}/${totalSlides}`);
            updateSlider();
            updateSlideIndicators();
            
            // BULLETPROOF SYNC - Multiple aggressive calls
            console.log('🔄 Triggering navigation sync...');
            setTimeout(() => {
                console.log('🔄 Nav sync phase 1');
                ensureConsistentHeight();
            }, 50);
            setTimeout(() => {
                console.log('🔄 Nav sync phase 2');
                ensureConsistentHeight();
            }, 200);
            setTimeout(() => {
                console.log('🔄 Nav sync phase 3');
                ensureConsistentHeight();
            }, 600);
        }

        function goToSlide(index) {
            currentSlide = index;
            showSlide(currentSlide);
            
            // Reset auto-slide timer
            clearInterval(slideInterval);
            startAutoSlide();
        }

        function startAutoSlide() {
            if (totalSlides > 1) {
                slideInterval = setInterval(nextSlide, 4000); // Change slide every 4 seconds
            }
        }

        // Load perangkat desa data from backend
        async function loadPerangkatDesa() {
            try {
                console.log('Loading perangkat desa data...');
                
                // Try multiple possible URLs
                const possibleUrls = [
                    `${window.location.origin}/api/v1/perangkat-desa`,
                    `http://localhost:8000/api/v1/perangkat-desa`,
                    `http://127.0.0.1:8000/api/v1/perangkat-desa`,
                    `/api/v1/perangkat-desa` // relative URL as fallback
                ];
                
                let lastError = null;
                
                for (let apiUrl of possibleUrls) {
                    try {
                        console.log('Trying API URL:', apiUrl);
                        
                        const response = await fetch(apiUrl, {
                            method: 'GET',
                            headers: {
                                'Accept': 'application/json',
                                'Content-Type': 'application/json'
                            }
                        });
                        
                        console.log('Response status:', response.status);
                        console.log('Response ok:', response.ok);
                        
                        if (!response.ok) {
                            throw new Error(`HTTP error! status: ${response.status}`);
                        }
                        
                        const data = await response.json();
                        
                        console.log('Perangkat Desa API Response:', data); // Debug log
                        
                        if (data.success && data.data && data.data.length > 0) {
                            console.log(`Found ${data.data.length} perangkat desa records from ${apiUrl}`);
                            renderPerangkatSlides(data.data);
                            updateSlideCount(Math.ceil(data.data.length / 2));
                            startAutoSlide();
                            return; // Success, exit function
                        } else {
                            console.log('No perangkat desa data found from:', apiUrl);
                        }
                        
                    } catch (urlError) {
                        console.warn(`Failed to fetch from ${apiUrl}:`, urlError.message);
                        lastError = urlError;
                        continue; // Try next URL
                    }
                }
                
                // If we reach here, all URLs failed
                console.log('All API URLs failed, showing no data message');
                renderNoDataMessage();
                
            } catch (error) {
                console.error('Error loading perangkat desa:', error);
                console.error('Error details:', {
                    message: error.message,
                    stack: error.stack
                });
                // Show error message instead of default fallback
                renderErrorMessage();
            }
        }

        // Create slides with 2 columns each - ENHANCED GRID LAYOUT WITH DEBUGGING
        function renderPerangkatSlides(data) {
            console.log('🏗️ Starting slide rendering with', data.length, 'perangkat desa records');
            
            const colors = ['blue', 'green', 'purple', 'red', 'yellow', 'indigo'];
            
            // Group data into slides (2 per slide)
            const slides = [];
            for (let i = 0; i < data.length; i += 2) {
                slides.push(data.slice(i, i + 2));
            }
            
            console.log(`📋 Created ${slides.length} slides from ${data.length} records`);
            
            let slidesHTML = '';
            slides.forEach((slide, slideIndex) => {
                console.log(`🎯 Building slide ${slideIndex + 1} with ${slide.length} items`);
                
                slidesHTML += '<div class="perangkat-slide">';
                
                // Always render exactly 2 columns for consistent grid
                for (let colIndex = 0; colIndex < 2; colIndex++) {
                    const perangkat = slide[colIndex];
                    const isEmpty = !perangkat;
                    
                    console.log(`  📦 Column ${colIndex + 1}: ${isEmpty ? 'EMPTY' : perangkat.nama || 'NO NAME'}`);
                    
                    slidesHTML += `<div class="perangkat-column${isEmpty ? ' empty' : ''}">`;
                    
                    if (perangkat) {
                        const color = colors[(slideIndex * 2 + colIndex) % colors.length];
                        const nama = perangkat.nama || perangkat.penduduk?.nama || 'Nama tidak tersedia';
                        const jabatan = perangkat.jabatan || 'Jabatan tidak tersedia';
                        const bidangTugas = perangkat.bidang_tugas || perangkat.keterangan || 'Perangkat Desa';
                        
                        slidesHTML += `
                            <div class="perangkat-content">
                                <div class="perangkat-avatar">
                                    ${perangkat.foto ? 
                                        `<img src="/storage/${perangkat.foto}" alt="${nama}" onerror="this.style.display='none';">` :
                                        `<div style="background: linear-gradient(135deg, #${color === 'blue' ? '3b82f6' : color === 'green' ? '10b981' : color === 'purple' ? '8b5cf6' : color === 'red' ? 'ef4444' : color === 'yellow' ? 'f59e0b' : '6366f1'}, #${color === 'blue' ? '1d4ed8' : color === 'green' ? '059669' : color === 'purple' ? '7c3aed' : color === 'red' ? 'dc2626' : color === 'yellow' ? 'd97706' : '4f46e5'}); width: 100%; height: 100%; border-radius: 50%; display: flex; align-items: center; justify-content: center; color: white; font-weight: bold; font-size: 20px;">${nama.charAt(0).toUpperCase()}</div>`
                                    }
                                </div>
                                <div class="perangkat-info">
                                    <div class="perangkat-name">${nama}</div>
                                    <div class="perangkat-position">${jabatan}</div>
                                    <div class="perangkat-description">${bidangTugas}</div>
                                </div>
                            </div>`;
                    } else {
                        // Empty placeholder with same structure
                        slidesHTML += `
                            <div class="perangkat-content">
                                <div class="perangkat-avatar"></div>
                                <div class="perangkat-info">
                                    <div class="perangkat-name">-</div>
                                    <div class="perangkat-position">-</div>
                                    <div class="perangkat-description">-</div>
                                </div>
                            </div>`;
                    }
                    
                    slidesHTML += '</div>'; // Close column
                }
                
                slidesHTML += '</div>'; // Close slide
            });
            
            // Update slider content
            const sliderContent = document.getElementById('perangkatSliderContent');
            if (!sliderContent) {
                console.error('❌ Slider content element not found!');
                return;
            }
            
            sliderContent.innerHTML = slidesHTML;
            console.log('✅ HTML content updated');
            
            // Update slide count and navigation
            totalSlides = slides.length;
            updateSlideCount();
            updateSlideIndicators();
            
            console.log(`🎯 Rendered ${totalSlides} slides with ${data.length} perangkat desa (Grid Layout)`);
            
            // BULLETPROOF SYNC - Multiple phases with debugging
            console.log('🔄 Starting synchronization phases...');
            
            // Phase 1: Immediate
            ensureConsistentHeight();
            
            // Phase 2: After DOM settle
            setTimeout(() => {
                console.log('🔄 Phase 2 sync...');
                ensureConsistentHeight();
            }, 100);
            
            // Phase 3: After layout complete
            setTimeout(() => {
                console.log('🔄 Phase 3 sync...');
                ensureConsistentHeight();
            }, 500);
            
            // DOM MUTATION OBSERVER - Watch for changes
            const observer = createDOMObserver(sliderContent);
            
            console.log('✅ Slide rendering complete with DOM observer active');
        }
        
        // Create DOM observer to watch for changes
        function createDOMObserver(sliderContent) {
            if (!window.MutationObserver) {
                console.warn('⚠️ MutationObserver not supported');
                return null;
            }
            
            const observer = new MutationObserver(function(mutations) {
                let shouldSync = false;
                
                mutations.forEach(function(mutation) {
                    if (mutation.type === 'childList' || 
                        (mutation.type === 'attributes' && 
                         (mutation.attributeName === 'style' || mutation.attributeName === 'class'))) {
                        shouldSync = true;
                    }
                });
                
                if (shouldSync) {
                    console.log('🔍 DOM mutation detected, triggering sync...');
                    setTimeout(() => {
                        ensureConsistentHeight();
                    }, 50);
                }
            });
            
            observer.observe(sliderContent, {
                childList: true,
                subtree: true,
                attributes: true,
                attributeFilter: ['style', 'class']
            });
            
            console.log('👁️ DOM observer activated');
            return observer;
        }

        function renderNoDataMessage() {
            const sliderContent = document.getElementById('perangkatSliderContent');
            const noDataHTML = `
            <div class="flex-shrink-0 w-full grid grid-cols-1 place-items-center py-8">
                <div class="text-center">
                    <div class="w-16 h-16 bg-gray-100 rounded-full mx-auto mb-4 flex items-center justify-center">
                        <span class="text-gray-400 text-3xl">ℹ️</span>
                    </div>
                    <h4 class="font-semibold text-gray-800 text-sm mb-1">Data Perangkat Desa</h4>
                    <p class="text-gray-500 text-xs">Belum ada data perangkat desa yang tersedia</p>
                </div>
            </div>`;
            
            sliderContent.innerHTML = noDataHTML;
            
            // Update slide count to 1 for no data message
            updateSlideCount(1);
        }

        function renderErrorMessage() {
            const sliderContent = document.getElementById('perangkatSliderContent');
            const errorHTML = `
            <div class="flex-shrink-0 w-full grid grid-cols-1 place-items-center py-8">
                <div class="text-center">
                    <div class="w-16 h-16 bg-red-100 rounded-full mx-auto mb-4 flex items-center justify-center">
                        <span class="text-red-500 text-3xl">❌</span>
                    </div>
                    <h4 class="font-semibold text-gray-800 text-sm mb-1">Gagal Memuat Data</h4>
                    <p class="text-gray-500 text-xs">Terjadi kesalahan saat memuat data perangkat desa</p>
                </div>
            </div>`;
            
            sliderContent.innerHTML = errorHTML;
            
            // Update slide count to 1 for error message
            updateSlideCount(1);
        }

        function renderDefaultSlides() {
            // This function is now deprecated, use renderNoDataMessage instead
            renderNoDataMessage();
        }

        function updateSlideCount(newTotalSlides) {
            // Update the global totalSlides variable
            totalSlides = Math.max(newTotalSlides, 1); // Ensure at least 1 slide
            
            // Reset current slide if it's out of bounds
            if (currentSlide >= totalSlides) {
                currentSlide = 0;
            }
            
            // Update indicators
            const indicatorsContainer = document.getElementById('indicators');
            if (indicatorsContainer) {
                let indicatorsHTML = '';
                for (let i = 0; i < totalSlides; i++) {
                    const activeClass = i === currentSlide ? 'bg-blue-600' : 'bg-gray-300';
                    indicatorsHTML += `<button onclick="goToSlide(${i})" class="w-2 h-2 ${activeClass} rounded-full transition-all duration-300" id="indicator-${i}"></button>`;
                }
                indicatorsContainer.innerHTML = indicatorsHTML;
            }
            
            // Show/hide navigation buttons based on slide count
            const prevBtn = document.getElementById('prevBtn');
            const nextBtn = document.getElementById('nextBtn');
            
            if (totalSlides <= 1) {
                if (prevBtn) prevBtn.style.display = 'none';
                if (nextBtn) nextBtn.style.display = 'none';
                if (indicatorsContainer) indicatorsContainer.style.display = 'none';
            } else {
                if (prevBtn) prevBtn.style.display = 'block';
                if (nextBtn) nextBtn.style.display = 'block';
                if (indicatorsContainer) indicatorsContainer.style.display = 'flex';
            }
            
            // Show the current slide
            showSlide(currentSlide);
        }

        // Load setting desa untuk logo dan nama desa
        async function loadSettingDesa() {
            try {
                const response = await fetch('/api/v1/setting-desa');
                const data = await response.json();
                
                if (data.success && data.data) {
                    const setting = data.data;
                    
                    // Update logo desa
                    if (setting.logo) {
                        const logoContainer = document.getElementById('logoContainer');
                        const defaultIcon = document.getElementById('defaultIcon');
                        
                        if (logoContainer && defaultIcon) {
                            // Hide default icon
                            defaultIcon.style.display = 'none';
                            
                            // Create logo image
                            const logoImg = document.createElement('img');
                            logoImg.src = setting.logo;
                            logoImg.alt = 'Logo ' + setting.nama_desa;
                            logoImg.className = 'w-full h-full object-contain';
                            logoImg.style.borderRadius = '8px';
                            
                            // Add error handler to fallback to default icon
                            logoImg.onerror = function() {
                                this.style.display = 'none';
                                defaultIcon.style.display = 'block';
                            };
                            
                            logoContainer.appendChild(logoImg);
                        }
                    }
                    
                    // Update header text
                    const headerText = document.getElementById('headerText');
                    if (headerText && setting.nama_desa) {
                        const lokasi = [];
                        if (setting.kecamatan) lokasi.push(`Kec. ${setting.kecamatan}`);
                        if (setting.kabupaten) lokasi.push(`Kab. ${setting.kabupaten}`);
                        
                        const lokasiText = lokasi.length > 0 ? lokasi.join(', ') : 'Desa Digital';
                        
                        headerText.innerHTML = `
                            <h1 class="text-xl font-bold">${setting.nama_desa}</h1>
                            <p class="text-white/80 text-sm">${lokasiText}</p>
                        `;
                    }
                }
            } catch (error) {
                console.error('Error loading setting desa:', error);
                // Keep default values if API fails
            }
        }

        // Start auto-slide when page loads
        document.addEventListener('DOMContentLoaded', function() {
            console.log('🚀 DOM Content Loaded - Initializing...');
            
            // FontAwesome loaded with CSS emoji fallback
            console.log('✅ Homepage loaded with FontAwesome + CSS emoji fallback');
            
            loadSettingDesa();
            loadPerangkatDesa();
            
            // Pause auto-slide on hover
            const sliderContainer = document.querySelector('.relative.overflow-hidden');
            if (sliderContainer) {
                sliderContainer.addEventListener('mouseenter', () => {
                    console.log('🐭 Mouse entered slider - pausing auto-slide');
                    clearInterval(slideInterval);
                });
                
                sliderContainer.addEventListener('mouseleave', () => {
                    console.log('🐭 Mouse left slider - resuming auto-slide');
                    startAutoSlide();
                });
            }
            
            // COMPREHENSIVE EVENT LISTENERS FOR SYNC
            console.log('📡 Setting up comprehensive event listeners...');
            
            // Window resize with debouncing
            let resizeTimeout;
            window.addEventListener('resize', () => {
                console.log('📏 Window resize detected');
                clearTimeout(resizeTimeout);
                resizeTimeout = setTimeout(() => {
                    console.log('📏 Resize debounced - triggering sync');
                    ensureConsistentHeight();
                }, 300);
            });
            
            // Orientation change
            window.addEventListener('orientationchange', () => {
                console.log('📱 Orientation change detected');
                setTimeout(() => {
                    console.log('📱 Orientation sync triggered');
                    ensureConsistentHeight();
                }, 500);
            });
            
            // Page visibility change
            document.addEventListener('visibilitychange', () => {
                if (!document.hidden) {
                    console.log('👁️ Page became visible - triggering sync');
                    setTimeout(() => {
                        ensureConsistentHeight();
                    }, 200);
                }
            });
            
            // Focus events
            window.addEventListener('focus', () => {
                console.log('🎯 Window focused - triggering sync');
                setTimeout(() => {
                    ensureConsistentHeight();
                }, 100);
            });
            
            // Load event (after all resources)
            window.addEventListener('load', () => {
                console.log('✅ Window fully loaded - final sync');
                setTimeout(() => {
                    ensureConsistentHeight();
                }, 1000);
            });
            
            console.log('✅ All event listeners set up');
        });

        function navigateToService(serviceType) {
            console.log('Navigating to:', serviceType);
            
            switch(serviceType) {
                case '/':
                case 'home':
                case 'beranda':
                    window.location.href = '/';
                    break;
                case 'peta':
                    window.location.href = '/peta';
                    break;
                case 'demografi':
                    window.location.href = '/demografi';
                    break;
                case 'berita':
                    window.location.href = '/berita';
                    break;
                case 'umkm':
                    window.location.href = '/produk-umkm';
                    break;
                case 'wisata':
                    window.location.href = '/wisata';
                    break;
                case 'layanan-mandiri':
                    window.location.href = '/layanan-mandiri';
                    break;
                case 'ppob':
                    window.location.href = '/ppob';
                    break;
                default:
                    console.log('Unknown service type:', serviceType);
                    window.location.href = '/';
            }
        }

        // YouTube Video Functions
        function refreshVideo() {
            const iframe = document.getElementById('youtubeVideo');
            const loading = document.getElementById('videoLoading');
            
            // Show loading
            loading.classList.remove('hidden');
            
            // Reload iframe
            const currentSrc = iframe.src;
            iframe.src = '';
            
            setTimeout(() => {
                iframe.src = currentSrc;
                loading.classList.add('hidden');
            }, 1000);
        }

        function openFullVideo() {
            const iframe = document.getElementById('youtubeVideo');
            const videoId = extractVideoId(iframe.src);
            
            if (videoId) {
                window.open(`https://www.youtube.com/watch?v=tLzO0PZ7aWI`, '_blank');
            }
        }

        function extractVideoId(url) {
            const regex = /(?:embed\/|v=|vi=|youtu\.be\/|\/embed\/)([^&\n?#]+)/;
            const match = url.match(regex);
            return match ? match[1] : null;
        }

        // Function to change YouTube video
        function changeYouTubeVideo(videoId) {
            const iframe = document.getElementById('youtubeVideo');
            const loading = document.getElementById('videoLoading');
            
            // Show loading
            loading.classList.remove('hidden');
            
            // Update iframe source
            iframe.src = `https://www.youtube.com/embed/${videoId}?rel=0&modestbranding=1&showinfo=0`;
            
            // Hide loading after iframe loads
            iframe.onload = function() {
                loading.classList.add('hidden');
            };
        }
        
        // Simple counter animation
        function animateCounters() {
            const counters = document.querySelectorAll('.animate-counter');
            counters.forEach(counter => {
                const target = parseInt(counter.textContent.replace(/,/g, ''));
                let current = 0;
                const increment = target / 50;
                const timer = setInterval(() => {
                    current += increment;
                    if (current >= target) {
                        counter.textContent = target.toLocaleString();
                        clearInterval(timer);
                    } else {
                        counter.textContent = Math.floor(current).toLocaleString();
                    }
                }, 40);
            });
        }
        
        // Initialize animations
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(animateCounters, 500);
        });

        // BULLETPROOF GRID SYNCHRONIZATION WITH DETAILED DEBUGGING
        function ensureConsistentHeight() {
            console.log('🔧 Starting grid synchronization...');
            
            setTimeout(() => {
                const sliderContent = document.getElementById('perangkatSliderContent');
                const slides = document.querySelectorAll('.perangkat-slide');
                
                console.log(`📊 Found ${slides.length} slides in DOM`);
                
                if (!sliderContent) {
                    console.error('❌ Slider content not found!');
                    return;
                }
                
                if (slides.length === 0) {
                    console.error('❌ No slides found!');
                    return;
                }
                
                // STEP 1: FORCE CONTAINER STRUCTURE
                console.log('🎯 Step 1: Forcing container structure...');
                sliderContent.style.display = 'flex';
                sliderContent.style.flexWrap = 'nowrap';
                sliderContent.style.alignItems = 'stretch';
                sliderContent.style.justifyContent = 'flex-start';
                
                // STEP 2: FORCE GRID ON ALL SLIDES
                console.log('🎯 Step 2: Forcing grid structure on all slides...');
                slides.forEach((slide, slideIndex) => {
                    console.log(`  📋 Processing slide ${slideIndex + 1}:`);
                    
                    // Force slide properties
                    slide.style.display = 'grid';
                    slide.style.gridTemplateColumns = '1fr 1fr';
                    slide.style.gridTemplateRows = '1fr';
                    slide.style.gap = '12px';
                    slide.style.alignItems = 'stretch';
                    slide.style.alignContent = 'stretch';
                    slide.style.width = '100%';
                    slide.style.minWidth = '100%';
                    slide.style.flexShrink = '0';
                    slide.style.flexGrow = '0';
                    slide.style.flexBasis = '100%';
                    slide.style.padding = '8px';
                    slide.style.boxSizing = 'border-box';
                    slide.style.minHeight = '180px';
                    slide.style.position = 'relative';
                    slide.style.overflow = 'visible';
                    
                    const columns = slide.querySelectorAll('.perangkat-column');
                    console.log(`    📦 Found ${columns.length} columns`);
                    
                    if (columns.length !== 2) {
                        console.warn(`    ⚠️ Slide ${slideIndex + 1} has ${columns.length} columns instead of 2!`);
                    }
                    
                    // Force column properties
                    columns.forEach((col, colIndex) => {
                        col.style.gridColumn = 'auto';
                        col.style.gridRow = '1';
                        col.style.display = 'flex';
                        col.style.flexDirection = 'column';
                        col.style.justifyContent = 'space-between';
                        col.style.alignItems = 'stretch';
                        col.style.width = '100%';
                        col.style.height = '100%';
                        col.style.minHeight = '160px';
                        col.style.maxWidth = 'none';
                        col.style.position = 'relative';
                        col.style.overflow = 'hidden';
                        
                        const computedStyle = window.getComputedStyle(col);
                        console.log(`      🔍 Column ${colIndex + 1}: ${col.offsetWidth}px x ${col.offsetHeight}px (computed: ${computedStyle.width} x ${computedStyle.height})`);
                    });
                });
                
                // STEP 3: HEIGHT SYNCHRONIZATION
                console.log('🎯 Step 3: Height synchronization...');
                let maxSlideHeight = 0;
                let maxColumnHeight = 0;
                
                // Reset heights
                slides.forEach(slide => {
                    slide.style.height = 'auto';
                    const columns = slide.querySelectorAll('.perangkat-column');
                    columns.forEach(col => {
                        col.style.height = 'auto';
                    });
                });
                
                // Measure heights
                slides.forEach((slide, slideIndex) => {
                    const slideHeight = slide.offsetHeight;
                    if (slideHeight > maxSlideHeight) {
                        maxSlideHeight = slideHeight;
                    }
                    console.log(`    📏 Slide ${slideIndex + 1} height: ${slideHeight}px`);
                    
                    const columns = slide.querySelectorAll('.perangkat-column');
                    columns.forEach((col, colIndex) => {
                        const colHeight = col.offsetHeight;
                        if (colHeight > maxColumnHeight) {
                            maxColumnHeight = colHeight;
                        }
                        console.log(`      📏 Column ${colIndex + 1} height: ${colHeight}px`);
                    });
                });
                
                // Apply synchronized heights
                slides.forEach(slide => {
                    slide.style.height = maxSlideHeight + 'px';
                    slide.style.minHeight = maxSlideHeight + 'px';
                    
                    const columns = slide.querySelectorAll('.perangkat-column');
                    columns.forEach(col => {
                        col.style.height = maxColumnHeight + 'px';
                        col.style.minHeight = maxColumnHeight + 'px';
                    });
                });
                
                console.log(`✅ SYNC COMPLETE: ${slides.length} slides, Max heights - Slide: ${maxSlideHeight}px, Column: ${maxColumnHeight}px`);
                
                // STEP 4: FINAL GRID ENFORCEMENT
                setTimeout(() => {
                    console.log('🎯 Step 4: Final grid enforcement...');
                    slides.forEach((slide, index) => {
                        slide.style.display = 'grid';
                        slide.style.gridTemplateColumns = '1fr 1fr';
                        slide.style.gap = '12px';
                        console.log(`    ✅ Slide ${index + 1} grid enforced`);
                    });
                }, 100);
                
            }, 250); // Increased delay for stability
        }
        
        // Re-sync on window resize
        window.addEventListener('resize', ensureConsistentHeight);
        window.addEventListener('orientationchange', ensureConsistentHeight);
        
        function updateSlideIndicators() {
            const indicatorsContainer = document.getElementById('indicators');
            if (!indicatorsContainer) return;
            
            let indicatorsHTML = '';
            for (let i = 0; i < totalSlides; i++) {
                const activeClass = i === currentSlide ? 'bg-blue-600' : 'bg-gray-300';
                indicatorsHTML += `<button onclick="goToSlide(${i})" class="w-2 h-2 ${activeClass} rounded-full transition-all duration-300" id="indicator-${i}"></button>`;
            }
            indicatorsContainer.innerHTML = indicatorsHTML;
        }

        // Load statistik penduduk real dari database
        


    </script>
</body>
</html>