<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Layanan Mandiri - Portal Warga</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <style>
        .mobile-card {
            background: white;
            border-radius: 16px;
            padding: 16px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border: 1px solid #f1f5f9;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .animate-float {
            animation: float 3s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }

        .login-card {
            background: white;
            border-radius: 12px;
            padding: 14px;
            color: #374151;
            position: relative;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            border: 1px solid #e5e7eb;
        }

        .login-card::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 200%;
            background: rgba(59, 130, 246, 0.05);
            border-radius: 50%;
            transform: rotate(45deg);
            pointer-events: none;
            z-index: 0;
        }
        
        .login-card > * {
            position: relative;
            z-index: 1;
        }
        
        /* Ensure form elements are clickable */
        .login-card input,
        .login-card button,
        .login-card label {
            position: relative;
            z-index: 10;
            pointer-events: auto;
        }
        
        /* Fix for any potential overlay issues */
        .login-card form {
            position: relative;
            z-index: 5;
        }
        
        /* Debug: Remove any potential blocking elements */
        * {
            pointer-events: auto;
        }
        
        .login-card::before {
            pointer-events: none !important;
        }
        
        /* Ensure interactive elements work */
        input, button, a, [onclick] {
            pointer-events: auto !important;
            cursor: pointer;
        }
        
        input {
            cursor: text !important;
        }
        
        /* FontAwesome fallback with !important for navigation */
        .fas.fa-home:before, .fa.fa-home:before { content: "🏠" !important; font-family: system-ui !important; }
        .fas.fa-newspaper:before, .fa.fa-newspaper:before { content: "📰" !important; font-family: system-ui !important; }
        .fas.fa-map-marked-alt:before, .fa.fa-map-marked-alt:before { content: "🗺️" !important; font-family: system-ui !important; }
        .fas.fa-store:before, .fa.fa-store:before { content: "🏪" !important; font-family: system-ui !important; }
        .fas.fa-user-shield:before, .fa.fa-user-shield:before { content: "🛡️" !important; font-family: system-ui !important; }
        .fab.fa-whatsapp:before, .fa.fa-whatsapp:before { content: "💬" !important; font-family: system-ui !important; }
        .fas.fa-headset:before, .fa.fa-headset:before { content: "🎧" !important; font-family: system-ui !important; }
        .fas.fa-times-circle:before, .fa.fa-times-circle:before { content: "❌" !important; font-family: system-ui !important; }
        .fas.fa-check-circle:before, .fa.fa-check-circle:before { content: "✅" !important; font-family: system-ui !important; }
        .fas.fa-info-circle:before, .fa.fa-info-circle:before { content: "ℹ️" !important; font-family: system-ui !important; }
        .fas.fa-exclamation-triangle:before, .fa.fa-warning:before { content: "⚠️" !important; font-family: system-ui !important; }
        
        /* Login form icons */
        .fas.fa-id-card:before, .fa.fa-id-card:before { content: "🆔" !important; font-family: system-ui !important; }
        .fas.fa-lock:before, .fa.fa-lock:before { content: "🔒" !important; font-family: system-ui !important; }
        .fas.fa-eye:before, .fa.fa-eye:before { content: "👁️" !important; font-family: system-ui !important; }
        .fas.fa-eye-slash:before, .fa.fa-eye-slash:before { content: "🙈" !important; font-family: system-ui !important; }
        .fas.fa-spinner:before, .fa.fa-spinner:before { content: "⏳" !important; font-family: system-ui !important; }
        
        /* Force emoji display for all FontAwesome icons */
        .fas:before, .fab:before, .fa:before {
            font-weight: normal !important;
            font-style: normal !important;
            text-rendering: auto !important;
            -webkit-font-smoothing: antialiased !important;
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Mobile App Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        
        <!-- Header/Status Bar -->
        <div class="gradient-bg text-white px-6 py-8 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 bg-cover bg-top bg-no-repeat opacity-60" style="background-image: url('/images/bg-pettren.png');"></div>
            
            <div class="relative z-10">
                <!-- Back Button -->
                <div class="flex items-center mb-6">
                    <button onclick="history.back()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center mr-4 hover:bg-white/30 transition-colors">
                        <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z"/>
                        </svg>
                    </button>
                    <div>
                        <h1 class="text-xl font-bold text-white">Layanan Mandiri</h1>
                        <p class="text-white/80 text-sm">Portal Warga Digital</p>
                    </div>
                </div>

                <!-- Status Online -->
                <div class="flex items-center justify-center space-x-2 mb-4">
                    <div class="w-3 h-3 bg-green-400 rounded-full animate-pulse"></div>
                    <span class="text-white/90 text-sm font-medium">Portal Online & Siap Digunakan</span>
                </div>
            </div>
        </div>

        <!-- Content Area -->
        <div class="px-6 -mt-6 relative z-20">
            <!-- Login Section -->
            <div class="mb-6">
                <div class="login-card relative z-10">
                <div class="text-center mb-3">
                    <div class="w-12 h-12 bg-blue-100 rounded-xl flex items-center justify-center mx-auto mb-3 animate-float">
                        <svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4z"/>
                            <path d="M10 17l-4-4 1.41-1.41L10 14.17l6.59-6.59L18 9l-8 8z" fill="#2563eb" opacity="0.8"/>
                        </svg>
                    </div>
                    <h2 class="text-base font-bold mb-1 text-gray-800">Masuk Portal Warga</h2>
                    <p class="text-gray-600 text-xs">Login menggunakan NIK</p>
                </div>

                <!-- Login Form -->
                <form id="loginForm" class="space-y-2.5">
                    <div>
                        <label class="block text-gray-700 text-xs font-medium mb-1">
                            <i class="fas fa-id-card mr-1 text-xs text-blue-600"></i>NIK (16 digit)
                        </label>
                        <input type="text" id="nik" class="w-full px-2.5 py-2 bg-gray-50 border border-gray-300 rounded-md text-gray-800 placeholder-gray-500 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-sm" placeholder="Masukkan NIK 16 digit" maxlength="16">
                    </div>
                    
                    <div>
                        <label class="block text-gray-700 text-xs font-medium mb-1">
                            <i class="fas fa-lock mr-1 text-xs text-blue-600"></i>Password
                        </label>
                        <div class="relative">
                            <input type="password" id="password" class="w-full px-2.5 py-2 bg-gray-50 border border-gray-300 rounded-md text-gray-800 placeholder-gray-500 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 pr-8 text-sm" placeholder="Masukkan password">
                            <button type="button" onclick="togglePassword()" title="Tampilkan password" class="absolute inset-y-0 right-0 flex items-center pr-2.5 text-gray-600 hover:text-blue-600 transition-colors">
                                <i class="fas fa-eye text-xs" id="eyeIcon"></i>
                            </button>
                        </div>
                    </div>

                    <div class="pt-1">
                        <button type="submit" class="w-full bg-blue-600 text-white py-2 rounded-md font-semibold hover:bg-blue-700 transition-all flex items-center justify-center space-x-1.5 text-sm">
                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2C13.1 2 14 2.9 14 4C14 5.1 13.1 6 12 6C10.9 6 10 5.1 10 4C10 2.9 10.9 2 12 2ZM12 8C13.1 8 14 8.9 14 10C14 11.1 13.1 12 12 12C10.9 12 10 11.1 10 10C10 8.9 10.9 8 12 8ZM12 14C16.4 14 20 16.69 20 20V22H4V20C4 16.69 7.6 14 12 14Z"/>
                            </svg>
                            <span>Masuk Portal</span>
                        </button>
                    </div>
                </form>
                </div>
            </div>
            
            <!-- Info Card -->
            <div class="mb-4">
                <div class="bg-blue-50 border border-blue-200 rounded-md p-2 shadow-sm">
                    <div class="flex items-start space-x-1.5">
                        <div class="w-6 h-6 bg-blue-100 rounded-md flex items-center justify-center flex-shrink-0">
                            <i class="fas fa-info-circle text-blue-600 text-xs"></i>
                        </div>
                        <div class="flex-1">
                            <h4 class="font-semibold text-gray-800 text-xs mb-1.5">Cara Menggunakan Portal</h4>
                            <div class="space-y-0.5 text-xs text-gray-700">
                                <div class="flex items-start space-x-1">
                                    <span class="text-blue-600 font-bold text-xs">1.</span>
                                    <div class="text-xs leading-tight">
                                        <span class="font-medium">Login:</span> Masukkan NIK 16 digit yang terdaftar di database kependudukan desa
                                    </div>
                                </div>
                                <div class="flex items-start space-x-1">
                                    <span class="text-blue-600 font-bold text-xs">2.</span>
                                    <div class="text-xs leading-tight">
                                        <span class="font-medium">Password:</span> Hubungi perangkat desa untuk mendapatkan password akses portal
                                    </div>
                                </div>
                                <div class="flex items-start space-x-1">
                                    <span class="text-blue-600 font-bold text-xs">3.</span>
                                    <div class="text-xs leading-tight">
                                        <span class="font-medium">Password Default:</span> Jika belum ada password khusus, gunakan 6 digit terakhir NIK Anda
                                    </div>
                                </div>
                                <div class="flex items-start space-x-1">
                                    <span class="text-blue-600 font-bold text-xs">4.</span>
                                    <div class="text-xs leading-tight">
                                        <span class="font-medium">Akses Layanan:</span> Semua fitur portal dapat diakses 24 jam sehari, 7 hari seminggu
                                    </div>
                                </div>
                                <div class="flex items-start space-x-1">
                                    <span class="text-blue-600 font-bold text-xs">5.</span>
                                    <div class="text-xs leading-tight">
                                        <span class="font-medium">Bantuan:</span> Jika mengalami kesulitan, hubungi admin desa melalui WhatsApp di bawah
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Contact Support -->
            <div class="mb-6">
                <div class="bg-gray-50 border border-gray-200 rounded-lg p-3 shadow-sm">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center space-x-2">
                            <div class="w-8 h-8 bg-gray-200 rounded-lg flex items-center justify-center">
                                <i class="fas fa-headset text-gray-500 text-sm"></i>
                            </div>
                            <div>
                                <h4 class="font-semibold text-gray-800 text-xs">Butuh Bantuan?</h4>
                                <p class="text-gray-600 text-xs">Hubungi perangkat desa</p>
                            </div>
                        </div>
                        <button onclick="contactWhatsApp()" class="bg-green-500 text-white p-2 rounded-lg hover:bg-green-600 transition-colors flex-shrink-0">
                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893A11.821 11.821 0 0020.465 3.488"/>
                            </svg>
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- Spacer before bottom navigation -->
            <div class="pb-24"></div>
        </div>

    </div>

    <!-- Bottom Navigation -->
    <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-100 px-4 py-3 z-50 shadow-lg backdrop-blur-sm bg-white/95">
        <div class="flex justify-around items-center">
            <button onclick="navigateToService('/')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                <div class="p-2 rounded-xl hover:bg-blue-50">
                    <i class="fas fa-home text-lg"></i>
                </div>
                <span class="text-xs">Beranda</span>
            </button>
            
            <button onclick="navigateToService('berita')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                <div class="p-2 rounded-xl hover:bg-blue-50">
                    <i class="fas fa-newspaper text-lg"></i>
                </div>
                <span class="text-xs">Berita</span>
            </button>
            
            <button onclick="navigateToService('wisata')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                <div class="p-2 rounded-xl hover:bg-blue-50">
                    <i class="fas fa-map-marked-alt text-lg"></i>
                </div>
                <span class="text-xs">Wisata</span>
            </button>
            
            <button onclick="navigateToService('umkm')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                <div class="p-2 rounded-xl hover:bg-blue-50">
                    <i class="fas fa-store text-lg"></i>
                </div>
                <span class="text-xs">UMKM</span>
            </button>
            
            <button onclick="navigateToService('layanan-mandiri')" class="flex flex-col items-center space-y-1.5 text-blue-600 transition-all duration-200">
                <div class="bg-blue-50 p-2 rounded-xl">
                    <i class="fas fa-user-shield text-lg"></i>
                </div>
                <span class="text-xs font-semibold">Portal</span>
            </button>
        </div>
    </div>

    <script>
        // Debug function to check element accessibility
        function debugClickability() {
            console.log('=== Debug Clickability ===');
            const form = document.getElementById('loginForm');
            const nikInput = document.getElementById('nik');
            const passwordInput = document.getElementById('password');
            const submitBtn = document.querySelector('button[type="submit"]');
            
            console.log('Form element:', form);
            console.log('NIK input:', nikInput);
            console.log('Password input:', passwordInput);
            console.log('Submit button:', submitBtn);
            
            // Test if elements are accessible
            console.log('NIK clickable:', nikInput && !nikInput.disabled);
            console.log('Password clickable:', passwordInput && !passwordInput.disabled);
            console.log('Submit clickable:', submitBtn && !submitBtn.disabled);
        }

        // Toggle Password Visibility
        function togglePassword() {
            console.log('Toggle password clicked');
            const passwordInput = document.getElementById('password');
            const eyeIcon = document.getElementById('eyeIcon');
            const eyeButton = eyeIcon.parentElement;
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                eyeIcon.className = 'fas fa-eye-slash text-xs text-white';
                eyeButton.title = 'Sembunyikan password';
            } else {
                passwordInput.type = 'password';
                eyeIcon.className = 'fas fa-eye text-xs text-white';
                eyeButton.title = 'Tampilkan password';
            }
        }

        // Login Form Handler
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const nik = document.getElementById('nik').value.trim();
            const password = document.getElementById('password').value.trim();
            
            console.log('Login attempt:', { nik: nik }); // Debug log (don't log password)
            
            if (!nik || !password) {
                showCustomAlert('warning', 'Data Tidak Lengkap', 'Mohon lengkapi NIK dan password');
                return;
            }
            
            if (nik.length !== 16) {
                showCustomAlert('error', 'NIK Tidak Valid', 'NIK harus 16 digit');
                return;
            }
            
            // Show loading
            const submitBtn = e.target.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Memproses...';
            submitBtn.disabled = true;
            
            // CRITICAL FIX: Clear any existing session/localStorage first
            console.log('Clearing existing session...');
            localStorage.removeItem('portal_token');
            localStorage.removeItem('portal_user');
            localStorage.removeItem('portal_nik');
            
            // Get CSRF token
            const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
            if (!csrfToken) {
                alert('CSRF token tidak ditemukan. Silakan refresh halaman.');
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
                return;
            }
            
            // Clear existing session via API (optional, continue if fails)
            fetch('/portal/logout', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken
                }
            }).then(response => {
                // Don't check response status, just continue
                console.log('Previous session clear attempted');
                return proceedWithLogin();
            }).catch(error => {
                console.log('Session clear failed, continuing with login:', error);
                return proceedWithLogin();
            });
            
            function proceedWithLogin() {
                console.log('Proceeding with login for NIK:', nik);
                
                // Real authentication
                return fetch('/api/v1/portal/login', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({
                        nik: nik,
                        password: password
                    })
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error(`HTTP ${response.status}: ${response.statusText}`);
                    }
                    return response.json();
                })
                .then(data => {
                    console.log('Login response:', data);
                    
                    if (data.success) {
                        // Validate response data
                        if (!data.user || !data.user.nik || data.user.nik !== nik) {
                            throw new Error('Invalid response data - NIK mismatch');
                        }
                        
                        // Store login data with NIK validation
                        localStorage.setItem('portal_token', data.token);
                        localStorage.setItem('portal_user', JSON.stringify(data.user));
                        localStorage.setItem('portal_nik', data.user.nik);
                        
                        console.log('Stored login data for NIK:', data.user.nik);
                        
                        // Show success message
                        showCustomAlert('success', 'Login Berhasil', 'Selamat datang ' + data.user.nama);
                        
                        // Check if password must be changed
                        if (data.must_change_password) {
                            // Redirect to dashboard with change password flag
                            window.location.href = '/dashboard-warga?change_password=1';
                        } else {
                            // Redirect directly to dashboard warga
                            window.location.href = '/dashboard-warga';
                        }
                    } else {
                        showCustomAlert('error', 'Login Gagal', data.message || 'Unknown error');
                        submitBtn.innerHTML = originalText;
                        submitBtn.disabled = false;
                    }
                })
                .catch(error => {
                    console.error('Login Error:', error);
                    showCustomAlert('error', 'Terjadi Kesalahan', 'Terjadi kesalahan saat login: ' + error.message);
                    submitBtn.innerHTML = originalText;
                    submitBtn.disabled = false;
                });
            }
        });

        // Contact Functions
        function contactWhatsApp() {
            const phoneNumber = '6281234567890'; // Replace with actual admin WhatsApp
            const message = 'Halo, saya membutuhkan bantuan untuk mengakses Portal Layanan Mandiri';
            window.open(`https://wa.me/${phoneNumber}?text=${encodeURIComponent(message)}`, '_blank');
        }

        function contactPhone() {
            window.open('tel:+6281234567890', '_self');
        }
        
        // Test Connection Function
        function testConnection() {
            console.log('Testing connection...');
            
            // Test API route (no CSRF required)
            fetch('/api/v1/portal/test', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify({
                    test: 'connection'
                })
            })
            .then(response => {
                console.log('Test response status:', response.status);
                if (!response.ok) {
                    throw new Error(`HTTP ${response.status}: ${response.statusText}`);
                }
                return response.json();
            })
            .then(data => {
                console.log('Test response data:', data);
                showCustomAlert('success', 'Koneksi Berhasil', 'API: OK\nRouting: OK\nNo CSRF needed');
            })
            .catch(error => {
                console.error('Test error:', error);
                showCustomAlert('error', 'Test Gagal', 'Test gagal: ' + error.message + '\n\nCoba test CSRF juga...');
                
                // Fallback: test CSRF route
                testCSRF();
            });
        }
        
        // Test CSRF Function
        function testCSRF() {
            const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
            
            if (!csrfToken) {
                showCustomAlert('error', 'CSRF Token Tidak Ditemukan', 'Silakan refresh halaman.');
                return;
            }
            
            fetch('/portal/test', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': csrfToken
                },
                body: JSON.stringify({
                    test: 'csrf'
                })
            })
            .then(response => {
                console.log('CSRF Test response status:', response.status);
                if (!response.ok) {
                    throw new Error(`HTTP ${response.status}: ${response.statusText}`);
                }
                return response.json();
            })
            .then(data => {
                console.log('CSRF Test response data:', data);
                showCustomAlert('success', 'CSRF Test Berhasil', 'CSRF: OK\nRouting: OK');
            })
            .catch(error => {
                console.error('CSRF Test error:', error);
                showCustomAlert('error', 'CSRF Test Gagal', 'CSRF Test gagal: ' + error.message);
            });
        }

        // Auto-format NIK input
        document.getElementById('nik').addEventListener('input', function(e) {
            // Only allow numbers
            e.target.value = e.target.value.replace(/\D/g, '');
        });

        // Add enter key support
        document.getElementById('nik').addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                document.getElementById('password').focus();
            }
        });

        document.getElementById('password').addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                document.getElementById('loginForm').dispatchEvent(new Event('submit'));
            }
        });

        // Navigation function
        function navigateToService(serviceType) {
            console.log('Navigating to:', serviceType);
            
            switch(serviceType) {
                case '/':
                case 'home':
                case 'beranda':
                    window.location.href = '/';
                    break;
                case 'berita':
                    window.location.href = '/berita';
                    break;
                case 'wisata':
                    window.location.href = '/wisata';
                    break;
                case 'umkm':
                    window.location.href = '/produk-umkm';
                    break;
                case 'layanan-mandiri':
                    window.location.href = '/layanan-mandiri';
                    break;
                case 'peta':
                    window.location.href = '/peta';
                    break;
                default:
                    console.log('Unknown service type:', serviceType);
                    window.location.href = '/';
            }
        }

        // Run debug on page load
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Page loaded, running debug...');
            debugClickability();
            
            // Debug CSRF token
            const csrfToken = document.querySelector('meta[name="csrf-token"]')?.getAttribute('content');
            console.log('CSRF Token available:', !!csrfToken);
            console.log('CSRF Token length:', csrfToken ? csrfToken.length : 0);
            
            // Debug current URL and base URL
            console.log('Current URL:', window.location.href);
            console.log('Base URL:', window.location.origin);
            
            // Test click events
            const nikInput = document.getElementById('nik');
            const passwordInput = document.getElementById('password');
            
            nikInput.addEventListener('click', function() {
                console.log('NIK input clicked successfully');
            });
            
            passwordInput.addEventListener('click', function() {
                console.log('Password input clicked successfully');
            });
            
            // Force focus on NIK input for testing
            setTimeout(() => {
                nikInput.focus();
                console.log('NIK input focused');
            }, 500);
            
            // Add debug info to page
            const debugInfo = document.createElement('div');
            debugInfo.style.cssText = 'position:fixed;bottom:10px;left:10px;background:rgba(0,0,0,0.8);color:white;padding:10px;font-size:10px;border-radius:5px;z-index:9999;max-width:300px;';
            debugInfo.innerHTML = `
                <strong>Debug Info:</strong><br>
                CSRF: ${csrfToken ? '✓' : '✗'}<br>
                URL: ${window.location.pathname}<br>
                Time: ${new Date().toLocaleTimeString()}
            `;
            document.body.appendChild(debugInfo);
            
            // Hide debug info after 10 seconds
            setTimeout(() => {
                debugInfo.remove();
            }, 10000);
        });

        // Custom Alert Modal Function
        function showCustomAlert(type, title, message, callback) {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 z-50';
            modal.style.cssText = `
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: 100vh !important;
                padding: 1rem !important;
            `;
            
            let iconClass, iconColor, buttonColor;
            switch(type) {
                case 'warning':
                    iconClass = 'fas fa-exclamation-triangle';
                    iconColor = 'yellow';
                    buttonColor = 'yellow';
                    break;
                case 'error':
                    iconClass = 'fas fa-times-circle';
                    iconColor = 'red';
                    buttonColor = 'red';
                    break;
                case 'success':
                    iconClass = 'fas fa-check-circle';
                    iconColor = 'green';
                    buttonColor = 'green';
                    break;
                case 'info':
                default:
                    iconClass = 'fas fa-info-circle';
                    iconColor = 'blue';
                    buttonColor = 'blue';
                    break;
            }
            
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm mx-auto my-auto" style="margin: auto;">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-${iconColor}-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="${iconClass} text-${iconColor}-600 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">${title}</h3>
                        <p class="text-gray-600 text-sm">${message}</p>
                    </div>
                    
                    <button onclick="closeCustomAlert()" class="w-full bg-${buttonColor}-600 text-white py-3 rounded-xl font-semibold hover:bg-${buttonColor}-700 transition-all">
                        OK
                    </button>
                </div>
            `;
            
            modal.id = 'customAlertModal';
            document.body.appendChild(modal);
            
            // Store callback for when modal is closed
            window.customAlertCallback = callback;
        }

        // Close Custom Alert Modal
        function closeCustomAlert() {
            const modal = document.getElementById('customAlertModal');
            if (modal) {
                modal.remove();
            }
            
            // Execute callback if provided
            if (window.customAlertCallback) {
                window.customAlertCallback();
                window.customAlertCallback = null;
            }
        }
    </script>
</body>
</html> 