<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profil Warga - Portal Layanan Mandiri</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <style>
        .mobile-card {
            background: white;
            border-radius: 16px;
            padding: 16px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border: 1px solid #f1f5f9;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .profile-avatar {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 2rem;
            font-weight: bold;
            margin: 0 auto;
            overflow: hidden;
            position: relative;
        }
        
        .profile-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .member-avatar {
            width: 48px;
            height: 48px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 16px;
            font-weight: bold;
            overflow: hidden;
            flex-shrink: 0;
        }
        
        .member-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .modal-avatar {
            width: 56px;
            height: 56px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
            font-weight: bold;
            margin: 0 auto;
            overflow: hidden;
        }
        
        .modal-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .info-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 12px 0;
            border-bottom: 1px solid #f1f5f9;
        }
        
        .info-item:last-child {
            border-bottom: none;
        }
        
        .info-label {
            font-weight: 600;
            color: #374151;
            font-size: 14px;
        }
        
        .info-value {
            color: #6b7280;
            font-size: 14px;
            text-align: right;
            max-width: 60%;
        }
        
        .tab-button {
            padding: 12px 20px;
            border-radius: 12px;
            font-weight: 600;
            font-size: 14px;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .tab-button.active {
            background: #3b82f6;
            color: white;
        }
        
        .tab-button:not(.active) {
            background: #f3f4f6;
            color: #6b7280;
        }
        
        .family-member {
            background: white;
            border: 1px solid #f1f5f9;
            border-radius: 12px;
            padding: 12px;
            margin-bottom: 12px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 10px;
            font-weight: 600;
            text-transform: uppercase;
        }
        
        .status-active { background: #d1fae5; color: #065f46; }
        .status-inactive { background: #fee2e2; color: #991b1b; }
        
        /* FontAwesome fallback with !important for all icons */
        .fas.fa-arrow-left:before, .fa.fa-arrow-left:before { content: "⬅️" !important; font-family: system-ui !important; }
        .fas.fa-edit:before, .fa.fa-edit:before { content: "✏️" !important; font-family: system-ui !important; }
        .fas.fa-user:before, .fa.fa-user:before { content: "👤" !important; font-family: system-ui !important; }
        .fas.fa-spinner:before, .fa.fa-spinner:before { content: "⏳" !important; font-family: system-ui !important; }
        .fas.fa-key:before, .fa.fa-key:before { content: "🔑" !important; font-family: system-ui !important; }
        .fas.fa-camera:before, .fa.fa-camera:before { content: "📷" !important; font-family: system-ui !important; }
        .fas.fa-print:before, .fa.fa-print:before { content: "🖨️" !important; font-family: system-ui !important; }
        .fas.fa-home:before, .fa.fa-home:before { content: "🏠" !important; font-family: system-ui !important; }
        .fas.fa-file-text:before, .fa.fa-file-text:before { content: "📝" !important; font-family: system-ui !important; }
        .fas.fa-clock:before, .fa.fa-clock:before { content: "🕐" !important; font-family: system-ui !important; }
        .fas.fa-user-circle:before, .fa.fa-user-circle:before { content: "👤" !important; font-family: system-ui !important; }
        .fas.fa-exclamation-triangle:before, .fa.fa-warning:before { content: "⚠️" !important; font-family: system-ui !important; }
        .fas.fa-users:before, .fa.fa-users:before { content: "👥" !important; font-family: system-ui !important; }
        .fas.fa-eye:before, .fa.fa-eye:before { content: "👁️" !important; font-family: system-ui !important; }
        .fas.fa-user-edit:before, .fa.fa-user-edit:before { content: "✏️" !important; font-family: system-ui !important; }
        .fas.fa-cloud-upload-alt:before, .fa.fa-cloud-upload:before { content: "☁️" !important; font-family: system-ui !important; }
        .fas.fa-upload:before, .fa.fa-upload:before { content: "⬆️" !important; font-family: system-ui !important; }
        .fas.fa-info-circle:before, .fa.fa-info:before { content: "ℹ️" !important; font-family: system-ui !important; }
        .fas.fa-newspaper:before, .fa.fa-newspaper:before { content: "📰" !important; font-family: system-ui !important; }
        .fas.fa-map-marked-alt:before, .fa.fa-map-marked-alt:before { content: "🗺️" !important; font-family: system-ui !important; }
        .fas.fa-store:before, .fa.fa-store:before { content: "🏪" !important; font-family: system-ui !important; }
        .fas.fa-user-shield:before, .fa.fa-user-shield:before { content: "🛡️" !important; font-family: system-ui !important; }
        .fas.fa-times-circle:before, .fa.fa-times-circle:before { content: "❌" !important; font-family: system-ui !important; }
        .fas.fa-check-circle:before, .fa.fa-check-circle:before { content: "✅" !important; font-family: system-ui !important; }
        .fas.fa-info-circle:before, .fa.fa-info-circle:before { content: "ℹ️" !important; font-family: system-ui !important; }
        
        /* Force emoji display for all FontAwesome icons */
        .fas:before, .fab:before, .fa:before {
            font-weight: normal !important;
            font-style: normal !important;
            text-rendering: auto !important;
            -webkit-font-smoothing: antialiased !important;
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        <!-- Header -->
        <div class="gradient-bg px-6 py-6 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 bg-cover bg-top bg-no-repeat opacity-60" style="background-image: url('/images/bg-pettren.png');"></div>
            <div class="relative z-10">
            <div class="flex items-center justify-between mb-4">
                <button onclick="goBack()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center">
                    <i class="fas fa-arrow-left text-white"></i>
                </button>
                <h1 class="text-lg font-bold text-white">Profil Warga</h1>
                <button onclick="editProfile()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center">
                    <i class="fas fa-edit text-white"></i>
                </button>
            </div>

            <!-- Profile Avatar -->
            <div class="text-center mb-4">
                <div class="profile-avatar" id="profileAvatar">
                    <i class="fas fa-user"></i>
                </div>
                <h2 class="text-xl font-bold text-white mt-3" id="profileName">Loading...</h2>
                <p class="text-white/80 text-sm" id="profileNik">NIK: Loading...</p>
            </div>
            </div>
        </div>

        <!-- Tabs -->
        <div class="px-6 -mt-6 relative z-20 mb-6">
            <div class="mobile-card">
                <div class="flex space-x-2 mb-4">
                    <button class="tab-button active" onclick="switchTab('personal')" id="tabPersonal">
                        Data Pribadi
                    </button>
                    <button class="tab-button" onclick="switchTab('family')" id="tabFamily">
                        Data Keluarga
                    </button>
                </div>

                <!-- Personal Data Tab -->
                <div id="personalData" class="tab-content">
                    <h3 class="text-base font-semibold text-gray-800 mb-3">Informasi Pribadi</h3>
                    
                    <div class="space-y-1" id="personalInfo">
                        <!-- Personal data will be loaded here -->
                        <div class="text-center py-8">
                            <i class="fas fa-spinner fa-spin text-gray-400 text-2xl mb-2"></i>
                            <p class="text-gray-500">Memuat data...</p>
                        </div>
                    </div>
                </div>

                <!-- Family Data Tab -->
                <div id="familyData" class="tab-content hidden">
                    <h3 class="text-base font-semibold text-gray-800 mb-3">Data Keluarga</h3>
                    
                    <div id="familyInfo">
                        <!-- Family data will be loaded here -->
                        <div class="text-center py-8">
                            <i class="fas fa-spinner fa-spin text-gray-400 text-2xl mb-2"></i>
                            <p class="text-gray-500">Memuat data keluarga...</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="px-6 mb-6">
            <div class="mobile-card">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Aksi Cepat</h3>
                
                <div class="grid grid-cols-2 gap-3">
                    <button onclick="changePassword()" class="flex flex-col items-center p-4 bg-blue-50 rounded-xl hover:bg-blue-100 transition-colors">
                        <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mb-2">
                            <i class="fas fa-key text-blue-600"></i>
                        </div>
                        <span class="text-sm font-medium text-gray-800">Ubah Password</span>
                    </button>

                    <button onclick="updatePhoto()" class="flex flex-col items-center p-4 bg-green-50 rounded-xl hover:bg-green-100 transition-colors">
                        <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center mb-2">
                            <i class="fas fa-camera text-green-600"></i>
                        </div>
                        <span class="text-sm font-medium text-gray-800">Ubah Foto</span>
                    </button>

                    <button onclick="printKK()" class="flex flex-col items-center p-4 bg-purple-50 rounded-xl hover:bg-purple-100 transition-colors">
                        <div class="w-12 h-12 bg-purple-100 rounded-full flex items-center justify-center mb-2">
                            <i class="fas fa-print text-purple-600"></i>
                        </div>
                        <span class="text-sm font-medium text-gray-800">Cetak KK</span>
                    </button>

                    <button onclick="requestUpdate()" class="flex flex-col items-center p-4 bg-yellow-50 rounded-xl hover:bg-yellow-100 transition-colors">
                        <div class="w-12 h-12 bg-yellow-100 rounded-full flex items-center justify-center mb-2">
                            <i class="fas fa-edit text-yellow-600"></i>
                        </div>
                        <span class="text-sm font-medium text-gray-800">Ajukan Perubahan</span>
                    </button>
                </div>
            </div>
        </div>

        <!-- Bottom Navigation -->
        <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-100 px-4 py-3 z-50 shadow-lg backdrop-blur-sm bg-white/95">
            <div class="flex justify-around items-center">
                <button onclick="navigateToHome()" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-home text-lg"></i>
                    </div>
                    <span class="text-xs">Beranda</span>
                </button>
                
                <button onclick="navigateToBerita()" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-newspaper text-lg"></i>
                    </div>
                    <span class="text-xs">Berita</span>
                </button>
                
                <button onclick="navigateToWisata()" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-map-marked-alt text-lg"></i>
                    </div>
                    <span class="text-xs">Wisata</span>
                </button>
                
                <button onclick="navigateToUmkm()" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-store text-lg"></i>
                    </div>
                    <span class="text-xs">UMKM</span>
                </button>
                
                <button class="flex flex-col items-center space-y-1.5 text-blue-600 transition-all duration-200">
                    <div class="bg-blue-50 p-2 rounded-xl">
                        <i class="fas fa-user-shield text-lg"></i>
                    </div>
                    <span class="text-xs font-semibold">Portal</span>
                </button>
            </div>
        </div>

        <!-- Spacer for bottom navigation -->
        <div class="h-20"></div>
    </div>

    <script>
        let currentUser = null;
        let familyData = null;

        // Initialize page
        document.addEventListener('DOMContentLoaded', function() {
            checkAuthentication();
            loadUserData();
            loadFamilyData();
        });

        // Check authentication
        function checkAuthentication() {
            const portalToken = localStorage.getItem('portal_token');
            const portalUser = localStorage.getItem('portal_user');
            const portalNik = localStorage.getItem('portal_nik');
            
            if (!portalToken || !portalUser || !portalNik) {
                showCustomAlert('warning', 'Belum Login', 'Anda belum login. Silakan login terlebih dahulu.', function() {
                    window.location.href = '/layanan-mandiri';
                });
                return;
            }
            
            try {
                const userData = JSON.parse(portalUser);
                if (!userData.nik || userData.nik !== portalNik) {
                    throw new Error('Invalid user data');
                }
                currentUser = userData;
            } catch (error) {
                console.error('Invalid user data:', error);
                localStorage.removeItem('portal_token');
                localStorage.removeItem('portal_user');
                localStorage.removeItem('portal_nik');
                showCustomAlert('error', 'Data Tidak Valid', 'Data login tidak valid. Silakan login ulang.', function() {
                    window.location.href = '/layanan-mandiri';
                });
            }
        }

        // Load user data
        function loadUserData() {
            if (!currentUser) return;

            // Fetch real user data from database
            fetchUserData(currentUser.nik);
        }
        
        // Fetch user data from API
        async function fetchUserData(nik) {
            try {
                const response = await fetch('/api/v1/portal/user-data', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ nik: nik })
                });
                
                const result = await response.json();
                
                if (result.success && result.data) {
                    // Update current user with real data
                    currentUser = { ...currentUser, ...result.data };
                    
                    // Update header
                    document.getElementById('profileName').textContent = currentUser.nama || 'Nama Tidak Tersedia';
                    document.getElementById('profileNik').textContent = 'NIK: ' + (currentUser.nik || 'Tidak Tersedia');
                    
                    // Update avatar with photo or initials
                    const profileAvatar = document.getElementById('profileAvatar');
                    const profilePhoto = currentUser.foto; // Real photo from database
                    
                    if (profilePhoto) {
                        profileAvatar.innerHTML = `<img src="/storage/${profilePhoto}" alt="Foto Profil" onerror="this.style.display='none'; this.parentNode.innerHTML='${getInitials(currentUser.nama || 'NN')}'">`;
                    } else {
                        const initials = getInitials(currentUser.nama || 'NN');
                        profileAvatar.innerHTML = initials;
                    }

                    // Load personal information
                    loadPersonalInfo();
                } else {
                    console.error('Failed to fetch user data:', result.message);
                    // Fallback to existing data
                    loadPersonalInfoFallback();
                }
            } catch (error) {
                console.error('Error fetching user data:', error);
                // Fallback to existing data
                loadPersonalInfoFallback();
            }
        }
        
        // Load personal information from real data
        function loadPersonalInfo() {
            const personalInfo = document.getElementById('personalInfo');
            
            personalInfo.innerHTML = `
                <div class="space-y-2">
                    <div class="info-item">
                        <span class="info-label text-xs">Nama Lengkap</span>
                        <span class="info-value text-xs font-medium">${currentUser.nama || 'Tidak Tersedia'}</span>
                    </div>
                    <div class="info-item">
                        <span class="info-label text-xs">NIK</span>
                        <span class="info-value text-xs font-medium">${currentUser.nik || 'Tidak Tersedia'}</span>
                    </div>
                    <div class="info-item">
                        <span class="info-label text-xs">TTL</span>
                        <span class="info-value text-xs">${currentUser.tempat_lahir || 'Tidak Tersedia'}, ${currentUser.tanggal_lahir || 'Tidak Tersedia'}</span>
                    </div>
                    <div class="info-item">
                        <span class="info-label text-xs">Jenis Kelamin</span>
                        <span class="info-value text-xs">${currentUser.jenis_kelamin === 'L' ? 'Laki-laki' : currentUser.jenis_kelamin === 'P' ? 'Perempuan' : 'Tidak Tersedia'}</span>
                    </div>
                    <div class="info-item">
                        <span class="info-label text-xs">Agama</span>
                        <span class="info-value text-xs">${currentUser.agama || 'Tidak Tersedia'}</span>
                    </div>
                    <div class="info-item">
                        <span class="info-label text-xs">Pekerjaan</span>
                        <span class="info-value text-xs">${currentUser.pekerjaan || 'Tidak Tersedia'}</span>
                    </div>
                    <div class="info-item">
                        <span class="info-label text-xs">Alamat</span>
                        <span class="info-value text-xs">${currentUser.alamat || 'Tidak Tersedia'}</span>
                    </div>
                    <div class="info-item">
                        <span class="info-label text-xs">RT/RW</span>
                        <span class="info-value text-xs">RT ${currentUser.rt || '000'} / RW ${currentUser.rw || '000'}</span>
                    </div>
                    <div class="info-item">
                        <span class="info-label text-xs">No. HP</span>
                        <span class="info-value text-xs">${currentUser.no_hp || 'Tidak Tersedia'}</span>
                    </div>
                </div>
            `;
        }
        
        // Fallback function for personal info
        function loadPersonalInfoFallback() {
            const personalInfo = document.getElementById('personalInfo');
            
            personalInfo.innerHTML = `
                <div class="text-center py-8">
                    <i class="fas fa-exclamation-triangle text-yellow-500 text-3xl mb-3"></i>
                    <p class="text-gray-600">Tidak dapat memuat data pribadi</p>
                    <p class="text-gray-500 text-sm">Silakan coba refresh halaman</p>
                </div>
            `;
        }

        // Load family data
        function loadFamilyData() {
            if (!currentUser || !currentUser.nik) {
                displayFamilyDataError('NIK tidak tersedia');
                return;
            }
            
            // Fetch real family data from database
            fetchFamilyData(currentUser.nik);
        }
        
        // Fetch family data from API
        async function fetchFamilyData(nik) {
            try {
                const response = await fetch('/api/v1/portal/family-data', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ nik: nik })
                });
                
                const result = await response.json();
                
                if (result.success && result.data) {
                    familyData = result.data;
                    displayFamilyData();
                } else {
                    console.error('Failed to fetch family data:', result.message);
                    displayFamilyDataError(result.message || 'Gagal memuat data keluarga');
                }
            } catch (error) {
                console.error('Error fetching family data:', error);
                displayFamilyDataError('Terjadi kesalahan saat memuat data keluarga');
            }
        }
        
        // Display family data error
        function displayFamilyDataError(message) {
            const familyInfo = document.getElementById('familyInfo');
            familyInfo.innerHTML = `
                <div class="text-center py-8">
                    <i class="fas fa-exclamation-triangle text-yellow-500 text-3xl mb-3"></i>
                    <p class="text-gray-600">${message}</p>
                    <p class="text-gray-500 text-sm">Silakan coba refresh halaman</p>
                </div>
            `;
        }

        // Get initials from name
        function getInitials(name) {
            return name.split(' ')
                      .map(word => word.charAt(0))
                      .join('')
                      .substring(0, 2)
                      .toUpperCase();
        }

        // Display family data
        function displayFamilyData() {
            const familyInfo = document.getElementById('familyInfo');
            
            if (!familyData || familyData.length === 0) {
                familyInfo.innerHTML = `
                    <div class="text-center py-8">
                        <i class="fas fa-users text-gray-400 text-3xl mb-3"></i>
                        <p class="text-gray-500">Tidak ada data keluarga</p>
                    </div>
                `;
                return;
            }

            let html = '';
            familyData.forEach((member, index) => {
                const statusClass = member.status === 'Aktif' ? 'status-active' : 'status-inactive';
                const memberInitials = getInitials(member.nama);
                
                html += `
                    <div class="family-member">
                        <div class="flex items-start space-x-3 mb-2">
                            <div class="member-avatar">
                                ${member.foto ? 
                                    `<img src="/storage/${member.foto}" alt="Foto ${member.nama}" onerror="this.style.display='none'; this.parentNode.innerHTML='${memberInitials}'">` 
                                    : memberInitials
                                }
                            </div>
                            <div class="flex-1">
                                <div class="flex items-start justify-between">
                                    <div class="flex-1">
                                        <h4 class="font-semibold text-gray-800 text-sm">${member.nama}</h4>
                                        <p class="text-gray-600 text-xs">${member.hubungan}</p>
                                    </div>
                                    <span class="px-2 py-1 bg-green-100 text-green-800 text-xs rounded-full font-medium">${member.status}</span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="space-y-1 text-xs ml-14">
                            <div class="flex justify-between">
                                <span class="text-gray-600">NIK:</span>
                                <span class="text-gray-800 font-medium">${member.nik}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">TTL:</span>
                                <span class="text-gray-800">${member.tempat_lahir}, ${member.tanggal_lahir}</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Jenis Kelamin:</span>
                                <span class="text-gray-800">${member.jenis_kelamin === 'L' ? 'Laki-laki' : 'Perempuan'}</span>
                            </div>
                        </div>
                        
                        <div class="mt-2 pt-2 border-t border-gray-200 flex space-x-2">
                            <button onclick="viewMemberDetail(${index})" class="flex-1 text-xs bg-blue-50 text-blue-600 py-2 px-3 rounded-lg hover:bg-blue-100 transition-colors">
                                <i class="fas fa-eye mr-1"></i> Detail
                            </button>
                            <button onclick="editMember(${index})" class="flex-1 text-xs bg-gray-50 text-gray-600 py-2 px-3 rounded-lg hover:bg-gray-100 transition-colors">
                                <i class="fas fa-camera mr-1"></i> Ubah Foto
                            </button>
                        </div>
                    </div>
                `;
            });

            familyInfo.innerHTML = html;
        }

        // Switch tabs
        function switchTab(tab) {
            // Update tab buttons
            document.getElementById('tabPersonal').classList.toggle('active', tab === 'personal');
            document.getElementById('tabFamily').classList.toggle('active', tab === 'family');
            
            // Update tab content
            document.getElementById('personalData').classList.toggle('hidden', tab !== 'personal');
            document.getElementById('familyData').classList.toggle('hidden', tab !== 'family');
        }

        // View member detail
        function viewMemberDetail(index) {
            const member = familyData[index];
            const memberInitials = getInitials(member.nama);
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4';
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-5 w-full max-w-sm max-h-[80vh] overflow-y-auto">
                    <div class="text-center mb-5">
                        <div class="modal-avatar mb-3">
                            ${member.foto ? 
                                `<img src="/storage/${member.foto}" alt="Foto ${member.nama}" onerror="this.style.display='none'; this.parentNode.innerHTML='${memberInitials}'">` 
                                : memberInitials
                            }
                        </div>
                        <h3 class="text-lg font-semibold text-gray-800">${member.nama}</h3>
                        <p class="text-gray-600 text-xs">${member.hubungan}</p>
                    </div>
                    
                    <div class="space-y-2">
                        <div class="info-item">
                            <span class="info-label text-xs">NIK</span>
                            <span class="info-value text-xs font-medium">${member.nik}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-label text-xs">Tempat Lahir</span>
                            <span class="info-value text-xs">${member.tempat_lahir}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-label text-xs">Tanggal Lahir</span>
                            <span class="info-value text-xs">${member.tanggal_lahir}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-label text-xs">Jenis Kelamin</span>
                            <span class="info-value text-xs">${member.jenis_kelamin === 'L' ? 'Laki-laki' : 'Perempuan'}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-label text-xs">Agama</span>
                            <span class="info-value text-xs">${member.agama}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-label text-xs">Pendidikan</span>
                            <span class="info-value text-xs">${member.pendidikan}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-label text-xs">Pekerjaan</span>
                            <span class="info-value text-xs">${member.pekerjaan}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-label text-xs">Status</span>
                            <span class="info-value">
                                <span class="px-2 py-1 bg-green-100 text-green-800 text-xs rounded-full font-medium">${member.status}</span>
                            </span>
                        </div>
                    </div>
                    
                    <button onclick="closeModal()" class="w-full bg-gray-600 text-white py-2.5 rounded-xl text-sm font-semibold hover:bg-gray-700 transition-all mt-5">
                        Tutup
                    </button>
                </div>
            `;
            
            document.body.appendChild(modal);
        }

        // Navigation functions
        function goBack() {
            window.location.href = '/dashboard-warga';
        }

        function goToDashboard() {
            window.location.href = '/dashboard-warga';
        }

        function goToServices() {
            Swal.fire({
                icon: 'info',
                title: 'Segera Hadir',
                text: 'Fitur layanan akan segera tersedia',
                confirmButtonText: 'OK'
            });
        }

        function goToTracking() {
            Swal.fire({
                icon: 'info',
                title: 'Segera Hadir',
                text: 'Fitur tracking akan segera tersedia',
                confirmButtonText: 'OK'
            });
        }

        // Action functions
        function editProfile() {
            showEditProfileModal();
        }

        function changePassword() {
            showChangePasswordModal();
        }

        function updatePhoto() {
            showPhotoUploadModal('profile');
        }

        function printKK() {
            Swal.fire({
                icon: 'info',
                title: 'Segera Hadir',
                text: 'Fitur cetak KK akan segera tersedia',
                confirmButtonText: 'OK'
            });
        }

        function requestUpdate() {
            Swal.fire({
                icon: 'info',
                title: 'Segera Hadir',
                text: 'Fitur ajukan perubahan data akan segera tersedia',
                confirmButtonText: 'OK'
            });
        }

        function editMember(index) {
            showEditMemberModal(index);
        }
        
        // Show edit profile modal
        function showEditProfileModal() {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4';
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-5 w-full max-w-sm">
                    <div class="text-center mb-5">
                        <div class="w-14 h-14 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-3">
                            <i class="fas fa-edit text-blue-600 text-xl"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-800">Edit Profil</h3>
                        <p class="text-gray-600 text-xs">Ubah informasi profil Anda</p>
                    </div>
                    
                    <div class="space-y-3">
                        <button onclick="updatePhoto(); closeModal();" class="w-full flex items-center justify-center space-x-2 bg-blue-50 text-blue-600 py-2.5 rounded-xl hover:bg-blue-100 transition-colors text-sm">
                            <i class="fas fa-camera text-sm"></i>
                            <span>Ubah Foto Profil</span>
                        </button>
                        
                        <button onclick="changePassword(); closeModal();" class="w-full flex items-center justify-center space-x-2 bg-green-50 text-green-600 py-2.5 rounded-xl hover:bg-green-100 transition-colors text-sm">
                            <i class="fas fa-key text-sm"></i>
                            <span>Ubah Password</span>
                        </button>
                        
                        <button onclick="showCustomAlert('info', 'Segera Hadir', 'Fitur edit data pribadi akan segera tersedia'); closeModal();" class="w-full flex items-center justify-center space-x-2 bg-purple-50 text-purple-600 py-2.5 rounded-xl hover:bg-purple-100 transition-colors text-sm">
                            <i class="fas fa-user-edit text-sm"></i>
                            <span>Edit Data Pribadi</span>
                        </button>
                    </div>
                    
                    <button onclick="closeModal()" class="w-full text-gray-500 py-2 font-medium mt-4 text-sm">
                        Batalkan
                    </button>
                </div>
            `;
            
            document.body.appendChild(modal);
        }
        
        // Show change password modal
        function showChangePasswordModal() {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4';
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-5 w-full max-w-sm">
                    <div class="text-center mb-5">
                        <div class="w-14 h-14 bg-yellow-100 rounded-full flex items-center justify-center mx-auto mb-3">
                            <i class="fas fa-key text-yellow-600 text-xl"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-800">Ubah Password</h3>
                        <p class="text-gray-600 text-xs">Masukkan password baru untuk keamanan akun</p>
                    </div>
                    
                    <div class="space-y-3">
                        <div>
                            <label class="block text-xs font-medium text-gray-700 mb-1">Password Lama</label>
                            <input type="password" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 text-sm" placeholder="Masukkan password lama">
                        </div>
                        
                        <div>
                            <label class="block text-xs font-medium text-gray-700 mb-1">Password Baru</label>
                            <input type="password" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 text-sm" placeholder="Masukkan password baru">
                        </div>
                        
                        <div>
                            <label class="block text-xs font-medium text-gray-700 mb-1">Konfirmasi Password</label>
                            <input type="password" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 text-sm" placeholder="Konfirmasi password baru">
                        </div>
                        
                        <button onclick="showCustomAlert('info', 'Segera Hadir', 'Fitur ubah password akan segera tersedia'); closeModal();" class="w-full bg-yellow-600 text-white py-2.5 rounded-xl font-semibold hover:bg-yellow-700 transition-all text-sm">
                            Ubah Password
                        </button>
                    </div>
                    
                    <button onclick="closeModal()" class="w-full text-gray-500 py-2 font-medium mt-4 text-sm">
                        Batalkan
                    </button>
                </div>
            `;
            
            document.body.appendChild(modal);
        }
        
        // Show photo upload modal
        function showPhotoUploadModal(type, memberIndex = null) {
            const isProfile = type === 'profile';
            const memberName = isProfile ? 'Profil Anda' : familyData[memberIndex].nama;
            
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4';
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-5 w-full max-w-sm">
                    <div class="text-center mb-5">
                        <div class="w-14 h-14 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-3">
                            <i class="fas fa-camera text-green-600 text-xl"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-800">Ubah Foto</h3>
                        <p class="text-gray-600 text-xs">Upload foto untuk ${memberName}</p>
                    </div>
                    
                    <div class="space-y-3">
                        <div class="border-2 border-dashed border-gray-300 rounded-xl p-4 text-center">
                            <i class="fas fa-cloud-upload-alt text-gray-400 text-2xl mb-2"></i>
                            <p class="text-gray-600 text-xs mb-1">Klik untuk pilih foto atau drag & drop</p>
                            <p class="text-gray-400 text-xs">Format: JPG, PNG (Max: 2MB)</p>
                            <input type="file" accept="image/*" class="hidden" id="photoInput">
                        </div>
                        
                        <div class="grid grid-cols-2 gap-2">
                            <button onclick="document.getElementById('photoInput').click()" class="flex items-center justify-center space-x-1 bg-blue-50 text-blue-600 py-2 px-2 rounded-lg hover:bg-blue-100 transition-colors text-xs">
                                <i class="fas fa-upload text-xs"></i>
                                <span>Pilih File</span>
                            </button>
                            
                            <button onclick="showCustomAlert('info', 'Segera Hadir', 'Fitur kamera akan segera tersedia')" class="flex items-center justify-center space-x-1 bg-green-50 text-green-600 py-2 px-2 rounded-lg hover:bg-green-100 transition-colors text-xs">
                                <i class="fas fa-camera text-xs"></i>
                                <span>Kamera</span>
                            </button>
                        </div>
                        
                        <button onclick="showCustomAlert('info', 'Segera Hadir', 'Fitur upload foto akan segera tersedia'); closeModal();" class="w-full bg-green-600 text-white py-2.5 rounded-xl font-semibold hover:bg-green-700 transition-all text-sm">
                            Upload Foto
                        </button>
                    </div>
                    
                    <button onclick="closeModal()" class="w-full text-gray-500 py-2 font-medium mt-4 text-sm">
                        Batalkan
                    </button>
                </div>
            `;
            
            document.body.appendChild(modal);
        }
        
        // Show edit member modal
        function showEditMemberModal(index) {
            const member = familyData[index];
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4';
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-5 w-full max-w-sm">
                    <div class="text-center mb-5">
                        <div class="w-14 h-14 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-3">
                            <i class="fas fa-camera text-blue-600 text-xl"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-800">Ubah Foto</h3>
                        <p class="text-gray-600 text-xs">${member.nama} - ${member.hubungan}</p>
                    </div>
                    
                    <div class="space-y-3">
                        <div class="p-3 bg-blue-50 rounded-xl text-center">
                            <i class="fas fa-info-circle text-blue-600 mb-1 text-sm"></i>
                            <p class="text-xs text-gray-700">Anda hanya dapat mengubah foto anggota keluarga</p>
                        </div>
                        
                        <button onclick="showPhotoUploadModal('member', ${index}); closeModal();" class="w-full flex items-center justify-center space-x-2 bg-blue-600 text-white py-2.5 rounded-xl hover:bg-blue-700 transition-colors text-sm">
                            <i class="fas fa-camera text-sm"></i>
                            <span>Ubah Foto</span>
                        </button>
                    </div>
                    
                    <button onclick="closeModal()" class="w-full text-gray-500 py-2 font-medium mt-4 text-sm">
                        Tutup
                    </button>
                </div>
            `;
            
            document.body.appendChild(modal);
        }

        // Close modal
        function closeModal() {
            const modals = document.querySelectorAll('.fixed.inset-0');
            modals.forEach(modal => {
                if (modal.classList.contains('bg-black')) {
                    modal.remove();
                }
            });
        }

        // Navigation functions
        function navigateToHome() {
            window.location.href = '/';
        }

        function navigateToBerita() {
            window.location.href = '/berita';
        }

        function navigateToWisata() {
            window.location.href = '/wisata';
        }

        function navigateToUmkm() {
            window.location.href = '/produk-umkm';
        }

        function goBack() {
            if (document.referrer && document.referrer !== window.location.href) {
                window.history.back();
            } else {
                window.location.href = '/layanan-mandiri';
            }
        }

        // Custom Alert Modal Function
        function showCustomAlert(type, title, message, callback) {
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 z-50';
            modal.style.cssText = `
                display: flex !important;
                align-items: center !important;
                justify-content: center !important;
                min-height: 100vh !important;
                padding: 1rem !important;
            `;
            
            let iconClass, iconColor, buttonColor;
            switch(type) {
                case 'warning':
                    iconClass = 'fas fa-exclamation-triangle';
                    iconColor = 'yellow';
                    buttonColor = 'yellow';
                    break;
                case 'error':
                    iconClass = 'fas fa-times-circle';
                    iconColor = 'red';
                    buttonColor = 'red';
                    break;
                case 'success':
                    iconClass = 'fas fa-check-circle';
                    iconColor = 'green';
                    buttonColor = 'green';
                    break;
                case 'info':
                default:
                    iconClass = 'fas fa-info-circle';
                    iconColor = 'blue';
                    buttonColor = 'blue';
                    break;
            }
            
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm mx-auto my-auto" style="margin: auto;">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-${iconColor}-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="${iconClass} text-${iconColor}-600 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">${title}</h3>
                        <p class="text-gray-600 text-sm">${message}</p>
                    </div>
                    
                    <button onclick="closeCustomAlert()" class="w-full bg-${buttonColor}-600 text-white py-3 rounded-xl font-semibold hover:bg-${buttonColor}-700 transition-all">
                        OK
                    </button>
                </div>
            `;
            
            modal.id = 'customAlertModal';
            document.body.appendChild(modal);
            
            // Store callback for when modal is closed
            window.customAlertCallback = callback;
        }

        // Close Custom Alert Modal
        function closeCustomAlert() {
            const modal = document.getElementById('customAlertModal');
            if (modal) {
                modal.remove();
            }
            
            // Execute callback if provided
            if (window.customAlertCallback) {
                window.customAlertCallback();
                window.customAlertCallback = null;
            }
        }
    </script>
</body>
</html> 