@extends('layouts.public')

@section('title', 'Tentang Desa')

@section('content')
<section class="py-5 bg-primary text-white">
    <div class="container">
        <div class="row">
            <div class="col-12 text-center">
                <h1 class="display-4 fw-bold mb-3">Tentang Desa</h1>
                <p class="lead">Profil dan informasi lengkap tentang desa kami</p>
            </div>
        </div>
    </div>
</section>

<section class="py-5">
    <div class="container">
        <div class="row">
            <!-- Village Profile -->
            <div class="col-lg-8 mb-4">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="fas fa-home me-2"></i>Profil Desa</h5>
                    </div>
                    <div class="card-body">
                        @if($setting ?? null)
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <strong>Nama Desa:</strong><br>
                                    {{ $setting->nama_desa ?? 'Desa Digital' }}
                                </div>
                                <div class="col-md-6 mb-3">
                                    <strong>Kecamatan:</strong><br>
                                    {{ $setting->kecamatan ?? '-' }}
                                </div>
                                <div class="col-md-6 mb-3">
                                    <strong>Kabupaten:</strong><br>
                                    {{ $setting->kabupaten ?? '-' }}
                                </div>
                                <div class="col-md-6 mb-3">
                                    <strong>Provinsi:</strong><br>
                                    {{ $setting->provinsi ?? '-' }}
                                </div>
                            </div>

                            @if($setting->visi)
                            <hr>
                            <h6 class="fw-bold text-primary">VISI</h6>
                            <p>{{ $setting->visi }}</p>
                            @endif

                            @if($setting->misi)
                            <h6 class="fw-bold text-primary">MISI</h6>
                            <p>{{ $setting->misi }}</p>
                            @endif

                            @if($setting->sejarah_desa)
                            <h6 class="fw-bold text-primary">SEJARAH DESA</h6>
                            <p>{{ $setting->sejarah_desa }}</p>
                            @endif
                        @else
                            <h4>Desa Digital</h4>
                            <p>Sistem informasi desa modern untuk pelayanan digital yang lebih baik kepada masyarakat.</p>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Quick Stats -->
            <div class="col-lg-4 mb-4">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0"><i class="fas fa-chart-bar me-2"></i>Data Desa</h5>
                    </div>
                    <div class="card-body">
                        @if($setting ?? null)
                            <div class="mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Luas Wilayah:</span>
                                    <strong>{{ $setting->luas_wilayah ?? '-' }} km²</strong>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Jumlah Penduduk:</span>
                                    <strong>{{ number_format($setting->jumlah_penduduk ?? 0) }} jiwa</strong>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Jumlah KK:</span>
                                    <strong>{{ number_format($setting->jumlah_kk ?? 0) }} KK</strong>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Jumlah RT:</span>
                                    <strong>{{ $setting->jumlah_rt ?? 0 }} RT</strong>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Jumlah RW:</span>
                                    <strong>{{ $setting->jumlah_rw ?? 0 }} RW</strong>
                                </div>
                            </div>
                            <div class="mb-3">
                                <div class="d-flex justify-content-between">
                                    <span>Jumlah Dusun:</span>
                                    <strong>{{ $setting->jumlah_dusun ?? 0 }} Dusun</strong>
                                </div>
                            </div>
                        @else
                            <p class="text-muted">Data belum tersedia</p>
                        @endif
                    </div>
                </div>

                <!-- Leadership -->
                @if($perangkat_desa->count() > 0)
                <div class="card border-0 shadow-sm mt-4">
                    <div class="card-header bg-warning text-dark">
                        <h5 class="mb-0"><i class="fas fa-user-tie me-2"></i>Pimpinan Desa</h5>
                    </div>
                    <div class="card-body">
                        @foreach($perangkat_desa->whereIn('jabatan', ['Kepala Desa', 'Sekretaris Desa']) as $perangkat)
                        <div class="mb-3">
                            <div class="d-flex align-items-center">
                                @if($perangkat->foto)
                                    <img src="{{ asset('storage/' . $perangkat->foto) }}" 
                                         alt="{{ $perangkat->nama }}" 
                                         class="rounded-circle me-3" 
                                         style="width: 50px; height: 50px; object-fit: cover;">
                                @else
                                    <div class="rounded-circle bg-primary text-white d-flex align-items-center justify-content-center me-3" 
                                         style="width: 50px; height: 50px;">
                                        <i class="fas fa-user"></i>
                                    </div>
                                @endif
                                <div>
                                    <strong>{{ $perangkat->jabatan }}:</strong><br>
                                    {{ $perangkat->nama }}
                                    @if($perangkat->nip)
                                        <br><small class="text-muted">NIP: {{ $perangkat->nip }}</small>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endforeach
                        
                        @if($perangkat_desa->whereNotIn('jabatan', ['Kepala Desa', 'Sekretaris Desa'])->count() > 0)
                        <hr>
                        <h6 class="fw-bold text-primary mb-3">Perangkat Desa Lainnya</h6>
                        <div class="row">
                            @foreach($perangkat_desa->whereNotIn('jabatan', ['Kepala Desa', 'Sekretaris Desa'])->take(6) as $perangkat)
                            <div class="col-md-6 mb-2">
                                <div class="d-flex align-items-center">
                                    @if($perangkat->foto)
                                        <img src="{{ asset('storage/' . $perangkat->foto) }}" 
                                             alt="{{ $perangkat->nama }}" 
                                             class="rounded-circle me-2" 
                                             style="width: 35px; height: 35px; object-fit: cover;">
                                    @else
                                        <div class="rounded-circle bg-secondary text-white d-flex align-items-center justify-content-center me-2" 
                                             style="width: 35px; height: 35px; font-size: 12px;">
                                            {{ strtoupper(substr($perangkat->nama, 0, 1)) }}
                                        </div>
                                    @endif
                                    <div>
                                        <small class="fw-bold">{{ $perangkat->nama }}</small><br>
                                        <small class="text-muted">{{ $perangkat->jabatan }}</small>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        @endif
                    </div>
                </div>
                @elseif($setting ?? null)
                <div class="card border-0 shadow-sm mt-4">
                    <div class="card-header bg-warning text-dark">
                        <h5 class="mb-0"><i class="fas fa-user-tie me-2"></i>Pimpinan Desa</h5>
                    </div>
                    <div class="card-body">
                        @if($setting->kepala_desa)
                        <div class="mb-3">
                            <strong>Kepala Desa:</strong><br>
                            {{ $setting->kepala_desa }}
                            @if($setting->nip_kepala_desa)
                                <br><small class="text-muted">NIP: {{ $setting->nip_kepala_desa }}</small>
                            @endif
                        </div>
                        @endif

                        @if($setting->sekretaris_desa)
                        <div class="mb-3">
                            <strong>Sekretaris Desa:</strong><br>
                            {{ $setting->sekretaris_desa }}
                            @if($setting->nip_sekretaris)
                                <br><small class="text-muted">NIP: {{ $setting->nip_sekretaris }}</small>
                            @endif
                        </div>
                        @endif
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
</section>
@endsection 
