<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Surat Online - Portal Warga</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <style>
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .mobile-card {
            background: white;
            border-radius: 1rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
            padding: 1.5rem;
        }
        
        .service-card {
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .service-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px -5px rgba(0, 0, 0, 0.1);
        }

        .form-input {
            width: 100%;
            padding: 0.75rem;
            border: 1px solid #e5e7eb;
            border-radius: 0.5rem;
            font-size: 0.875rem;
            transition: all 0.2s ease;
        }

        .form-input:focus {
            outline: none;
            border-color: #3b82f6;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        }

        .btn-primary {
            background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
            color: white;
            padding: 0.75rem 1.5rem;
            border-radius: 0.75rem;
            font-weight: 600;
            text-align: center;
            transition: all 0.2s ease;
            border: none;
            cursor: pointer;
        }

        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.4);
        }

        .btn-secondary {
            background: #f3f4f6;
            color: #374151;
            padding: 0.75rem 1.5rem;
            border-radius: 0.75rem;
            font-weight: 500;
            text-align: center;
            transition: all 0.2s ease;
            border: none;
            cursor: pointer;
        }

        .btn-secondary:hover {
            background: #e5e7eb;
        }

        .loading {
            opacity: 0.7;
            pointer-events: none;
        }

        .success-animation {
            animation: successPulse 0.6s ease-out;
        }

        @keyframes successPulse {
            0% { transform: scale(0.8); opacity: 0; }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); opacity: 1; }
        }

        .requirement-item {
            display: flex;
            align-items: flex-start;
            gap: 0.5rem;
            padding: 0.5rem;
            border-radius: 0.5rem;
            transition: background-color 0.2s ease;
        }

        .requirement-item:hover {
            background-color: #f9fafb;
        }
    </style>
</head>
<body>
    <div class="min-h-screen max-w-md mx-auto bg-white relative">
        <!-- Header with user info (matching dashboard-warga) -->
        <div class="bg-gradient-to-r from-blue-600 to-purple-700 text-white p-6">
            <div class="flex items-center justify-between mb-4">
                <div class="flex items-center space-x-3">
                    <div class="w-12 h-12 bg-white/20 rounded-full flex items-center justify-center overflow-hidden relative">
                        <img id="userAvatar" src="" alt="User Avatar" class="w-full h-full object-cover rounded-full hidden">
                        <div id="userInitials" class="w-full h-full bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center hidden">
                            <span class="text-white font-bold text-sm" id="initialsText"></span>
                        </div>
                        <i id="defaultIcon" class="fas fa-user text-white text-xl"></i>
                    </div>
                    <div>
                        <h1 class="text-lg font-bold">Surat Online</h1>
                        <p class="text-white/80 text-sm" id="userName">Loading...</p>
                    </div>
                </div>
                <button onclick="goBackToDashboard()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center">
                    <i class="fas fa-arrow-left text-white"></i>
                </button>
            </div>

            <!-- Quick Stats -->
            <div class="grid grid-cols-3 gap-3">
                <div class="bg-white/20 rounded-xl p-3 text-center">
                    <div class="text-xl font-bold text-white">24/7</div>
                    <div class="text-white/80 text-xs">Tersedia</div>
                </div>
                <div class="bg-white/20 rounded-xl p-3 text-center">
                    <div class="text-xl font-bold text-white">3-5</div>
                    <div class="text-white/80 text-xs">Hari Kerja</div>
                </div>
                <div class="bg-white/20 rounded-xl p-3 text-center">
                    <div class="text-xl font-bold text-white">Gratis</div>
                    <div class="text-white/80 text-xs">Biaya</div>
                </div>
            </div>
        </div>

        <!-- Main Content -->
        <div class="px-6 -mt-6 relative z-20 mb-6">
            <!-- Jenis Surat -->
            <div class="mobile-card mb-6">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Pilih Jenis Surat</h3>
                
                <div class="grid grid-cols-1 gap-3">
                    <button onclick="selectSurat('Surat Keterangan Domisili')" class="surat-option flex items-center space-x-3 p-4 border border-gray-200 rounded-xl hover:border-blue-300 hover:bg-blue-50 transition-all" data-surat="Surat Keterangan Domisili">
                        <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-home text-blue-600"></i>
                        </div>
                        <div class="flex-1 text-left">
                            <h4 class="font-semibold text-gray-800">Surat Keterangan Domisili</h4>
                            <p class="text-gray-500 text-sm">Untuk keperluan administrasi tempat tinggal</p>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </button>

                    <button onclick="selectSurat('Surat Keterangan Usaha')" class="surat-option flex items-center space-x-3 p-4 border border-gray-200 rounded-xl hover:border-green-300 hover:bg-green-50 transition-all" data-surat="Surat Keterangan Usaha">
                        <div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-briefcase text-green-600"></i>
                        </div>
                        <div class="flex-1 text-left">
                            <h4 class="font-semibold text-gray-800">Surat Keterangan Usaha</h4>
                            <p class="text-gray-500 text-sm">Untuk keperluan perizinan usaha/bisnis</p>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </button>

                    <button onclick="selectSurat('Surat Keterangan Tidak Mampu')" class="surat-option flex items-center space-x-3 p-4 border border-gray-200 rounded-xl hover:border-yellow-300 hover:bg-yellow-50 transition-all" data-surat="Surat Keterangan Tidak Mampu">
                        <div class="w-12 h-12 bg-yellow-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-hand-holding-heart text-yellow-600"></i>
                        </div>
                        <div class="flex-1 text-left">
                            <h4 class="font-semibold text-gray-800">Surat Keterangan Tidak Mampu</h4>
                            <p class="text-gray-500 text-sm">Untuk bantuan sosial dan beasiswa</p>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </button>

                    <button onclick="selectSurat('Surat Keterangan Penghasilan')" class="surat-option flex items-center space-x-3 p-4 border border-gray-200 rounded-xl hover:border-purple-300 hover:bg-purple-50 transition-all" data-surat="Surat Keterangan Penghasilan">
                        <div class="w-12 h-12 bg-purple-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-money-bill-wave text-purple-600"></i>
                        </div>
                        <div class="flex-1 text-left">
                            <h4 class="font-semibold text-gray-800">Surat Keterangan Penghasilan</h4>
                            <p class="text-gray-500 text-sm">Untuk keperluan kredit dan administrasi</p>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </button>

                    <button onclick="selectSurat('SKCK')" class="surat-option flex items-center space-x-3 p-4 border border-gray-200 rounded-xl hover:border-indigo-300 hover:bg-indigo-50 transition-all" data-surat="SKCK">
                        <div class="w-12 h-12 bg-indigo-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-shield-alt text-indigo-600"></i>
                        </div>
                        <div class="flex-1 text-left">
                            <h4 class="font-semibold text-gray-800">Surat Pengantar SKCK</h4>
                            <p class="text-gray-500 text-sm">Untuk keperluan kepolisian</p>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </button>

                    <button onclick="selectSurat('Lainnya')" class="surat-option flex items-center space-x-3 p-4 border border-gray-200 rounded-xl hover:border-gray-300 hover:bg-gray-50 transition-all" data-surat="Lainnya">
                        <div class="w-12 h-12 bg-gray-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-file-alt text-gray-600"></i>
                        </div>
                        <div class="flex-1 text-left">
                            <h4 class="font-semibold text-gray-800">Surat Lainnya</h4>
                            <p class="text-gray-500 text-sm">Jenis surat yang tidak tersedia di atas</p>
                        </div>
                        <i class="fas fa-chevron-right text-gray-400"></i>
                    </button>
                </div>
            </div>

            <!-- Form Pengajuan (Hidden initially) -->
            <div id="formPengajuan" class="mobile-card mb-6" style="display: none;">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Form Pengajuan</h3>
                
                <form id="suratForm" class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Jenis Surat</label>
                        <input type="text" id="jenisSurat" class="form-input bg-gray-50" readonly>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">NIK <span class="text-red-500">*</span></label>
                        <input type="text" id="nik" class="form-input" placeholder="Masukkan NIK 16 digit" maxlength="16" required>
                        <p class="text-xs text-gray-500 mt-1">NIK harus terdaftar di sistem</p>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Nama Lengkap <span class="text-red-500">*</span></label>
                        <input type="text" id="nama" class="form-input" placeholder="Nama sesuai KTP" required>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Keperluan <span class="text-red-500">*</span></label>
                        <textarea id="keperluan" class="form-input" rows="3" placeholder="Jelaskan keperluan surat ini..." required></textarea>
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Berkas Pendukung</label>
                        <input type="file" id="berkasPendukung" class="form-input" accept=".pdf,.jpg,.jpeg,.png" multiple>
                        <p class="text-xs text-gray-500 mt-1">Format: PDF, JPG, PNG (Max 2MB per file)</p>
                    </div>

                    <div class="flex space-x-3">
                        <button type="button" onclick="hideForm()" class="flex-1 btn-secondary">
                            <i class="fas fa-arrow-left mr-2"></i>Kembali
                        </button>
                        <button type="submit" class="flex-1 btn-primary">
                            <i class="fas fa-paper-plane mr-2"></i>Ajukan Surat
                        </button>
                    </div>
                </form>
            </div>

            <!-- Persyaratan (Hidden initially) -->
            <div id="persyaratan" class="mobile-card mb-6" style="display: none;">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Persyaratan</h3>
                
                <div class="space-y-3" id="persyaratanList">
                    <!-- Will be populated by JavaScript -->
                </div>

                <div class="mt-4 p-3 bg-blue-50 rounded-xl">
                    <div class="flex items-center space-x-2 mb-2">
                        <i class="fas fa-info-circle text-blue-600"></i>
                        <h4 class="font-semibold text-blue-800 text-sm">Informasi Penting</h4>
                    </div>
                    <ul class="text-xs text-blue-700 space-y-1">
                        <li>• Estimasi selesai: 3-5 hari kerja</li>
                        <li>• Biaya: Gratis</li>
                        <li>• Notifikasi via WhatsApp</li>
                        <li>• Ambil surat di kantor desa</li>
                    </ul>
                </div>
            </div>

            <!-- Status Tracking -->
            <div class="mobile-card mb-6">
                <h3 class="text-lg font-semibold text-gray-800 mb-4">Lacak Status Surat</h3>
                
                <div class="flex space-x-2">
                    <input type="text" id="nomorAntrian" class="flex-1 form-input" placeholder="Masukkan nomor antrian">
                    <button onclick="trackStatus()" class="btn-primary px-4">
                        <i class="fas fa-search"></i>
                    </button>
                </div>
                
                <div id="trackingResult" class="mt-4" style="display: none;">
                    <!-- Will show tracking result -->
                </div>
            </div>
        </div>

        <!-- Bottom Navigation (matching dashboard-warga) -->
        <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-100 px-4 py-3 z-50 shadow-lg backdrop-blur-sm bg-white/95">
            <div class="flex justify-around items-center">
                <button onclick="navigateToHome()" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-home text-lg"></i>
                    </div>
                    <span class="text-xs">Beranda</span>
                </button>
                
                <button onclick="navigateToBerita()" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-newspaper text-lg"></i>
                    </div>
                    <span class="text-xs">Berita</span>
                </button>
                
                <button onclick="navigateToWisata()" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-map-marked-alt text-lg"></i>
                    </div>
                    <span class="text-xs">Wisata</span>
                </button>
                
                <button onclick="navigateToUmkm()" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-store text-lg"></i>
                    </div>
                    <span class="text-xs">UMKM</span>
                </button>
                
                <button onclick="goBackToDashboard()" class="flex flex-col items-center space-y-1.5 text-blue-600 transition-all duration-200">
                    <div class="bg-blue-50 p-2 rounded-xl">
                        <i class="fas fa-user-shield text-lg"></i>
                    </div>
                    <span class="text-xs font-semibold">Portal</span>
                </button>
            </div>
        </div>

        <!-- Spacer for bottom navigation -->
        <div class="h-20"></div>

        <!-- Success Modal -->
        <div id="successModal" class="fixed inset-0 bg-black bg-opacity-50 z-50" style="display: none;">
            <div class="flex items-center justify-center min-h-screen p-4">
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm success-animation">
                    <div class="text-center mb-6">
                        <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-check text-green-600 text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-800 mb-2">Berhasil Diajukan!</h3>
                        <p class="text-gray-600 text-sm">Pengajuan surat Anda telah diterima</p>
                    </div>
                    
                    <div class="space-y-3">
                        <div class="p-3 bg-green-50 rounded-xl">
                            <p class="text-sm text-green-800 mb-1"><strong>Nomor Antrian:</strong></p>
                            <p class="text-lg font-bold text-green-600" id="nomorAntrianResult">-</p>
                        </div>
                        
                        <div class="p-3 bg-blue-50 rounded-xl">
                            <p class="text-xs text-blue-700">
                                <i class="fas fa-info-circle mr-1"></i>
                                Simpan nomor antrian untuk melacak status pengajuan Anda
                            </p>
                        </div>
                        
                        <button onclick="closeSuccessModal()" class="w-full btn-primary">
                            Selesai
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // CSRF Token setup
        const csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute('content');
        
        // Global variables
        let selectedSurat = '';
        let currentForm = null;

        // Check authentication and load user data (same as dashboard-warga)
        document.addEventListener('DOMContentLoaded', function() {
            checkAuthentication();
            loadUserData();
            
            // Simple fade-in animation for cards
            const cards = document.querySelectorAll('.mobile-card');
            cards.forEach((card, index) => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(20px)';
                setTimeout(() => {
                    card.style.transition = 'all 0.5s ease';
                    card.style.opacity = '1';
                    card.style.transform = 'translateY(0)';
                }, index * 100);
            });
        });

        // Check if user is authenticated (same as dashboard-warga)
        function checkAuthentication() {
            const portalToken = localStorage.getItem('portal_token');
            const portalUser = localStorage.getItem('portal_user');
            const portalNik = localStorage.getItem('portal_nik');
            
            if (!portalToken || !portalUser || !portalNik) {
                showCustomAlert('warning', 'Belum Login', 'Anda belum login. Silakan login terlebih dahulu.', function() {
                    window.location.href = '/layanan-mandiri';
                });
                return;
            }
            
            // Validate user data
            try {
                const userData = JSON.parse(portalUser);
                if (!userData.nik || userData.nik !== portalNik) {
                    throw new Error('Invalid user data');
                }
            } catch (error) {
                console.error('Invalid user data:', error);
                localStorage.removeItem('portal_token');
                localStorage.removeItem('portal_user');
                localStorage.removeItem('portal_nik');
                showCustomAlert('error', 'Data Tidak Valid', 'Data login tidak valid. Silakan login ulang.', function() {
                    window.location.href = '/layanan-mandiri';
                });
                return;
            }
        }

        // Load user data from localStorage (same as dashboard-warga)
        function loadUserData() {
            try {
                const portalUser = localStorage.getItem('portal_user');
                if (portalUser) {
                    const userData = JSON.parse(portalUser);
                    document.getElementById('userName').textContent = userData.nama || 'Warga';
                    
                    // Fetch real user data from database
                    fetchUserData(userData.nik);
                }
            } catch (error) {
                console.error('Error loading user data:', error);
                document.getElementById('userName').textContent = 'Warga';
                showDefaultAvatar();
            }
        }

        // Fetch user data from API (same as dashboard-warga)
        async function fetchUserData(nik) {
            try {
                const response = await fetch('/api/v1/portal/user-data', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({ nik: nik })
                });
                
                const result = await response.json();
                
                if (result.success && result.data) {
                    // Update user data with real data from database
                    const realUserData = result.data;
                    
                    // Update user name
                    document.getElementById('userName').textContent = realUserData.nama || 'Warga';
                    
                    // Load user avatar with real photo data
                    loadUserAvatar(realUserData);
                } else {
                    console.error('Failed to fetch user data:', result.message);
                    // Fallback to default avatar
                    showDefaultAvatar();
                }
            } catch (error) {
                console.error('Error fetching user data:', error);
                // Fallback to default avatar
                showDefaultAvatar();
            }
        }

        // Load user avatar (same pattern as dashboard-warga)
        function loadUserAvatar(userData) {
            const avatarContainer = document.querySelector('.w-12.h-12.bg-white\\/20.rounded-full');
            const profilePhoto = userData.foto; // Real photo from database
            
            if (profilePhoto && profilePhoto.trim() !== '') {
                // Show photo with fallback to initials
                avatarContainer.innerHTML = `<img src="/storage/${profilePhoto}" alt="Foto Profil" class="w-full h-full object-cover rounded-full" onerror="this.style.display='none'; this.parentNode.innerHTML='${getInitials(userData.nama || 'NN')}'">`;
            } else {
                // Show initials
                const initials = getInitials(userData.nama || 'NN');
                avatarContainer.innerHTML = `<div class="w-full h-full bg-gradient-to-br from-blue-500 to-purple-600 rounded-full flex items-center justify-center"><span class="text-white font-bold text-sm">${initials}</span></div>`;
            }
        }

        // Get user initials (same as dashboard-warga)
        function getInitials(name) {
            return name.split(' ').map(word => word.charAt(0)).join('').substring(0, 2).toUpperCase();
        }

        // Show default avatar (same as dashboard-warga)
        function showDefaultAvatar() {
            const avatarContainer = document.querySelector('.w-12.h-12.bg-white\\/20.rounded-full');
            avatarContainer.innerHTML = '<i class="fas fa-user text-white text-xl"></i>';
        }

        // Navigation Functions (same as dashboard-warga)
        function navigateToHome() {
            window.location.href = '/';
        }

        function navigateToBerita() {
            window.location.href = '/berita';
        }

        function navigateToWisata() {
            window.location.href = '/wisata';
        }

        function navigateToUmkm() {
            window.location.href = '/produk-umkm';
        }

        function goBackToDashboard() {
            window.location.href = '/dashboard-warga';
        }

        // Custom Alert Function (same as dashboard-warga)
        function showCustomAlert(type, title, message, callback) {
            const colors = {
                success: 'green',
                error: 'red',
                warning: 'yellow',
                info: 'blue'
            };
            
            const color = colors[type] || 'blue';
            const icons = {
                success: 'fa-check-circle',
                error: 'fa-times-circle',
                warning: 'fa-exclamation-triangle',
                info: 'fa-info-circle'
            };
            
            const icon = icons[type] || 'fa-info-circle';
            
            const modal = document.createElement('div');
            modal.className = 'fixed inset-0 bg-black bg-opacity-50 z-50';
            modal.style.display = 'flex';
            modal.style.alignItems = 'center';
            modal.style.justifyContent = 'center';
            modal.style.padding = '1rem';
            
            modal.innerHTML = `
                <div class="bg-white rounded-2xl p-6 w-full max-w-sm">
                    <div class="text-center mb-4">
                        <div class="w-12 h-12 bg-${color}-100 rounded-full flex items-center justify-center mx-auto mb-3">
                            <i class="fas ${icon} text-${color}-600 text-xl"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-800 mb-2">${title}</h3>
                        <p class="text-gray-600 text-sm">${message}</p>
                    </div>
                    <button onclick="this.closest('.fixed').remove(); ${callback ? 'callback()' : ''}" class="w-full btn-primary">
                        OK
                    </button>
                </div>
            `;
            
            document.body.appendChild(modal);
        }

        // Persyaratan untuk setiap jenis surat
        const persyaratanData = {
            'Surat Keterangan Domisili': [
                'Fotocopy KTP yang masih berlaku',
                'Fotocopy Kartu Keluarga',
                'Surat pengantar RT/RW',
                'Materai 10.000'
            ],
            'Surat Keterangan Usaha': [
                'Fotocopy KTP yang masih berlaku',
                'Fotocopy Kartu Keluarga',
                'Surat pengantar RT/RW',
                'Foto tempat usaha',
                'Materai 10.000'
            ],
            'Surat Keterangan Tidak Mampu': [
                'Fotocopy KTP yang masih berlaku',
                'Fotocopy Kartu Keluarga',
                'Surat pengantar RT/RW',
                'Surat keterangan penghasilan',
                'Materai 10.000'
            ],
            'Surat Keterangan Penghasilan': [
                'Fotocopy KTP yang masih berlaku',
                'Fotocopy Kartu Keluarga',
                'Surat pengantar RT/RW',
                'Slip gaji/keterangan usaha',
                'Materai 10.000'
            ],
            'SKCK': [
                'Fotocopy KTP yang masih berlaku',
                'Fotocopy Kartu Keluarga',
                'Surat pengantar RT/RW',
                'Pas foto 4x6 (2 lembar)',
                'Materai 10.000'
            ],
            'Lainnya': [
                'Fotocopy KTP yang masih berlaku',
                'Fotocopy Kartu Keluarga',
                'Surat pengantar RT/RW',
                'Berkas pendukung sesuai keperluan',
                'Materai 10.000'
            ]
        };

        // Select surat function
        function selectSurat(jenisSurat) {
            selectedSurat = jenisSurat;
            
            // Update form
            document.getElementById('jenisSurat').value = jenisSurat;
            
            // Show persyaratan
            showPersyaratan(jenisSurat);
            
            // Show form
            document.getElementById('formPengajuan').style.display = 'block';
            document.getElementById('persyaratan').style.display = 'block';
            
            // Highlight selected option
            document.querySelectorAll('.surat-option').forEach(option => {
                option.classList.remove('border-blue-500', 'bg-blue-50');
            });
            
            document.querySelector(`[data-surat="${jenisSurat}"]`).classList.add('border-blue-500', 'bg-blue-50');
            
            // Scroll to form
            document.getElementById('formPengajuan').scrollIntoView({ behavior: 'smooth' });
        }

        // Show persyaratan
        function showPersyaratan(jenisSurat) {
            const persyaratanList = document.getElementById('persyaratanList');
            const requirements = persyaratanData[jenisSurat] || [];
            
            persyaratanList.innerHTML = requirements.map(req => `
                <div class="requirement-item">
                    <i class="fas fa-check-circle text-green-500 text-sm mt-0.5"></i>
                    <span class="text-sm text-gray-700">${req}</span>
                </div>
            `).join('');
        }

        // Hide form
        function hideForm() {
            document.getElementById('formPengajuan').style.display = 'none';
            document.getElementById('persyaratan').style.display = 'none';
            
            // Reset selection
            document.querySelectorAll('.surat-option').forEach(option => {
                option.classList.remove('border-blue-500', 'bg-blue-50');
            });
            
            selectedSurat = '';
        }

        // Form submission
        document.getElementById('suratForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalText = submitBtn.innerHTML;
            
            // Show loading
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Mengirim...';
            submitBtn.disabled = true;
            
            try {
                const formData = new FormData();
                formData.append('_token', csrfToken);
                formData.append('jenis_surat', document.getElementById('jenisSurat').value);
                formData.append('nik', document.getElementById('nik').value);
                formData.append('nama', document.getElementById('nama').value);
                formData.append('keperluan', document.getElementById('keperluan').value);
                
                // Add files
                const files = document.getElementById('berkasPendukung').files;
                for (let i = 0; i < files.length; i++) {
                    formData.append('berkas_pendukung', files[i]);
                }
                
                const response = await fetch('/ajukan-surat', {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-CSRF-TOKEN': csrfToken,
                        'Accept': 'application/json'
                    }
                });
                
                const result = await response.json();
                
                if (result.success) {
                    // Show success modal
                    document.getElementById('nomorAntrianResult').textContent = result.data.nomor_antrian;
                    document.getElementById('successModal').style.display = 'flex';
                    
                    // Reset form
                    this.reset();
                    hideForm();
                } else {
                    showCustomAlert('error', 'Gagal', result.message || 'Terjadi kesalahan saat mengirim pengajuan');
                }
                
            } catch (error) {
                console.error('Error:', error);
                showCustomAlert('error', 'Error', 'Terjadi kesalahan jaringan');
            } finally {
                // Reset button
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            }
        });

        // Track status function
        async function trackStatus() {
            const nomorAntrian = document.getElementById('nomorAntrian').value.trim();
            
            if (!nomorAntrian) {
                showCustomAlert('warning', 'Peringatan', 'Masukkan nomor antrian');
                return;
            }
            
            try {
                const response = await fetch('/cek-layanan', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': csrfToken,
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({
                        tipe: 'surat',
                        nomor_antrian: nomorAntrian
                    })
                });
                
                const result = await response.json();
                
                if (result.success) {
                    showTrackingResult(result.data);
                } else {
                    showCustomAlert('error', 'Tidak Ditemukan', result.message || 'Data tidak ditemukan');
                }
                
            } catch (error) {
                console.error('Error:', error);
                showCustomAlert('error', 'Error', 'Terjadi kesalahan saat melacak status');
            }
        }

        // Show tracking result
        function showTrackingResult(data) {
            const trackingResult = document.getElementById('trackingResult');
            const statusColor = getStatusColor(data.status);
            
            trackingResult.innerHTML = `
                <div class="p-4 bg-${statusColor}-50 border border-${statusColor}-200 rounded-xl">
                    <div class="flex items-center justify-between mb-3">
                        <h4 class="font-semibold text-gray-800">${data.jenis_surat}</h4>
                        <span class="px-2 py-1 bg-${statusColor}-100 text-${statusColor}-800 text-xs rounded-full font-medium">${data.status}</span>
                    </div>
                    <div class="space-y-2 text-sm text-gray-600">
                        <p><strong>Nomor Antrian:</strong> ${data.nomor_antrian}</p>
                        <p><strong>Tanggal Pengajuan:</strong> ${formatDate(data.tanggal_pengajuan)}</p>
                        <p><strong>Keperluan:</strong> ${data.keperluan}</p>
                        ${data.catatan ? `<p><strong>Catatan:</strong> ${data.catatan}</p>` : ''}
                    </div>
                </div>
            `;
            
            trackingResult.style.display = 'block';
        }

        // Get status color
        function getStatusColor(status) {
            switch(status) {
                case 'Menunggu': return 'yellow';
                case 'Diproses': return 'blue';
                case 'Selesai': return 'green';
                case 'Ditolak': return 'red';
                default: return 'gray';
            }
        }

        // Format date
        function formatDate(dateString) {
            const options = { 
                year: 'numeric', 
                month: 'long', 
                day: 'numeric',
                timeZone: 'Asia/Jakarta'
            };
            return new Date(dateString).toLocaleDateString('id-ID', options);
        }

        // Close success modal
        function closeSuccessModal() {
            document.getElementById('successModal').style.display = 'none';
        }

        // Auto-validate NIK
        document.getElementById('nik').addEventListener('input', function(e) {
            const nik = e.target.value.replace(/\D/g, '');
            e.target.value = nik;
            
            if (nik.length === 16) {
                // Here you could add NIK validation logic
                console.log('NIK valid:', nik);
            }
        });

        // File size validation
        document.getElementById('berkasPendukung').addEventListener('change', function(e) {
            const files = Array.from(e.target.files);
            const maxSize = 2 * 1024 * 1024; // 2MB
            
            for (let file of files) {
                if (file.size > maxSize) {
                    showCustomAlert('warning', 'File Terlalu Besar', `File ${file.name} melebihi batas 2MB`);
                    e.target.value = '';
                    break;
                }
            }
        });
    </script>
</body>
</html> <?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/frontend/surat-online.blade.php ENDPATH**/ ?>