

<?php $__env->startSection('title', 'Kelola Produk UMKM'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Kelola Produk UMKM</h1>
        <a href="<?php echo e(route('admin.produk-umkm.create')); ?>" class="btn btn-primary btn-icon-split">
            <span class="icon text-white-50"><i class="fas fa-plus"></i></span>
            <span class="text">Tambah Produk</span>
        </a>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Produk</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['total'] ?? 0); ?></div>
                        </div>
                        <div class="col-auto"><i class="fas fa-box fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Aktif</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['aktif'] ?? 0); ?></div>
                        </div>
                        <div class="col-auto"><i class="fas fa-check-circle fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Stok Menipis</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['stok_menipis'] ?? 0); ?></div>
                        </div>
                        <div class="col-auto"><i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Pending</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['pending'] ?? 0); ?></div>
                        </div>
                        <div class="col-auto"><i class="fas fa-clock fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter & Search -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter & Pencarian</h6>
        </div>
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('admin.produk-umkm.index')); ?>">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="search">Pencarian</label>
                            <input type="text" class="form-control" name="search" value="<?php echo e(request('search')); ?>" placeholder="Nama produk...">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" name="status">
                                <option value="">Semua Status</option>
                                <option value="aktif" <?php echo e(request('status') === 'aktif' ? 'selected' : ''); ?>>Aktif</option>
                                <option value="nonaktif" <?php echo e(request('status') === 'nonaktif' ? 'selected' : ''); ?>>Non-aktif</option>
                                <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="kategori">Kategori</label>
                            <select class="form-control" name="kategori">
                                <option value="">Semua Kategori</option>
                                <option value="makanan" <?php echo e(request('kategori') === 'makanan' ? 'selected' : ''); ?>>Makanan</option>
                                <option value="minuman" <?php echo e(request('kategori') === 'minuman' ? 'selected' : ''); ?>>Minuman</option>
                                <option value="kerajinan" <?php echo e(request('kategori') === 'kerajinan' ? 'selected' : ''); ?>>Kerajinan</option>
                                <option value="fashion" <?php echo e(request('kategori') === 'fashion' ? 'selected' : ''); ?>>Fashion</option>
                                <option value="elektronik" <?php echo e(request('kategori') === 'elektronik' ? 'selected' : ''); ?>>Elektronik</option>
                                <option value="lainnya" <?php echo e(request('kategori') === 'lainnya' ? 'selected' : ''); ?>>Lainnya</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="umkm">UMKM</label>
                            <select class="form-control" name="umkm_id">
                                <option value="">Semua UMKM</option>
                                <?php $__currentLoopData = $umkmList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $umkm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($umkm->id); ?>" <?php echo e(request('umkm_id') == $umkm->id ? 'selected' : ''); ?>>
                                        <?php echo e($umkm->nama_umkm); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div class="d-flex">
                                <button type="submit" class="btn btn-primary btn-sm mr-1"><i class="fas fa-search"></i></button>
                                <a href="<?php echo e(route('admin.produk-umkm.index')); ?>" class="btn btn-secondary btn-sm"><i class="fas fa-undo"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Data Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Produk UMKM</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th width="15%">Gambar</th>
                            <th width="20%">Produk</th>
                            <th width="15%">UMKM</th>
                            <th width="10%">Kategori</th>
                            <th width="12%">Harga</th>
                            <th width="8%">Stok</th>
                            <th width="8%">Status</th>
                            <th width="12%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $produkUmkm; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $produk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($produkUmkm->firstItem() + $index); ?></td>
                            <td>
                                <?php if($produk->gambar_utama): ?>
                                    <img src="<?php echo e(Storage::url($produk->gambar_utama)); ?>" 
                                         alt="<?php echo e($produk->nama); ?>" 
                                         class="img-thumbnail" 
                                         style="width: 70px; height: 50px; object-fit: cover;">
                                <?php else: ?>
                                    <div class="bg-light d-flex align-items-center justify-content-center" style="width: 70px; height: 50px;">
                                        <i class="fas fa-image text-muted"></i>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="font-weight-bold"><?php echo e($produk->nama); ?></div>
                                <small class="text-muted">SKU: <?php echo e($produk->sku); ?></small>
                                <?php if($produk->is_unggulan): ?>
                                    <br><span class="badge badge-warning badge-sm"><i class="fas fa-star"></i> Unggulan</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="font-weight-bold"><?php echo e($produk->umkm->nama_umkm); ?></div>
                                <small class="text-muted"><?php echo e($produk->umkm->pemilik); ?></small>
                            </td>
                            <td><span class="badge badge-info"><?php echo e(ucfirst($produk->kategori)); ?></span></td>
                            <td>
                                <div class="font-weight-bold">Rp <?php echo e(number_format($produk->harga)); ?></div>
                                <?php if($produk->harga_diskon > 0): ?>
                                    <small class="text-success">Diskon: Rp <?php echo e(number_format($produk->harga_diskon)); ?></small>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="font-weight-bold <?php if($produk->stok <= $produk->minimum_stok): ?> text-danger <?php elseif($produk->stok <= ($produk->minimum_stok * 2)): ?> text-warning <?php else: ?> text-success <?php endif; ?>">
                                    <?php echo e($produk->stok); ?>

                                </div>
                                <small class="text-muted">Min: <?php echo e($produk->minimum_stok); ?></small>
                            </td>
                            <td>
                                <?php if($produk->status === 'aktif'): ?>
                                    <span class="badge badge-success">Aktif</span>
                                <?php elseif($produk->status === 'pending'): ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php else: ?>
                                    <span class="badge badge-secondary">Non-aktif</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('admin.produk-umkm.show', $produk->id)); ?>" class="btn btn-info btn-sm" title="Detail">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.produk-umkm.edit', $produk->id)); ?>" class="btn btn-warning btn-sm" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <?php if($produk->status === 'pending'): ?>
                                        <button type="button" class="btn btn-success btn-sm" onclick="approveProduct(<?php echo e($produk->id); ?>)" title="Setujui">
                                            <i class="fas fa-check"></i>
                                        </button>
                                    <?php endif; ?>
                                    <button type="button" class="btn btn-danger btn-sm" onclick="deleteProduct(<?php echo e($produk->id); ?>)" title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center py-4">
                                <i class="fas fa-search fa-3x text-muted mb-3"></i>
                                <h5 class="text-muted">Tidak ada data produk</h5>
                                <p class="text-muted">Silakan tambah produk baru atau ubah filter pencarian</p>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <?php if($produkUmkm->hasPages()): ?>
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        Menampilkan <?php echo e($produkUmkm->firstItem()); ?> - <?php echo e($produkUmkm->lastItem()); ?> 
                        dari <?php echo e($produkUmkm->total()); ?> data
                    </div>
                    <?php echo e($produkUmkm->appends(request()->query())->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Konfirmasi Hapus</h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin menghapus produk ini?</p>
                <p class="text-danger"><small>Tindakan ini tidak dapat dibatalkan.</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function deleteProduct(id) {
    $('#deleteForm').attr('action', `/admin/produk-umkm/${id}`);
    $('#deleteModal').modal('show');
}

function approveProduct(id) {
    if (confirm('Setujui produk ini?')) {
        const form = $('<form>', {
            'method': 'POST',
            'action': `/admin/produk-umkm/${id}/approve`
        });
        form.append($('<input>', {'type': 'hidden', 'name': '_token', 'value': $('meta[name="csrf-token"]').attr('content')}));
        form.append($('<input>', {'type': 'hidden', 'name': '_method', 'value': 'PATCH'}));
        $('body').append(form);
        form.submit();
    }
}

// Auto-hide alerts
setTimeout(function() {
    $('.alert').fadeOut('slow');
}, 5000);
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/produk-umkm/index.blade.php ENDPATH**/ ?>