

<?php $__env->startSection('title', 'Detail Bantuan Sosial'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-hand-holding-heart me-2 text-primary"></i>Detail Bantuan Sosial
            </h2>
            <p class="text-muted mb-0">Informasi lengkap program bantuan #<?php echo e($bantuan->id ?? '1'); ?></p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.bantuan.index')); ?>" class="btn btn-outline-secondary me-2">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
            <a href="<?php echo e(route('admin.bantuan.edit', $bantuan->id ?? 1)); ?>" class="btn btn-warning">
                <i class="fas fa-edit me-2"></i>Edit
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-hand-holding-heart me-2"></i>Informasi Program</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Jenis Bantuan</label>
                                <div class="fw-bold"><?php echo e($bantuan->jenis_bantuan ?? 'Bantuan Langsung Tunai (BLT)'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Status</label>
                                <div>
                                    <span class="badge bg-success fs-6"><?php echo e($bantuan->status ?? 'Aktif'); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label text-muted">Nama Program</label>
                        <div class="fw-bold"><?php echo e($bantuan->nama_program ?? 'BLT Dana Desa 2024'); ?></div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label text-muted">Deskripsi</label>
                        <div class="fw-medium"><?php echo e($bantuan->deskripsi ?? 'Program bantuan langsung tunai untuk keluarga kurang mampu di desa sebagai bantuan sosial COVID-19.'); ?></div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Periode Mulai</label>
                                <div class="fw-medium"><?php echo e($bantuan->periode_mulai ? \Carbon\Carbon::parse($bantuan->periode_mulai)->format('d F Y') : '1 November 2024'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Periode Selesai</label>
                                <div class="fw-medium"><?php echo e($bantuan->periode_selesai ? \Carbon\Carbon::parse($bantuan->periode_selesai)->format('d F Y') : '31 Desember 2024'); ?></div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label text-muted">Jumlah Bantuan</label>
                                <div class="fw-bold text-success"><?php echo e($bantuan->jumlah_bantuan ? 'Rp ' . number_format($bantuan->jumlah_bantuan) : 'Rp 300,000'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label text-muted">Target Penerima</label>
                                <div class="fw-bold"><?php echo e($bantuan->target_penerima ?? '150'); ?> KK</div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label class="form-label text-muted">Sudah Disalurkan</label>
                                <div class="fw-bold text-primary"><?php echo e($bantuan->sudah_disalurkan ?? '120'); ?> KK</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label text-muted">Sumber Dana</label>
                        <div class="fw-medium"><?php echo e($bantuan->sumber_dana ?? 'APBD Desa'); ?></div>
                    </div>
                    
                    <?php if($bantuan->syarat_ketentuan ?? true): ?>
                    <div class="mb-3">
                        <label class="form-label text-muted">Syarat & Ketentuan</label>
                        <div class="fw-medium">
                            <?php if($bantuan->syarat_ketentuan ?? false): ?>
                                <?php echo e($bantuan->syarat_ketentuan); ?>

                            <?php else: ?>
                                <ul class="mb-0">
                                    <li>Keluarga kurang mampu dengan penghasilan di bawah Rp 1,000,000/bulan</li>
                                    <li>Memiliki KTP dan KK yang masih berlaku</li>
                                    <li>Tidak sedang menerima bantuan sejenis dari pemerintah</li>
                                    <li>Domisili tetap di desa minimal 1 tahun</li>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Progress Penyaluran -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-chart-line me-2"></i>Progress Penyaluran</h5>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-md-3">
                            <div class="border-end">
                                <h3 class="text-success mb-1"><?php echo e($bantuan->target_penerima ?? '150'); ?></h3>
                                <small class="text-muted">Target</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border-end">
                                <h3 class="text-primary mb-1"><?php echo e($bantuan->sudah_disalurkan ?? '120'); ?></h3>
                                <small class="text-muted">Tersalurkan</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="border-end">
                                <h3 class="text-warning mb-1"><?php echo e(($bantuan->target_penerima ?? 150) - ($bantuan->sudah_disalurkan ?? 120)); ?></h3>
                                <small class="text-muted">Sisa</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <h3 class="text-info mb-1"><?php echo e(round((($bantuan->sudah_disalurkan ?? 120) / ($bantuan->target_penerima ?? 150)) * 100)); ?>%</h3>
                            <small class="text-muted">Progress</small>
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <div class="d-flex justify-content-between mb-2">
                            <span>Progress Penyaluran</span>
                            <span><?php echo e(round((($bantuan->sudah_disalurkan ?? 120) / ($bantuan->target_penerima ?? 150)) * 100)); ?>%</span>
                        </div>
                        <div class="progress">
                            <div class="progress-bar bg-success" style="width: <?php echo e(round((($bantuan->sudah_disalurkan ?? 120) / ($bantuan->target_penerima ?? 150)) * 100)); ?>%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <!-- Statistik -->
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-chart-bar me-2"></i>Statistik Penerima</h6>
                </div>
                <div class="card-body">
                    <div class="row text-center mb-3">
                        <div class="col-6">
                            <div class="border-end">
                                <h5 class="text-primary mb-1"><?php echo e($bantuan->penerima_laki ?? '65'); ?></h5>
                                <small class="text-muted">Laki-laki</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <h5 class="text-danger mb-1"><?php echo e($bantuan->penerima_perempuan ?? '55'); ?></h5>
                            <small class="text-muted">Perempuan</small>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <div class="small">
                        <div class="d-flex justify-content-between mb-2">
                            <span>Dusun 1</span>
                            <span class="fw-bold">30 KK</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Dusun 2</span>
                            <span class="fw-bold">35 KK</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Dusun 3</span>
                            <span class="fw-bold">25 KK</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Dusun 4</span>
                            <span class="fw-bold">30 KK</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Actions -->
            <div class="card mt-4">
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('admin.bantuan.edit', $bantuan->id ?? 1)); ?>" class="btn btn-warning">
                            <i class="fas fa-edit me-2"></i>Edit Program
                        </a>
                        <button type="button" class="btn btn-outline-primary" onclick="printBantuan()">
                            <i class="fas fa-print me-2"></i>Cetak Data
                        </button>
                        <button type="button" class="btn btn-outline-success" onclick="exportExcel()">
                            <i class="fas fa-file-excel me-2"></i>Export Excel
                        </button>
                        <button type="button" class="btn btn-outline-info" onclick="kirimNotifikasi()">
                            <i class="fas fa-bell me-2"></i>Kirim Notifikasi
                        </button>
                    </div>
                </div>
            </div>
            
            <!-- Informasi Sistem -->
            <div class="card mt-4">
                <div class="card-header">
                    <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Informasi Sistem</h6>
                </div>
                <div class="card-body">
                    <div class="small">
                        <div class="d-flex justify-content-between mb-2">
                            <span>ID Program</span>
                            <span class="fw-bold">#<?php echo e($bantuan->id ?? '1'); ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Dibuat</span>
                            <span class="fw-bold"><?php echo e($bantuan->created_at->format('d/m/Y') ?? '01/11/2024'); ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Diperbarui</span>
                            <span class="fw-bold"><?php echo e($bantuan->updated_at->format('d/m/Y') ?? '15/11/2024'); ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Total Anggaran</span>
                            <span class="fw-bold text-success"><?php echo e($bantuan->total_anggaran ? 'Rp ' . number_format($bantuan->total_anggaran) : 'Rp 45,000,000'); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function printBantuan() {
    window.print();
}

function exportExcel() {
    showToast('File Excel sedang dipersiapkan...', 'info');
}

function kirimNotifikasi() {
    if (confirm('Kirim notifikasi WhatsApp ke semua penerima bantuan?')) {
        showToast('Notifikasi sedang dikirim...', 'info');
    }
}
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/bantuan/show.blade.php ENDPATH**/ ?>