

<?php $__env->startSection('title', 'Kelola Objek Wisata'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Kelola Objek Wisata</h1>
        <a href="<?php echo e(route('admin.objek-wisata.create')); ?>" class="btn btn-primary btn-icon-split">
            <span class="icon text-white-50">
                <i class="fas fa-plus"></i>
            </span>
            <span class="text">Tambah Objek Wisata</span>
        </a>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Objek Wisata</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['total'] ?? 0); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-map-marked-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Aktif</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['aktif'] ?? 0); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Menunggu Verifikasi</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e($stats['pending'] ?? 0); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Total Kunjungan</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800"><?php echo e(number_format($stats['total_kunjungan'] ?? 0)); ?></div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter & Search -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter & Pencarian</h6>
        </div>
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('admin.objek-wisata.index')); ?>">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="search">Pencarian</label>
                            <input type="text" class="form-control" id="search" name="search" 
                                   value="<?php echo e(request('search')); ?>" placeholder="Nama objek wisata...">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" id="status" name="status">
                                <option value="">Semua Status</option>
                                <option value="aktif" <?php echo e(request('status') === 'aktif' ? 'selected' : ''); ?>>Aktif</option>
                                <option value="nonaktif" <?php echo e(request('status') === 'nonaktif' ? 'selected' : ''); ?>>Non-aktif</option>
                                <option value="pending" <?php echo e(request('status') === 'pending' ? 'selected' : ''); ?>>Pending</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="kategori">Kategori</label>
                            <select class="form-control" id="kategori" name="kategori">
                                <option value="">Semua Kategori</option>
                                <option value="alam" <?php echo e(request('kategori') === 'alam' ? 'selected' : ''); ?>>Alam</option>
                                <option value="budaya" <?php echo e(request('kategori') === 'budaya' ? 'selected' : ''); ?>>Budaya</option>
                                <option value="religi" <?php echo e(request('kategori') === 'religi' ? 'selected' : ''); ?>>Religi</option>
                                <option value="sejarah" <?php echo e(request('kategori') === 'sejarah' ? 'selected' : ''); ?>>Sejarah</option>
                                <option value="kuliner" <?php echo e(request('kategori') === 'kuliner' ? 'selected' : ''); ?>>Kuliner</option>
                                <option value="adventure" <?php echo e(request('kategori') === 'adventure' ? 'selected' : ''); ?>>Adventure</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div class="d-flex">
                                <button type="submit" class="btn btn-primary btn-sm mr-2">
                                    <i class="fas fa-search"></i> Filter
                                </button>
                                <a href="<?php echo e(route('admin.objek-wisata.index')); ?>" class="btn btn-secondary btn-sm">
                                    <i class="fas fa-undo"></i> Reset
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Data Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Objek Wisata</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th width="15%">Foto</th>
                            <th width="20%">Nama</th>
                            <th width="15%">Kategori</th>
                            <th width="15%">Harga Tiket</th>
                            <th width="10%">Status</th>
                            <th width="10%">Rating</th>
                            <th width="10%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $objekWisata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $wisata): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($objekWisata->firstItem() + $index); ?></td>
                            <td>
                                <?php if($wisata->foto_utama): ?>
                                    <img src="<?php echo e(Storage::url($wisata->foto_utama)); ?>" 
                                         alt="<?php echo e($wisata->nama); ?>" 
                                         class="img-thumbnail" 
                                         style="width: 80px; height: 60px; object-fit: cover;">
                                <?php else: ?>
                                    <div class="bg-light d-flex align-items-center justify-content-center" 
                                         style="width: 80px; height: 60px;">
                                        <i class="fas fa-image text-muted"></i>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="font-weight-bold"><?php echo e($wisata->nama); ?></div>
                                <small class="text-muted"><?php echo e(Str::limit($wisata->alamat, 50)); ?></small>
                            </td>
                            <td>
                                <span class="badge badge-info"><?php echo e(ucfirst($wisata->kategori)); ?></span>
                            </td>
                            <td>
                                <?php if($wisata->harga_tiket_dewasa > 0): ?>
                                    <div><strong>Dewasa:</strong> Rp <?php echo e(number_format($wisata->harga_tiket_dewasa)); ?></div>
                                    <?php if($wisata->harga_tiket_anak > 0): ?>
                                        <div><strong>Anak:</strong> Rp <?php echo e(number_format($wisata->harga_tiket_anak)); ?></div>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <span class="text-success font-weight-bold">GRATIS</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($wisata->status === 'aktif'): ?>
                                    <span class="badge badge-success">Aktif</span>
                                <?php elseif($wisata->status === 'pending'): ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php else: ?>
                                    <span class="badge badge-secondary">Non-aktif</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <i class="fas fa-star text-warning mr-1"></i>
                                    <span class="font-weight-bold"><?php echo e(number_format($wisata->rating_rata_rata, 1)); ?></span>
                                    <small class="text-muted ml-1">(<?php echo e($wisata->total_ulasan); ?>)</small>
                                </div>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="<?php echo e(route('admin.objek-wisata.show', $wisata->id)); ?>" 
                                       class="btn btn-info btn-sm" title="Detail">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('admin.objek-wisata.edit', $wisata->id)); ?>" 
                                       class="btn btn-warning btn-sm" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <?php if($wisata->status === 'pending'): ?>
                                        <form action="<?php echo e(route('admin.objek-wisata.approve', $wisata->id)); ?>" 
                                              method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('PATCH'); ?>
                                            <button type="submit" class="btn btn-success btn-sm" 
                                                    title="Setujui" 
                                                    onclick="return confirm('Setujui objek wisata ini?')">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                    <button type="button" class="btn btn-danger btn-sm" 
                                            onclick="deleteWisata(<?php echo e($wisata->id); ?>)" 
                                            title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center py-4">
                                <i class="fas fa-search fa-3x text-muted mb-3"></i>
                                <h5 class="text-muted">Tidak ada data objek wisata</h5>
                                <p class="text-muted">Silakan tambah objek wisata baru atau ubah filter pencarian</p>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <?php if($objekWisata->hasPages()): ?>
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        Menampilkan <?php echo e($objekWisata->firstItem()); ?> - <?php echo e($objekWisata->lastItem()); ?> 
                        dari <?php echo e($objekWisata->total()); ?> data
                    </div>
                    <?php echo e($objekWisata->appends(request()->query())->links()); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Konfirmasi Hapus</h5>
                <button type="button" class="close" data-dismiss="modal">
                    <span>&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin menghapus objek wisata ini?</p>
                <p class="text-danger"><small>Tindakan ini tidak dapat dibatalkan.</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function deleteWisata(id) {
    $('#deleteForm').attr('action', `/admin/objek-wisata/${id}`);
    $('#deleteModal').modal('show');
}

// Auto-hide alerts
setTimeout(function() {
    $('.alert').fadeOut('slow');
}, 5000);
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/objek-wisata/index.blade.php ENDPATH**/ ?>