

<?php $__env->startSection('title', 'Dashboard'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item active">Dashboard</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Page Title -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Dashboard</h1>
            <p class="mb-0 text-muted">Selamat datang di Aplikasi Desa</p>
        </div>
        <div class="text-muted">
            <i class="fas fa-calendar-alt me-2"></i>
            <?php echo e(now()->format('d F Y')); ?>

        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="row g-4 mb-4">
        <div class="col-xl-3 col-lg-6">
            <div class="stats-card">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-primary me-3">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="h3 mb-0 font-weight-bold"><?php echo e(number_format($stats['total_penduduk'] ?? 0)); ?></div>
                        <div class="text-xs font-weight-bold text-uppercase tracking-wide">Total Penduduk</div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-chart-line text-success me-1"></i>
                            Aktif
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6">
            <div class="stats-card">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-success me-3">
                        <i class="fas fa-home"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="h3 mb-0 font-weight-bold"><?php echo e(number_format($stats['total_keluarga'] ?? 0)); ?></div>
                        <div class="text-xs font-weight-bold text-uppercase tracking-wide">Total Keluarga</div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-home text-info me-1"></i>
                            Terdaftar
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6">
            <div class="stats-card">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-warning me-3">
                        <i class="fas fa-file-alt"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="h3 mb-0 font-weight-bold"><?php echo e(number_format($stats['total_surat'] ?? 0)); ?></div>
                        <div class="text-xs font-weight-bold text-uppercase tracking-wide">Permohonan Surat</div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-clock text-warning me-1"></i>
                            Bulan ini
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-lg-6">
            <div class="stats-card">
                <div class="d-flex align-items-center">
                    <div class="stats-icon bg-info me-3">
                        <i class="fas fa-comment-dots"></i>
                    </div>
                    <div class="flex-grow-1">
                        <div class="h3 mb-0 font-weight-bold"><?php echo e(number_format($stats['total_pengaduan'] ?? 0)); ?></div>
                        <div class="text-xs font-weight-bold text-uppercase tracking-wide">Pengaduan</div>
                        <div class="text-xs text-muted mt-1">
                            <i class="fas fa-envelope text-danger me-1"></i>
                            Aktif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Mutasi Penduduk Statistics -->
    <div class="row g-4 mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-exchange-alt me-2 text-warning"></i>
                            Mutasi Penduduk Bulan Ini
                        </h5>
                        <a href="<?php echo e(route('admin.mutasi-penduduk.index')); ?>" class="btn btn-sm btn-outline-warning">
                            <i class="fas fa-history me-1"></i>
                            Lihat Riwayat
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-lg-3 col-md-6">
                            <div class="d-flex align-items-center p-3 bg-light rounded">
                                <div class="flex-shrink-0">
                                    <div class="stats-icon-sm bg-success me-3">
                                        <i class="fas fa-baby text-white"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <div class="fw-bold h5 mb-0"><?php echo e(number_format($stats['lahir_bulan_ini'] ?? 0)); ?></div>
                                    <div class="text-sm text-muted">Kelahiran</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6">
                            <div class="d-flex align-items-center p-3 bg-light rounded">
                                <div class="flex-shrink-0">
                                    <div class="stats-icon-sm bg-secondary me-3">
                                        <i class="fas fa-cross text-white"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <div class="fw-bold h5 mb-0"><?php echo e(number_format($stats['meninggal_bulan_ini'] ?? 0)); ?></div>
                                    <div class="text-sm text-muted">Meninggal</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6">
                            <div class="d-flex align-items-center p-3 bg-light rounded">
                                <div class="flex-shrink-0">
                                    <div class="stats-icon-sm bg-info me-3">
                                        <i class="fas fa-arrow-right text-white"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <div class="fw-bold h5 mb-0"><?php echo e(number_format($stats['pindah_masuk_bulan_ini'] ?? 0)); ?></div>
                                    <div class="text-sm text-muted">Pindah Masuk</div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-6">
                            <div class="d-flex align-items-center p-3 bg-light rounded">
                                <div class="flex-shrink-0">
                                    <div class="stats-icon-sm bg-warning me-3">
                                        <i class="fas fa-arrow-left text-white"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1">
                                    <div class="fw-bold h5 mb-0"><?php echo e(number_format($stats['pindah_keluar_bulan_ini'] ?? 0)); ?></div>
                                    <div class="text-sm text-muted">Pindah Keluar</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <?php if(isset($stats['total_mutasi_tahun_ini']) && $stats['total_mutasi_tahun_ini'] > 0): ?>
                    <div class="mt-3 pt-3 border-top">
                        <div class="text-center">
                            <small class="text-muted">
                                <i class="fas fa-chart-line me-1"></i>
                                Total mutasi tahun <?php echo e(date('Y')); ?>: 
                                <span class="fw-bold text-primary"><?php echo e(number_format($stats['total_mutasi_tahun_ini'])); ?></span> orang
                            </small>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="row g-4 mb-4">
        <!-- Demographics Chart -->
        <div class="col-lg-6">
            <div class="card h-100">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-chart-pie me-2 text-primary"></i>
                            Demografi Penduduk
                        </h5>
                        <div class="dropdown">
                            <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                <i class="fas fa-ellipsis-v"></i>
                            </button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo e(route('admin.penduduk.index')); ?>">
                                    <i class="fas fa-users me-2"></i>Lihat Detail
                                </a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="position-relative" style="height: 300px;">
                        <canvas id="demographicsChart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Monthly Services Chart -->
        <div class="col-lg-6">
            <div class="card h-100">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-chart-bar me-2 text-success"></i>
                            Pelayanan Bulanan
                        </h5>
                        <div class="dropdown">
                            <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                <i class="fas fa-ellipsis-v"></i>
                            </button>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo e(route('admin.pelayanan-surat.index')); ?>">
                                    <i class="fas fa-file-alt me-2"></i>Lihat Detail
                                </a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="position-relative" style="height: 300px;">
                        <canvas id="monthlyServicesChart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Education & Profession Statistics -->
    <div class="row g-4 mb-4">
        <!-- Education Statistics -->
        <div class="col-lg-6">
            <div class="card h-100">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-graduation-cap me-2 text-info"></i>
                            Statistik Pendidikan
                        </h5>
                        <small class="text-muted">
                            <i class="fas fa-users me-1"></i>
                            <?php echo e(collect($stats['statistik_pendidikan'] ?? [])->sum('total')); ?> Orang
                        </small>
                    </div>
                </div>
                <div class="card-body">
                    <?php if(isset($stats['statistik_pendidikan']) && count($stats['statistik_pendidikan']) > 0): ?>
                        <?php $__currentLoopData = $stats['statistik_pendidikan']->take(7); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="d-flex align-items-center">
                                <div class="education-icon me-3">
                                    <?php switch($item['pendidikan']):
                                        case ('S3'): ?>
                                            <i class="fas fa-university text-purple"></i>
                                            <?php break; ?>
                                        <?php case ('S2'): ?>
                                            <i class="fas fa-university text-blue"></i>
                                            <?php break; ?>
                                        <?php case ('S1'): ?>
                                            <i class="fas fa-graduation-cap text-primary"></i>
                                            <?php break; ?>
                                        <?php case ('D3'): ?>
                                        <?php case ('D2'): ?>
                                        <?php case ('D1'): ?>
                                            <i class="fas fa-certificate text-success"></i>
                                            <?php break; ?>
                                        <?php case ('SMA'): ?>
                                            <i class="fas fa-school text-warning"></i>
                                            <?php break; ?>
                                        <?php case ('SMP'): ?>
                                            <i class="fas fa-school text-info"></i>
                                            <?php break; ?>
                                        <?php case ('SD'): ?>
                                            <i class="fas fa-school text-secondary"></i>
                                            <?php break; ?>
                                        <?php default: ?>
                                            <i class="fas fa-minus-circle text-muted"></i>
                                    <?php endswitch; ?>
                                </div>
                                <div>
                                    <div class="fw-bold"><?php echo e($item['pendidikan']); ?></div>
                                    <small class="text-muted">
                                        <?php echo e(number_format($item['total'])); ?> orang
                                    </small>
                                </div>
                            </div>
                            <div class="text-end">
                                <?php
                                    $percentage = collect($stats['statistik_pendidikan'])->sum('total') > 0 
                                        ? round(($item['total'] / collect($stats['statistik_pendidikan'])->sum('total')) * 100, 1) 
                                        : 0;
                                ?>
                                <span class="badge bg-light text-dark"><?php echo e($percentage); ?>%</span>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="fas fa-graduation-cap fa-3x text-muted opacity-50 mb-3"></i>
                            <p class="text-muted">Belum ada data pendidikan</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Profession Statistics -->
        <div class="col-lg-6">
            <div class="card h-100">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-briefcase me-2 text-success"></i>
                            Statistik Pekerjaan
                        </h5>
                        <small class="text-muted">
                            <i class="fas fa-users me-1"></i>
                            <?php echo e(collect($stats['statistik_pekerjaan'] ?? [])->sum('total')); ?> Orang
                        </small>
                    </div>
                </div>
                <div class="card-body">
                    <?php if(isset($stats['statistik_pekerjaan']) && count($stats['statistik_pekerjaan']) > 0): ?>
                        <?php $__currentLoopData = $stats['statistik_pekerjaan']->take(8); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <div class="d-flex align-items-center">
                                <div class="profession-icon me-3">
                                    <?php if(str_contains(strtolower($item['pekerjaan']), 'petani')): ?>
                                        <i class="fas fa-seedling text-success"></i>
                                    <?php elseif(str_contains(strtolower($item['pekerjaan']), 'guru')): ?>
                                        <i class="fas fa-chalkboard-teacher text-info"></i>
                                    <?php elseif(str_contains(strtolower($item['pekerjaan']), 'pedagang')): ?>
                                        <i class="fas fa-store text-warning"></i>
                                    <?php elseif(str_contains(strtolower($item['pekerjaan']), 'pns')): ?>
                                        <i class="fas fa-user-tie text-primary"></i>
                                    <?php elseif(str_contains(strtolower($item['pekerjaan']), 'buruh')): ?>
                                        <i class="fas fa-hard-hat text-danger"></i>
                                    <?php elseif(str_contains(strtolower($item['pekerjaan']), 'wiraswasta')): ?>
                                        <i class="fas fa-business-time text-purple"></i>
                                    <?php elseif(str_contains(strtolower($item['pekerjaan']), 'tidak bekerja')): ?>
                                        <i class="fas fa-user-slash text-muted"></i>
                                    <?php else: ?>
                                        <i class="fas fa-briefcase text-secondary"></i>
                                    <?php endif; ?>
                                </div>
                                <div>
                                    <div class="fw-bold"><?php echo e(Str::limit($item['pekerjaan'], 20)); ?></div>
                                    <small class="text-muted">
                                        <?php echo e(number_format($item['total'])); ?> orang
                                    </small>
                                </div>
                            </div>
                            <div class="text-end">
                                <?php
                                    $percentage = collect($stats['statistik_pekerjaan'])->sum('total') > 0 
                                        ? round(($item['total'] / collect($stats['statistik_pekerjaan'])->sum('total')) * 100, 1) 
                                        : 0;
                                ?>
                                <span class="badge bg-light text-dark"><?php echo e($percentage); ?>%</span>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div class="text-center py-4">
                            <i class="fas fa-briefcase fa-3x text-muted opacity-50 mb-3"></i>
                            <p class="text-muted">Belum ada data pekerjaan</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Activities and Quick Stats -->
    <div class="row g-4">
        <!-- Recent Activities -->
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-clock me-2 text-info"></i>
                            Aktivitas Terbaru
                        </h5>
                        <a href="<?php echo e(route('admin.pelayanan-surat.index')); ?>" class="btn btn-sm btn-outline-primary">
                            Lihat Semua
                        </a>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th class="border-0">Waktu</th>
                                    <th class="border-0">Aktivitas</th>
                                    <th class="border-0">User</th>
                                    <th class="border-0">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(isset($recentData['surat_terbaru']) && $recentData['surat_terbaru']->count() > 0): ?>
                                    <?php $__currentLoopData = $recentData['surat_terbaru']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $surat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <small class="text-muted">
                                                <?php echo e($surat->created_at->format('d/m/Y H:i')); ?>

                                            </small>
                                        </td>
                                        <td>
                                            <div class="fw-500">Permohonan <?php echo e($surat->jenis_surat ?? 'Surat'); ?></div>
                                            <small class="text-muted">No: <?php echo e($surat->nomor_surat ?? '-'); ?></small>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar avatar-sm me-2">
                                                    <div class="avatar-img bg-primary text-white">
                                                        <?php echo e(substr($surat->penduduk->nama ?? 'N', 0, 1)); ?>

                                                    </div>
                                                </div>
                                                <div>
                                                    <div class="fw-500"><?php echo e($surat->penduduk->nama ?? 'N/A'); ?></div>
                                                    <small class="text-muted"><?php echo e($surat->penduduk->nik ?? ''); ?></small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <?php
                                                $statusColor = match(strtolower($surat->status ?? 'menunggu')) {
                                                    'menunggu' => 'warning',
                                                    'diproses' => 'info',
                                                    'selesai' => 'success',
                                                    'ditolak' => 'danger',
                                                    default => 'secondary'
                                                };
                                            ?>
                                            <span class="badge bg-<?php echo e($statusColor); ?>">
                                                <?php echo e($surat->status ?? 'Menunggu'); ?>

                                            </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                
                                <?php if(isset($recentData['pengaduan_terbaru']) && $recentData['pengaduan_terbaru']->count() > 0): ?>
                                    <?php $__currentLoopData = $recentData['pengaduan_terbaru']->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pengaduan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <small class="text-muted">
                                                <?php echo e($pengaduan->created_at->format('d/m/Y H:i')); ?>

                                            </small>
                                        </td>
                                        <td>
                                            <div class="fw-500">Pengaduan</div>
                                            <small class="text-muted"><?php echo e(Str::limit($pengaduan->judul ?? 'Pengaduan Baru', 40)); ?></small>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar avatar-sm me-2">
                                                    <div class="avatar-img bg-info text-white">
                                                        <?php echo e(substr($pengaduan->penduduk->nama ?? 'N', 0, 1)); ?>

                                                    </div>
                                                </div>
                                                <div>
                                                    <div class="fw-500"><?php echo e($pengaduan->penduduk->nama ?? 'N/A'); ?></div>
                                                    <small class="text-muted"><?php echo e($pengaduan->penduduk->nik ?? ''); ?></small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <?php
                                                $statusColor = match(strtolower($pengaduan->status ?? 'baru')) {
                                                    'baru' => 'warning',
                                                    'diproses' => 'info',
                                                    'selesai' => 'success',
                                                    'ditolak' => 'danger',
                                                    default => 'secondary'
                                                };
                                            ?>
                                            <span class="badge bg-<?php echo e($statusColor); ?>">
                                                <?php echo e($pengaduan->status ?? 'Baru'); ?>

                                            </span>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                
                                <?php if((!isset($recentData['surat_terbaru']) || $recentData['surat_terbaru']->count() == 0) && 
                                    (!isset($recentData['pengaduan_terbaru']) || $recentData['pengaduan_terbaru']->count() == 0)): ?>
                                <tr>
                                    <td colspan="4" class="text-center py-5">
                                        <div class="text-muted">
                                            <i class="fas fa-inbox fa-3x mb-3 d-block opacity-50"></i>
                                            <h6>Belum ada aktivitas terbaru</h6>
                                            <p class="mb-0 small">Aktivitas akan muncul di sini</p>
                                        </div>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Stats & Actions -->
        <div class="col-lg-4">
            <!-- Quick Stats -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-tachometer-alt me-2 text-warning"></i>
                        Statistik Cepat
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6 mb-3">
                            <div class="border-end">
                                <div class="h4 mb-0 text-primary"><?php echo e($stats['laki_laki'] ?? 0); ?></div>
                                <small class="text-muted">Laki-laki</small>
                            </div>
                        </div>
                        <div class="col-6 mb-3">
                            <div class="h4 mb-0 text-pink"><?php echo e($stats['perempuan'] ?? 0); ?></div>
                            <small class="text-muted">Perempuan</small>
                        </div>
                        <div class="col-6">
                            <div class="border-end">
                                <div class="h4 mb-0 text-success"><?php echo e($stats['kawin'] ?? 0); ?></div>
                                <small class="text-muted">Kawin</small>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="h4 mb-0 text-info"><?php echo e($stats['belum_kawin'] ?? 0); ?></div>
                            <small class="text-muted">Belum Kawin</small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-bolt me-2 text-success"></i>
                        Aksi Cepat
                    </h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('admin.penduduk.create')); ?>" class="btn btn-gradient-primary">
                            <i class="fas fa-user-plus me-2"></i>
                            Tambah Penduduk
                        </a>
                        <a href="<?php echo e(route('admin.keluarga.create')); ?>" class="btn btn-gradient-success">
                            <i class="fas fa-home me-2"></i>
                            Tambah Keluarga
                        </a>
                        <a href="<?php echo e(route('admin.pelayanan-surat.index')); ?>" class="btn btn-gradient-warning">
                            <i class="fas fa-file-alt me-2"></i>
                            Kelola Surat
                        </a>
                        <a href="<?php echo e(route('admin.pengaduan.index')); ?>" class="btn btn-gradient-info">
                            <i class="fas fa-comment-dots me-2"></i>
                            Kelola Pengaduan
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
    .tracking-wide {
        letter-spacing: 0.05em;
    }
    
    .font-weight-bold {
        font-weight: 600 !important;
    }
    
    .text-xs {
        font-size: 0.75rem;
    }
    
    .fw-500 {
        font-weight: 500;
    }
    
    .avatar {
        width: 32px;
        height: 32px;
    }
    
    .avatar-sm {
        width: 28px;
        height: 28px;
    }
    
    .avatar-img {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12px;
        font-weight: 600;
    }
    
    .opacity-50 {
        opacity: 0.5;
    }
    
    .h3 {
        font-size: 1.75rem;
    }
    
    .h4 {
        font-size: 1.25rem;
    }
    
    .h6 {
        font-size: 1rem;
    }
    
    /* Stats card styling */
    .stats-card {
        background: #fff;
        border-radius: 10px;
        padding: 1.5rem;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
        border: 1px solid rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
    }
    
    .stats-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.12);
    }
    
    .stats-icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        color: white;
    }
    
    .stats-icon-sm {
        width: 32px;
        height: 32px;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 14px;
    }
    
    /* Education & Profession icons */
    .education-icon, .profession-icon {
        width: 32px;
        height: 32px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 16px;
    }
    
    /* Custom text colors */
    .text-purple {
        color: #9c27b0 !important;
    }
    
    .text-blue {
        color: #2196f3 !important;
    }
    
    .text-pink {
        color: #e91e63 !important;
    }
    
    /* Gradient buttons */
    .btn-gradient-primary {
        background: linear-gradient(45deg, #667eea 0%, #764ba2 100%);
        border: none;
        color: white;
    }
    
    .btn-gradient-success {
        background: linear-gradient(45deg, #56ab2f 0%, #a8e6cf 100%);
        border: none;
        color: white;
    }
    
    .btn-gradient-warning {
        background: linear-gradient(45deg, #f093fb 0%, #f5576c 100%);
        border: none;
        color: white;
    }
    
    .btn-gradient-info {
        background: linear-gradient(45deg, #4facfe 0%, #00f2fe 100%);
        border: none;
        color: white;
    }
    
    /* Badge improvements */
    .badge {
        font-size: 0.75rem;
        padding: 0.375rem 0.75rem;
    }
    
    /* Card hover effects */
    .card {
        transition: all 0.3s ease;
        border: 1px solid rgba(0, 0, 0, 0.05);
    }
    
    .card:hover {
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    }
    
    /* Loading animations */
    @keyframes pulse {
        0% { opacity: 1; }
        50% { opacity: 0.5; }
        100% { opacity: 1; }
    }
    
    .loading {
        animation: pulse 1.5s infinite;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Demographics Chart
    const ctx1 = document.getElementById('demographicsChart').getContext('2d');
    new Chart(ctx1, {
        type: 'doughnut',
        data: {
            labels: ['Laki-laki', 'Perempuan'],
            datasets: [{
                data: [<?php echo e($stats['laki_laki'] ?? 0); ?>, <?php echo e($stats['perempuan'] ?? 0); ?>],
                backgroundColor: [
                    'rgba(102, 126, 234, 0.8)',
                    'rgba(233, 30, 99, 0.8)'
                ],
                borderColor: [
                    'rgba(102, 126, 234, 1)',
                    'rgba(233, 30, 99, 1)'
                ],
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true,
                        font: {
                            size: 14
                        }
                    }
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const total = context.dataset.data.reduce((a, b) => a + b, 0);
                            const percentage = ((context.parsed / total) * 100).toFixed(1);
                            return context.label + ': ' + context.parsed + ' (' + percentage + '%)';
                        }
                    }
                }
            }
        }
    });

    // Monthly Services Chart
    const ctx2 = document.getElementById('monthlyServicesChart').getContext('2d');
    new Chart(ctx2, {
        type: 'bar',
        data: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun'],
            datasets: [
                {
                    label: 'Surat',
                    data: [12, 19, 15, 25, 22, 30],
                    backgroundColor: 'rgba(102, 126, 234, 0.8)',
                    borderColor: 'rgba(102, 126, 234, 1)',
                    borderWidth: 1
                },
                {
                    label: 'Pengaduan',
                    data: [5, 8, 12, 15, 10, 18],
                    backgroundColor: 'rgba(255, 99, 132, 0.8)',
                    borderColor: 'rgba(255, 99, 132, 1)',
                    borderWidth: 1
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        padding: 20,
                        usePointStyle: true,
                        font: {
                            size: 14
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)'
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });

    // Auto-refresh stats (optional)
    setInterval(function() {
        // You can implement auto-refresh logic here if needed
    }, 60000); // Refresh every minute
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>