# Aplikasi Desa - Sistem Manajemen Desa Digital

Aplikasi Desa adalah sistem manajemen desa yang komprehensif untuk digitalisasi pelayanan dan administrasi desa. Sistem ini dibangun menggunakan Laravel untuk backend admin panel dan menyediakan API untuk integrasi dengan aplikasi mobile Flutter.

## 🎯 Fitur Utama

### 1. **Data Penduduk**
- ✅ CRUD data penduduk lengkap dengan NIK
- ✅ Import/Export data Excel
- ✅ Pemetaan rumah dengan koordinat GPS
- ✅ Reverse geocoding untuk alamat otomatis
- ✅ Pencarian dan filter data

### 2. **Data Keluarga**
- ✅ Manajemen Kartu Keluarga (KK)
- ✅ Hubungan anggota keluarga
- ✅ Alamat keluarga dengan koordinat
- ✅ Auto-fill alamat dari koordinat

### 3. **Pelayanan Surat**
- ✅ Pengajuan dan tracking surat
- ✅ Jenis surat: Domisili, Usaha, SKTM, dll
- ✅ Status workflow: Pending → Diproses → Disetujui → Selesai
- ✅ Generate PDF surat otomatis
- ✅ Notifikasi WhatsApp status surat

### 4. **Pengaduan & Aspirasi**
- ✅ Sistem pengaduan masyarakat
- ✅ Upload gambar bukti
- ✅ Koordinat lokasi pengaduan
- ✅ Tanggapan dan follow-up
- ✅ Notifikasi WhatsApp untuk tanggapan

### 5. **Bantuan Sosial**
- ✅ Manajemen distribusi bantuan
- ✅ Jenis bantuan: PKH, BLT, Bansos, dll
- ✅ Tracking penerima bantuan
- ✅ Laporan distribusi per periode
- ✅ Notifikasi penerima bantuan

### 6. **Berita & Informasi**
- ✅ Publikasi berita desa
- ✅ Kategorisasi berita
- ✅ Sistem publishing (Draft/Terbit)
- ✅ Broadcast berita via WhatsApp
- ✅ Tracking views dan engagement

### 7. **Peta Rumah Warga**
- ✅ Peta interaktif dengan Leaflet
- ✅ Marker lokasi rumah penduduk
- ✅ Info popup detail penduduk
- ✅ Clustering untuk performa optimal

### 8. **Notifikasi WhatsApp**
- ✅ Integrasi WhatsApp Gateway (Wablas/KirimWA)
- ✅ Template pesan otomatis
- ✅ Broadcast massal ke warga
- ✅ Log dan tracking pesan

### 9. **Dashboard & Laporan**
- ✅ Statistik realtime penduduk
- ✅ Chart interaktif dengan Chart.js
- ✅ Laporan pelayanan dan bantuan
- ✅ Export laporan PDF/Excel

## 🛠️ Teknologi yang Digunakan

### Backend
- **Laravel 11** - Framework PHP
- **MySQL** - Database
- **Laravel Sanctum** - API Authentication

### Frontend Admin
- **Laravel Blade** - Template Engine
- **Bootstrap 5** - CSS Framework
- **Font Awesome** - Icons
- **Leaflet** - Interactive Maps
- **Chart.js** - Data Visualization
- **DataTables** - Enhanced Tables

### Integrasi & API
- **OpenStreetMap Nominatim** - Reverse Geocoding
- **WhatsApp Gateway** - Notifikasi
- **REST API** - untuk Flutter Mobile App

## 📋 Prasyarat

- PHP >= 8.1
- Composer
- Node.js & NPM
- MySQL/MariaDB
- Server web (Apache/Nginx) atau Laragon/XAMPP

## 🚀 Instalasi

### 1. Clone Repository
```bash
git clone https://github.com/username/aplikasi-desa.git
cd aplikasi-desa
```

### 2. Install Dependencies
```bash
# Install PHP dependencies
composer install

# Install JavaScript dependencies
npm install
```

### 3. Konfigurasi Environment
```bash
# Copy file environment
cp .env.example .env

# Generate application key
php artisan key:generate
```

### 4. Konfigurasi Database
Edit file `.env` dan sesuaikan konfigurasi database:
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=aplikasi_desa
DB_USERNAME=root
DB_PASSWORD=
```

### 5. Konfigurasi WhatsApp (Opsional)
Tambahkan konfigurasi WhatsApp Gateway di `.env`:
```env
WHATSAPP_API_KEY=your_api_key_here
WHATSAPP_BASE_URL=https://api.wablas.com
```

### 6. Setup Database
```bash
# Buat database MySQL
mysql -u root -p -e "CREATE DATABASE aplikasi_desa CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;"

# Jalankan migration dan seeding
php artisan migrate:fresh --seed
```

### 7. Setup Storage
```bash
# Create storage symlink
php artisan storage:link

# Set permissions (Linux/Mac)
chmod -R 775 storage bootstrap/cache
```

### 8. Build Assets
```bash
# Compile assets for development
npm run dev

# Atau untuk production
npm run build
```

### 9. Jalankan Server
```bash
# Development server
php artisan serve

# Aplikasi dapat diakses di http://localhost:8000
```

## 📊 Data Demo

Setelah instalasi dengan seeding, sistem akan memiliki data demo:
- **5 data penduduk** dengan berbagai profil
- **2 keluarga** dengan anggota lengkap
- **3 permohonan surat** dengan status berbeda
- **2 pengaduan** warga
- **3 data bantuan sosial**
- **4 berita** dengan status berbeda

## 🌐 Struktur URL

### Admin Panel
- **Dashboard**: `/admin/dashboard`
- **Data Penduduk**: `/admin/penduduk`
- **Data Keluarga**: `/admin/keluarga`
- **Pelayanan Surat**: `/admin/pelayanan-surat`
- **Pengaduan**: `/admin/pengaduan`
- **Bantuan Sosial**: `/admin/bantuan`
- **Berita**: `/admin/berita`
- **Peta Rumah**: `/admin/peta-rumah`

### Public Website
- **Beranda**: `/`
- **Berita**: `/berita`
- **Detail Berita**: `/berita/{slug}`
- **Peta Desa**: `/peta`

### API Endpoints
Base URL: `/api`
- **Penduduk**: `GET /penduduk`, `GET /penduduk/{nik}`
- **Keluarga**: `GET /keluarga`, `GET /keluarga/{id}`
- **Pelayanan**: `GET /pelayanan-surat`, `POST /pelayanan-surat`
- **Pengaduan**: `GET /pengaduan`, `POST /pengaduan`
- **Bantuan**: `GET /bantuan`, `POST /bantuan`
- **Berita**: `GET /berita`, `GET /berita/{slug}`

## 🎨 Antarmuka

Sistem menggunakan desain modern dengan:
- **Gradient backgrounds** untuk tampilan menarik
- **Responsive design** untuk mobile dan desktop
- **Interactive maps** dengan clustering
- **Real-time charts** untuk statistik
- **Dark/Light mode** support
- **Smooth animations** dan transitions

## 📱 Integrasi Mobile

API endpoints siap untuk integrasi dengan aplikasi mobile Flutter:
- **Authentication** dengan Laravel Sanctum
- **CRUD operations** untuk semua modul
- **File upload** untuk gambar
- **Real-time notifications**
- **Offline capability** support

## 🔧 Konfigurasi Tambahan

### WhatsApp Gateway
Untuk mengaktifkan notifikasi WhatsApp:
1. Daftar di provider WhatsApp Gateway (Wablas, KirimWA, dll)
2. Dapatkan API Key
3. Tambahkan konfigurasi di `.env`
4. Test koneksi di menu Admin → Notifikasi WA

### Reverse Geocoding
Sistem menggunakan OpenStreetMap Nominatim untuk mendapatkan alamat dari koordinat GPS secara otomatis.

### File Storage
- Upload file disimpan di `storage/app/public/`
- Akses file melalui `/storage/` symlink
- Didukung: gambar (JPG, PNG), dokumen (PDF)

## 🐛 Troubleshooting

### Database Connection Error
```bash
# Pastikan MySQL berjalan
sudo systemctl start mysql  # Linux
brew services start mysql   # Mac

# Check koneksi
php artisan tinker
DB::connection()->getPdo();
```

### Permission Denied
```bash
# Set proper permissions
sudo chown -R www-data:www-data storage bootstrap/cache
chmod -R 775 storage bootstrap/cache
```

### Asset Not Found
```bash
# Rebuild assets
npm run build
php artisan storage:link
```

## 📚 Dokumentasi API

API documentation tersedia dalam format Postman Collection di folder `/docs/api/`.

### Authentication
```bash
# Login
POST /api/login
{
    "email": "admin@example.com",
    "password": "password"
}

# Response
{
    "token": "1|abc123...",
    "user": {...}
}
```

### Headers Required
```
Accept: application/json
Content-Type: application/json
Authorization: Bearer {token}
```

## 🤝 Kontribusi

1. Fork repository
2. Buat feature branch (`git checkout -b feature/amazing-feature`)
3. Commit changes (`git commit -m 'Add amazing feature'`)
4. Push branch (`git push origin feature/amazing-feature`)
5. Open Pull Request

## 📄 Lisensi

Project ini menggunakan lisensi MIT. Lihat file `LICENSE` untuk detail lengkap.

## 👥 Tim Pengembang

- **Backend Developer**: Laravel API & Admin Panel
- **Frontend Developer**: UI/UX & Responsive Design
- **Mobile Developer**: Flutter Integration
- **DevOps**: Server Configuration & Deployment

## 📞 Dukungan

Untuk bantuan dan dukungan:
- **Email**: support@aplikasidesa.com
- **Documentation**: [Wiki Pages](link-to-wiki)
- **Issues**: [GitHub Issues](link-to-issues)

---

**Aplikasi Desa** - Digitalisasi Desa untuk Indonesia Maju 🇮🇩

## 🔐 Portal Warga Digital

### Fitur Portal Warga
- **Login dengan NIK**: Penduduk dapat login menggunakan NIK dan password
- **Password Default**: 6 digit terakhir NIK sebagai password awal
- **Ganti Password**: Sistem paksa ganti password saat login pertama
- **Layanan Mandiri**: Akses ke layanan surat dan pengaduan
- **Profil Penduduk**: Melihat dan update data pribadi

### Manajemen Password Admin

#### 1. Generate Password Individual
```bash
# Di halaman detail penduduk, klik "Generate Password"
# Password akan otomatis dibuat dari 6 digit terakhir NIK
```

#### 2. Generate Password Massal (Web Interface)
```bash
# Buka Data Penduduk → Klik "Generate Password Massal"
# Pilih filter: Semua / Dusun / RT-RW
# Preview sebelum generate
# Maksimal 500 penduduk per batch
```

#### 3. Generate Password via Command Line
```bash
# Generate untuk semua penduduk tanpa password
php artisan warga:generate-passwords

# Generate dengan filter dusun
php artisan warga:generate-passwords --dusun="Dusun 1"

# Generate dengan filter RT/RW
php artisan warga:generate-passwords --rt=001 --rw=002

# Generate dengan limit
php artisan warga:generate-passwords --limit=50

# Paksa ganti password saat login pertama
php artisan warga:generate-passwords --force-change

# Dry run (preview tanpa generate)
php artisan warga:generate-passwords --dry-run

# Ekspor hasil ke CSV
php artisan warga:generate-passwords --verbose
```

#### 4. Status Password
- 🟢 **Portal Aktif**: Password sudah diset dan tidak perlu diganti
- 🟡 **Harus Ganti**: Password diset tapi harus diganti saat login
- 🔴 **Belum Diatur**: Belum ada password, tidak bisa login

#### 5. Monitoring Login
- **Login Hari Ini**: Jumlah penduduk yang login hari ini
- **Last Login**: Waktu login terakhir setiap penduduk
- **Login Count**: Total jumlah login per penduduk

### Akses Portal Warga
```
URL: https://your-domain.com/layanan-mandiri
Login: NIK + Password (6 digit terakhir NIK)
```

### Troubleshooting
```bash
# Reset password penduduk
# Di halaman detail penduduk → "Reset Password"

# Paksa ganti password
# Di halaman detail penduduk → "Paksa Ganti Password"

# Cek log login
# Lihat kolom "Last Login" di tabel penduduk
```
