<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\ObjekWisata;
use Illuminate\Support\Facades\Log;

class CleanTourismImagePaths extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'tourism:clean-image-paths';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean temporary file paths from tourism image fields';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Starting to clean tourism image paths...');
        
        $fixedCount = 0;
        
        // Clean foto_utama
        $tourismWithTempPaths = ObjekWisata::where('foto_utama', 'like', '%tmp%')
                                         ->orWhere('foto_utama', 'like', '%php%')
                                         ->get();
        
        foreach ($tourismWithTempPaths as $tourism) {
            $oldPath = $tourism->foto_utama;
            $tourism->update(['foto_utama' => null]);
            $fixedCount++;
            
            $this->warn("Fixed {$tourism->nama_wisata}: Removed temporary path '{$oldPath}'");
            Log::info("Tourism image path cleaned", [
                'tourism_id' => $tourism->id,
                'old_path' => $oldPath,
                'new_path' => null
            ]);
        }
        
        // Clean galeri_foto
        $tourismWithGallery = ObjekWisata::whereNotNull('galeri_foto')->get();
        
        foreach ($tourismWithGallery as $tourism) {
            $galeri = $tourism->galeri_foto;
            
            if (is_array($galeri)) {
                $cleanGaleri = [];
                $hasChanges = false;
                
                foreach ($galeri as $foto) {
                    if (is_string($foto) && 
                        strpos($foto, 'tmp') === false && 
                        strpos($foto, 'php') === false && 
                        !empty($foto)) {
                        $cleanGaleri[] = $foto;
                    } else {
                        $hasChanges = true;
                        $this->warn("Removed temporary gallery item from {$tourism->nama_wisata}: '{$foto}'");
                    }
                }
                
                if ($hasChanges) {
                    $tourism->update(['galeri_foto' => $cleanGaleri]);
                    $fixedCount++;
                    
                    Log::info("Tourism gallery cleaned", [
                        'tourism_id' => $tourism->id,
                        'original_count' => count($galeri),
                        'cleaned_count' => count($cleanGaleri)
                    ]);
                }
            }
        }
        
        $this->info("Completed! Fixed {$fixedCount} tourism objects.");
        
        return 0;
    }
}
