<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Http\Controllers\PendudukController;
use Illuminate\Http\Request;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Log;

class TestImport extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'test:import {file?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Test import functionality';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $filePath = $this->argument('file') ?? public_path('test_import.csv');
        
        if (!file_exists($filePath)) {
            $this->error("File tidak ditemukan: {$filePath}");
            return 1;
        }
        
        $this->info("Testing import dari file: {$filePath}");
        
        try {
            $controller = new PendudukController();
            
            // Call the private method using reflection
            $reflection = new \ReflectionClass($controller);
            $method = $reflection->getMethod('readExcelFile');
            $method->setAccessible(true);
            
            $data = $method->invoke($controller, $filePath);
            
            $this->info("Data berhasil dibaca: " . count($data) . " baris");
            
            if (!empty($data)) {
                $this->info("Sample data:");
                foreach (array_slice($data, 0, 2) as $index => $row) {
                    $this->line("Baris " . ($index + 1) . ":");
                    foreach ($row as $key => $value) {
                        $this->line("  {$key}: {$value}");
                    }
                    $this->line("");
                }
            }
            
            return 0;
            
        } catch (\Exception $e) {
            $this->error("Error: " . $e->getMessage());
            $this->error("Trace: " . $e->getTraceAsString());
            return 1;
        }
    }
}
