<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Models\Penduduk;
use App\Models\PelayananSurat;
use App\Models\Pengaduan;
use App\Models\Bantuan;
use Illuminate\Http\Request;

class VillageController extends Controller
{
    /**
     * Get village settings
     */
    public function getSetting()
    {
        try {
            $setting = Setting::first();

            if (!$setting) {
                return response()->json([
                    'success' => false,
                    'message' => 'Setting desa tidak ditemukan'
                ], 404);
            }

            return response()->json([
                'success' => true,
                'data' => [
                    'nama_desa' => $setting->nama_desa,
                    'logo' => $setting->logo ? url('storage/' . $setting->logo) : null,
                    'kecamatan' => $setting->kecamatan,
                    'kabupaten' => $setting->kabupaten,
                    'provinsi' => $setting->provinsi,
                    'kode_pos' => $setting->kode_pos,
                    'alamat' => $setting->alamat,
                    'telepon' => $setting->telepon,
                    'email' => $setting->email,
                    'website' => $setting->website,
                    'youtube_video_id' => $setting->youtube_video_id,
                ],
                'message' => 'Data setting desa berhasil diambil'
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Gagal mengambil data setting desa',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * Get village statistics
     */
    public function getStats()
    {
        try {
            $stats = [
                'total_penduduk' => Penduduk::count(),
                'total_keluarga' => Penduduk::distinct('no_kk')->count('no_kk'),
                'laki_laki' => Penduduk::where('jenis_kelamin', 'L')->count(),
                'perempuan' => Penduduk::where('jenis_kelamin', 'P')->count(),
                'total_surat' => PelayananSurat::count(),
                'surat_pending' => PelayananSurat::where('status', 'Menunggu')->count(),
                'total_pengaduan' => Pengaduan::count(),
                'pengaduan_baru' => Pengaduan::where('status', 'Baru')->count(),
                'total_bantuan' => Bantuan::count(),
                'bantuan_aktif' => Bantuan::where('status', 'Diterima')->count(),
            ];

            return response()->json([
                'success' => true,
                'data' => $stats,
                'message' => 'Data statistik desa berhasil diambil'
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Gagal mengambil data statistik desa',
                'error' => $e->getMessage()
            ], 500);
        }
    }
}
