<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\WilayahAdministratif;
use Illuminate\Http\Request;

class WilayahController extends Controller
{
    /**
     * Get all dusun
     */
    public function getDusun()
    {
        $dusun = WilayahAdministratif::where('jenis_wilayah', 'dusun')
            ->where('status', 'aktif')
            ->orderBy('urutan_tampil', 'asc')
            ->orderBy('nama_wilayah', 'asc')
            ->get(['id', 'nama_wilayah', 'kode_wilayah']);

        return response()->json([
            'success' => true,
            'data' => $dusun
        ]);
    }

    /**
     * Get RW by dusun ID
     */
    public function getRwByDusun($dusunId)
    {
        $rw = WilayahAdministratif::where('jenis_wilayah', 'rw')
            ->where('parent_id', $dusunId)
            ->where('status', 'aktif')
            ->orderBy('urutan_tampil', 'asc')
            ->orderBy('nama_wilayah', 'asc')
            ->get(['id', 'nama_wilayah', 'kode_wilayah']);

        return response()->json([
            'success' => true,
            'data' => $rw
        ]);
    }

    /**
     * Get RT by RW ID
     */
    public function getRtByRw($rwId)
    {
        $rt = WilayahAdministratif::where('jenis_wilayah', 'rt')
            ->where('parent_id', $rwId)
            ->where('status', 'aktif')
            ->orderBy('urutan_tampil', 'asc')
            ->orderBy('nama_wilayah', 'asc')
            ->get(['id', 'nama_wilayah', 'kode_wilayah']);

        return response()->json([
            'success' => true,
            'data' => $rt
        ]);
    }

    /**
     * Get all wilayah data for registration form
     */
    public function getWilayahForRegistration()
    {
        $dusun = WilayahAdministratif::where('jenis_wilayah', 'dusun')
            ->where('status', 'aktif')
            ->orderBy('urutan_tampil', 'asc')
            ->orderBy('nama_wilayah', 'asc')
            ->get(['id', 'nama_wilayah', 'kode_wilayah']);

        return response()->json([
            'success' => true,
            'data' => [
                'dusun' => $dusun
            ]
        ]);
    }
}
