<?php

namespace App\Http\Controllers;

use App\Models\Penduduk;
use Illuminate\Http\Request;

class PetaController extends Controller
{
    public function index()
    {
        // Get statistics for map
        $stats = [
            'penduduk' => Penduduk::whereNotNull('latitude')->whereNotNull('longitude')->count(),
            'keluarga' => Penduduk::whereNotNull('latitude')->whereNotNull('longitude')->distinct('no_kk')->count(),
            'pengaduan' => 0, // Will be implemented when pengaduan has location
            'bantuan' => 0   // Will be implemented when bantuan has location
        ];

        // Get all residents with coordinates for map
        $pendudukWithCoordinates = Penduduk::whereNotNull('latitude')
                                         ->whereNotNull('longitude')
                                         ->select('nik', 'nama', 'alamat', 'dusun', 'rt', 'rw', 'latitude', 'longitude', 'no_kk', 'foto_rumah')
                                         ->get();

        return view('admin.peta.index', compact('stats', 'pendudukWithCoordinates'));
    }

    public function show($nik)
    {
        $penduduk = Penduduk::where('nik', $nik)->firstOrFail();
        return response()->json($penduduk);
    }
}
