<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BeritaComment extends Model
{
    use HasFactory;

    protected $fillable = [
        'berita_id',
        'user_id',
        'nama',
        'email',
        'phone',
        'komentar',
        'likes_count',
        'status'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];

    // Relationships
    public function berita()
    {
        return $this->belongsTo(Berita::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Scopes
    public function scopeApproved($query)
    {
        return $query->where('status', 'approved');
    }

    public function scopeLatest($query)
    {
        return $query->orderBy('created_at', 'desc');
    }

    // Accessors
    public function getAuthorNameAttribute()
    {
        return $this->user ? $this->user->name : $this->nama;
    }

    public function getTimeAgoAttribute()
    {
        $diff = now()->diffInMinutes($this->created_at);
        
        // Always show in minutes only (Instagram style)
        // Ensure minimum 1 minute and no decimals
        $minutes = max(1, abs(round($diff)));
        return $minutes . 'm';
    }

    // Methods
    public function incrementLikes()
    {
        $this->increment('likes_count');
    }

    public function decrementLikes()
    {
        $this->decrement('likes_count');
    }
}
