<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PollingOpsi extends Model
{
    use HasFactory;

    protected $table = 'polling_opsi';

    protected $fillable = [
        'polling_id',
        'judul_opsi',
        'deskripsi_opsi',
        'gambar',
        'estimasi_biaya',
        'urutan',
        'jumlah_suara'
    ];

    protected $casts = [
        'estimasi_biaya' => 'decimal:2'
    ];

    // Relationships
    public function polling()
    {
        return $this->belongsTo(Polling::class);
    }

    public function votes()
    {
        return $this->hasMany(PollingVote::class, 'opsi_id');
    }

    // Method untuk get persentase suara
    public function getPersentaseSuara()
    {
        $totalSuara = $this->polling->total_suara;
        
        if ($totalSuara <= 0) {
            return 0;
        }

        return round(($this->jumlah_suara / $totalSuara) * 100, 2);
    }

    // Scope untuk urutan
    public function scopeOrderByUrutan($query)
    {
        return $query->orderBy('urutan');
    }
} 