<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PollingVote extends Model
{
    use HasFactory;

    protected $table = 'polling_vote';

    protected $fillable = [
        'polling_id',
        'opsi_id',
        'nik',
        'nama_voter',
        'ip_address',
        'alasan'
    ];

    // Relationships
    public function polling()
    {
        return $this->belongsTo(Polling::class);
    }

    public function opsi()
    {
        return $this->belongsTo(PollingOpsi::class, 'opsi_id');
    }

    public function penduduk()
    {
        return $this->belongsTo(Penduduk::class, 'nik', 'nik');
    }

    // Scope methods
    public function scopeByPolling($query, $pollingId)
    {
        return $query->where('polling_id', $pollingId);
    }

    public function scopeByNik($query, $nik)
    {
        return $query->where('nik', $nik);
    }

    public function scopeToday($query)
    {
        return $query->whereDate('created_at', today());
    }
} 