<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = [
        'nama_desa',
        'kode_desa', 
        'kecamatan',
        'kabupaten',
        'provinsi',
        'kode_pos',
        'alamat_kantor',
        'telepon',
        'email',
        'website',
        'kepala_desa',
        'nip_kepala_desa',
        'sekretaris_desa',
        'nip_sekretaris',
        'visi',
        'misi',
        'logo',
        'luas_wilayah',
        'jumlah_penduduk',
        'jumlah_kk',
        'jumlah_rt',
        'jumlah_rw',
        'jumlah_dusun',
        'latitude',
        'longitude',
        'jam_operasional',
        'media_sosial',
        'sejarah_desa',
        'tripay_api_key',
        'tripay_private_key',
        'tripay_merchant_code',
        'tripay_mode',
        'tripay_expiry_time',
        'tripay_fee_customer',
        'tripay_channels',
        'ottopay_api_key',
        'ottopay_secret_key',
        'ottopay_merchant_code',
        'ottopay_mode',
        'ottopay_expiry_time',
        'ottopay_fee_customer',
        'ottopay_channels'
    ];

    protected $casts = [
        'jam_operasional' => 'array',
        'media_sosial' => 'array',
        'luas_wilayah' => 'decimal:2',
        'latitude' => 'decimal:8',
        'longitude' => 'decimal:8',
        'tripay_channels' => 'array',
        'tripay_fee_customer' => 'boolean',
        'tripay_expiry_time' => 'integer',
        'ottopay_channels' => 'array',
        'ottopay_fee_customer' => 'boolean',
        'ottopay_expiry_time' => 'integer'
    ];

    /**
     * Get the village setting (singleton pattern)
     */
    public static function getSettings()
    {
        return self::firstOrCreate(
            [],
            [
                'nama_desa' => 'Desa Contoh',
                'kecamatan' => 'Kecamatan Contoh',
                'kabupaten' => 'Kabupaten Contoh',
                'provinsi' => 'Provinsi Contoh',
                'alamat_kantor' => 'Alamat Kantor Desa',
                'kepala_desa' => 'Nama Kepala Desa',
                'jumlah_penduduk' => 0,
                'jumlah_kk' => 0,
                'jumlah_rt' => 0,
                'jumlah_rw' => 0,
                'jumlah_dusun' => 0
            ]
        );
    }

    /**
     * Update or create setting
     */
    public static function updateSettings(array $data)
    {
        $setting = self::first();
        if ($setting) {
            $setting->update($data);
        } else {
            $setting = self::create($data);
        }
        return $setting;
    }
} 
